/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.deculture.misc;

import net.morilib.automata.lr.Nonterminal;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2014/01/12
 */
public class ConstantNonterminal implements Nonterminal {

	//
	private static int maxnum = 0;

	//
	private String constant;
	private int gennum;

	//
	private ConstantNonterminal(int x) {
		constant = "";
		gennum = x;
	}

	/**
	 * 
	 * @param t
	 */
	public ConstantNonterminal(String t) {
		constant = t;
		gennum = -1;
	}

	/**
	 * 
	 * @return
	 */
	public static ConstantNonterminal gensym() {
		return new ConstantNonterminal(maxnum++);
	}

	/**
	 * 
	 */
	public String getConstant() {
		return constant;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return gennum < 0 ? constant.hashCode() : gennum;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object o) {
		return (o instanceof ConstantNonterminal &&
				constant.equals(((ConstantNonterminal)o).constant) &&
				gennum == ((ConstantNonterminal)o).gennum);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		if(gennum < 0) {
			return constant;
		} else {
			return String.format("#%d", gennum);
		}
	}

}
