/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2014/02/10
 */
public class NinaLanguageOptionCSharp implements NinaLanguageOption {

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getLookahead()
	 */
	@Override
	public String getLookahead() {
		return "__this__.LOOKAHEAD($c);";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getLookaheadCommit()
	 */
	@Override
	public String getLookaheadCommit() {
		return "__this__.LOOKAHEAD_COMMIT();";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getLookaheadMark()
	 */
	@Override
	public String getLookaheadMark() {
		return "__this__.LOOKAHEAD_MARK();";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getUnget()
	 */
	@Override
	public String getUnget() {
		return "__this__.UNGET($c);";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getAssignArray(java.lang.String, int)
	 */
	@Override
	public String getAssignArray(String s, int k) {
		return String.format("%s[%d] = (char)$c;", s, k);
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getInitBuffer(java.lang.String)
	 */
	@Override
	public String getInitBuffer(String s) {
		return s + " = new System.Text.StringBuilder();";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getAppendBuffer(java.lang.String)
	 */
	@Override
	public String getAppendBuffer(String s) {
		return s + ".Append((char)$c);";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getInitList()
	 */
	@Override
	public String getInitList() {
		return "__this__._initlist();";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getAddList()
	 */
	@Override
	public String getAddList() {
		return "__this__._addlist(__this__._);";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getSeparator()
	 */
	@Override
	public String getSeparator() {
		return ";";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getSequenceBufferName()
	 */
	@Override
	public String getSequenceBufferName() {
		return "__this__._buffer";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getBufferToInteger()
	 */
	@Override
	public String getBufferToInteger(int radix) {
		return String.format(
				"__this__._int=System.Convert.ToInt32(__this__._buffer.ToString(), %d);",
				radix);
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getBufferToBigInteger(int)
	 */
	@Override
	public String getBufferToBigInteger(int radix) {
		if(radix == 10) {
			return ("__this__._bigint=System.Numerics.BigInteger.Parse(" +
					"__this__._buffer.ToString());");
		} else {
			throw new NinaException("bigintegernotsupported", radix);
		}
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getBufferToNumberInteger()
	 */
	@Override
	public String getBufferToNumberInteger() {
		return "__this__._num=int.Parse(__this__._buffer.ToString());";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getBufferToNumberDouble()
	 */
	@Override
	public String getBufferToNumberDouble() {
		return "__this__._num=double.Parse(__this__._buffer.ToString());";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getIndent(java.lang.String, int)
	 */
	@Override
	public String getIndent(String cmp, int off) {
		return String.format(
				"__c__ == INDENT && __this__._indent %s __this__._indentBefore + (%d)",
				cmp, off);
	}

}
