/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.pattern;

import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.pattern.AwkMatchState;
import net.morilib.awk.nano.pattern.AwkPattern;

public class AwkRangedPattern
implements AwkPattern {
    private AwkPattern begin;
    private AwkPattern end;

    public AwkRangedPattern(AwkPattern begin, AwkPattern end) {
        this.begin = begin;
        this.end = end;
    }

    @Override
    public boolean isBegin() {
        return false;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    public AwkMatchState match(AwkNamespace ns, AwkFiles fs, String s, AwkMatchState stat) {
        switch (stat) {
            case NO_MATCH: {
                if (this.begin.match(ns, fs, s, stat).isNotMatched()) {
                    return AwkMatchState.NO_MATCH;
                }
                if (this.end.match(ns, fs, s, stat).isNotMatched()) {
                    return AwkMatchState.IS_MATCHING;
                }
                return AwkMatchState.MATCHED;
            }
            case IS_MATCHING: {
                if (this.end.match(ns, fs, s, stat).isNotMatched()) {
                    return AwkMatchState.IS_MATCHING;
                }
                return AwkMatchState.MATCHED;
            }
            case MATCHED: {
                return AwkMatchState.MATCHED;
            }
        }
        throw new RuntimeException();
    }

    @Override
    public boolean isRanged() {
        return true;
    }
}

