/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.statement;

import net.morilib.awk.nano.expr.AwkExpression;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.statement.AwkExpressionMachine;
import net.morilib.awk.nano.value.AwkUndefined;
import net.morilib.awk.nano.value.AwkValue;

public class AwkIf
extends AwkExpression {
    private AwkExpression cond;
    private AwkExpression ifBlock;
    private AwkExpression elseBlock;

    public AwkIf(AwkExpression cond, AwkExpression ifBlock, AwkExpression elseBlock) {
        this.cond = cond;
        this.ifBlock = ifBlock;
        this.elseBlock = elseBlock;
    }

    @Override
    public AwkValue eval(AwkNamespace s, AwkFiles f) {
        if (this.cond.eval(s, f).toBoolean(s)) {
            return this.ifBlock.eval(s, f);
        }
        if (this.elseBlock != null) {
            return this.elseBlock.eval(s, f);
        }
        return AwkUndefined.UNDEF;
    }

    @Override
    public void compileInternally(AwkExpressionMachine.Builder b, Object brk, Object cnt) {
        Object l1 = new Object();
        Object l2 = new Object();
        this.cond.compileInternally(b, brk, cnt);
        b.addJmpZ(l1);
        this.ifBlock.compileInternally(b, brk, cnt);
        if (this.elseBlock != null) {
            b.addJmp(l2);
            b.addLabel(l1);
            this.elseBlock.compileInternally(b, brk, cnt);
            b.addLabel(l2);
        } else {
            b.addLabel(l1);
        }
    }
}

