/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.math.BigInteger;
import net.morilib.lisp.nano.LispComplex;
import net.morilib.lisp.nano.LispDouble;
import net.morilib.lisp.nano.LispNumber;
import net.morilib.lisp.nano.LispReal;

public abstract class LispInexactReal
extends LispReal {
    @Override
    public LispReal toInexact() {
        return this;
    }

    @Override
    public boolean isRational() {
        return !this.isInfinity() && !this.isNaN();
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public boolean isExact() {
        return false;
    }

    @Override
    public BigInteger getBigInteger() {
        return this.getBigDecimal().toBigInteger();
    }

    @Override
    public int getInt() {
        return this.getBigInteger().intValue();
    }

    @Override
    public long getLong() {
        return this.getBigInteger().longValue();
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex((LispReal)this.add(c.getReal()), c.getImag());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex((LispReal)this.sub(c.getReal()), c.getImag().uminus());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex((LispReal)this.mul(c.getReal()), (LispReal)this.mul(c.getImag()));
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispComplex) {
            LispReal xr = x.getReal();
            LispReal xi = x.getImag();
            LispReal xn = (LispReal)xr.mul(xr).add(xi.mul(xi));
            return LispComplex.newComplex((LispReal)this.mul(xr).div(xn), (LispReal)this.mul(xi).uminus().div(xn));
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispReal remainder(LispReal r) {
        return new LispDouble(Math.IEEEremainder(this.getRealDouble(), r.getRealDouble()));
    }
}

