/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.LispException;
import net.morilib.lisp.nano.LispUtils;
import net.morilib.lisp.nano.ReadException;

public final class LispMessage {
    private static final String CLSNAME = "net/morilib/lisp/nano/init/messages";
    private static Map<Locale, LispMessage> instances = new HashMap<Locale, LispMessage>();
    public static LispMessage ROOT_MESSAGE = LispMessage.getInstance(Locale.US);
    private ResourceBundle messages;
    private List<ResourceBundle> pluggable = new ArrayList<ResourceBundle>();
    private Locale locale;

    private LispMessage(Locale lc) {
        this.messages = ResourceBundle.getBundle(CLSNAME, lc);
        this.locale = lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LispMessage getInstance(Locale locale) {
        Locale lc = locale == null ? Locale.getDefault() : locale;
        LispMessage res = instances.get(lc);
        if (res != null) return res;
        Class<LispMessage> clazz = LispMessage.class;
        synchronized (LispMessage.class) {
            res = new LispMessage(lc);
            instances.put(lc, res);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return res;
        }
    }

    public static LispMessage getInstance() {
        return LispMessage.getInstance(Locale.getDefault());
    }

    private String get(ResourceBundle rb, String prop) {
        try {
            return this.messages.getString(prop);
        }
        catch (MissingResourceException e) {
            return LispMessage.ROOT_MESSAGE.messages.getString(prop);
        }
    }

    /*
     * Unable to fully structure code
     */
    public String get(String prop) {
        try {
            return this.get(this.messages, prop);
        }
        catch (MissingResourceException e) {
            ** for (rb : this.pluggable)
        }
lbl-1000:
        // 1 sources

        {
            try {
                return this.get(rb, prop);
            }
            catch (MissingResourceException var5_5) {
                // empty catch block
            }
            continue;
        }
lbl10:
        // 1 sources

        return String.valueOf(this.messages.getString("err.unknown")) + "(" + e.getKey() + ")";
    }

    public String get(String prop, String msg2) {
        return String.valueOf(this.get(prop)) + ":" + msg2;
    }

    public String get(String prop, Datum d) {
        return String.valueOf(this.get(prop)) + ":" + LispUtils.toWrite(d);
    }

    public LispException getError(String prop) {
        return new LispException(prop, this.get(prop));
    }

    public LispException getError(String prop, String msg2) {
        return new LispException(prop, this.get(prop, msg2));
    }

    public LispException getError(String prop, Datum d) {
        return new LispException(prop, this.get(prop, d));
    }

    public ReadException getReadError(String prop) {
        return new ReadException(prop, this.get(prop));
    }

    public ReadException getReadError(String prop, Datum d) {
        return new ReadException(prop, this.get(prop, d));
    }

    public void warn(String prop) {
        System.err.print(this.get("warn.repl.err"));
        System.err.print(" ");
        System.err.println(this.get(prop));
    }

    public Locale getLocale() {
        return this.locale;
    }
}

