/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.LispUtils;

public class LispVector
extends Datum
implements Serializable {
    private static final long serialVersionUID = 3364203058083838114L;
    private List<Datum> vec;

    public LispVector(Collection<Datum> vec) {
        if (vec == null) {
            throw new NullPointerException();
        }
        this.vec = new ArrayList<Datum>(vec);
    }

    public LispVector(Datum ... data) {
        this(Arrays.asList(data));
    }

    public LispVector() {
        this(new ArrayList<Datum>());
    }

    public LispVector(LispVector vec) {
        if (vec == null) {
            throw new NullPointerException();
        }
        this.vec = new ArrayList<Datum>(vec.vec);
    }

    public LispVector(int size) {
        this(new ArrayList<Datum>(size));
    }

    public Datum get(int index) {
        return this.vec.get(index);
    }

    void setS(int index, Datum d) {
        this.vec.set(index, d);
    }

    public int size() {
        return this.vec.size();
    }

    @Override
    public boolean isTypeVector() {
        return true;
    }

    @Override
    public List<Datum> getList() {
        return Collections.unmodifiableList(this.vec);
    }

    @Override
    public String toDisplay() {
        return LispUtils.toDisplay(this);
    }

    @Override
    public String toWrite() {
        return LispUtils.toWrite(this);
    }

    @Override
    public String toString() {
        return LispUtils.toWrite(this);
    }
}

