/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano.java6;

import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispUtils;
import net.morilib.lisp.nano.Symbol;
import net.morilib.lisp.nano.SymbolName;

public class SchlushScriptContext
implements ScriptContext {
    private Reader reader;
    private Writer writer;
    private Writer errwriter;
    Environment env;

    SchlushScriptContext(Environment e) {
        this.env = new Environment(e);
    }

    private Environment _scope(int scope) {
        switch (scope) {
            case 100: {
                return this.env;
            }
            case 200: {
                return this.env.getRootenv();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        Environment e = this._scope(scope);
        for (Map.Entry t : bindings.entrySet()) {
            e.bindDatum((String)t.getKey(), LispUtils.toDatum(t.getValue()));
        }
    }

    @Override
    public Bindings getBindings(int scope) {
        SimpleBindings b = new SimpleBindings();
        Environment e = this._scope(scope);
        for (Map.Entry<SymbolName, Datum> t : e.getBoundData().entrySet()) {
            b.put(t.getKey().getName(), (Object)t.getValue());
        }
        return b;
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        Environment e = this._scope(scope);
        e.bindDatum(name, LispUtils.toDatum(value));
    }

    @Override
    public Object getAttribute(String name, int scope) {
        Environment e = this._scope(scope);
        return e.getDatum(Symbol.getSymbol(name));
    }

    @Override
    public Object removeAttribute(String name, int scope) {
        Environment e = this._scope(scope);
        return e.removeDatum(Symbol.getSymbol(name));
    }

    @Override
    public Object getAttribute(String name) {
        return this.env.findDatum(Symbol.getSymbol(name));
    }

    @Override
    public int getAttributesScope(String name) {
        if (this.env.getDatum(Symbol.getSymbol(name)) != null) {
            return 100;
        }
        if (this.env.getRootenv().getDatum(Symbol.getSymbol(name)) != null) {
            return 200;
        }
        return -1;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public Writer getErrorWriter() {
        return this.errwriter;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void setErrorWriter(Writer writer) {
        this.errwriter = writer;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public List<Integer> getScopes() {
        return Arrays.asList(100, 200);
    }
}

