/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.range;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import net.morilib.range.CharSets;
import net.morilib.range.IntervalsInt;
import net.morilib.range.Range;
import net.morilib.range.RangeAdder;
import net.morilib.util.CharCodes;

public class CharsetParser {
    private static final int NINA_ACCEPT = -1;
    private static final int NINA_FAIL = -9;
    private static final int NINA_HALT_ACCEPT = -91;
    private static final int NINA_HALT_REJECT = -72;
    private static final int NINA_BEGIN = -2;
    private static final int NINA_STACKLEN = 72;
    static final int INITIAL = 0;
    private int STATE;
    private int[] __sts = new int[72];
    private Engine[] __stk = new Engine[72];
    private Object[][] __stv = new Object[72][];
    private int __slen = 0;
    Throwable exception;
    private int unread = -1;
    private StringBuffer bf;
    private RangeAdder add;
    private Range rng;
    private Stack<Range> stk = new Stack();
    private int lh;
    private int lz;
    private int lp = -1;
    private boolean sp = false;
    private String cset;
    private final Engine ENGINE_charsetParser = new Engine(){

        @Override
        int step(Reader __rd, int c) throws IOException {
            return CharsetParser.this.charsetParser_step(__rd, c);
        }

        @Override
        boolean accepted() {
            return CharsetParser.this.charsetParser_accepted();
        }

        @Override
        int execaction(int c) {
            return CharsetParser.this.charsetParser_execaction(c);
        }

        @Override
        boolean isend() {
            return CharsetParser.this.charsetParser_isend();
        }

        @Override
        int recover(Exception e) {
            return -1;
        }

        @Override
        int deadState() {
            return -1;
        }

        @Override
        int stateSize() {
            return 4;
        }

        @Override
        int finallyState() {
            return -1;
        }

        public String toString() {
            return "charsetParser";
        }
    };
    private final Engine ENGINE_parn = new Engine(){

        @Override
        int step(Reader __rd, int c) throws IOException {
            return CharsetParser.this.parn_step(__rd, c);
        }

        @Override
        boolean accepted() {
            return CharsetParser.this.parn_accepted();
        }

        @Override
        int execaction(int c) {
            return CharsetParser.this.parn_execaction(c);
        }

        @Override
        boolean isend() {
            return CharsetParser.this.parn_isend();
        }

        @Override
        int recover(Exception e) {
            return -1;
        }

        @Override
        int deadState() {
            return -1;
        }

        @Override
        int stateSize() {
            return 7;
        }

        @Override
        int finallyState() {
            return -1;
        }

        public String toString() {
            return "parn";
        }
    };
    private final Engine ENGINE_cset = new Engine(){

        @Override
        int step(Reader __rd, int c) throws IOException {
            return CharsetParser.this.cset_step(__rd, c);
        }

        @Override
        boolean accepted() {
            return CharsetParser.this.cset_accepted();
        }

        @Override
        int execaction(int c) {
            return CharsetParser.this.cset_execaction(c);
        }

        @Override
        boolean isend() {
            return CharsetParser.this.cset_isend();
        }

        @Override
        int recover(Exception e) {
            return -1;
        }

        @Override
        int deadState() {
            return -1;
        }

        @Override
        int stateSize() {
            return 9;
        }

        @Override
        int finallyState() {
            return -1;
        }

        public String toString() {
            return "cset";
        }
    };
    private final Engine ENGINE_andt = new Engine(){

        @Override
        int step(Reader __rd, int c) throws IOException {
            return CharsetParser.this.andt_step(__rd, c);
        }

        @Override
        boolean accepted() {
            return CharsetParser.this.andt_accepted();
        }

        @Override
        int execaction(int c) {
            return CharsetParser.this.andt_execaction(c);
        }

        @Override
        boolean isend() {
            return CharsetParser.this.andt_isend();
        }

        @Override
        int recover(Exception e) {
            return -1;
        }

        @Override
        int deadState() {
            return -1;
        }

        @Override
        int stateSize() {
            return 5;
        }

        @Override
        int finallyState() {
            return -1;
        }

        public String toString() {
            return "andt";
        }
    };

    private Range _rng() {
        if (this.add != null) {
            if (this.lh >= 0) {
                this.add.add(IntervalsInt.newClosedInterval(this.lh, this.lh));
            }
            if (this.lz >= 0 && this.lh != this.lz) {
                this.add.add(IntervalsInt.newClosedInterval(this.lz, this.lz));
            }
            this.rng = this.add.toRange();
            this.add = null;
            return this.rng;
        }
        return this.rng;
    }

    private void _ini() {
        this.add = new RangeAdder();
        this.lz = -1;
        this.lh = -1;
    }

    private void _adr1(int c) {
        if (this.lh >= 0) {
            this.add.add(IntervalsInt.newClosedInterval(this.lh, this.lh));
        }
        if (this.sp) {
            this.lz = -1;
            this.lh = -1;
        } else {
            this.lh = this.lz = c;
        }
        this.sp = false;
    }

    private void _adr2(int c) {
        this.add.add(IntervalsInt.newClosedInterval(this.lh, c));
        this.lz = -1;
        this.lh = -1;
    }

    private void _adx(String s) {
        int c = Integer.parseInt(s, 16);
        this.add.add(IntervalsInt.newClosedInterval(c, c));
    }

    private void _ade(int c) {
        this.sp = true;
        switch (c) {
            case 116: {
                this.add.add(CharSets.parse("\t"));
                break;
            }
            case 110: {
                this.add.add(CharSets.parse("\n"));
                break;
            }
            case 114: {
                this.add.add(CharSets.parse("\r"));
                break;
            }
            case 102: {
                this.add.add(CharSets.parse("\f"));
                break;
            }
            case 100: {
                this.add.add(CharSets.NUMBERS);
                break;
            }
            case 68: {
                this.add.add(CharSets.NOT_NUMBER);
                break;
            }
            case 115: {
                this.add.add(CharSets.ASCII_WHITESPACE);
                break;
            }
            case 83: {
                this.add.add(CharSets.NOT_ASCII_WHITESPACE);
                break;
            }
            case 119: {
                this.add.add(CharSets.ASCII_WORD);
                break;
            }
            case 87: {
                this.add.add(CharSets.NOT_ASCII_WORD);
                break;
            }
        }
    }

    public static Range parse(String s, String cset) {
        CharsetParser p = new CharsetParser();
        try {
            p.cset = cset;
            p.parse(new StringReader(s));
            Range r = p.stk.pop();
            if (p.lp >= 0) {
                r = r.join(IntervalsInt.newClosedInterval(p.lp, p.lp));
            }
            return r;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    int _read1(Reader stream) throws IOException {
        int c = stream.read();
        if (c < 0) {
            return -1;
        }
        return CharCodes.unicodeToOtherCode((char)c, this.cset);
    }

    private int _read(Reader rd) throws IOException {
        int c;
        if (this.unread >= 0) {
            c = this.unread;
            this.unread = -1;
            this.__logprint("Read unread: ", c);
        } else {
            c = this._read1(rd);
            if (c == -1) {
                this.__logprint("Read: ", c);
            } else {
                this.__logprint("Read end-of-file");
            }
        }
        return c;
    }

    void UNGET(int c) {
        this.unread = c;
        this.__logprint("Set unread: ", c);
    }

    private void __logprint(String s, int c) {
    }

    private void __logopen() {
    }

    private void __logprint(String s) {
    }

    private void __logclose() {
    }

    private void __puttrace() {
    }

    private int charsetParser_step(Reader __rd, int $c) throws IOException {
        switch (this.STATE) {
            case 0: {
                this.__stkpush(1, this.ENGINE_andt);
                this.STATE = 0;
                return -1;
            }
            case 1: {
                if ($c == 91) {
                    this.UNGET($c);
                    this.STATE = 2;
                    return 1;
                }
                return 0;
            }
            case 2: {
                this.__stkpush(3, this.ENGINE_andt);
                this.STATE = 0;
                return -1;
            }
            case 3: {
                this.UNGET($c);
                this.STATE = 1;
                return 1;
            }
        }
        return 0;
    }

    private boolean charsetParser_accepted() {
        return this.STATE == 1 || this.STATE == 3;
    }

    int charsetParser_execaction(int $c) {
        switch (this.STATE) {
            case 2: {
                break;
            }
            case 3: {
                this.stk.push(this.stk.pop().join(this.stk.pop()));
                break;
            }
            case 1: {
                break;
            }
        }
        return 1;
    }

    boolean charsetParser_isend() {
        return false;
    }

    private int parn_step(Reader __rd, int $c) throws IOException {
        switch (this.STATE) {
            case 0: {
                if ($c == 91) {
                    this.STATE = 1;
                    return 1;
                }
                if ($c == 94) {
                    this.STATE = 2;
                    return 1;
                }
                this.__stkpush(3, this.ENGINE_cset);
                this.STATE = 0;
                return -1;
            }
            case 3: {
                return 0;
            }
            case 2: {
                this.__stkpush(4, this.ENGINE_cset);
                this.STATE = 0;
                return -1;
            }
            case 4: {
                return 0;
            }
            case 1: {
                this.__stkpush(5, this.ENGINE_charsetParser);
                this.STATE = 0;
                return -1;
            }
            case 5: {
                if ($c == 93) {
                    this.STATE = 6;
                    return 1;
                }
                return 0;
            }
            case 6: {
                return 0;
            }
        }
        return 0;
    }

    private boolean parn_accepted() {
        return this.STATE == 3 || this.STATE == 4 || this.STATE == 6;
    }

    int parn_execaction(int $c) {
        switch (this.STATE) {
            case 2: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                this.stk.push(this._rng());
                break;
            }
            case 6: {
                break;
            }
            case 0: {
                this._ini();
                break;
            }
            case 4: {
                this.stk.push(CharSets.complement(this._rng()));
                break;
            }
        }
        return 1;
    }

    boolean parn_isend() {
        return false;
    }

    private int cset_step(Reader __rd, int $c) throws IOException {
        switch (this.STATE) {
            case 0: {
                this.UNGET($c);
                this.STATE = 1;
                return 1;
            }
            case 1: {
                if ($c == 92) {
                    this.STATE = 2;
                    return 1;
                }
                this.STATE = 3;
                return 1;
            }
            case 3: {
                if ($c >= 0 && $c <= 37) {
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 38) {
                    this.UNGET($c);
                    this.STATE = 4;
                    return 1;
                }
                if ($c >= 39 && $c <= 44) {
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 45) {
                    this.STATE = 5;
                    return 1;
                }
                if ($c >= 46 && $c <= 90) {
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 91) {
                    this.UNGET($c);
                    this.STATE = 4;
                    return 1;
                }
                if ($c == 92) {
                    this.STATE = 2;
                    return 1;
                }
                if ($c >= 94 && $c <= Integer.MAX_VALUE) {
                    this.STATE = 3;
                    return 1;
                }
                return 0;
            }
            case 5: {
                if ($c >= 0 && $c <= 37) {
                    this.STATE = 6;
                    return 1;
                }
                if ($c >= 39 && $c <= 90) {
                    this.STATE = 6;
                    return 1;
                }
                if ($c == 92) {
                    this.STATE = 6;
                    return 1;
                }
                if ($c >= 94 && $c <= Integer.MAX_VALUE) {
                    this.STATE = 6;
                    return 1;
                }
                return 0;
            }
            case 6: {
                if ($c >= 0 && $c <= 37) {
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 38) {
                    this.UNGET($c);
                    this.STATE = 4;
                    return 1;
                }
                if ($c >= 39 && $c <= 90) {
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 91) {
                    this.UNGET($c);
                    this.STATE = 4;
                    return 1;
                }
                if ($c == 92) {
                    this.STATE = 3;
                    return 1;
                }
                if ($c >= 94 && $c <= Integer.MAX_VALUE) {
                    this.STATE = 3;
                    return 1;
                }
                return 0;
            }
            case 4: {
                return 0;
            }
            case 2: {
                if ($c == 68) {
                    this._ade($c);
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 83) {
                    this._ade($c);
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 102) {
                    this._ade($c);
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 110) {
                    this._ade($c);
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 114) {
                    this._ade($c);
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 115) {
                    this._ade($c);
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 116) {
                    this._ade($c);
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 117) {
                    this.STATE = 7;
                    return 1;
                }
                if ($c == 119) {
                    this._ade($c);
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 120) {
                    this.STATE = 7;
                    return 1;
                }
                if ($c == 87) {
                    this._ade($c);
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 100) {
                    this._ade($c);
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 68) {
                    this._ade($c);
                    this.STATE = 3;
                    return 1;
                }
                this.STATE = 3;
                return 1;
            }
            case 7: {
                if ($c >= 48 && $c <= 57) {
                    this.STATE = 8;
                    return 1;
                }
                if ($c >= 65 && $c <= 70) {
                    this.STATE = 8;
                    return 1;
                }
                if ($c >= 97 && $c <= 102) {
                    this.STATE = 8;
                    return 1;
                }
                return 0;
            }
            case 8: {
                if ($c >= 48 && $c <= 57) {
                    this.STATE = 8;
                    return 1;
                }
                if ($c >= 65 && $c <= 70) {
                    this.STATE = 8;
                    return 1;
                }
                if ($c >= 97 && $c <= 102) {
                    this.STATE = 8;
                    return 1;
                }
                this._adx(this.bf.toString());
                this.STATE = 3;
                return 1;
            }
        }
        return 0;
    }

    private boolean cset_accepted() {
        return this.STATE == 2 || this.STATE == 3 || this.STATE == 4 || this.STATE == 5 || this.STATE == 6 || this.STATE == 8;
    }

    int cset_execaction(int $c) {
        switch (this.STATE) {
            case 2: {
                this._adr1(-1);
                this.lz = 92;
                break;
            }
            case 6: {
                this._adr2($c);
                break;
            }
            case 3: {
                this._adr1($c);
                break;
            }
            case 0: {
                this._ini();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.lz = 45;
                break;
            }
            case 7: {
                this.bf = new StringBuffer();
                break;
            }
            case 1: {
                break;
            }
            case 8: {
                this.bf.append((char)$c);
            }
        }
        return 1;
    }

    boolean cset_isend() {
        return false;
    }

    private int andt_step(Reader __rd, int $c) throws IOException {
        switch (this.STATE) {
            case 0: {
                this.__stkpush(1, this.ENGINE_parn);
                this.STATE = 0;
                return -1;
            }
            case 1: {
                if ($c == 38) {
                    this.STATE = 2;
                    return 1;
                }
                return 0;
            }
            case 2: {
                if ($c == 38) {
                    this.STATE = 3;
                    return 1;
                }
                return 0;
            }
            case 3: {
                this.__stkpush(4, this.ENGINE_parn);
                this.STATE = 0;
                return -1;
            }
            case 4: {
                this.UNGET($c);
                this.STATE = 1;
                return 1;
            }
        }
        return 0;
    }

    private boolean andt_accepted() {
        return this.STATE == 1 || this.STATE == 2 || this.STATE == 4;
    }

    int andt_execaction(int $c) {
        switch (this.STATE) {
            case 0: {
                break;
            }
            case 4: {
                this.stk.push(this.stk.pop().meet(this.stk.pop()));
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.lp = 38;
                break;
            }
            case 3: {
                this.lp = -1;
            }
        }
        return 1;
    }

    boolean andt_isend() {
        return false;
    }

    void __stkpush(int st, Engine en) {
        if (this.__slen >= this.__sts.length) {
            int[] a = new int[this.__sts.length * 2];
            Engine[] b = new Engine[this.__stk.length * 2];
            Object[][] c = new Object[this.__stk.length * 2][];
            System.arraycopy(this.__sts, 0, a, 0, this.__sts.length);
            System.arraycopy(this.__stk, 0, b, 0, this.__stk.length);
            System.arraycopy(this.__stv, 0, c, 0, this.__stv.length);
            this.__sts = a;
            this.__stk = b;
            this.__stv = c;
        }
        this.__sts[this.__slen] = st;
        this.__stk[this.__slen] = en;
        this.__stv[this.__slen++] = new Object[en.stateSize()];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int _parse(Reader rd, int x) throws IOException {
        boolean b = false;
        int c = x;
        b = this.__stk[this.__slen - 1].accepted();
        if (rd == null) {
            throw new RuntimeException("can not recurse");
        }
        switch (this.__stk[this.__slen - 1].execaction(-2)) {
            case -1: {
                this.__logprint("accept " + this.__stk[this.__slen - 1]);
                return -1;
            }
            case -9: {
                this.__logprint("match failed: begin");
                this.__puttrace();
                return -9;
            }
            case -91: {
                this.__logprint("machine halted: begin");
                return -91;
            }
            case -72: {
                this.__logprint("machine halted: begin");
                return -72;
            }
        }
        try {
            do {
                Engine en = this.__stk[this.__slen - 1];
                if (c < 0) continue;
                int a = en.step(rd, c);
                if (a > 0) {
                    this.__logprint("transit to state " + this.STATE + ": ", c);
                    b = en.accepted();
                    switch (en.execaction(c)) {
                        case -1: {
                            this.__logprint("accept " + this.__stk[this.__slen - 1]);
                            this.UNGET(c);
                            return -1;
                        }
                        case -9: {
                            this.__logprint("match failed: ", c);
                            this.__puttrace();
                            this.UNGET(c);
                            return -9;
                        }
                        case -91: {
                            this.__logprint("machine halted: ", c);
                            return -91;
                        }
                        case -72: {
                            this.__logprint("machine halted: ", c);
                            return -72;
                        }
                    }
                    continue;
                }
                if (a < 0) {
                    this.__logprint("entering " + this.__stk[this.__slen - 1]);
                    return c;
                }
                if (b) {
                    this.__logprint("accept " + this.__stk[this.__slen - 1]);
                    this.UNGET(c);
                    return -1;
                }
                this.__logprint("match failed: ", c);
                this.__puttrace();
                this.UNGET(c);
                return -9;
            } while ((c = this._read(rd)) >= 0);
            if (!b) {
                throw new TokenException();
            }
            return -1;
        }
        catch (RuntimeException e) {
            this.UNGET(c);
            throw e;
        }
    }

    private Boolean execfinally() {
        int a = this.__stk[this.__slen - 1].finallyState();
        if (a >= 0) {
            int b = this.STATE;
            this.STATE = a;
            switch (this.__stk[this.__slen - 1].execaction(-2)) {
                case -91: {
                    this.__slen = 0;
                    return Boolean.TRUE;
                }
                case -72: {
                    this.__slen = 0;
                    return Boolean.FALSE;
                }
            }
            this.STATE = b;
        }
        return null;
    }

    private int getdeadstate() {
        return this.__stk[this.__slen - 1].deadState();
    }

    private int getrecover(Exception e) {
        return this.__stk[this.__slen - 1].recover(e);
    }

    /*
     * Unable to fully structure code
     */
    boolean parse(Reader rd, Engine entry) throws IOException {
        c = -1;
        this.__logopen();
        try {
            this.__stkpush(0, entry);
            block13: while (true) {
                block24: {
                    try {
                        while ((c = this._parse(rd, c)) >= 0) {
                        }
                        if (c != -9) break block24;
                        while (true) lbl-1000:
                        // 2 sources

                        {
                            if ((this.STATE = this.getdeadstate()) >= 0) continue block13;
                            b = this.execfinally();
                            if (b == null) continue;
                            var7_6 = b;
                            return var7_6;
                        }
                    }
                    catch (RuntimeException e) {
                        this.exception = e;
                        if (this.__slen > 0) ** GOTO lbl54
                        throw e;
                    }
                    {
                        ** while (this.__slen-- > 1)
                    }
lbl21:
                    // 1 sources

                    throw new TokenException();
                }
                if (c == -91) {
                    b = this.execfinally();
                    if (b != null) {
                        var7_7 = b;
                        return var7_7;
                    }
                    this.__slen = 0;
                    return true;
                }
                if (c == -72) {
                    b = this.execfinally();
                    if (b != null) {
                        var7_8 = b;
                        return var7_8;
                    }
                    this.__slen = 0;
                    return false;
                }
                if (this.__slen > 1) {
                    b = this.execfinally();
                    if (b != null) {
                        var7_9 = b;
                        return var7_9;
                    }
                    this.STATE = this.__sts[--this.__slen];
                    continue;
                }
                b = this.execfinally();
                if (b == null) break;
                var7_10 = b;
                return var7_10;
lbl-1000:
                // 1 sources

                {
                    b = this.execfinally();
                    if (b != null) {
                        var7_11 = b;
                        return var7_11;
                    }
                    if (this.__slen-- > 1) continue;
                    throw e;
lbl54:
                    // 2 sources

                    ** while ((this.STATE = this.getrecover((Exception)e)) < 0)
                }
lbl55:
                // 1 sources

            }
            var7_12 = this.__stk[this.__slen - 1].accepted();
            return var7_12;
        }
        finally {
            this.__logclose();
        }
    }

    boolean parse(Reader rd) throws IOException {
        return this.parse(rd, this.ENGINE_charsetParser);
    }

    static boolean parseAll(Reader rd) throws IOException {
        CharsetParser o = new CharsetParser();
        return o.parse(rd);
    }

    boolean parse(InputStream rd) throws IOException {
        return this.parse(new InputStreamReader(rd));
    }

    static boolean parseAll(InputStream rd) throws IOException {
        return CharsetParser.parseAll(new InputStreamReader(rd));
    }

    static abstract class Engine {
        Engine() {
        }

        abstract int step(Reader var1, int var2) throws IOException;

        abstract boolean accepted();

        abstract int execaction(int var1);

        abstract boolean isend();

        abstract int recover(Exception var1);

        abstract int deadState();

        abstract int stateSize();

        abstract int finallyState();
    }

    static class TokenException
    extends RuntimeException {
        TokenException() {
        }
    }
}

