/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.morilib.util.Objects;

public final class Iterators {
    public static final ListIterator<Object> NULL = new ListIterator<Object>(){

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public Object previous() {
            throw new NoSuchElementException();
        }

        @Override
        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object o) {
            throw new UnsupportedOperationException();
        }
    };

    private Iterators() {
    }

    public static <E> ListIterator<E> emptyIterator() {
        return NULL;
    }

    public static <E> E nextNotNull(Iterator<E> iter) {
        E res = null;
        do {
            if (iter.hasNext()) continue;
            return null;
        } while ((res = (E)iter.next()) == null);
        return res;
    }

    public static <E> Iterator<E> unmodifiable(Iterator<E> i) {
        return new Unmodify<E>(i);
    }

    public static <E> Iterator<E> singleton(E o) {
        return new Single<E>(o);
    }

    public static <E> String toString(Iterator<E> i, String delim) {
        StringBuffer buf = new StringBuffer();
        String d2 = "";
        while (i.hasNext()) {
            buf.append(d2);
            buf.append(Objects.toString(i.next()));
            d2 = delim;
        }
        return buf.toString();
    }

    public static <E> E nextIf(Iterator<E> i) {
        return i.hasNext() ? (E)i.next() : null;
    }

    public static <E> E nextIf(Iterator<E> i, E ifnull) {
        return i.hasNext() ? i.next() : ifnull;
    }

    public static <E> E nextIf(Iterator<E> i, RuntimeException ifnull) {
        if (i.hasNext()) {
            return i.next();
        }
        throw ifnull;
    }

    public static <E> List<E> toList(Iterator<E> iterator) {
        ArrayList<E> r = new ArrayList<E>();
        while (iterator.hasNext()) {
            r.add(iterator.next());
        }
        return r;
    }

    public static <E> List<E> toList(Enumeration<E> iterator) {
        ArrayList<E> r = new ArrayList<E>();
        while (iterator.hasMoreElements()) {
            r.add(iterator.nextElement());
        }
        return r;
    }

    public static int length(Iterator<?> itr) {
        int l = 0;
        while (itr.hasNext()) {
            itr.next();
            ++l;
        }
        return l;
    }

    public static <T> T get(Iterable<T> iterator, int n) {
        Iterator<T> itr = iterator.iterator();
        int i = 0;
        while (itr.hasNext() && i < n) {
            itr.next();
            ++i;
        }
        if (itr.hasNext()) {
            return itr.next();
        }
        throw new IndexOutOfBoundsException();
    }

    public static <T extends Comparable<? super T>> boolean isSorted(Iterator<T> iterator) {
        Comparable x1 = null;
        while (iterator.hasNext()) {
            if (x1 == null) {
                x1 = (Comparable)iterator.next();
                continue;
            }
            Comparable x2 = (Comparable)iterator.next();
            if (x2 == null) {
                throw new NullPointerException();
            }
            if (x1.compareTo(x2) <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isSorted(Iterator<T> iterator, Comparator<? super T> cmp) {
        Object x1 = null;
        while (iterator.hasNext()) {
            if (x1 == null) {
                x1 = iterator.next();
                continue;
            }
            T x2 = iterator.next();
            if (x2 == null) {
                throw new NullPointerException();
            }
            if (cmp.compare(x1, x2) <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T> Iterator<T> toIterator(final Enumeration<T> e) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }

            @Override
            public T next() {
                return e.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class Single<E>
    implements Iterator<E> {
        private E obj;

        Single(E o) {
            this.obj = o;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.obj != null;
        }

        @Override
        public E next() {
            E o = this.obj;
            if (o == null) {
                throw new NoSuchElementException();
            }
            this.obj = null;
            return o;
        }
    }

    private static class Unmodify<E>
    implements Iterator<E> {
        Iterator<E> iter;

        Unmodify(Iterator<E> iter) {
            this.iter = iter;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public E next() {
            return this.iter.next();
        }
    }
}

