/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.morilib.automata.NFAState;
import net.morilib.automata.TextBound;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.range.Interval;
import net.morilib.range.Range;

public abstract class NFAClosure<T, A, B>
extends NFAObject<T, A, B> {
    final NFAState beginState = new NFAObject.IntStateObject(this, 0);
    final NFAState endState = new NFAObject.IntStateObject(this, 1);
    protected NFAObject<T, A, B> wrapee;
    protected boolean nullable;
    protected boolean repeatable;

    protected NFAClosure(NFAObject<T, A, B> wrapee, boolean nullable, boolean repeatable) {
        this.wrapee = wrapee;
        this.nullable = nullable;
        this.repeatable = repeatable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    @Override
    void addStates(Set<NFAState> res, NFAState state, T alphabet) {
        if (this.wrapee.isState(state)) {
            this.wrapee.addStates(res, state, alphabet);
        }
    }

    @Override
    void addStates(Set<NFAState> res, NFAState state, Range a) {
        if (this.wrapee.isState(state)) {
            this.wrapee.addStates(res, state, a);
        }
    }

    @Override
    void addStatesBound(Set<NFAState> res, NFAState state, EnumSet<TextBound> a) {
        if (this.wrapee.isState(state)) {
            this.wrapee.addStatesBound(res, state, a);
        }
    }

    @Override
    void addInitialStates(Set<NFAState> res) {
        res.add(this.beginState);
    }

    @Override
    void addStatesEpsilon(Set<NFAState> res, NFAState state) {
        if (this.beginState.equals(state)) {
            if (this.nullable) {
                res.add(this.endState);
            }
            this.wrapee.addInitialStates(res);
        } else if (this.wrapee.isFinal(state)) {
            res.addAll(this.wrapee.getStatesEpsilon(state));
            res.add(this.endState);
            if (this.repeatable) {
                this.wrapee.addInitialStates(res);
            }
        } else if (this.wrapee.isState(state)) {
            res.addAll(this.wrapee.getStatesEpsilon(state));
        }
    }

    @Override
    public boolean isState(NFAState o) {
        if (o instanceof NFAObject.IntStateObject) {
            NFAObject.IntStateObject s = (NFAObject.IntStateObject)o;
            return s.equals(this.beginState) || s.equals(this.endState) || this.wrapee.isState(o);
        }
        return false;
    }

    @Override
    public boolean isInitialState(NFAState o) {
        return this.beginState.equals(o);
    }

    @Override
    public boolean isFinal(NFAState state) {
        return this.endState.equals(state);
    }

    @Override
    public Set<Interval> nextAlphabets(NFAState state) {
        if (this.wrapee.isState(state)) {
            return this.wrapee.nextAlphabets(state);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<T> nextDiscreteAlphabets(NFAState state) {
        if (this.wrapee.isState(state)) {
            return this.wrapee.nextDiscreteAlphabets(state);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getAcceptedStates() {
        return Collections.singleton(this.endState);
    }

    @Override
    public Set<B> getMatchTag(NFAState state) {
        HashSet res = new HashSet();
        if (this.wrapee.isState(state)) {
            res.addAll(this.wrapee.getMatchTag(state));
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<B> getMatchTagEnd(NFAState state) {
        HashSet res = new HashSet();
        if (this.wrapee.isState(state)) {
            res.addAll(this.wrapee.getMatchTagEnd(state));
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<A> getAccept(NFAState state) {
        HashSet res = new HashSet();
        if (this.wrapee.isState(state)) {
            res.addAll(this.wrapee.getAccept(state));
        }
        return Collections.unmodifiableSet(res);
    }
}

