/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAState;
import net.morilib.automata.TextBound;
import net.morilib.automata.nfa.NFAConcatenation;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.automata.nfa.NFAOptional;
import net.morilib.automata.nfa.NFARepetition;
import net.morilib.automata.nfa.SingleObjectNFA;
import net.morilib.automata.nfa.SingleSetNFA;
import net.morilib.range.CharSets;
import net.morilib.range.Range;
import net.morilib.util.LinkedListStack;

public final class NFAs {
    private NFAs() {
    }

    public static <A, B> NFA<Integer, A, B> build(String str) {
        ArrayList arr = new ArrayList();
        int i = 0;
        while (i < str.length()) {
            arr.add(SingleObjectNFA.newInstance(new Integer(str.charAt(i))));
            ++i;
        }
        return NFAConcatenation.newInstance(arr);
    }

    public static <T, A, B> NFA<T, A, B> build(T[] array) {
        ArrayList arr = new ArrayList();
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            arr.add(SingleObjectNFA.newInstance(t));
            ++n2;
        }
        return NFAConcatenation.newInstance(arr);
    }

    public static <T, A, B> NFA<T, A, B> build(Collection<T> col) {
        ArrayList arr = new ArrayList();
        for (T t : col) {
            arr.add(SingleObjectNFA.newInstance(t));
        }
        return NFAConcatenation.newInstance(arr);
    }

    public static <T, A, B> Set<NFAState> getEpsilonReachable(NFA<T, A, B> nfa, Set<NFAState> states) {
        HashSet<NFAState> res = new HashSet<NFAState>(states);
        LinkedListStack<NFAState> stk = new LinkedListStack<NFAState>(states);
        while (!stk.isEmpty()) {
            NFAState t = (NFAState)stk.pop();
            Set<NFAState> e = nfa.getStatesEpsilon(t);
            for (NFAState u : e) {
                if (res.contains(u)) continue;
                res.add(u);
                stk.push(u);
            }
        }
        return res;
    }

    public static <B> Set<B> getMatchTag(NFA<?, ?, B> nfa, Set<NFAState> states) {
        HashSet<B> res = new HashSet<B>();
        for (NFAState s : states) {
            res.addAll(nfa.getMatchTag(s));
        }
        return Collections.unmodifiableSet(res);
    }

    public static <B> Set<B> getMatchTagEnd(NFA<?, ?, B> nfa, Set<NFAState> states) {
        HashSet<B> res = new HashSet<B>();
        for (NFAState s : states) {
            res.addAll(nfa.getMatchTagEnd(s));
        }
        return Collections.unmodifiableSet(res);
    }

    public static <A> Set<A> getAccept(NFA<?, A, ?> nfa, Set<NFAState> states) {
        HashSet<A> res = new HashSet<A>();
        for (NFAState s : states) {
            res.addAll(nfa.getAccept(s));
        }
        return Collections.unmodifiableSet(res);
    }

    public static boolean isAccepted(NFA<?, ?, ?> nfa, Set<NFAState> states) {
        for (NFAState s : states) {
            if (!nfa.isAccepted(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInitialState(NFA<?, ?, ?> nfa, Set<NFAState> states) {
        for (NFAState s : states) {
            if (!nfa.isInitialState(s)) continue;
            return true;
        }
        return false;
    }

    public static <T, A> Set<NFAState> getStates(NFA<T, A, ?> nfa, Set<NFAState> state, T alphabet) {
        HashSet<NFAState> res = new HashSet<NFAState>();
        if (nfa instanceof NFAObject) {
            NFAObject nfo = (NFAObject)nfa;
            for (NFAState s : state) {
                nfo.addStates(res, s, alphabet);
            }
        } else {
            for (NFAState s : state) {
                res.addAll(nfa.getStates(s, alphabet));
            }
        }
        return Collections.unmodifiableSet(res);
    }

    public static <T, A> Set<NFAState> getStates(NFA<T, A, ?> nfa, Set<NFAState> state, Range rng) {
        HashSet<NFAState> res = new HashSet<NFAState>();
        if (nfa instanceof NFAObject) {
            NFAObject nfo = (NFAObject)nfa;
            for (NFAState s : state) {
                nfo.addStates((Set<NFAState>)res, s, rng);
            }
        } else {
            for (NFAState s : state) {
                res.addAll(nfa.getStates(s, rng));
            }
        }
        return Collections.unmodifiableSet(res);
    }

    public static <T, A> Set<NFAState> getStatesBound(NFA<T, A, ?> nfa, Set<NFAState> state, EnumSet<TextBound> b) {
        HashSet<NFAState> res = new HashSet<NFAState>();
        if (nfa instanceof NFAObject) {
            NFAObject nfo = (NFAObject)nfa;
            for (NFAState s : state) {
                nfo.addStatesBound(res, s, b);
            }
        } else {
            for (NFAState s : state) {
                res.addAll(nfa.getStates(s, b));
            }
        }
        return Collections.unmodifiableSet(res);
    }

    public static <T, A, B> NFAObject<T, A, B> newRepetitionNM(NFAObject<T, A, B> nfa, int n, int m) {
        if (n > m && m >= 0) {
            throw new IllegalArgumentException();
        }
        ArrayList l = new ArrayList();
        int i = 0;
        while (i < n) {
            l.add(nfa.clone());
            ++i;
        }
        if (m < 0) {
            l.add(NFARepetition.newInstance(nfa.clone(), true));
        } else {
            i = n;
            while (i < m) {
                l.add(NFAOptional.newInstance(nfa.clone()));
                ++i;
            }
        }
        return NFAConcatenation.newInstance(l);
    }

    public static <T, A, B> NFAObject<T, A, B> newComplexLetter() {
        ArrayList l = new ArrayList();
        SingleSetNFA o = SingleSetNFA.newInstance(CharSets.parse("\\P{M}"));
        l.add(o);
        o = SingleSetNFA.newInstance(CharSets.parse("\\p{M}"));
        l.add(NFARepetition.newInstance(o, true));
        return NFAConcatenation.newInstance(l);
    }
}

