/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.expr;

import java.math.BigInteger;
import net.morilib.awk.nano.expr.AwkExpression;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.value.AwkUndefined;
import net.morilib.awk.nano.value.AwkValue;

public class AwkReferField
extends AwkExpression {
    private BigInteger MI = BigInteger.valueOf(Integer.MAX_VALUE);
    private AwkExpression field;

    public AwkReferField(AwkExpression field) {
        this.field = field;
    }

    @Override
    public AwkValue eval(AwkNamespace ns, AwkFiles o) {
        BigInteger b = this.field.eval(ns, o).toInteger();
        if (b.compareTo(this.MI) > 0 && b.signum() < 0) {
            return AwkUndefined.UNDEF;
        }
        return ns.referField(b.intValue());
    }

    @Override
    public void assign(AwkNamespace ns, AwkValue v, AwkFiles f) {
        BigInteger b = this.field.eval(ns, f).toInteger();
        if (b.compareTo(this.MI) <= 0 && b.signum() >= 0) {
            ns.setField(b.intValue(), v.toString(ns));
        }
    }

    @Override
    public boolean isLvalue() {
        return true;
    }
}

