/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.statement;

import java.util.Iterator;
import net.morilib.awk.nano.AwkBreakException;
import net.morilib.awk.nano.AwkContinueException;
import net.morilib.awk.nano.expr.AwkExpression;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.statement.AwkExpressionMachine;
import net.morilib.awk.nano.value.AwkUndefined;
import net.morilib.awk.nano.value.AwkValue;

public class AwkForIn
extends AwkExpression {
    private AwkExpression array;
    private AwkExpression stmt;
    private String name;

    public AwkForIn(AwkExpression array, AwkExpression stmt, String name) {
        this.array = array;
        this.stmt = stmt;
        this.name = name;
    }

    @Override
    public AwkValue eval(AwkNamespace ns, AwkFiles o) {
        AwkValue v = AwkUndefined.UNDEF;
        try {
            Iterator<AwkValue> t = this.array.eval(ns, o).iterator();
            while (t.hasNext()) {
                AwkValue x = t.next();
                ns.assign(this.name, x);
                try {
                    v = this.stmt.eval(ns, o);
                }
                catch (AwkContinueException awkContinueException) {
                    // empty catch block
                }
            }
        }
        catch (AwkBreakException awkBreakException) {
            // empty catch block
        }
        return v;
    }

    @Override
    public void compileInternally(AwkExpressionMachine.Builder b, Object brk, Object cnt) {
        Object r = new Object();
        Object c = new Object();
        b.add(this.array);
        b.addPushin();
        b.addLabel(c);
        b.addGetin(this.name, r);
        this.stmt.compileInternally(b, r, c);
        b.addJmp(c);
        b.addLabel(r);
    }
}

