/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morilib.automata.DFA;
import net.morilib.automata.DFAState;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAEdges;
import net.morilib.automata.NFAState;
import net.morilib.automata.TextBound;
import net.morilib.automata.dfa.ConvertedRangeDFA;
import net.morilib.automata.dfa.DFAs;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.automata.nfa.RegexParseException;
import net.morilib.nina.BuildMachine;
import net.morilib.nina.DoubleQuoteTokenizer;
import net.morilib.nina.Nina;
import net.morilib.nina.NinaAction;
import net.morilib.nina.NinaEvent;
import net.morilib.nina.NinaException;
import net.morilib.nina.NinaFrameReader;
import net.morilib.nina.NinaLanguageOption;
import net.morilib.nina.NinaNondeterministicException;
import net.morilib.nina.NinaParser;
import net.morilib.nina.NinaSubautomata;
import net.morilib.range.CharSets;
import net.morilib.range.Interval;
import net.morilib.range.IntervalsInt;
import net.morilib.range.Range;
import net.morilib.range.RangeAdder;
import net.morilib.regex.dfa.RegexParser;
import net.morilib.util.TreeSectionMap;
import net.morilib.util.Tuple2;

public class DFABuilder
implements NinaAction {
    private static final Object _END = new Object();
    private static final Object _FLOAT = new Object();
    private static final Object _ID_JAVA = new Object();
    private static final Object _ID_C = new Object();
    private static final Range SPACES = CharSets.parse(" \t\r\b");
    private static final Range DIGIT = IntervalsInt.newClosedInterval(48, 57);
    private static final Range SIGN_P = IntervalsInt.newClosedInterval(43, 43);
    private static final Range SIGN_N = IntervalsInt.newClosedInterval(45, 45);
    private static final Range HEXD1 = IntervalsInt.newClosedInterval(65, 70);
    private static final Range HEXD2 = IntervalsInt.newClosedInterval(97, 102);
    private static final Range HEXD = DIGIT.join(HEXD1).join(HEXD2);
    private static final Range OCTD = IntervalsInt.newClosedInterval(48, 55);
    private static final Range POINT = IntervalsInt.newClosedInterval(46, 46);
    private static final Range CHAR_E = IntervalsInt.newClosedInterval(101, 101).join(IntervalsInt.newClosedInterval(69, 69));
    private static final Range ID_C_START = IntervalsInt.newClosedInterval(65, 90).join(IntervalsInt.newClosedInterval(97, 122)).join(IntervalsInt.newClosedInterval(95, 95));
    private static final Range ID_C_PART = ID_C_START.join(IntervalsInt.newClosedInterval(48, 57));
    private static final Range ID_JAVA_START = CharSets.parse("\\p{JavaIdentifierStart}");
    private static final Range ID_JAVA_PART = CharSets.parse("\\p{JavaIdentifierPart}");
    private static final Range WORD = CharSets.parse("\\p{L}");
    private static final Range NOT_WORD = CharSets.parse("\\P{L}");
    private static final Range MARK = CharSets.parse("\\p{M}");
    private Map<String, DBS> map = new HashMap<String, DBS>();
    private Map<Object, String> inv = new IdentityHashMap<Object, String>();
    private Map<String, String> typemap = new HashMap<String, String>();
    private Map<String, String> dynmap = new HashMap<String, String>();
    private DBS initial;
    private DBS vertex;
    private BuildMachine accepted = null;
    private int mealyType;
    private Object mealy;
    private String name;
    private int nfaFlag;

    @Override
    public DBS createState(NinaEvent q) {
        DBS s = new DBS();
        s.nomFichier = q.getOption("out");
        s.moore = q.getOptionBoolean("moore");
        return s;
    }

    @Override
    public void labelAdded(NinaEvent q, NinaFrameReader rd, boolean accept) {
        int l;
        StringWriter wr = new StringWriter();
        char[] a = new char[1024];
        while ((l = rd.read(a)) >= 0) {
            wr.write(a, 0, l);
        }
        if (this.vertex == null) {
            this.vertex = this.createState(q);
            this.vertex.initial = true;
            this.initial = this.vertex;
        }
        if (this.vertex.identical == null) {
            this.vertex.accepted = accept;
        } else {
            for (DBS x : this.vertex.identical) {
                x.accepted = accept;
            }
        }
        this.vertex.label = wr.toString();
    }

    private DBS _linkv(NinaEvent q, DBS x, DBS a, Range r, String o) {
        x.linkAlphabet(a, r, (Object)o);
        return a;
    }

    private DBS _linkv(NinaEvent q, DBS x, DBS a, int c, String o) {
        Interval r = Interval.newPoint(c);
        x.linkAlphabet(a, r, (Object)o);
        return a;
    }

    private DBS _linkc(NinaEvent q, DBS x, int c, String o) {
        Interval r = Interval.newPoint(c);
        DBS a = this.createState(q);
        return this._linkv(q, x, a, r, o);
    }

    private DBS _linki(NinaEvent q, DBS x, int c, String o) {
        Range r = Interval.newPoint(c);
        r = CharSets.complement(r);
        return this._linkv(q, x, this.vertex, r, o);
    }

    private void _linkdfa1(NinaEvent q, DFA<Object, NFAState, Integer> d, DBS v, DBS z, Object o, String lh, String lc1, String lcb, String lce, boolean en) {
        List<DFAState<Object, NFAState, Integer>> c = DFAs.allStateRanges(d.getInitialState());
        HashMap m = new HashMap();
        String g = lc1;
        if (o != null) {
            g = String.valueOf(g) + o.toString();
        }
        for (DFAState dFAState : c) {
            DBS x;
            if (dFAState.equals(d.getInitialState())) {
                x = v;
            } else {
                x = (DBS)m.get(dFAState);
                if (x == null) {
                    x = new DBS();
                    m.put(dFAState, x);
                }
            }
            if (dFAState.isAccepted()) {
                x.linkOthers(z, String.valueOf(lcb) + g + lce);
                if (en) {
                    x.linkEnd(z, g);
                }
            }
            for (Interval a : dFAState.getAlphabetRanges()) {
                DFAState h = dFAState.go(a.getInfimumBound());
                if (h.equals(d.getInitialState())) {
                    x.linkAlphabet(v, a, (Object)lh);
                    continue;
                }
                DBS w = (DBS)m.get(h);
                if (w == null) {
                    w = new DBS();
                    m.put(h, w);
                }
                x.linkAlphabet(w, a, (Object)lh);
            }
        }
    }

    private void _linkre(NinaEvent q, String re, DBS x, String lh, String lc) {
        try {
            NFAObject<Object, NFAState, Integer> n = RegexParser.parse(re);
            DFA<Object, NFAState, Integer> d = ConvertedRangeDFA.convertDFA(n);
            this._linkdfa1(q, d, x, this.vertex, this.mealy, lh, String.valueOf(lh) + lc, "", "", false);
        }
        catch (RegexParseException e) {
            throw new NinaException("invalidregex", new Object[0]);
        }
    }

    private static boolean _isword(CharSequence s) {
        int k = 0;
        while (k < s.length()) {
            if (NOT_WORD.contains(s.charAt(k))) {
                return false;
            }
            ++k;
        }
        return true;
    }

    private void _linkdq(NinaEvent q, CharSequence s, DBS v, int f) {
        String lh = q.getLanguageOption().getLookahead();
        String lm = q.getLanguageOption().getLookaheadMark();
        String lc = q.getLanguageOption().getLookaheadCommit();
        String lu = q.getLanguageOption().getUnget();
        List<DoubleQuoteTokenizer.Elems> b = DoubleQuoteTokenizer.parse(s.toString());
        for (DoubleQuoteTokenizer.Elems p : b) {
            String g;
            int C;
            int c;
            DBS X;
            DBS x = X = v;
            s = p.getString();
            int k = 0;
            while (k < s.length() - 1) {
                DBS a;
                if (f == 73) {
                    DBS A;
                    c = s.charAt(k);
                    C = Character.toUpperCase(c);
                    c = Character.toLowerCase(c);
                    x = x.edges == null ? this._linkc(q, x, c, lh) : ((a = x.edges.map((Interval)((Object)Integer.valueOf(c)))) != null ? a : this._linkc(q, x, c, lh));
                    X = X.edges == null ? this._linkc(q, X, C, lh) : ((A = X.edges.map((Interval)((Object)Integer.valueOf(C)))) != null ? A : this._linkc(q, X, C, lh));
                } else {
                    c = s.charAt(k);
                    x = x.edges == null ? this._linkc(q, x, c, lh) : ((a = x.edges.map((Interval)((Object)Integer.valueOf(c)))) != null ? a : this._linkc(q, x, c, lh));
                }
                ++k;
            }
            if (p.getRegex() != null) {
                x = this._linkc(q, x, s.charAt(k), String.valueOf(lh) + lm);
                this._linkre(q, p.getRegex(), x, q.getLanguageOption().getLookahead(), q.getLanguageOption().getLookaheadCommit());
                continue;
            }
            if (p.getLookahead() != null) {
                x = this._linkc(q, x, s.charAt(k), lh);
                g = String.valueOf(lm) + lh;
                boolean z = p.isInvertLookahead();
                s = p.getLookahead();
                k = 0;
                while (k < s.length() - 1) {
                    c = s.charAt(k);
                    if (z) {
                        this._linki(q, x, c, String.valueOf(g) + lc);
                    }
                    x = this._linkc(q, x, c, g);
                    g = lh;
                    ++k;
                }
                g = String.valueOf(g) + lc;
                if (this.mealy != null) {
                    g = String.valueOf(g) + this.mealy.toString();
                }
                Range r = Interval.newPoint(s.charAt(k));
                if (p.isInvertLookahead()) {
                    r = CharSets.complement(r);
                }
                x.linkAlphabet(this.vertex, r, (Object)g);
                continue;
            }
            if (DFABuilder._isword(s)) {
                g = String.valueOf(lc) + lu;
                if (this.mealy != null) {
                    g = String.valueOf(g) + this.mealy.toString();
                }
                if (f == 73) {
                    c = s.charAt(k);
                    C = Character.toUpperCase(c);
                    c = Character.toLowerCase(c);
                    x = this._linkc(q, x, c, lh);
                    X = this._linkc(q, X, C, lh);
                    x.linkAlphabet(this.vertex, NOT_WORD, (Object)g);
                    X.linkAlphabet(this.vertex, NOT_WORD, (Object)g);
                    continue;
                }
                x = this._linkc(q, x, s.charAt(k), lh);
                x.linkAlphabet(this.vertex, NOT_WORD, (Object)g);
                continue;
            }
            g = lc;
            if (this.mealy != null) {
                g = String.valueOf(g) + this.mealy.toString();
            }
            if (f == 73) {
                c = s.charAt(k);
                C = Character.toUpperCase(c);
                c = Character.toLowerCase(c);
                this._linkv(q, x, this.vertex, c, g);
                this._linkv(q, X, this.vertex, C, g);
                continue;
            }
            this._linkv(q, x, this.vertex, s.charAt(k), g);
        }
    }

    private void _link1(NinaEvent q, DBS v) {
        CharSequence s = ((W)q.getEdge()).wrap;
        int b = ((W)q.getEdge()).quote;
        int f = ((W)q.getEdge()).quoteFlag;
        int l = s.length() - 1;
        DBS x = v;
        if (b == 34) {
            this._linkdq(q, s, v, f);
        } else {
            int k = 0;
            while (k < l) {
                x = this._linkc(q, x, s.charAt(k), null);
                ++k;
            }
            Interval r = Interval.newPoint(s.charAt(k));
            x.linkAlphabet(this.vertex, r, this.mealy);
        }
    }

    private void _linksq(NinaEvent q, DBS v, Range r, int len) {
        NinaLanguageOption p = q.getLanguageOption();
        String t = "";
        DBS x = v;
        String m = this.mealy != null ? this.mealy.toString() : "";
        String s = this.mealyType == 37 ? p.getInitBuffer(m) : "";
        int k = 0;
        while (k < len - 1) {
            DBS y = this.createState(q);
            if (this.mealyType == 37) {
                t = p.getAppendBuffer(m);
            } else if (this.mealyType == 35) {
                t = p.getAssignArray(m, k);
            }
            if (r == null) {
                x.linkOthers(y, String.valueOf(s) + t);
            } else {
                x.linkAlphabet(y, r, (Object)(String.valueOf(s) + t));
            }
            s = "";
            ++k;
            x = y;
        }
        t = this.mealyType == 37 ? p.getAppendBuffer(m) : (this.mealyType == 35 ? p.getAssignArray(m, len - 1) : m);
        if (r == null) {
            x.linkOthers(this.vertex, t);
        } else {
            x.linkAlphabet(this.vertex, r, (Object)t);
        }
    }

    private void _linkrepr(NinaEvent q, DBS w, String sub, Object dl) {
        NinaLanguageOption l = q.getLanguageOption();
        String s = l.getUnget();
        String t = this.mealy != null ? String.valueOf(s) + this.mealy.toString() : s;
        DBS v = new DBS();
        w.linkOthers(v, String.valueOf(l.getUnget()) + l.getInitList());
        if (dl == null || dl.equals("")) {
            v.linkRecursive(this.vertex, sub);
            this.vertex.linkOthers(v, s);
        } else if (dl instanceof String) {
            DBS x = new DBS();
            v.linkRecursive(x, sub);
            x.label = l.getAddList();
            x.linkAlphabet(v, dl, null);
            x.linkOthers(this.vertex, t);
            x.linkEnd(this.vertex, this.mealy);
        } else if (dl instanceof DFA) {
            DBS x = new DBS();
            v.linkRecursive(x, sub);
            x.label = l.getAddList();
            this._linkdfa1(q, (DFA)dl, x, v, this.mealy, "", s, "", "", true);
            x.linkOthers(this.vertex, t);
            x.linkEnd(this.vertex, this.mealy);
        } else {
            char[] a = (char[])dl;
            if (a.length < 1) {
                v.linkRecursive(this.vertex, sub);
                this.vertex.linkOthers(v, s);
            } else {
                DBS z;
                DBS x = z = new DBS();
                v.linkRecursive(z, sub);
                z.label = l.getAddList();
                int k = 0;
                while (k < a.length - 1) {
                    DBS y = new DBS();
                    x.linkAlphabet(y, IntervalsInt.newPoint(a[k]), null);
                    x = y;
                    ++k;
                }
                x.linkAlphabet(v, IntervalsInt.newPoint(a[k]), null);
                z.linkOthers(this.vertex, t);
                z.linkEnd(this.vertex, this.mealy);
            }
        }
    }

    private void _linkDigitsBig(NinaEvent q, DBS v, boolean s) {
        NinaLanguageOption p = q.getLanguageOption();
        DBS y = null;
        String m = this.mealy != null ? this.mealy.toString() : "";
        String ib = p.getInitBuffer(p.getSequenceBufferName());
        String ab = p.getAppendBuffer(p.getSequenceBufferName());
        String ed = String.valueOf(p.getUnget()) + p.getBufferToBigInteger(10) + m;
        if (s) {
            y = this.createState(q);
            v.linkAlphabet(y, SIGN_P, (Object)ib);
            v.linkAlphabet(y, SIGN_N, (Object)(String.valueOf(ib) + ab));
        }
        DBS x = this.createState(q);
        v.linkAlphabet(x, DIGIT, (Object)(String.valueOf(ib) + ab));
        if (y != null) {
            y.linkAlphabet(x, DIGIT, (Object)ab);
        }
        x.linkAlphabet(x, DIGIT, (Object)ab);
        x.linkOthers(this.vertex, ed);
        x.linkEnd(this.vertex, ed);
    }

    private void _linkDigitsInt(NinaEvent q, DBS v, int d, boolean s) {
        NinaLanguageOption p = q.getLanguageOption();
        DBS y = v;
        String m = this.mealy != null ? this.mealy.toString() : "";
        String ib = p.getInitBuffer(p.getSequenceBufferName());
        String ab = p.getAppendBuffer(p.getSequenceBufferName());
        String ed = String.valueOf(p.getBufferToInteger(10)) + m;
        if (s) {
            y = this.createState(q);
            v.linkAlphabet(y, SIGN_P, (Object)ib);
            v.linkAlphabet(y, SIGN_N, (Object)(String.valueOf(ib) + ab));
            v.linkOthers(y, ib);
            ib = "";
        }
        if (d > 1) {
            DBS x = this.createState(q);
            y.linkAlphabet(x, DIGIT, (Object)(String.valueOf(ib) + ab));
            int i = 1;
            while (i < d - 1) {
                y = x;
                x = this.createState(q);
                y.linkAlphabet(x, DIGIT, (Object)ab);
                y.linkOthers(this.vertex, String.valueOf(p.getUnget()) + ed);
                y.linkEnd(this.vertex, String.valueOf(p.getUnget()) + ed);
                ++i;
            }
            x.linkAlphabet(this.vertex, DIGIT, (Object)(String.valueOf(ab) + ed));
            x.linkOthers(this.vertex, String.valueOf(p.getUnget()) + ed);
            x.linkEnd(this.vertex, String.valueOf(p.getUnget()) + ed);
        } else {
            y.linkAlphabet(this.vertex, DIGIT, (Object)(String.valueOf(ib) + ab + ed));
        }
    }

    private void _linkHexBig(NinaEvent q, DBS v) {
        NinaLanguageOption p = q.getLanguageOption();
        String m = this.mealy != null ? this.mealy.toString() : "";
        String ib = p.getInitBuffer(p.getSequenceBufferName());
        String ab = p.getAppendBuffer(p.getSequenceBufferName());
        String ed = String.valueOf(p.getUnget()) + p.getBufferToBigInteger(16) + m;
        DBS x = this.createState(q);
        v.linkAlphabet(x, HEXD, (Object)(String.valueOf(ib) + ab));
        x.linkAlphabet(x, HEXD, (Object)ab);
        x.linkOthers(this.vertex, ed);
        x.linkEnd(this.vertex, ed);
    }

    private void _linkHexInt(NinaEvent q, DBS v, int d) {
        NinaLanguageOption p = q.getLanguageOption();
        DBS y = v;
        String m = this.mealy != null ? this.mealy.toString() : "";
        String ib = p.getInitBuffer(p.getSequenceBufferName());
        String ab = p.getAppendBuffer(p.getSequenceBufferName());
        String ed = String.valueOf(p.getBufferToInteger(16)) + m;
        DBS x = this.createState(q);
        y.linkAlphabet(x, HEXD, (Object)(String.valueOf(ib) + ab));
        int i = 1;
        while (i < d / 4 - 1) {
            y = x;
            x = this.createState(q);
            y.linkAlphabet(x, HEXD, (Object)ab);
            y.linkOthers(this.vertex, String.valueOf(p.getUnget()) + ed);
            y.linkEnd(this.vertex, String.valueOf(p.getUnget()) + ed);
            ++i;
        }
        x.linkAlphabet(this.vertex, HEXD, (Object)(String.valueOf(ab) + ed));
        x.linkOthers(this.vertex, String.valueOf(p.getUnget()) + ed);
        x.linkEnd(this.vertex, String.valueOf(p.getUnget()) + ed);
    }

    private void _linkOctBig(NinaEvent q, DBS v) {
        NinaLanguageOption p = q.getLanguageOption();
        String m = this.mealy != null ? this.mealy.toString() : "";
        String ib = p.getInitBuffer(p.getSequenceBufferName());
        String ab = p.getAppendBuffer(p.getSequenceBufferName());
        String ed = String.valueOf(p.getUnget()) + p.getBufferToBigInteger(8) + m;
        DBS x = this.createState(q);
        v.linkAlphabet(x, OCTD, (Object)(String.valueOf(ib) + ab));
        x.linkAlphabet(x, OCTD, (Object)ab);
        x.linkOthers(this.vertex, ed);
        x.linkEnd(this.vertex, ed);
    }

    private void _linkOctInt(NinaEvent q, DBS v, int d) {
        NinaLanguageOption p = q.getLanguageOption();
        DBS y = v;
        String m = this.mealy != null ? this.mealy.toString() : "";
        String ib = p.getInitBuffer(p.getSequenceBufferName());
        String ab = p.getAppendBuffer(p.getSequenceBufferName());
        String ed = String.valueOf(p.getBufferToInteger(8)) + m;
        DBS x = this.createState(q);
        v.linkAlphabet(x, IntervalsInt.newClosedInterval(48, 48 + (1 << d % 3) - 1), (Object)(String.valueOf(ib) + ab));
        y = x;
        x = this.createState(q);
        v.linkAlphabet(x, IntervalsInt.newClosedInterval(48 + (1 << d % 3), 55), (Object)(String.valueOf(ib) + ab));
        y.linkAlphabet(x, OCTD, (Object)ab);
        y.linkOthers(this.vertex, String.valueOf(p.getUnget()) + ed);
        y.linkEnd(this.vertex, String.valueOf(p.getUnget()) + ed);
        int i = 2;
        while (i < d / 3) {
            y = x;
            x = this.createState(q);
            y.linkAlphabet(x, OCTD, (Object)ab);
            y.linkOthers(this.vertex, String.valueOf(p.getUnget()) + ed);
            y.linkEnd(this.vertex, String.valueOf(p.getUnget()) + ed);
            ++i;
        }
        x.linkAlphabet(this.vertex, OCTD, (Object)(String.valueOf(ab) + ed));
        x.linkOthers(this.vertex, String.valueOf(p.getUnget()) + ed);
        x.linkEnd(this.vertex, String.valueOf(p.getUnget()) + ed);
    }

    private void _linkFloat(NinaEvent q, DBS v) {
        NinaLanguageOption p = q.getLanguageOption();
        String m = this.mealy != null ? this.mealy.toString() : "";
        String ib = p.getInitBuffer(p.getSequenceBufferName());
        String ab = p.getAppendBuffer(p.getSequenceBufferName());
        String e1 = String.valueOf(p.getUnget()) + p.getBufferToNumberInteger() + m;
        String e2 = String.valueOf(p.getUnget()) + p.getBufferToNumberDouble() + m;
        DBS ssgn = this.createState(q);
        v.linkAlphabet(ssgn, SIGN_P, (Object)ib);
        v.linkAlphabet(ssgn, SIGN_N, (Object)(String.valueOf(ib) + ab));
        DBS sint = this.createState(q);
        v.linkAlphabet(sint, DIGIT, (Object)(String.valueOf(ib) + ab));
        ssgn.linkAlphabet(sint, DIGIT, (Object)ab);
        sint.linkAlphabet(sint, DIGIT, (Object)ab);
        sint.linkOthers(this.vertex, e1);
        sint.linkEnd(this.vertex, e1);
        DBS sfpt = this.createState(q);
        v.linkAlphabet(sfpt, POINT, (Object)(String.valueOf(ib) + ab));
        ssgn.linkAlphabet(sfpt, POINT, (Object)ab);
        sint.linkAlphabet(sfpt, POINT, (Object)ab);
        DBS sdec = this.createState(q);
        sfpt.linkAlphabet(sdec, DIGIT, (Object)ab);
        sdec.linkAlphabet(sdec, DIGIT, (Object)ab);
        sdec.linkOthers(this.vertex, e2);
        sdec.linkEnd(this.vertex, e2);
        DBS sep1 = this.createState(q);
        sint.linkAlphabet(sep1, CHAR_E, (Object)ab);
        sdec.linkAlphabet(sep1, CHAR_E, (Object)ab);
        DBS sep2 = this.createState(q);
        sep1.linkAlphabet(sep2, SIGN_P, (Object)ab);
        sep1.linkAlphabet(sep2, SIGN_N, (Object)ab);
        DBS sepd = this.createState(q);
        sep2.linkAlphabet(sepd, DIGIT, (Object)ab);
        sep1.linkAlphabet(sepd, DIGIT, (Object)ab);
        sepd.linkAlphabet(sepd, DIGIT, (Object)ab);
        sepd.linkOthers(this.vertex, e2);
        sepd.linkEnd(this.vertex, e2);
    }

    private void _linkId(NinaEvent q, DBS v, Range st, Range pa) {
        NinaLanguageOption p = q.getLanguageOption();
        String m = this.mealy != null ? this.mealy.toString() : "";
        String ib = p.getInitBuffer(p.getSequenceBufferName());
        String ab = p.getAppendBuffer(p.getSequenceBufferName());
        DBS svar = this.createState(q);
        v.linkAlphabet(svar, st, (Object)(String.valueOf(ib) + ab));
        svar.linkAlphabet(svar, pa, (Object)ab);
        svar.linkOthers(this.vertex, String.valueOf(p.getUnget()) + m);
        svar.linkEnd(this.vertex, m);
    }

    private void _linkSkipSpaces(NinaEvent q, DBS v, String str) {
        DBS x = v;
        v.linkAlphabet(v, SPACES, null);
        if (str.length() > 0) {
            int k = 0;
            while (k < str.length() - 1) {
                x = this._linkc(q, x, str.charAt(k), null);
                ++k;
            }
            x.linkAlphabet(this.vertex, IntervalsInt.newPoint(str.charAt(k)), this.mealy);
            this.vertex.linkAlphabet(this.vertex, SPACES, null);
        } else {
            v.linkOthers(this.vertex, q.getLanguageOption().getUnget());
            v.linkEnd(this.vertex, null);
        }
    }

    private void _linkBackslash(NinaEvent q, DBS v, int seq) {
        NinaLanguageOption p = q.getLanguageOption();
        switch (seq) {
            case 88: {
                DBS x = this.createState(q);
                String ib = p.getInitBuffer(p.getSequenceBufferName());
                String ab = p.getAppendBuffer(p.getSequenceBufferName());
                v.linkOthers(x, String.valueOf(ib) + ab);
                this._linkv(q, x, x, MARK, ab);
                String s = this.mealy != null ? this.mealy.toString() : "";
                s = String.valueOf(s) + p.getUnget();
                x.linkOthers(this.vertex, s);
                x.linkEnd(this.vertex, s);
                break;
            }
            case 98: {
                String s = this.mealy != null ? this.mealy.toString() : "";
                v.linkAlphabet(this.vertex, WORD, (Object)(String.valueOf(p.getUnget()) + s));
                break;
            }
            case 66: {
                String s = this.mealy != null ? this.mealy.toString() : "";
                v.linkAlphabet(this.vertex, NOT_WORD, (Object)(String.valueOf(p.getUnget()) + s));
                break;
            }
            default: {
                throw new NinaException("invalidsequence", new Object[0]);
            }
        }
    }

    private Range _regexFirst(DFA<Object, NFAState, Integer> d) {
        RangeAdder r = new RangeAdder();
        for (Interval a : d.getInitialState().getAlphabetRanges()) {
            r.add(a);
        }
        return r.toRange();
    }

    private void _linkRegex(NinaEvent q, DBS v, NFAObject<Object, NFAState, Integer> n, int f) {
        NinaLanguageOption p = q.getLanguageOption();
        if (f == 1) {
            DFA<Object, NFAState, Integer> d = ConvertedRangeDFA.convertDFA(n);
            this._linkdfa1(q, d, v, this.vertex, this.mealy, "", "", "", p.getUnget(), true);
        } else if (f == 2) {
            DFA<Object, NFAState, Integer> d = ConvertedRangeDFA.convertDFA(n);
            String h = p.getLookahead();
            String e = p.getLookaheadCommit();
            this._linkdfa1(q, d, v, this.vertex, this.mealy, h, e, "", p.getUnget(), true);
        } else if (f == 3) {
            DFA<Object, NFAState, Integer> d = ConvertedRangeDFA.convertDFA(n);
            String h = String.valueOf(p.getLookahead()) + p.getLookaheadMarkInit();
            String e = p.getLookaheadCommit();
            this._linkdfa1(q, d, v, this.vertex, this.mealy, h, e, p.getLookahead(), "", true);
        } else {
            DFA<Object, NFAState, Integer> d = ConvertedRangeDFA.convertDFA(n);
            String h = p.getAppendBuffer(p.getSequenceBufferName());
            String i = p.getInitBuffer(p.getSequenceBufferName());
            DBS x = this.createState(q);
            x.accepted = v.accepted;
            v.linkAlphabet(x, this._regexFirst(d), (Object)(String.valueOf(p.getUnget()) + i));
            this._linkdfa1(q, d, x, this.vertex, this.mealy, h, "", "", p.getUnget(), true);
        }
    }

    @Override
    public void link(NinaEvent q, Object ver) {
        DBS v = this.vertex;
        this.vertex = ver != null ? (DBS)ver : this.createState(q);
        Object o = q.getEdge();
        if (o == null) {
            v.linkOthers(this.vertex, q.getLanguageOption().getUnget());
            v.linkEnd(this.vertex, null);
            v.emptyTrans = true;
        } else if (o instanceof BuildMachine) {
            v.linkRecursive(this.vertex, ((BuildMachine)o).name);
        } else if (o instanceof RT) {
            v.linkRecursive(this.vertex, ((RT)o).name);
        } else if (o instanceof W) {
            this._link1(q, v);
        } else if (o instanceof SQ) {
            this._linksq(q, v, ((SQ)o).r, ((SQ)o).num);
        } else if (o.equals(CharSets.ALL_CHAR)) {
            v.linkOthers(this.vertex, this.mealy);
        } else if (o instanceof Range) {
            v.linkAlphabet(this.vertex, (Range)o, this.mealy);
        } else if (o instanceof UE) {
            v.linkUser(this.vertex, ((UE)o).edge, this.mealy);
        } else if (o instanceof DY) {
            v.linkDynamic(this.vertex, ((DY)o).var);
        } else if (o instanceof RR) {
            this._linkrepr(q, v, ((RR)o).name, ((RR)o).delim);
        } else if (o instanceof DG) {
            if (((DG)o).num < 0) {
                this._linkDigitsBig(q, v, ((DG)o).sign);
            } else {
                this._linkDigitsInt(q, v, ((DG)o).num, ((DG)o).sign);
            }
        } else if (o instanceof DH) {
            if (((DH)o).num < 0) {
                this._linkHexBig(q, v);
            } else {
                this._linkHexInt(q, v, ((DH)o).num);
            }
        } else if (o instanceof DO) {
            if (((DO)o).num < 0) {
                this._linkOctBig(q, v);
            } else {
                this._linkOctInt(q, v, ((DO)o).num);
            }
        } else if (o instanceof WS) {
            this._linkSkipSpaces(q, v, ((WS)o).str);
        } else if (o instanceof BS) {
            this._linkBackslash(q, v, ((BS)o).seq);
        } else if (o instanceof NFAObject) {
            this._linkRegex(q, v, (NFAObject)o, this.nfaFlag);
        } else if (o == _FLOAT) {
            this._linkFloat(q, v);
        } else if (o == _END) {
            v.linkEnd(this.vertex, this.mealy);
        } else if (o == _ID_JAVA) {
            this._linkId(q, v, ID_JAVA_START, ID_JAVA_PART);
        } else if (o == _ID_C) {
            this._linkId(q, v, ID_C_START, ID_C_PART);
        } else {
            v.linkAlphabet(this.vertex, o, this.mealy);
        }
        this.mealy = null;
    }

    @Override
    public String getLabel() {
        return this.vertex.label;
    }

    @Override
    public Object getVertex() {
        return this.vertex;
    }

    @Override
    public void setVertex(Object o) {
        this.vertex = (DBS)o;
    }

    @Override
    public void doneBlockSearching(NinaEvent q) {
        this.vertex = q.getScratch() instanceof NinaParser.Z ? (DBS)((NinaParser.Z)q.getScratch()).vertex : (DBS)q.getScratch();
    }

    @Override
    public void setEdge(NinaEvent q, Object o) {
        q.setEdge(o);
    }

    @Override
    public void setEdgeCharSequence(NinaEvent q, CharSequence o, int qc, int qf) {
        q.setEdge(new W(o, qc, qf));
    }

    @Override
    public void setEdgeResource(NinaEvent q, NinaParser p, String s, Map<String, String> map, NinaSubautomata sub) {
        String t = Nina.getFAName(sub, s);
        if (sub.containsKey(t)) {
            q.setEdge(new RT(t));
        } else {
            sub.put(t, null);
            q.setEdge(p.compileSubautomaton(s, new DFABuilder(), map, sub, null).getMachine());
        }
    }

    @Override
    public void setEdgeNFA(NinaEvent q, NFA<Object, NFAState, Integer> s, int f) {
        this.nfaFlag = f;
        q.setEdge(s);
    }

    @Override
    public void setEdgeEnd(NinaEvent q) {
        q.setEdge(_END);
    }

    @Override
    public void setEdgeGrammar(NinaEvent q, String name) {
        q.setEdge(new RT("g:" + name));
    }

    @Override
    public NinaAction accept(String name) {
        if (this.accepted == null) {
            this.name = name;
            this.accepted = new BuildMachine(name, this.initial);
        }
        return this;
    }

    @Override
    public DFA<Object, Object, Void> getMachine() {
        return this.accepted;
    }

    @Override
    public void setMealyEdge(int c) {
        this.mealy = Character.valueOf((char)c);
    }

    @Override
    public void setMealyEdge(Object o) {
        this.mealy = o;
    }

    @Override
    public void setPriority(int p) {
    }

    @Override
    public void putStateByLabel(String l, Object s) {
        this.map.put(l, (DBS)s);
        this.inv.put(s, l);
    }

    @Override
    public DBS getStateByLabel(String l) {
        return this.map.get(l);
    }

    @Override
    public String getLabelByState(Object s) {
        return this.inv.get(s);
    }

    @Override
    public Object getDeadState() {
        return this.getStateByLabel("D");
    }

    @Override
    public void setStartState(Object o) {
        this.vertex = (DBS)o;
        this.vertex.initial = true;
        this.initial = this.vertex;
    }

    @Override
    public void setUserEdge(NinaEvent q, String o) {
        q.setEdge(new UE(o));
    }

    @Override
    public Set<String> getLabels() {
        return this.map.keySet();
    }

    @Override
    public void putTypeByLabel(String l, String s) {
        this.typemap.put(l, s);
    }

    @Override
    public String getTypeByLabel(String l) {
        return this.typemap.get(l);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setEdgeSequence(NinaEvent q, Range r, int len) {
        q.setEdge(new SQ(r, len));
    }

    @Override
    public void setMealyEdgeType(int c) {
        this.mealyType = c;
    }

    @Override
    public void setAccept(boolean accept) {
        this.vertex.accepted = accept;
    }

    @Override
    public void setEdgeDynamic(NinaEvent q, String var) {
        q.setEdge(new DY(var));
        this.dynmap.put(var, var);
    }

    @Override
    public Map<String, String> getDynamicTransitMap() {
        return Collections.unmodifiableMap(this.dynmap);
    }

    @Override
    public void setEdgeRepeatedResource(NinaEvent q, String s, Object d) {
        q.setEdge(new RR(s, d));
    }

    @Override
    public NinaAction empty(NinaEvent q, String name) {
        this.setStartState(this.createState(q));
        return this.accept(name);
    }

    @Override
    public void setEdgeDigits(NinaEvent q, int digits, boolean sign) {
        q.setEdge(new DG(digits, sign));
    }

    @Override
    public void setEdgeHexadecimal(NinaEvent q, int bits) {
        q.setEdge(new DH(bits));
    }

    @Override
    public void setEdgeOctal(NinaEvent q, int bits) {
        q.setEdge(new DO(bits));
    }

    @Override
    public void setEdgeFloat(NinaEvent q) {
        q.setEdge(_FLOAT);
    }

    @Override
    public void setEdgeIndent(NinaEvent q, String cmp, int off) {
        NinaLanguageOption p = q.getLanguageOption();
        this.setUserEdge(q, p.getIndent(cmp, off));
    }

    @Override
    public void setEdgeIdentifier(NinaEvent q, String lang) {
        if (lang.equals("Java")) {
            q.setEdge(_ID_JAVA);
        } else {
            q.setEdge(_ID_C);
        }
    }

    @Override
    public void setEdgeSkipSpaces(NinaEvent q, String str) {
        q.setEdge(new WS(str));
    }

    @Override
    public void setEdgeBackslash(NinaEvent q, int c) {
        q.setEdge(new BS(c));
    }

    private static class BS {
        private int seq;

        BS(int s) {
            this.seq = s;
        }
    }

    public static class DBS
    implements DFAState<Object, Object, Void>,
    NFAState,
    NFAEdges<Object> {
        TreeSectionMap<Interval, Object, DBS> edges;
        TreeSectionMap<Interval, Object, Object> mealy;
        Map<String, DBS> userEdge = null;
        Map<String, Object> userMealy = null;
        boolean initial;
        boolean accepted;
        boolean moore;
        String nomFichier;
        String label;
        String recursiveName = null;
        Object mealyOthers = null;
        Object mealyEnd = null;
        DBS others = null;
        DBS end = null;
        DBS recursive = null;
        String dynamicVariable;
        DBS dynamic = null;
        PrintWriter out = null;
        int devoirFermer = 0;
        boolean emptyTrans = false;
        Collection<DBS> identical = null;

        private void _linkRange(DBS d, Range o, Interval r, Object m) {
            if (d.identical != null) {
                throw new NinaException("invaliddfasubautomaton", new Object[0]);
            }
            if (this.edges == null) {
                this.edges = new TreeSectionMap(r, d);
                this.mealy = new TreeSectionMap(r, m);
            } else {
                this.edges.insert(r, d);
                this.mealy.insert(r, m);
            }
        }

        void linkAlphabet(DBS d, Object o, Object m) {
            if (this.identical != null) {
                for (DBS x : this.identical) {
                    x.linkAlphabet(d, o, m);
                }
            } else {
                Interval r = Interval.newPoint(o);
                this._linkRange(d, r, r, m);
            }
        }

        void linkAlphabet(DBS d, Range o, Object m) {
            if (this.identical != null) {
                for (DBS x : this.identical) {
                    x.linkAlphabet(d, o, m);
                }
            } else {
                for (Interval v : o.intervals()) {
                    this._linkRange(d, o, v, m);
                }
            }
        }

        void linkOthers(DBS d, Object m) {
            if (this.others != null || this.recursive != null) {
                throw new NinaNondeterministicException("others");
            }
            this.others = d;
            this.mealyOthers = m;
        }

        void linkRecursive(DBS d, String name) {
            if (this.others != null || this.end != null) {
                throw new NinaNondeterministicException("others");
            }
            this.recursive = d;
            this.recursiveName = name;
        }

        void linkEnd(DBS d, Object m) {
            if (this.end != null || this.recursive != null) {
                throw new NinaNondeterministicException("END");
            }
            this.end = d;
            this.mealyEnd = m;
        }

        void linkUser(DBS d, String l, Object m) {
            if (this.userEdge == null) {
                this.userEdge = new HashMap<String, DBS>();
                this.userMealy = new HashMap<String, Object>();
            }
            this.userEdge.put(l, d);
            this.userMealy.put(l, m);
        }

        void linkDynamic(DBS d, String var) {
            this.dynamicVariable = var;
            this.dynamic = d;
        }

        void sortir(Object o) {
            try {
                String s;
                if (this.nomFichier == null || this.nomFichier.equals("")) {
                    return;
                }
                if (this.out == null) {
                    if (this.nomFichier.equals("/dev/stdout")) {
                        this.out = new PrintWriter(System.out, true);
                        this.devoirFermer = -1;
                    } else if (this.nomFichier.equals("/dev/stderr")) {
                        this.out = new PrintWriter(System.err, true);
                        this.devoirFermer = -1;
                    } else if (this.nomFichier.equals("/dev/null")) {
                        this.out = null;
                    } else {
                        this.out = new PrintWriter(new FileOutputStream(this.nomFichier, this.devoirFermer > 0), true);
                        this.devoirFermer = 1;
                    }
                }
                if (this.out != null && o != null && !(s = o.toString().trim()).equals("")) {
                    this.out.print(s);
                    this.out.flush();
                }
                if (this.devoirFermer > 0) {
                    this.out.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        void sortirMoore() {
            if (this.moore) {
                this.sortir(this.label.trim());
            }
        }

        public DBS getOthers() {
            return this.others;
        }

        public Object getMealyOthers() {
            return this.mealyOthers;
        }

        public DBS getEnd() {
            return this.end;
        }

        public Object getMealyEnd() {
            return this.mealyEnd;
        }

        public DBS getRecursive() {
            return this.recursive;
        }

        public String getRecursiveName() {
            return this.recursiveName;
        }

        public Set<String> getUserEdges() {
            return this.userEdge != null ? this.userEdge.keySet() : null;
        }

        public DBS getUserEdge(String s) {
            return this.userEdge != null ? this.userEdge.get(s) : null;
        }

        public Object getUserMealyEdge(String s) {
            return this.userMealy != null ? this.userMealy.get(s) : null;
        }

        public String getDynamicVariable() {
            return this.dynamicVariable;
        }

        public DBS getDynamic() {
            return this.dynamic;
        }

        @Override
        public DFAState<Object, Object, Void> go(Object a) {
            DFAState d;
            if (this.edges != null && (d = (DFAState)this.edges.map((Interval)a)) != null) {
                this.sortir(this.mealy.map((Interval)a));
                if (d instanceof DBS) {
                    ((DBS)d).sortirMoore();
                }
                return d;
            }
            if (this.others == null) {
                return DFAs.deadState();
            }
            this.sortir(this.mealyOthers);
            return this.others;
        }

        @Override
        public DFAState<Object, Object, Void> goInt(int x) {
            return this.go((Object)x);
        }

        @Override
        public DFAState<Object, Object, Void> goChar(char x) {
            return this.go((Object)x);
        }

        @Override
        public DFAState<Object, Object, Void> goBound(TextBound b) {
            return DFAs.deadState();
        }

        @Override
        public boolean isInitialState() {
            return this.initial;
        }

        @Override
        public Set<Object> getAccepted() {
            return this.accepted ? Collections.singleton(this.label) : Collections.emptySet();
        }

        @Override
        public boolean isDead() {
            return this.edges == null && this.others == null && this.end == null && this.recursive == null && this.dynamic == null;
        }

        public boolean isOnlyEmptyTransition() {
            return this.emptyTrans && !this.initial && this.edges == null && this.recursive == null && this.dynamic == null;
        }

        @Override
        public boolean isAccepted() {
            return this.accepted;
        }

        @Override
        public Set<Object> getAlphabets() {
            HashSet<Object> r = new HashSet<Object>();
            if (this.edges != null) {
                for (Interval v : this.edges.keys()) {
                    Object b;
                    Object a = v.getInfimumBound();
                    if (a.equals(b = v.getSupremumBound())) {
                        r.add(a);
                        continue;
                    }
                    if (a instanceof Integer) {
                        int x;
                        int i = x = ((Integer)a).intValue();
                        while (v.contains(i)) {
                            r.add(i);
                            ++i;
                        }
                        continue;
                    }
                    throw new NinaException("invalidalphabet", a);
                }
            }
            return r;
        }

        @Override
        public Iterable<Interval> getAlphabetRanges() {
            return this.edges != null ? this.edges.keys() : Collections.emptySet();
        }

        @Override
        public Object getLabel(Object a) {
            return this.mealy.map((Interval)a);
        }

        @Override
        public Object getLabelInt(int x) {
            return this.getLabel((Object)x);
        }

        @Override
        public Object getLabelChar(char x) {
            return this.getLabel((Object)x);
        }

        @Override
        public Set<NFAState> goNext(Object a) {
            DBS d;
            if (this.edges != null && (d = this.edges.map((Interval)a)) != null) {
                return Collections.singleton(d);
            }
            if (this.others == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(this.others);
        }

        @Override
        public Set<NFAState> goNext(int a) {
            return this.goNext((Object)a);
        }

        @Override
        public Set<NFAState> goNext(char a) {
            return this.goNext((Object)a);
        }

        @Override
        public Set<NFAState> goNextEpsilon() {
            return Collections.emptySet();
        }

        @Override
        public Set<? extends Range> nextAlphabets() {
            HashSet<Range> x = new HashSet<Range>();
            RangeAdder a = new RangeAdder();
            for (Tuple2<Interval, DBS> t : this.edges.entries()) {
                x.add(t.getA());
                a.add(t.getA());
            }
            if (this.others != null) {
                x.add(CharSets.complement(a.toRange()));
            }
            return x;
        }

        @Override
        public boolean isNextEpsilon() {
            return false;
        }

        public String toString() {
            return this.label;
        }
    }

    private static class DG {
        private int num;
        private boolean sign;

        DG(int n, boolean s) {
            this.num = n;
            this.sign = s;
        }
    }

    private static class DH {
        private int num;

        DH(int n) {
            this.num = n;
        }
    }

    private static class DO {
        private int num;

        DO(int n) {
            this.num = n;
        }
    }

    private static class DY {
        private String var;

        DY(String s) {
            this.var = s;
        }
    }

    private static class RR {
        private String name;
        private Object delim;

        RR(String s, Object d) {
            this.name = s;
            this.delim = d;
        }
    }

    private static class RT {
        private String name;

        RT(String s) {
            this.name = s;
        }
    }

    private static class SQ {
        private Range r;
        private int num;

        SQ(Range r, int n) {
            this.r = r;
            this.num = n;
        }
    }

    private static class UE {
        private String edge;

        UE(String s) {
            this.edge = s;
        }
    }

    private static class W {
        private CharSequence wrap;
        private int quote;
        private int quoteFlag;

        W(CharSequence s, int qc, int qf) {
            this.wrap = s;
            this.quote = qc;
            this.quoteFlag = qf;
        }
    }

    private static class WS {
        private String str;

        WS(String s) {
            this.str = s;
        }
    }
}

