/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.Reader;
import net.morilib.nina.NinaParser;
import net.morilib.nina.Quadro;

public class NinaFrameReader
extends Reader {
    private Quadro quadro;
    private E etat = E.INIT;

    NinaFrameReader(Quadro q) {
        this.quadro = q;
    }

    private boolean isfrm2() {
        return NinaParser._FRAME1.equals(this.quadro.getScratch2()) || NinaParser._FRAME2.equals(this.quadro.getScratch2());
    }

    @Override
    public int read() {
        block7: while (true) {
            switch (this.etat) {
                case INIT: {
                    if (this.isfrm2()) {
                        this.quadro.north();
                        this.etat = E.EOF;
                        continue block7;
                    }
                    this.etat = E.CHR0;
                    int c = this.quadro.get();
                    this.quadro.east();
                    return c < 0 ? 0 : c;
                }
                case CHR0: {
                    if (this.isfrm2()) {
                        this.quadro.west();
                        this.etat = E.CRLF;
                        continue block7;
                    }
                    int c = this.quadro.get();
                    if (c >= 0) {
                        this.quadro.east();
                        return c;
                    }
                    this.quadro.east();
                    continue block7;
                }
                case CRLF: {
                    if (this.isfrm2()) {
                        this.quadro.east().south();
                        this.etat = E.INIT;
                        return 10;
                    }
                    this.quadro.west();
                    continue block7;
                }
                case EOF: {
                    if (this.isfrm2()) {
                        this.quadro.west();
                        this.etat = E.FIN;
                        continue block7;
                    }
                    this.quadro.north();
                    continue block7;
                }
                case FIN: {
                    return -1;
                }
            }
        }
    }

    @Override
    public int read(char[] b, int off, int len) {
        int i = off;
        while (i < off + len) {
            int c = this.read();
            if (c < 0) {
                return i > off ? i - off : -1;
            }
            b[i] = (char)c;
            ++i;
        }
        return len;
    }

    @Override
    public int read(char[] cbuf) {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public void close() {
        switch (this.etat) {
            case INIT: {
                this.quadro.west();
                while (this.isfrm2()) {
                    this.quadro.north();
                }
                this.quadro.south();
                return;
            }
            case CHR0: {
                while (!this.isfrm2()) {
                    this.quadro.west();
                }
                while (this.isfrm2()) {
                    this.quadro.north();
                }
                this.quadro.south();
                return;
            }
        }
    }

    private static enum E {
        INIT,
        CHR0,
        CRLF,
        EOF,
        FIN;

    }
}

