/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.cmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.nina.NinaConsole;
import net.morilib.nina.NinaNullConsole;
import net.morilib.nina.Quadro;
import net.morilib.nina.cmd.NinaInfo;
import net.morilib.nina.cmd.NinatMessages;
import net.morilib.nina.translate.NinaTranslator;
import net.morilib.nina.translate.NinaTranslatorJavaScript;
import net.morilib.nina.translate.NinaTranslatorXML;
import net.morilib.nina.translate.ProxyNinaTranslator;
import net.morilib.nina.translate.sh.ShNinaRealFile;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;

public class NinatOptions
implements NinaInfo {
    private static final Pattern POPT = Pattern.compile("-P([^=]+)=(.*)");
    private static final Pattern TABP = Pattern.compile("--tab=([0-9]+)");
    private NinaTranslator translator = new ProxyNinaTranslator();
    private NinaTranslator report = null;
    private Map<String, String> opts = new HashMap<String, String>();
    private List<String> libs = new ArrayList<String>();
    private NinaConsole console = NinaNullConsole.NULL;
    private boolean jflag = false;
    private boolean stdin = false;
    String filename;

    int parseOptions(String[] args, Map<String, String> prms) {
        int k = 0;
        while (k < args.length) {
            String s = args[k];
            if (s.equals("-J")) {
                this.jflag = true;
            } else if (s.startsWith("-L")) {
                this.libs.add(s.substring(2));
            } else if (s.equals("-v")) {
                this.console = this;
            } else if (s.equals("-i")) {
                this.translator = new NinaTranslatorJavaScript();
                this.opts.put("interpret", "on");
            } else if (s.equals("-I")) {
                if (k + 1 < args.length) {
                    this.opts.put("inject", args[++k]);
                }
            } else if (s.equals("-")) {
                this.stdin = true;
            } else {
                Matcher m = POPT.matcher(s);
                if (m.matches()) {
                    prms.put(m.group(1), m.group(2));
                } else {
                    if (!s.startsWith("--")) {
                        return k;
                    }
                    if (s.equals("--help")) {
                        this.usage();
                        System.exit(2);
                    } else if (s.equals("--lint")) {
                        Quadro.errst = System.err;
                    } else if (s.startsWith("--libpath=")) {
                        this.libs.add(s.substring(10));
                    } else if (s.equals("--verbose")) {
                        this.console = this;
                    } else if (s.equals("--xml")) {
                        this.report = new NinaTranslatorXML();
                    } else {
                        m = TABP.matcher(s);
                        if (m.matches()) {
                            Quadro.setTab(Integer.valueOf(m.group(1)));
                        } else {
                            int x = s.indexOf(61);
                            if (x < 0) {
                                this.opts.put(s.substring(2), "");
                            } else {
                                this.opts.put(s.substring(2, x), s.substring(x + 1));
                            }
                        }
                    }
                }
            }
            ++k;
        }
        return k;
    }

    @Override
    public void print(String p, Object ... a) {
        System.err.println(NinatMessages.getMessage(p, a));
    }

    @Override
    public void perror(String p, Object ... a) {
        System.err.print(NinatMessages.getMessage("errorheader", new Object[0]));
        System.err.println(NinatMessages.getMessage(p, a));
    }

    @Override
    public void pwarn(String p, Object ... a) {
        System.err.print(NinatMessages.getMessage("warnheader", new Object[0]));
        System.err.println(NinatMessages.getMessage(p, a));
    }

    @Override
    public void pmessage(String p) {
        System.err.print(NinatMessages.getMessage("errorheader", new Object[0]));
        System.err.println(p);
    }

    public void usage() {
        int l = Integer.parseInt(NinatMessages.getMessage("usage.length", new Object[0]));
        this.print("title", "0.4.12");
        int i = 1;
        while (i <= l) {
            String x = String.format("%03d", i);
            this.print("usage." + x, new Object[0]);
            ++i;
        }
    }

    public NinaTranslator getTranslator() {
        return this.translator;
    }

    public NinaTranslator getReport() {
        return this.report;
    }

    @Override
    public String getClassName() {
        char[] a = this.getOutputFilename().toCharArray();
        a[0] = Character.toUpperCase(a[0]);
        return new String(a);
    }

    @Override
    public String getBufSize() {
        String s = this.getOption("bufsize");
        return s.equals("") ? "1024" : s;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getOutputFilename() {
        String s = this.getOption("outfile");
        return s.equals("") ? this.filename : s;
    }

    @Override
    public Object getOutputDir() {
        String s = this.getOption("output");
        return new File(s.equals("") ? "." : s);
    }

    @Override
    public Object getTitleFile(String t) {
        char[] a = (String.valueOf(this.getOutputFilename()) + t).toCharArray();
        a[0] = Character.toUpperCase(a[0]);
        String s = this.getOption("output");
        s = s.equals("") ? "." : s;
        return new File(s, new String(a));
    }

    @Override
    public NinaConsole getConsole() {
        return this.console;
    }

    @Override
    public Object getInjectFile() {
        String s = this.opts.get("inject");
        return s != null ? new File(s) : null;
    }

    @Override
    public OutputStream getOutputStream(Object path, String file) throws IOException {
        return new FileOutputStream(new File((File)path, file));
    }

    @Override
    public OutputStream getOutputStream(Object file) throws IOException {
        return new FileOutputStream((File)file);
    }

    @Override
    public InputStream getInputStream(Object path, String file) throws IOException {
        return new FileInputStream(new File((File)path, file));
    }

    @Override
    public InputStream getInputStream(Object file) throws IOException {
        return new FileInputStream((File)file);
    }

    @Override
    public void postprocess() {
    }

    @Override
    public ShFile getShOutputDir(ShFileSystem fs) {
        return new ShNinaRealFile(fs, "/output", (File)this.getOutputDir());
    }

    @Override
    public ShFile getShOutputFile(ShFileSystem fs, String p, String f) {
        return new ShNinaRealFile(fs, p, new File((File)this.getOutputDir(), f));
    }

    public String getOption(String key) {
        String s = this.opts.get(key);
        return s != null ? s : "";
    }

    public boolean isOptionDefined(String key) {
        return this.opts.containsKey(key);
    }

    public List<String> getLibraryList() {
        return Collections.unmodifiableList(this.libs);
    }

    public String getJavaFile() {
        return this.getTitleFile(".java").toString();
    }

    public boolean isJavaCompiler() {
        return this.jflag;
    }

    public boolean isStandardInput() {
        return this.stdin;
    }
}

