/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShLexer;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShString;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShTrees;
import net.morilib.sh.misc.XtraceStream;

public class ShToken {
    public static final ShToken PIPE = new ShToken(){

        @Override
        public int precedence() {
            return 10;
        }

        public String toString() {
            return "|";
        }
    };
    public static final ShToken BG = new ShToken(){

        @Override
        public int precedence() {
            return 50;
        }

        public String toString() {
            return "&";
        }
    };
    public static final ShToken FG = new ShToken(){

        @Override
        public int precedence() {
            return 50;
        }

        @Override
        public boolean isEndOfLine() {
            return true;
        }

        public String toString() {
            return ";";
        }
    };
    public static final ShToken CASEEND = new ShToken(){

        @Override
        public int precedence() {
            return 50;
        }

        public String toString() {
            return ";;";
        }
    };
    public static final ShToken NEWLINE = new ShToken(){

        @Override
        public int precedence() {
            return 50;
        }

        @Override
        public boolean isEndOfLine() {
            return true;
        }

        public String toString() {
            return "\\n";
        }
    };
    public static final ShToken EOF = new ShToken(){

        @Override
        public int precedence() {
            return 50;
        }

        public String toString() {
            return "<eof>";
        }
    };
    public static final ShToken AND = new ShToken(){

        @Override
        public int precedence() {
            return 30;
        }

        public String toString() {
            return "&&";
        }
    };
    public static final ShToken OR = new ShToken(){

        @Override
        public int precedence() {
            return 40;
        }

        public String toString() {
            return "||";
        }
    };
    public static final ShToken PAREN_B = new ShToken(){

        public String toString() {
            return "(";
        }
    };
    public static final ShToken PAREN_E = new ShToken(){

        @Override
        public int precedence() {
            return 50;
        }

        public String toString() {
            return ")";
        }
    };

    public boolean isString() {
        return false;
    }

    public boolean isEndOfLine() {
        return false;
    }

    public boolean equalsKeyword(String keyword) {
        return false;
    }

    public int precedence() {
        return -1;
    }

    public List<ShToken> replaceBracket() {
        throw new UnsupportedOperationException();
    }

    public static String replaceTilde(ShEnvironment env, String s) {
        if (s.equals("~")) {
            return env.find("HOME");
        }
        if (s.startsWith("~/")) {
            return s.replaceFirst("^~", env.find("HOME"));
        }
        return s;
    }

    public ShToken replaceTilde(ShEnvironment run) {
        throw new UnsupportedOperationException();
    }

    public List<ShToken> replaceParameter(ShEnvironment env, PrintStream err) {
        throw new UnsupportedOperationException();
    }

    public ShToken replaceCommand(ShEnvironment env, ShFileSystem fs, ShRuntime run, XtraceStream p) throws IOException, ShSyntaxException {
        throw new UnsupportedOperationException();
    }

    public ShToken replaceArithmetic(ShEnvironment env) throws ShSyntaxException {
        throw new UnsupportedOperationException();
    }

    public List<String> splitWord(String ifs) {
        throw new UnsupportedOperationException();
    }

    public boolean isFileRedirector() {
        return false;
    }

    public boolean isDescriptorCopier() {
        return false;
    }

    public boolean isHereDocument() {
        return false;
    }

    public static boolean isWildcard(String name) {
        S1 stat = S1.INIT;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            switch (stat) {
                case INIT: {
                    if (c == '*') {
                        return true;
                    }
                    if (c == '[') {
                        return true;
                    }
                    if (c == '?') {
                        return true;
                    }
                    if (c == '\'') {
                        stat = S1.SQUT;
                        break;
                    }
                    if (c == '\"') {
                        stat = S1.DQUT;
                        break;
                    }
                    if (c != '\\') break;
                    stat = S1.ESC1;
                    break;
                }
                case SQUT: {
                    if (c != '\'') break;
                    stat = S1.INIT;
                    break;
                }
                case DQUT: {
                    if (c == '\"') {
                        stat = S1.INIT;
                        break;
                    }
                    if (c != '\\') break;
                    stat = S1.ESC2;
                    break;
                }
                case ESC1: {
                    stat = S1.INIT;
                    break;
                }
                case ESC2: {
                    stat = S1.DQUT;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean isWildcard() {
        return false;
    }

    public static boolean isBind(String value) {
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (i > 0 && c == '=') {
                return true;
            }
            if (!ShLexer.isId(c)) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public boolean isBind() {
        return false;
    }

    public static void bindVariable(ShEnvironment env, ShFileSystem fs, ShRuntime run, PrintStream err, XtraceStream p, String v) throws IOException, ShSyntaxException {
        String t;
        int x = v.indexOf(61);
        String s = v.substring(0, x);
        String string = t = x < v.length() - 1 ? v.substring(x + 1) : "";
        if (env.isReadonly(s)) {
            err.print(s);
            err.println(": readonly variable");
        } else {
            env.bind(s, ShTrees.substitute(env, run, fs, err, p, new ShString(t)).toString());
        }
    }

    public void bindVariable(ShEnvironment env, ShFileSystem fs, ShRuntime run, PrintStream err, XtraceStream p) throws IOException, ShSyntaxException {
        throw new UnsupportedOperationException();
    }

    private static enum S1 {
        INIT,
        ESC1,
        SQUT,
        DQUT,
        ESC2;

    }
}

