/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.misc;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.NoSuchElementException;

public class ByteRingBuffer
implements Serializable {
    private static final long serialVersionUID = 5015372387740172285L;
    private byte[] buffer;
    private int ptrt;
    private int ptrb;

    public ByteRingBuffer(int size) {
        this.buffer = new byte[size];
        this.ptrt = 0;
        this.ptrb = -1;
    }

    private void incb() {
        this.ptrb = this.ptrb < this.buffer.length ? this.ptrb + 1 : 1;
    }

    private void inct() {
        this.ptrt = this.ptrt < this.buffer.length ? this.ptrt + 1 : 1;
    }

    private void dect() {
        this.ptrt = this.ptrt > 0 ? this.ptrt - 1 : this.buffer.length - 1;
    }

    private int index(int c) {
        return (this.ptrb + c) % this.buffer.length;
    }

    public boolean add(byte c) {
        if (this.ptrb < 0) {
            this.ptrb = 0;
        } else if (this.ptrt % this.buffer.length == this.ptrb % this.buffer.length) {
            this.incb();
        }
        this.buffer[this.ptrt < this.buffer.length ? this.ptrt : 0] = c;
        this.inct();
        return this.size() < this.buffer.length;
    }

    public byte remove() {
        if (this.ptrb < 0) {
            throw new NoSuchElementException();
        }
        this.dect();
        byte res = this.buffer[this.ptrt];
        if (this.ptrb == this.ptrt) {
            this.ptrb = -1;
        }
        return res;
    }

    public int size() {
        if (this.ptrb < 0) {
            return 0;
        }
        return this.ptrt <= this.ptrb ? this.ptrt + this.buffer.length - this.ptrb : this.ptrt - this.ptrb;
    }

    public byte get(int c) {
        if (c >= this.buffer.length) {
            throw new IndexOutOfBoundsException("" + c);
        }
        if (c >= this.size()) {
            throw new NoSuchElementException();
        }
        return this.buffer[this.index(c)];
    }

    public boolean isEmpty() {
        return this.ptrb < 0;
    }

    public void clear() {
        this.ptrt = 0;
        this.ptrb = -1;
    }

    public void add(byte[] a, int len) {
        if (len != 0) {
            if (len >= this.buffer.length) {
                int s = len - this.buffer.length;
                System.arraycopy(a, s, this.buffer, 0, this.buffer.length);
                this.ptrt = 0;
                this.ptrb = 0;
            } else {
                byte[] b = new byte[this.buffer.length];
                this.toArray(b);
                if (len > this.buffer.length - this.size()) {
                    int s = this.buffer.length - len;
                    int t = this.size() - s;
                    System.arraycopy(b, t, this.buffer, 0, s);
                    System.arraycopy(a, 0, this.buffer, s, len);
                    this.ptrt = 0;
                    this.ptrb = 0;
                } else {
                    int s = this.size();
                    System.arraycopy(a, 0, b, s, len);
                    this.buffer = b;
                    this.ptrb = 0;
                    this.ptrt = s + len;
                }
            }
        }
    }

    public void add(byte[] a) {
        this.add(a, a.length);
    }

    public byte[] toArray(byte[] a) {
        int z;
        int b = this.ptrb;
        int e = this.ptrt;
        if (this.ptrb < 0) {
            return new byte[0];
        }
        int n = z = b >= e ? e + this.buffer.length : e;
        if (a.length < this.size()) {
            a = new byte[z - b];
        }
        if (z <= this.buffer.length) {
            System.arraycopy(this.buffer, b, a, 0, z);
        } else {
            int x = this.buffer.length - b;
            System.arraycopy(this.buffer, b, a, 0, x);
            System.arraycopy(this.buffer, 0, a, x, a.length - x);
        }
        return a;
    }

    public byte[] toArray() {
        return this.toArray(new byte[0]);
    }

    public String toString() {
        try {
            return new String(this.toArray(), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

