/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.morilib.sh.ShFile;
import net.morilib.sh.misc.UnixExecutableType;

public final class FileTypeUtils {
    private FileTypeUtils() {
    }

    public static String[] parseShebang(InputStream input) throws IOException {
        int c;
        StringBuffer b = null;
        StringBuffer d = null;
        String p = null;
        String f = null;
        S1 stat = S1.INIT;
        while ((c = input.read()) >= 0) {
            switch (stat) {
                case INIT: {
                    if (c != 35) {
                        return null;
                    }
                    stat = S1.SHRP;
                    break;
                }
                case SHRP: {
                    if (c != 33) {
                        return null;
                    }
                    stat = S1.BANG;
                    break;
                }
                case BANG: {
                    if (c == 47) {
                        b = new StringBuffer();
                        d = new StringBuffer("/");
                        stat = S1.PATH;
                        break;
                    }
                    if (c == 10 || c == 13) {
                        return null;
                    }
                    if (Character.isWhitespace(c)) break;
                    return null;
                }
                case PATH: {
                    if (c > 127) {
                        return null;
                    }
                    if (c == 10 || c == 13) {
                        if (b.length() == 0) {
                            return null;
                        }
                        return new String[]{d.toString(), b.toString(), ""};
                    }
                    if (c == 47) {
                        if (d.length() > 1) {
                            d.append('/');
                        }
                        d.append(b);
                        b = new StringBuffer();
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        p = d.toString();
                        f = b.toString();
                        b = new StringBuffer();
                        stat = S1.ARGS;
                        break;
                    }
                    if (Character.isISOControl(c)) {
                        return null;
                    }
                    b.append((char)c);
                    break;
                }
                case ARGS: {
                    if (c > 127) {
                        return null;
                    }
                    if (c == 10 || c == 13) {
                        return new String[]{p, f, ""};
                    }
                    if (Character.isWhitespace(c)) break;
                    if (Character.isISOControl(c)) {
                        return null;
                    }
                    b.append((char)c);
                    stat = S1.ARG2;
                    break;
                }
                case ARG2: {
                    if (c > 127) {
                        return null;
                    }
                    if (c == 10 || c == 13) {
                        return new String[]{p, f, b.toString()};
                    }
                    if (Character.isISOControl(c)) {
                        return null;
                    }
                    b.append((char)c);
                }
            }
        }
        return null;
    }

    public static String[] parseShebang(ShFile f) {
        InputStream ins = null;
        try {
            ins = f.getInputStream();
            String[] stringArray = FileTypeUtils.parseShebang(ins);
            return stringArray;
        }
        catch (IOException e) {
            return null;
        }
        finally {
            try {
                if (ins != null) {
                    ins.close();
                }
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    public static String[] parseShebang(File f) {
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(f);
            String[] stringArray = FileTypeUtils.parseShebang(ins);
            return stringArray;
        }
        catch (IOException e) {
            return null;
        }
        finally {
            try {
                if (ins != null) {
                    ((InputStream)ins).close();
                }
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    public static boolean guessWindowsExecutable(File f) {
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(f);
            if (((InputStream)ins).read() != 77) {
                return false;
            }
            return ((InputStream)ins).read() == 90;
            {
            }
        }
        catch (IOException e) {
            return false;
        }
        finally {
            try {
                if (ins != null) {
                    ((InputStream)ins).close();
                }
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    public static UnixExecutableType guessUnixExecutable(File f) {
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(f);
            if (((InputStream)ins).read() != 127) {
                UnixExecutableType unixExecutableType = UnixExecutableType.UNKNOWN;
                return unixExecutableType;
            }
            if (((InputStream)ins).read() != 69) {
                UnixExecutableType unixExecutableType = UnixExecutableType.UNKNOWN;
                return unixExecutableType;
            }
            if (((InputStream)ins).read() != 76) {
                UnixExecutableType unixExecutableType = UnixExecutableType.UNKNOWN;
                return unixExecutableType;
            }
            if (((InputStream)ins).read() != 70) {
                UnixExecutableType unixExecutableType = UnixExecutableType.UNKNOWN;
                return unixExecutableType;
            }
            UnixExecutableType unixExecutableType = UnixExecutableType.ELF;
            return unixExecutableType;
        }
        catch (IOException e) {
            UnixExecutableType unixExecutableType = UnixExecutableType.ERROR;
            return unixExecutableType;
        }
        finally {
            try {
                if (ins != null) {
                    ((InputStream)ins).close();
                }
            }
            catch (IOException e) {
                return UnixExecutableType.ERROR;
            }
        }
    }

    private static enum S1 {
        INIT,
        SHRP,
        BANG,
        PATH,
        ARGS,
        ARG2;

    }
}

