/*
 *  _niseshiori.c
 *  Tamito KAJIYAMA <31 July 2001>
 *
 *  $Id: _niseshiori.c,v 1.1.1.1 2003/04/11 05:54:33 shy Exp $
 */

#include "Python.h"

static PyObject *ErrorObject;

static char ns_decrypt__doc__[] = "";

static PyObject *
ns_decrypt(PyObject *self, PyObject *args)
{
  unsigned char *s, *line, a, x, y;
  int len, i, j, n, size, error;
  PyObject *list, *item;

  /* parse the method argument(s) */
  if (!PyArg_ParseTuple(args, "s#", &s, &len))
    return NULL;

  /* create an empty list */
  list = PyList_New(0);
  if (list == NULL)
    return NULL;

  /* allocate a data buffer */
  size = 4096;
  line = (unsigned char *)malloc(size);
  if (line == NULL)
    goto failed;

  a = 0x61;
  i = 0;
  while (i < len) {
    /* resize the data buffer if necessary */
    n = 0;
    for (j = i; j < len && s[j] != '@'; j += 2)
      n++;
    if (n > size) {
      size = n;
      line = (unsigned char *)realloc(line, size);
      if (line == NULL)
        goto failed;
    }
    /* decrypt one line of data */
    n = 0;
    while (i < j) {
      y = s[i++];
      x = s[i++];
      x -= a;
      a += 9;
      y -= a;
      a += 2;
      if (a > 0xdd)
        a = 0x61;
      line[n++] = (x & 0x03) | ((y & 0x03) << 2) | ((y & 0x0c) << 2) | ((x & 0x0c) << 4);
    }
    /* append the line to the list */
    item = PyString_FromStringAndSize(line, n);
    if (item == NULL)
      goto failed;
    error = PyList_Append(list, item);
    Py_DECREF(item);
    if (error < 0)
      goto failed;
    i++; /* skip the @ character */
  }
  free(line);

  return list;

failed:
  Py_DECREF(list);
  if (line != NULL)
    free(line);
  return NULL;
}

static struct PyMethodDef ns_methods[] = {
  {"decrypt", (PyCFunction)ns_decrypt, METH_VARARGS, ns_decrypt__doc__},
  {NULL, (PyCFunction)NULL, 0, NULL} /* sentinel */
};

static char _niseshiori_module_documentation[] = "";

void
init_niseshiori(void)
{
  PyObject *m, *d;

  /* create the module and add functions */
  m = Py_InitModule4("_niseshiori", ns_methods,
                     _niseshiori_module_documentation,
                     (PyObject*)NULL,PYTHON_API_VERSION);

  /* add symbolic constants to the module */
  d = PyModule_GetDict(m);
  ErrorObject = PyString_FromString("_niseshiori.error");
  PyDict_SetItemString(d, "error", ErrorObject);

  /* check for errors */
  if (PyErr_Occurred())
    Py_FatalError("cannot initialize the _niseshiori module");
}
