# -*- coding: utf-8 -*-
#
#  communicate.py - ghost-to-ghost communication mechanism
#  Copyright (C) 2002-2012 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import logging


class Communicate:

    def __init__(self):
        self.__ghosts = {}

    def rebuild_ghostdb(self, sakura, name='', s0=0, s1=10):
        if sakura in self.__ghosts:
            del self.__ghosts[sakura]
        if name is None:
            return
        else:
            self.__ghosts[sakura] = (name, s0, s1)

    def get_otherghostname(self, name):
        return [chr(1).join(value) for value in self.__ghosts.values() \
                    if value[0] != name]

    ON_OTHER_EVENT = {
        'OnBoot': 'OnOtherGhostBooted',
        'OnFirstBoot': 'OnOtherGhostBooted',
        'OnClose': 'OnOtherGhostClosed',
        'OnGhostChanged': 'OnOtherGhostChanged',
        'OnSurfaceChange': 'OnOtherSurfaceChange',
        'OnVanishSelected': 'OnOtherGhostVanished',
        'OnOverlap': 'OnOtherOverlap',
        'OnOffscreen': 'OnOtherOffscreen'
        }

    def notify_other(self, sakura_key,
                     event, name, self_name, shell_name,
                     flag_break, communicate,
                     sstp, notranslate, script, references):
        if not script and event not in self.ON_OTHER_EVENT:
            return
        on_other_event = None
        if event in self.ON_OTHER_EVENT:
            if flag_break and event in ['OnClose', 'OnVanishSelected']:
                pass
            else:
                on_other_event = self.ON_OTHER_EVENT[event]
        if on_other_event is None and script:
            on_other_event = 'OnOtherGhostTalk'
        if on_other_event is None:
            return
        if on_other_event == 'OnOtherGhostBooted':
            args = (self_name, script, name)
        elif on_other_event == 'OnOtherGhostClosed':
            args = (self_name, script, name)
        elif on_other_event == 'OnOtherGhostChanged':
            args = (references[0], self_name, references[1], script,
                    references[2], name, references[7], shell_name)
        elif on_other_event == 'OnOtherSurfaceChange':
            side, new_id, new_w, new_h = references[2].split(',')
            prev_id = references[3]
            args = (name, self_name, side, new_id, prev_id, references[4])
        elif on_other_event == 'OnOtherGhostVanished':
            args = (self_name, script, name, shell_name)
        elif on_other_event == 'OnOtherOverlap':
            args = () ## FIXME
        elif on_other_event == 'OnOtherOffscreen':
            args = () ## FIXME
        elif on_other_event == 'OnOtherGhostTalk':
            flags = ''
            if flag_break:
                if flags:
                    flags = ''.join((flags, ','))
                flags = ''.join((flags, 'break'))
            if sstp is not None: ## FIXME: owned, remote
                if flags:
                    flags = ''.join((flags, ','))
                flags = ''.join((flags, 'sstp-send'))
            if notranslate:
                if flags:
                    flags = ''.join((flags, ','))
                flags = ''.join((flags, 'notranslate'))
            ## FIXME: plugin-script, plugin-event
            refs = chr(1).join((str(value) for value in references))
            #logging.debug("NOTIFY OTHER: {}, {}, {}, {}, {}, {}, {}".format(
            #        on_other_event, name, self_name, flags, event, script, refs))
            args = (name, self_name, flags, event, script, refs)
        else: # XXX: should not reach here
            return
        for sakura in self.__ghosts.keys():
            if sakura.key == sakura_key:
                continue
            if communicate is not None:
                if communicate == '__SYSTEM_ALL_GHOST__':
                    sakura.enqueue_event('OnCommunicate', self_name, script)
                    continue
                elif chr(1) in communicate:
                    to = name.split(chr(1))
                    if self.__ghosts[sakura][0] in to:
                        sakura.enqueue_event('OnCommunicate',
                                             self_name, script)
                        continue
                else:
                    if self.__ghosts[sakura][0] == communicate:
                        sakura.enqueue_event('OnCommunicate',
                                             self_name, script)
                        continue
            if sakura.is_listening(on_other_event):
                sakura.enqueue_event(on_other_event, *args)
