# -*- coding: utf-8 -*-
#
#  Copyright (C) 2002 by Tamito KAJIYAMA
#  Copyright (C) 2003-2013 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

from gi.repository import Gtk
from gi.repository import Gdk


keymap_old = {
    Gdk.KEY_BackSpace: 'back',
    Gdk.KEY_Tab: 'tab',
    Gdk.KEY_KP_Tab: 'tab',
    Gdk.KEY_Clear: 'clear',
    Gdk.KEY_Return: 'return',
    Gdk.KEY_KP_Enter: 'return',
    Gdk.KEY_Menu: '',
    Gdk.KEY_Pause: 'pause',
    Gdk.KEY_Kanji: '',
    Gdk.KEY_Escape: 'escape',
    Gdk.KEY_Henkan: '',
    Gdk.KEY_Muhenkan: '',
    Gdk.KEY_space: 'space',
    Gdk.KEY_Prior: 'prior',
    Gdk.KEY_Next: 'next',
    Gdk.KEY_End: 'end',
    Gdk.KEY_Home: 'home',
    Gdk.KEY_Left: 'left',
    Gdk.KEY_Up: 'up',
    Gdk.KEY_Right: 'right',
    Gdk.KEY_Down: 'down',
    Gdk.KEY_Select: '',
    Gdk.KEY_Print: '',
    Gdk.KEY_Execute: '',
    Gdk.KEY_Insert: '',
    Gdk.KEY_Delete: 'delete',
    Gdk.KEY_Help: '',
    Gdk.KEY_0: '0',
    Gdk.KEY_1: '1',
    Gdk.KEY_2: '2',
    Gdk.KEY_3: '3',
    Gdk.KEY_4: '4',
    Gdk.KEY_5: '5',
    Gdk.KEY_6: '6',
    Gdk.KEY_7: '7',
    Gdk.KEY_8: '8',
    Gdk.KEY_9: '9',
    Gdk.KEY_a: 'a',
    Gdk.KEY_b: 'b',
    Gdk.KEY_c: 'c',
    Gdk.KEY_d: 'd',
    Gdk.KEY_e: 'e',
    Gdk.KEY_f: 'f',
    Gdk.KEY_g: 'g',
    Gdk.KEY_h: 'h',
    Gdk.KEY_i: 'i',
    Gdk.KEY_j: 'j',
    Gdk.KEY_k: 'k',
    Gdk.KEY_l: 'l',
    Gdk.KEY_m: 'm',
    Gdk.KEY_n: 'n',
    Gdk.KEY_o: 'o',
    Gdk.KEY_p: 'p',
    Gdk.KEY_q: 'q',
    Gdk.KEY_r: 'r',
    Gdk.KEY_s: 's',
    Gdk.KEY_t: 't',
    Gdk.KEY_u: 'u',
    Gdk.KEY_v: 'v',
    Gdk.KEY_w: 'w',
    Gdk.KEY_x: 'x',
    Gdk.KEY_y: 'y',
    Gdk.KEY_z: 'z',
    Gdk.KEY_KP_0: '0',
    Gdk.KEY_KP_1: '1',
    Gdk.KEY_KP_2: '2',
    Gdk.KEY_KP_3: '3',
    Gdk.KEY_KP_4: '4',
    Gdk.KEY_KP_5: '5',
    Gdk.KEY_KP_6: '6',
    Gdk.KEY_KP_7: '7',
    Gdk.KEY_KP_8: '8',
    Gdk.KEY_KP_9: '9',
    Gdk.KEY_KP_Multiply: '*',
    Gdk.KEY_KP_Add: '+',
    Gdk.KEY_KP_Separator: '',
    Gdk.KEY_KP_Subtract: '-',
    Gdk.KEY_KP_Decimal: '',
    Gdk.KEY_KP_Divide: '/',
    Gdk.KEY_F1: 'f1',
    Gdk.KEY_F2: 'f2',
    Gdk.KEY_F3: 'f3',
    Gdk.KEY_F4: 'f4',
    Gdk.KEY_F5: 'f5',
    Gdk.KEY_F6: 'f6',
    Gdk.KEY_F7: 'f7',
    Gdk.KEY_F8: 'f8',
    Gdk.KEY_F9: 'f9',
    Gdk.KEY_F10: 'f10',
    Gdk.KEY_F11: 'f11',
    Gdk.KEY_F12: 'f12',
    Gdk.KEY_F13: 'f13',
    Gdk.KEY_F14: 'f14',
    Gdk.KEY_F15: 'f15',
    Gdk.KEY_F16: 'f16',
    Gdk.KEY_F17: 'f17',
    Gdk.KEY_F18: 'f18',
    Gdk.KEY_F19: 'f19',
    Gdk.KEY_F20: 'f20',
    Gdk.KEY_F21: 'f21',
    Gdk.KEY_F22: 'f22',
    Gdk.KEY_F23: 'f23',
    Gdk.KEY_F24: 'f24',
    Gdk.KEY_Num_Lock: '',
    Gdk.KEY_Scroll_Lock: '',
    Gdk.KEY_Shift_L: '',
    Gdk.KEY_Shift_R: '',
    Gdk.KEY_Control_L: '',
    Gdk.KEY_Control_R: '',
    }

keymap_new = {
    Gdk.KEY_BackSpace: '8',
    Gdk.KEY_Tab: '9',
    Gdk.KEY_KP_Tab: '9',
    Gdk.KEY_Clear: '12',
    Gdk.KEY_Return: '13',
    Gdk.KEY_KP_Enter: '13',
    Gdk.KEY_Menu: '18',
    Gdk.KEY_Pause: '19',
    Gdk.KEY_Kanji: '25',
    Gdk.KEY_Escape: '27',
    Gdk.KEY_Henkan: '28',
    Gdk.KEY_Muhenkan: '29',
    Gdk.KEY_space: '32',
    Gdk.KEY_Prior: '33',
    Gdk.KEY_Next: '34',
    Gdk.KEY_End: '35',
    Gdk.KEY_Home: '36',
    Gdk.KEY_Left: '37',
    Gdk.KEY_Up: '38',
    Gdk.KEY_Right: '39',
    Gdk.KEY_Down: '40',
    Gdk.KEY_Select: '41',
    Gdk.KEY_Print: '42',
    Gdk.KEY_Execute: '43',
    Gdk.KEY_Insert: '45',
    Gdk.KEY_Delete: '46',
    Gdk.KEY_Help: '47',
    Gdk.KEY_0: '48',
    Gdk.KEY_1: '49',
    Gdk.KEY_2: '50',
    Gdk.KEY_3: '51',
    Gdk.KEY_4: '52',
    Gdk.KEY_5: '53',
    Gdk.KEY_6: '54',
    Gdk.KEY_7: '55',
    Gdk.KEY_8: '56',
    Gdk.KEY_9: '57',
    Gdk.KEY_a: '65',
    Gdk.KEY_b: '66',
    Gdk.KEY_c: '67',
    Gdk.KEY_d: '68',
    Gdk.KEY_e: '69',
    Gdk.KEY_f: '70',
    Gdk.KEY_g: '71',
    Gdk.KEY_h: '72',
    Gdk.KEY_i: '73',
    Gdk.KEY_j: '74',
    Gdk.KEY_k: '75',
    Gdk.KEY_l: '76',
    Gdk.KEY_m: '77',
    Gdk.KEY_n: '78',
    Gdk.KEY_o: '79',
    Gdk.KEY_p: '80',
    Gdk.KEY_q: '81',
    Gdk.KEY_r: '82',
    Gdk.KEY_s: '83',
    Gdk.KEY_t: '84',
    Gdk.KEY_u: '85',
    Gdk.KEY_v: '86',
    Gdk.KEY_w: '87',
    Gdk.KEY_x: '88',
    Gdk.KEY_y: '89',
    Gdk.KEY_z: '90',
    Gdk.KEY_KP_0: '96',
    Gdk.KEY_KP_1: '97',
    Gdk.KEY_KP_2: '98',
    Gdk.KEY_KP_3: '99',
    Gdk.KEY_KP_4: '100',
    Gdk.KEY_KP_5: '101',
    Gdk.KEY_KP_6: '102',
    Gdk.KEY_KP_7: '103',
    Gdk.KEY_KP_8: '104',
    Gdk.KEY_KP_9: '105',
    Gdk.KEY_KP_Multiply: '106',
    Gdk.KEY_KP_Add: '107',
    Gdk.KEY_KP_Separator: '108',
    Gdk.KEY_KP_Subtract: '109',
    Gdk.KEY_KP_Decimal: '110',
    Gdk.KEY_KP_Divide: '111',
    Gdk.KEY_F1: '112',
    Gdk.KEY_F2: '113',
    Gdk.KEY_F3: '114',
    Gdk.KEY_F4: '115',
    Gdk.KEY_F5: '116',
    Gdk.KEY_F6: '117',
    Gdk.KEY_F7: '118',
    Gdk.KEY_F8: '119',
    Gdk.KEY_F9: '120',
    Gdk.KEY_F10: '121',
    Gdk.KEY_F11: '122',
    Gdk.KEY_F12: '123',
    Gdk.KEY_F13: '124',
    Gdk.KEY_F14: '125',
    Gdk.KEY_F15: '126',
    Gdk.KEY_F16: '127',
    Gdk.KEY_F17: '128',
    Gdk.KEY_F18: '129',
    Gdk.KEY_F19: '130',
    Gdk.KEY_F20: '131',
    Gdk.KEY_F21: '132',
    Gdk.KEY_F22: '133',
    Gdk.KEY_F23: '134',
    Gdk.KEY_F24: '135',
    Gdk.KEY_Num_Lock: '144',
    Gdk.KEY_Scroll_Lock: '145',
    Gdk.KEY_Shift_L: '160',
    Gdk.KEY_Shift_R: '161',
    Gdk.KEY_Control_L: '162',
    Gdk.KEY_Control_R: '163',
    }

def test():
    def key_press(widget, event):
        try:
            print(keymap_old[event.keyval], \
                  keymap_new[event.keyval], '({0:d})'.format(event.keyval))
        except KeyError:
            if event.string:
                print(repr(event.string), '({0:d})'.format(event.keyval))
            else:
                print('unknown keyval:', event.keyval)
    win = Gtk.Window()
    win.set_events(Gdk.EventMask.KEY_PRESS_MASK)
    win.connect('destroy', Gtk.main_quit)
    win.connect('key_press_event', key_press)
    win.show()
    Gtk.main()


if __name__ == '__main__':
    test()
