# -*- coding: utf-8 -*-
#
#  gomi.py - a gomi.dll compatible Saori module for ninix
#  Copyright (C) 2012 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import os
import argparse

from gi.repository import Gio
from gi.repository import GLib

from ninix.dll import SAORI

class Saori(SAORI):

    def __init__(self):
        SAORI.__init__(self)

    def setup(self):
        self.parser = argparse.ArgumentParser()
        self.parser.add_argument('-e', '--empty', action='store_true')
        self.parser.add_argument('-n', '--number-of-items', action='store_true')
        self.parser.add_argument('-V', '--version', action='store_true')
        self.parser.add_argument('-a', '--asynchronous', action='store_true')
        self.parser.add_argument('-f', '--force', action='store_true')
        self.parser.add_argument('-q', '--quiet', action='store_true')
        self.parser.add_argument('-s', '--silent', action='store_true')
        self.parser.add_argument('-v', '--verbose', action='store_true')
        self.parser.add_argument('-w', '--hwnd')
        bus = Gio.bus_get_sync(Gio.BusType.SESSION, None)
        try:
            self.notify = Gio.DBusProxy.new_sync(
                bus, 0, None, 'org.gnome.Nautilus', '/org/gnome/Nautilus',
                'org.gnome.Nautilus.FileOperations', None)
            return 1
        except:
            self.notify = None
            return 0

    def get_dir_size(self, dir_name):
        file_count = 0
        dir_size = 0
        for (path, dirs, files) in os.walk(dir_name):
            for file in files:
                file_count += 1
                dir_size += os.path.getsize(os.path.join(path, file))
        return (file_count, dir_size)

    def execute(self, argument):
        args = self.parser.parse_args(argument[0].split())
        if self.notify is None:
            return self.RESPONSE[400]
        if args.number_of_items:
            file_count, dir_size = self.get_dir_size(
                os.fsencode(os.path.expanduser('~/.local/share/Trash'))) # XXX
            return b''.join((b'SAORI/1.0 200 OK\r\n',
                             b'Result: ',
                             str(file_count).encode('ascii'),
                             b'\r\n'
                             b'Reference0: ',
                             str(dir_size).encode('ascii'),
                             b'\r\n\r\n'))
        elif args.empty:
            result = self.notify.call_sync(
                'EmptyTrash', GLib.Variant('()', ()),
                Gio.DBusCallFlags.NONE, -1, None)
            return b''.join((b'SAORI/1.0 200 OK\r\n',
                             b'Result: ',
                             b'1', # FIXME
                             b'\r\n\r\n'))
