//------------------------------------------------
// Line.c C
//------------------------------------------------
#include <math.h>
#include <stdlib.h>
#include "funcs.h"


#ifndef __Line__
#define __Line__

// `
#ifndef EPS
#define EPS      1e-10		// ̌덷el
#endif
#ifndef sinf
#define sinf sin
#endif
#ifndef cosf
#define cosf cos
#endif

//-----------------------------------------------------------------
// C
// ֐͕K Line n܂D
//
// lɁuȕϊ/ZvƂ̂́C
// ʊi[AhXƕϊAhX/ZAhX
// ɂ邱Ƃŕϊ/Z\
//   FLineShift(L1, L1, v1)  L1 Ɍʂi[
//-----------------------------------------------------------------
//-----------------------------------------------------------------



//-----------------------------------------------------------------
// LineFromVector
// @\F2xNg𐶐
// FLine *L0, Vector *v1, Vector *v2
//       *L0 : ʂi[AhX
//       *v1 : n_ʒuxNg
//       *v2 : I_ʒuxNg
// ԒlFꂽ̃AhX
Line* LineFromVector(Line *L0, Vector *v1, Vector *v2)
{
	L0->st = *v1;
	L0->ed = *v2;
	return L0;
}

//-----------------------------------------------------------------
// LineFromXY
// @\FQ_𐶐
// FLine *L0, float x1, float y1, float x2, float y2
//       *L0    : ʂi[AhX
//       x1, y1 : n_W
//       x2, y2 : I_W
// ԒlFꂽ̃AhX
Line* LineFromXY(Line *L0, float x1, float y1, float x2, float y2)
{
	L0->st.x = x1 - CenterX;
	L0->st.y = CenterY - y1;
	L0->ed.x = x2 - CenterX;
	L0->ed.y = CenterY - y2;
	return L0;
}

//-----------------------------------------------------------------
// LineFromUV
// @\FxNgWnQ_𐶐
// FLine *L0, float u1, float v1, float u2, float v2
//       *L0    : ʂi[AhX
//       u1, v1 : n_W
//       u2, v2 : I_W
// ԒlFꂽ̃AhX
Line* LineFromUV(Line *L0, float u1, float v1, float u2, float v2)
{
	L0->st.x = u1;
	L0->st.y = v1;
	L0->ed.x = u2;
	L0->ed.y = v2;
	return L0;
}


//-----------------------------------------------------------------
// LineToXY
// @\FQ_𐶐
// Fint *x1, int *y1, int *x2, int *y2, Line *L1
//       *x1, *y1 : n_WAhX
//       *x2, *y2 : I_WAhX
//       *L1      : ϊCAhX
// ԒlFȂ
void LineToXY(int *x1, int *y1, int *x2, int *y2, Line *L1)
{
	*x1 = CenterX + (int)L1->st.x;
	*y1 = CenterY - (int)L1->st.y;
	*x2 = CenterX + (int)L1->ed.x;
	*y2 = CenterY - (int)L1->ed.y;
}


//-----------------------------------------------------------------
// LineShift
// @\FCxNgɍ킹ĕsړ
// FLine *L0, Line *L1, Vector *v1
//       *L0 : ʂi[AhX
//       *L1 : ϊC
//       *v1 : ړxNg
// ԒlFꂽC̃AhX
// lFȕϊ/Z
Line* LineShift(Line *L0, Line *L1, Vector *v1)
{
	VectorAdd(&L0->st, &L1->st, v1);
	VectorAdd(&L0->ed, &L1->ed, v1);
	return L0;
}

//-----------------------------------------------------------------
// LineRotate
// @\F]
// FLine *L0, Line *L1, float rad
//       *L0 : ʂi[AhX
//       *L1 : ]AhX
//       rad : ]pxiWAj
// ԒlFʂ̃AhX
// lFȕϊ/Z
// ⑫FVectorRotatep킩₷
//       x̂߂Ɋ֐ŏĂ
Line* LineRotate(Line *L0, Line *L1 , float rad)
{
	float sinx = sinf(rad),
	      cosx = cosf(rad),
	      x;
	//if(rad == 0) return L1;	//d

	       x = L1->st.x*cosx - L1->st.y*sinx;
	L0->st.y = L1->st.x*sinx + L1->st.y*cosx;
	L0->st.x = x;
	       x = L1->ed.x*cosx - L1->ed.y*sinx;
	L0->ed.y = L1->ed.x*sinx + L1->ed.y*cosx;
	L0->ed.x = x;
	return L0;
}

//-----------------------------------------------------------------
// LineArrayRotate
// @\Fz]
// FLine *lines, int num, float rad
//       *lines : ]zAhX
//       num    : 
//       rad    : ]pxiWAj
// ԒlFʂ̃AhX
Line* LineArrayRotate(Line *lines, int num, float rad)
{
	float sinx = sinf(rad),
	      cosx = cosf(rad),
	      x;
	int i;
	if(rad == 0) return lines;
	
	for(i=0; i<num; i++){
		            x = lines[i].st.x*cosx - lines[i].st.y*sinx;
		lines[i].st.y = lines[i].st.x*sinx + lines[i].st.y*cosx;
		lines[i].st.x = x;
		            x = lines[i].ed.x*cosx - lines[i].ed.y*sinx;
		lines[i].ed.y = lines[i].ed.x*sinx + lines[i].ed.y*cosx;
		lines[i].ed.x = x;
	}
	return lines;
}

//-----------------------------------------------------------------
// LineCrossCheck
// @\F2̌𔻒肷
// FLine *L1, Line *L2
//       *L1 : P̃AhX
//       *L2 : Q̃AhX
// ԒlFtrue  : 
//       false : Ȃ
// ӁFsfalseԂ
// XVF08/10/10 : 삷̂ɒu
bool LineCrossCheck(Line *L1, Line *L2)
{
	Vector tmp1, tmp2;
	
	// Q̃xNgP̗ɂ邩
	VectorSub(&tmp1, &L1->ed, &L1->st);
	if(VectorCrossProduct(VectorSub(&tmp2, &L2->st, &L1->st), &tmp1)*VectorCrossProduct(VectorSub(&tmp2, &L2->ed, &L1->st), &tmp1) > 0)
		return false;
	
	// P̃xNgQ̗ɂ邩
	VectorSub(&tmp1, &L2->ed, &L2->st);
	if(VectorCrossProduct(VectorSub(&tmp2, &L1->st, &L2->st), &tmp1)*VectorCrossProduct(VectorSub(&tmp2, &L1->ed, &L2->st), &tmp1) > 0)
		return false;

	// ̑SĂ̔NAĂ
	return true;
}

//-----------------------------------------------------------------
// LineCrossGet
// @\F2̌_߂
//       肪sĂ邱ƂOƂ
// FVecotr *v0, Line *L1, Line *L2
//       *v0 : ʂi[xNg̃AhX
//       *L1 : P̃AhX
//       *L2 : Q̃AhX
// ԒlFxNg̃AhX
// QlFhttp://www.deqnotes.net/acmicpc/2d_geometry/lines
Vector* LineCrossGet(Vector *v0, Line *L1, Line *L2)
{
	Vector b, v1, v2;
	float f1, f2, t;
	
	VectorSub(&b, &L2->ed, &L2->st);
	f1 = fabs(VectorCrossProduct(&b, VectorSub(&v1, &L1->st, &L2->st))),
	f2 = fabs(VectorCrossProduct(&b, VectorSub(&v2, &L1->ed, &L2->st))),
	t  = f1 / (f1 + f2);
	VectorSub(v0, &L1->ed, &L1->st);
	VectorMult(v0, v0, t);
	VectorAdd(v0, v0, &L1->st);
	return v0;
}


//-----------------------------------------------------------------
// LineDotLength
// @\FƓ_Ƃ̍ŏ߂
// FLine *L1, Vector *v1, int *type
//       *L1   : 
//       *v1   : _̃|C^
//       *type : ŒZ̏
//               type = 0 : ɍŒZ
//                      1 : n_ŒZ
//                      2 : I_ŒZ
// ԒlFŒZ̒l
// QlFhttp://www.deqnotes.net/acmicpc/2d_geometry/lines
float LineDotLength(Line *L1, Vector *v1, int *type)
{
	Vector AB, AC, BA, BC;
	VectorSub(&AB, &L1->ed, &L1->st);
	VectorSub(&AC, v1, &L1->st);
	VectorInvert(&BA, &AB);
	VectorSub(&BC, v1, &L1->ed);
	if( VectorDotProduct(&AB, &AC) < EPS ){
		*type = 1;
		return VectorLength(&AC);
	}
	if( VectorDotProduct(&BA, &BC) < EPS){
		*type = 2;
		return VectorLength(&BC);
	}
	*type = 0;
	return fabs(VectorCrossProduct(&AB, &AC))/VectorLength(&AB);
}

#endif
