//------------------------------------------------
// Move.c Main֐Ƃ̃C^[tF[X
//------------------------------------------------

#include <stdlib.h>
#include <math.h>
#include "Move.h"

//t[̏
int InitFrame(Frame *Frm, int StageNum)
{
	const char *LineFile[3] = STAGE_LINE_DEF;
	char Buf[64];
	FILE *fp;
	int x1, x2, y1, y2;
	int ErrChk = 0, Num = 0;
	
	if ((fp=fopen(LineFile[StageNum], "r")) == NULL)
		return -1;
	
	//{[̏ʒu̓ǂ݂
	fgets(Buf, sizeof(Buf), fp);
	ErrChk = sscanf(Buf,"%d,%d",&x1,&y1);
	if(ErrChk==2) Frm->Ball.xy.x = x1, Frm->Ball.xy.y = y1;
	else return -1;
	
	//C̐ǂݍ
	fgets(Buf, sizeof(Buf), fp);
	ErrChk = sscanf(Buf,"%d",&x1);
	if(ErrChk==1) Frm->line = (Line*)malloc(sizeof(Line)*x1), Frm->size = x1;
	else return -1;
	
	//C̈ʒut@Cǂݍ
	while( fgets(Buf, sizeof(Buf), fp)!=NULL ){
		ErrChk = sscanf(Buf,"%d,%d,%d,%d",&x1,&y1,&x2,&y2);
		x1+=CenterX-STAGE_HW, y1+=CenterY-STAGE_HH;
		x2+=CenterX-STAGE_HW, y2+=CenterY-STAGE_HH;
		if(ErrChk==4)
			LineFromXY(&Frm->line[Num++], x1,y1,x2,y2);
		else return -1;
	}
	
	//{[̐ݒ
	Frm->Ball.r = BALL_SIZE;
	Frm->Ball.velocity.x = Frm->Ball.velocity.y = 0;
	fclose(fp);
	return 0;
}

//t[̏I
void FinFrame(Frame *Frm)
{
	free(Frm->line);
}

void MoveBall(Frame *Frm, Surface *Scr, int Reset)
{
	static float oldRad=0;
	Frm->Ball.velocity.y -= GRAVITY/FRAME_RATE;		//d͂͐̂
	
	oldRad -= Scr->Rad;
	if(fabs(oldRad) >= 0.00001){
		//if(oldRad > M_PI)	oldRad= -ROTATE_RAD;
		//{[ɉ]
		float sinx = sin(oldRad), cosx = cos(oldRad), x;
		Frm->Ball.xy.x = Frm->Ball.xy.x*cosx - Frm->Ball.xy.y*sinx;
		Frm->Ball.xy.y = Frm->Ball.xy.x*sinx + Frm->Ball.xy.y*cosx;
		
		//܂
		LineArrayRotate(Frm->line, Frm->size, oldRad);
		CollisionRotate(&Frm->Ball, Frm->line, Frm->size, oldRad);
	}
	//DrawFormatString(0,0,0xFFCCCC,"dRad:%f",oldRad);	//WA̕ω\
	
	CollisionProcess(&Frm->Ball, Frm->line, Frm->size, COLLISION_MOVE);
	oldRad = Scr->Rad;
	
	//{[̍Wn𒼂
	VectorToXY(&Scr->BallX, &Scr->BallY, &Frm->Ball.xy);
	Scr->BallX -= BALL_SIZE, Scr->BallY -= BALL_SIZE;
	if(Reset) oldRad=0;
}

void DrawVector(Frame *Frm)
{
	int i, x1, y1, x2, y2;
	// xNg]\
	for(i=0; i<Frm->size; i++){
		LineToXY(&x1, &y1, &x2, &y2, &Frm->line[i]);
		DrawLine( x1, y1, x2, y2, 0xFF00FF );
	}
	
	//{[̕`
	VectorToXY(&x1, &y1, &Frm->Ball.xy);
	DrawCircle( (int)x1, (int)y1, Frm->Ball.r, 0xFF00FF, FALSE );
	//ScreenFlip();
}