package org.mineap.a2n4as
{
	import flash.events.ErrorEvent;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.HTTPStatusEvent;
	import flash.events.IOErrorEvent;
	import flash.events.SecurityErrorEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	
	[Event(name="getMylistGroupSuccess", type="MyListGroupLoader")]
	[Event(name="getMylistGroupFailure", type="MyListGroupLoader")]
	[Event(name="httpResponseStatus", type="HTTPStatusEvent")]
	
	/**
	 * 
	 * @author shiraminekeisuke
	 * 
	 */
	public class MyListGroupLoader extends EventDispatcher
	{
		
		public static const NICO_MYLIST_GROUP_API_URL:String = "http://www.nicovideo.jp/api/mylistgroup/list";
		
		public static const GET_MYLIST_GROUP_SUCCESS:String = "GetMylistGroupSuccess";
		public static const GET_MYLIST_GROUP_FAILURE:String = "GetMylistGroupFailure";
		
		private var _loader:URLLoader = null;
		
		/**
		 * 
		 * 
		 */
		public function MyListGroupLoader()
		{
			this._loader = new URLLoader();
		}
		
		/**
		 * ログイン中のユーザーについて、マイリストグループ（マイリストのIDの一覧）を取得します。
		 * 
		 */
		public function getMyListGroup():void{
			
			var urlRequest:URLRequest = new URLRequest(NICO_MYLIST_GROUP_API_URL);

			this._loader.addEventListener(Event.COMPLETE, completeEventHandler);
			this._loader.addEventListener(IOErrorEvent.IO_ERROR, errorEventHandler);
			this._loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, errorEventHandler);
			this._loader.addEventListener(HTTPStatusEvent.HTTP_RESPONSE_STATUS, httpResponseStatusHandler);
			this._loader.load(urlRequest);
		}
		
		/**
		 * 
		 * @param event
		 * 
		 */
		private function httpResponseStatusHandler(event:HTTPStatusEvent):void{
			trace(event);
			dispatchEvent(event);
		}
		
		/**
		 * 
		 * @param event
		 * 
		 */
		public function completeEventHandler(event:Event):void{
			
			trace(this._loader.data);
			
			trace(event);
			dispatchEvent(new Event(GET_MYLIST_GROUP_SUCCESS));
			
		}
		
		/**
		 * 
		 * @param event
		 * 
		 */
		public function errorEventHandler(event:ErrorEvent):void{
			
			trace(event);
			dispatchEvent(new ErrorEvent(GET_MYLIST_GROUP_FAILURE, false, false, event.text));
			close();
			
		}
		
		/**
		 * 
		 * 
		 */
		public function close():void{
			try{
				this._loader.close();
			}catch(error:Error){
				trace(error);
			}
				
		}
		
		/**
		 * 
		 * @return 
		 * 
		 */
		public function get result():Object{
			return this._loader.data;
		}

	}
}