#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>

/**/

#include "Common.h"

/**/

#include <WSCmainWindow.h>
#include <WSCvkslabel.h>
#include <WSCvscrBar.h>
#include <WSCvbtn.h>
#include <WSCvtimer.h>
#include <WSCcomboBox.h>
#include <WSCmessageDialog.h>

extern WSCmainWindow *MainWin;
extern WSCvkslabel *Maivksl_HeadLine;
extern WSCvscrBar *Maivscr_ScrollBar;
extern WSCvbtn *Maivbtn_StopBtn;
extern WSCvtimer *Maivtim_MainTimer;
extern WSCvtimer *Maivtim_BeginTimer;
extern WSCcomboBox *Maicomb_Url;

/**/

void CHeadLine::Init( void )
{
	mHeadLineCurN = 0;
	ResetHeadLineMaxN();

	mFlagDown = false;

	mStrHeadLine = new WSCstring[1];
	mStrItem = "";

	mWordIdx = 0;
	mWordMaxIdx = 1;

	mStrWordSep = "\n";

//@@@	AddUrlList( "http://lnl.sourceforge.jp/" );
//@@@	AddUrlList( "http://life4.2ch.net/yume/" );
	AddUrlList( "http://news2.2ch.net/news5plus/" );
	AddUrlList( "http://sports2.2ch.net/iraq/" );
	AddUrlList( "http://news2.2ch.net/news5/" );
	AddUrlList( "http://society.2ch.net/kokusai/" );
	AddUrlList( "http://tmp2.2ch.net/bakanews/" );
	AddUrlList( "http://tmp2.2ch.net/asia/" );
	AddUrlList( "http://news2.2ch.net/news2/" );
	AddUrlList( "http://pc.2ch.net/pcnews/" );
	AddUrlList( "http://comic.2ch.net/comicnews/" );
	AddUrlList( "http://music3.2ch.net/musicnews/" );
	AddUrlList( "http://news6.2ch.net/trafficinfo/" );
	AddUrlList( "http://news4.2ch.net/news/" );
	AddUrlList( "http://news5.2ch.net/newsplus/" );
	AddUrlList( "http://book.2ch.net/bizplus/" );
	AddUrlList( "http://bbq.2ch.net/bbynews/" );
	AddUrlList( "http://news7.2ch.net/femnewsplus/" );
	AddUrlList( "http://news6.2ch.net/mnewsplus/" );
	AddUrlList( "http://book.2ch.net/bizplus/" );
	AddUrlList( "http://news8.2ch.net/eqplus/" );
	AddUrlList( "http://news8.2ch.net/eq/" );

AddUrlList( "http://news5.2ch.net/newsplus/" );//@@@

	Reset();

	InitSrvr();

	if( !NewsThreadCreate( BGDownLoad ) )
		PopupError( "Xbh؂܂ł" );
}

/**/

void CHeadLine::Reset( void )
{
	Stop();
	Update( 0, true );
}

/**/

void CHeadLine::Update( long nSkip, bool flgForce )
{
	long scrollLen = 2;

	unsigned long n = Maivscr_ScrollBar->getProperty( WSNvalue );
	unsigned long max_n = Maivscr_ScrollBar->getProperty( WSNmaximum );

	if( flgForce || ((n + scrollLen) >= max_n) ){
		mStrItem = GetText( nSkip );

		n = 0;
		max_n = mStrItem.getChars();
		if( max_n < 1 )
			max_n = 1;
		Maivscr_ScrollBar->setProperty( WSNvalue, n );
		Maivscr_ScrollBar->setProperty( WSNmaximum, max_n );
		Maivscr_ScrollBar->setProperty( WSNsliderSize, scrollLen );
		Maivscr_ScrollBar->setProperty( WSNincrement, scrollLen );
		Maivscr_ScrollBar->setProperty( WSNpageIncrement,
			scrollLen * 10 );

		WaitTimer();
	} else {
		n += scrollLen;
		Maivscr_ScrollBar->setProperty( WSNvalue, n );
	}

	Draw();
}

/**/

void CHeadLine::Draw( void )
{
	WSCstring strDraw = mStrItem;

	unsigned long n = Maivscr_ScrollBar->getProperty( WSNvalue );
	if( n > 0 )
		strDraw.deleteChars( 0, n );

	Maivksl_HeadLine->setProperty( WSNlabelString, strDraw );
	MainWin->setProperty( WSNtitleString, strDraw );
}

/**/

void CHeadLine::WaitTimer( void )
{
	WSCbool flagBegin = Maivtim_BeginTimer->getProperty( WSNrunning );
	WSCbool flagMain = Maivtim_MainTimer->getProperty( WSNrunning );

	if( flagBegin || flagMain ){
		Maivtim_BeginTimer->setProperty( WSNrunning, true );
		Maivtim_MainTimer->setProperty( WSNrunning, false );
	}

	SetStopBtn();
}

/**/

bool CHeadLine::PlayOrStop( void )
{
	WSCbool flagBegin = Maivtim_BeginTimer->getProperty( WSNrunning );
	WSCbool flagMain = Maivtim_MainTimer->getProperty( WSNrunning );

	if( flagBegin || flagMain ){
		return Stop();
	} else {
		return Play();
	}
}

/**/

bool CHeadLine::Play( void )
{
	Maivtim_BeginTimer->setProperty( WSNrunning, false );
	Maivtim_MainTimer->setProperty( WSNrunning, true );

	return SetStopBtn();
}

/**/

bool CHeadLine::Stop( void )
{
	Maivtim_BeginTimer->setProperty( WSNrunning, false );
	Maivtim_MainTimer->setProperty( WSNrunning, false );

	return SetStopBtn();
}

/**/

bool CHeadLine::SetStopBtn( void )
{
	WSCbool flagBegin = Maivtim_BeginTimer->getProperty( WSNrunning );
	WSCbool flagMain = Maivtim_MainTimer->getProperty( WSNrunning );

	if( flagBegin || flagMain ){
		/* It's playing. */
		Maivbtn_StopBtn->setProperty( WSNlabelString, "||" );
		return true;
	} else {
		/* It's stopping. */
		Maivbtn_StopBtn->setProperty( WSNlabelString, ">" );
		return false;
	}
}

/**/

long CHeadLine::PrevUrl( void )
{
	gHeadLine.IncHeadLineCurN( -1 );
	gHeadLine.Update( 0, true );

	return mHeadLineCurN;
}

/**/

long CHeadLine::NextUrl( void )
{
	gHeadLine.IncHeadLineCurN( +1 );
	gHeadLine.Update( 0, true );

	return mHeadLineCurN;
}

/**/

long CHeadLine::SelectUrl( void )
{
	WSCstring list = Maicomb_Url->getProperty( WSNmenuItems );
	WSCstring label = Maicomb_Url->getProperty( WSNlabelString );

	long pos = list.isExist( label );
	if( pos <= -1 )
		return mHeadLineMaxN;

	long n = 0;
	for( long i = 0; i < pos; i++ ){
		if( list[i] == ',' )
			n++;
	}
	if( mHeadLineCurN != n ){
		mHeadLineCurN = n;
		gHeadLine.Update( 0, true );
	}

	return mHeadLineCurN;
}

/**/

void CHeadLine::AddUrlList( WSCstring item )
{
	WSCstring list = Maicomb_Url->getProperty( WSNmenuItems );

	if( list.getChars() <= 0 ){
		list = item;
	} else {
		WSCstring newList;
		newList << item << "," << list;
		list = newList;
	}

	Maicomb_Url->setProperty( WSNmenuItems, list );
	Maicomb_Url->setProperty( WSNlabelString, item );

	mHeadLineCurN = 0;
	ResetHeadLineMaxN();
	if( mHeadLineMaxN > 0 ){
		WSCstring *preStr = mStrHeadLine;
		mStrHeadLine = new WSCstring[mHeadLineMaxN];
		delete[] preStr;

		bool *preFlag = mFlagDone;
		mFlagDone = new bool[mHeadLineMaxN];
		delete[] preFlag;

		for( long i = 0; i < mHeadLineMaxN; i++ ){
			mStrHeadLine[i] = "_E[hĂ܂B";
			mFlagDone[i] = false;
		}
	}
}

/**/

WSCstring CHeadLine::PickUp2ch( WSCstring html )
{
	WSCstring text;
	WSCstring strBgn = "<dd>";
	WSCstring strEnd = "<dt>";
	WSCstring strBgnSkip = "<dd><";
	long lenBgn = strBgn.getChars();

	while( 1 ){
		if( html.getChars() <= 0 )
			break;

		/* I search tokens. */

		WSCstring tmp = html;
		tmp.to_lower();

		long idxBgn = tmp.isExist( strBgn );
		long idxEnd = tmp.isExist( strEnd );
		long idxBgnSkip = tmp.isExist( strBgnSkip );

		tmp.deleteChars( 0, lenBgn );
		long idxEnd2 = tmp.isExist( strBgn );
		if( idxEnd2 > -1 )
			idxEnd2 += lenBgn;

		if( idxBgn <= -1 )
			break;
		if( idxEnd > -1 ){
			if( idxEnd2 > -1 ){
				if( idxEnd2 < idxEnd ){
					/* There are beginning token */
					/* after beginning token. */

					idxEnd = idxEnd2;
				}
			}
		} else {
			if( idxEnd2 > -1 ){
				idxEnd = idxEnd2;
			} else {
				/* I can't find beginning token */
				/* and ending token. */

				break;
			}
		}
		if( idxEnd < idxBgn ){
			/* There are ending token */
			/* before beginning token. */

			html.deleteChars( 0, idxBgn );
			continue;
		}
		if( idxBgn == idxBgnSkip ){
			/* There are skipping token */

			html.deleteChars( 0, idxBgn + lenBgn );
			continue;
		}

		/* I cut HTML text from beginning token */
		/* to ending token. */

		WSCstring str = html;

		idxBgn += lenBgn;
		str.cutString( idxEnd );
		str.deleteChars( 0, idxBgn );

		text << str << mStrWordSep;

		/* I set HTML text to next position. */

		html.deleteChars( 0, idxEnd );
	}

	return text;
}

/**/

WSCstring CHeadLine::GetText( long nSkip )
{
	mWordIdx += nSkip;

	if( mWordIdx >= mWordMaxIdx ){
		IncHeadLineCurN( +1 );
		mWordIdx = 0;
	}
	if( mWordIdx < 0 ){
		IncHeadLineCurN( -1 );
		mWordIdx = mWordMaxIdx - 1;
	}

	WSCstring str = mStrHeadLine[mHeadLineCurN].getWord(
		mWordIdx, mStrWordSep );

	str = DelHtmlTag( str, "<a href", "</a>" );
	str = DelHtmlTag( str, "<font", "</font>" );
	str = DelHtmlBr( str );
	str = ConvHtmlMetaChar( str );

	str << "    ";

	return str;
}

/**/

WSCstring CHeadLine::SetText( long n, WSCstring str )
{
	if( (n < 0) || (n >= mHeadLineMaxN) )
		return "";

	mStrHeadLine[n] = str;

	if( n == mHeadLineCurN )
		Update( 0, true );

	return str;
}

/**/

long CHeadLine::IncHeadLineCurN( long n )
{
	mWordIdx = 0;
	mWordMaxIdx = 1;

	if( mHeadLineMaxN <= 0 ){
		mHeadLineCurN = 0;

		return mHeadLineCurN;
	}

	mHeadLineCurN += n;
	mHeadLineCurN %= mHeadLineMaxN;
	mHeadLineCurN += mHeadLineMaxN;
	mHeadLineCurN %= mHeadLineMaxN;

	mWordMaxIdx = mStrHeadLine[mHeadLineCurN].getWords( mStrWordSep );
	if( mWordMaxIdx <= 0 )
		mWordMaxIdx = 1;

	/* I Select URL list */

	WSCstring list = Maicomb_Url->getProperty( WSNmenuItems );
	WSCstring label = list.getWord( mHeadLineCurN, "," );
	Maicomb_Url->setProperty( WSNlabelString, label );

	return mHeadLineCurN;
}

/**/

long CHeadLine::ResetHeadLineMaxN( void )
{
	WSCstring list = Maicomb_Url->getProperty( WSNmenuItems );
	mHeadLineMaxN = list.getWords( "," );

	return mHeadLineMaxN;
}

/**/

WSCstring CHeadLine::DelHtmlTag(
	WSCstring html, WSCstring strBgn, WSCstring strEnd
)
{
	long lenEnd = strEnd.getChars();

	while( 1 ){
		long idxBgn = html.isExist( strBgn );
		long idxEnd = html.isExist( strEnd );
		if( idxBgn <= -1 )
			break;
		if( idxEnd <= -1 )
			break;
		if( idxEnd < idxBgn )
			break;

		idxEnd += lenEnd;
		html.deleteChars( idxBgn, idxEnd - idxBgn );
	}

	return html;
}

/**/

WSCstring CHeadLine::DelHtmlBr( WSCstring html )
{
	html.delString( " <br> ", 0 );
	html.delString( " <br>", 0 );
	html.delString( "<br> ", 0 );
	html.delString( "<br>", 0 );

	return html;
}

/**/

WSCstring CHeadLine::ConvHtmlMetaChar( WSCstring html )
{
	WSCstring listMeta[][2] = {
		{
			"&gt;",
			">",
		},
		{
			"&lt;",
			"<",
		},
		{
			"",
			"",
		},
	};

	for( long i = 0; i < 128; i++ ){
		if( listMeta[i][0].getChars() <= 0 ){
			break;
		}

		html.replaceString( listMeta[i][0], listMeta[i][1], 0 );
	}

	return html;
}

/**/

void CHeadLine::UpdateDownText( void )
{
	if( mFlagDown ){
		SetText( mDownN, mStrDown );
		mFlagDone[mDownN] = true;

		mFlagDown = false;
	}
}

/**/

void CHeadLine::SetDownText( long n, WSCstring str )
{
	while( mFlagDown ){
		SleepSec( 1 );
	}

	mDownN = n;
	mStrDown = str;
	mFlagDown = true;
}

/**/

void *BGDownLoad( void *arg )
{
	CHeadLine &hl = gHeadLine;

	while( 1 ){
		if( hl.mFlagDown ){
			SleepSec( 1 );
			continue;
		}

		WSCstring text;

		long curN = -1;
		long hlCurN = hl.mHeadLineCurN;
		long hlMaxN = hl.mHeadLineMaxN;
		long flagFirst = true;
		for( long i = hlMaxN - 1; i >= 0; i-- ){
			long j = (hlCurN + i) % hlMaxN;
			if( hlMaxN != hl.mHeadLineMaxN ){
				curN = -1;
				break;
			}
			if( hl.mFlagDone[j] ){
				flagFirst = false;
			} else {
				curN = j;
			}
		}
		if( curN <= -1 ){
			SleepSec( 5 );
			continue;
		} else {
			hl.mDownN = curN;
		}

		WSCstring list = Maicomb_Url->getProperty( WSNmenuItems );
		WSCstring url = list.getWord( 0, "," );

		/* I am connecting a server. */

		text = "T[oɐڑĂ܂B";
		hl.SetDownText( curN, text );

		int sock = OpenSrvr( url, "http", 80 );
		if( sock <= -1 ){
			text = "T[oɐڑo܂łB";
			hl.SetDownText( curN, text );

			continue;
		}

		SleepSec( 1 );

		/* I am downloading from a server. */

		text = "T[o_E[hĂ܂B";
		hl.SetDownText( curN, text );

		WSCstring strHtml;
		if( !RecvSrvr( sock, url, &strHtml ) ){
			text = strHtml;
			hl.SetDownText( curN, text );

			continue;
		}

		SleepSec( 1 );

		/* I am disconnecting a server. */

		text = "T[o̐ڑĂ܂B";
		hl.SetDownText( curN, text );

		if( CloseSrvr( sock ) <= -1 ){
			text = "T[o̐ڑo܂łB";
			hl.SetDownText( curN, text );

			continue;
		}

		SleepSec( 1 );

		/* I am converting data from HTML to text. */

		text = "f[^ϊĂ܂B";
		hl.SetDownText( curN, text );

		text = hl.PickUp2ch( strHtml );
		hl.SetDownText( curN, text );
		if( text.getChars() <= 0 ){
			text = "j[X܂łB";
			hl.SetDownText( curN, text );

			continue;
		}

		SleepSec( 1 );

		/* Finish. */

		hl.mFlagDown = true;

		if( flagFirst ){
			hl.mHeadLineCurN = curN;
			hl.IncHeadLineCurN( +-0 );
			hl.Update( 0, true );

			hl.Play();
		}

		SleepSec( 5 );
	}

	return NULL;
}

/**/

CHeadLine gHeadLine;
