#ifndef HEAD_LINE_H
#define HEAD_LINE_H

#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>

class CHeadLine {
private:
	long mHeadLineCurN;
	long mHeadLineMaxN;

	bool mFlagDown;
	long mDownN;
	WSCstring mStrDown;

	WSCstring *mStrHeadLine;
	bool *mFlagDone;
	WSCstring mStrItem;

	long mWordIdx;
	long mWordMaxIdx;

	WSCstring mStrWordSep;
public:
	void Init( void );
	void Reset( void );

	void Update( long nSkip, bool flgForce );
	void Draw( void );
	void WaitTimer( void );

	bool PlayOrStop( void );
	bool Play( void );
	bool Stop( void );
	bool SetStopBtn( void );

	long PrevUrl( void );
	long NextUrl( void );
	long SelectUrl( void );

	void CHeadLine::UpdateDownText( void );
private:
	void AddUrlList( WSCstring item );
	WSCstring PickUp2ch( WSCstring html );
	WSCstring GetText( long nSkip );
	WSCstring SetText( long n, WSCstring str );
	long IncHeadLineCurN( long n );
	long ResetHeadLineMaxN( void );

	WSCstring DelHtmlTag(
		WSCstring html, WSCstring strBgn, WSCstring strEnd
	);
	WSCstring DelHtmlBr( WSCstring html );
	WSCstring ConvHtmlMetaChar( WSCstring html );

	void SetDownText( long n, WSCstring str );

	friend void *BGDownLoad( void *arg );
};

extern CHeadLine gHeadLine;

#endif /* HEAD_LINE_H */
