#ifdef _WIN32
# include <windows.h>
#else /* _WIN32 */
# include <pthread.h>
#endif /* _WIN32 */

/**/

#include "Common.h"
#include "NewsThread.h"

/**/

bool NewsThreadCreate( void *(*func)( void * ) )
{
#ifdef _WIN32
# if 0
	unsigned dmy = 0;
	int id = _beginthreadex( NULL, 0, func, (void *)1, 0, &dmy );
	if( id == 0 )
		return false;
# else
	DWORD id = 0;
	HANDLE status = CreateThread( NULL, 0, (DWORD (*)( void * ))func,
		(void *)NULL, 0, &id );
	if( status == FALSE )
		return false;
# endif
#else /* _WIN32 */
	pthread_t id;
	int status = pthread_create( &id, NULL, func, (void *)NULL );
	if( status != 0 )
		return false;

	pthread_detach( id );
#endif /* _WIN32 */

	return true;
}

/**/

