#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>

/**/

#include <stdlib.h>
#include <stdio.h>

#ifdef _WIN32
# include <WINSOCK.H>
#else /* _WIN32 */
# include <unistd.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netinet/tcp.h>
# include <netdb.h>
# include <arpa/inet.h>
#endif /* _WIN32 */

/**/

#include "Common.h"
#include "Sock.h"

/**/

void InitSrvr( void )
{
#ifdef _WIN32
	WORD verReq = MAKEWORD( 1, 1 );
	WSADATA wsa;
	WSAStartup( verReq, &wsa );
#endif /* _WIN32 */
}

/**/

int OpenSrvr( WSCstring url, WSCstring port, int portN )
{
	WSCstring host = ConvUrlToHost( url );

	struct hostent *srvrHost = gethostbyname( host );
	if( srvrHost == NULL ){
		u_long addr = inet_addr( host );
		srvrHost = gethostbyaddr( (char *)&addr, sizeof( addr ),
			AF_INET );
		if( srvrHost == NULL )
			return -1;
	}

	struct servent *srvrEnt = getservbyname( port, "tcp" );

	int sock = socket( AF_INET, SOCK_STREAM, 0 );
	if( sock < 0 )
		return -1;

	struct sockaddr_in srvr;
	memset( (char *)&srvr, 0, sizeof( srvr ) );
	srvr.sin_family = AF_INET;
	if( srvrEnt == NULL ){
		int p = atoi( port );
		if( p == 0 )
			p = portN;
		srvr.sin_port = (p & 0xff) << 8;
		srvr.sin_port += (p >> 8) & 0xff;
	} else {
		srvr.sin_port = srvrEnt->s_port;
	}

	memcpy( (char *)&srvr.sin_addr,
		srvrHost->h_addr, srvrHost->h_length );

	int res = connect( sock, (sockaddr *)&srvr, sizeof( srvr ) );
	if( res <= -1 ){
		CloseSrvr( sock );
		return -1;
	}

	return sock;
}

/**/

int CloseSrvr( int sock )
{
	shutdown( sock, 2 );
#ifdef	_WIN32
	return( closesocket( sock ) );
#else	/* _WIN32 */
	return( close( sock ) );
#endif	/* _WIN32 */
}

/**/

bool RecvSrvr( int sock, const WSCstring url, WSCstring *dst )
{
	if( dst == NULL )
		return false;
	*dst = "T[of[^擾o܂łB";

	/**/

	WSCstring req;
	req << "GET " << url << " HTTP/1.0" << "\r\n" << "\r\n";

	if( send( sock, req, strlen( req ), 0 ) <= -1 ){
		*dst = "T[o֗v܂łB";
		return false;
	}

	/**/

	while( 1 ){
		WSCstring tmp;

		if( !RecvLine( sock, &tmp ) ){
			dst->clear();
			*dst << "T[owb_擾o܂łB"
				<< "(" << tmp << ")";
			return false;
		}

		if( tmp.getChars() <= 0 )
			break;
	}

	dst->clear();
	while( 1 ){
		WSCstring tmp;

		bool res = RecvLine( sock, &tmp );
		*dst << tmp;

		if( !res ){
			break;
		}
	}

	return true;
}

/**/

bool RecvLine( int sock, WSCstring *dst )
{
	if( dst == NULL )
		return false;
	dst->clear();

	bool ret = true;

	int preChar = '\0';
	while( 1 ){
		char buf[1 + 1];
		if( recv( sock, buf, 1, 0 ) <= 0 ){
			ret = false;
			break;
		}
		buf[1] = '\0';

		if( buf[0] == '\0' ){
			ret = false;
			break;
		}

		dst->addString( buf );

		if( buf[0] == '\n' ){
			long len;
			if( preChar == '\r' )
				len = 2;
			else
				len = 1;

			dst->cutString( dst->getChars() - len );

			break;
		} else if( preChar == '\r' ){
			dst->cutString( dst->getChars() - 2 );

			break;
		}

		preChar = buf[0];
	}

	dst->delLineFeed();

	return ret;
}

/**/

WSCstring ConvUrlToPath( WSCstring url )
{
	WSCstring path = url.getWord( 1, "//" );
	if( path.getChars() <= 0 )
		path = url;

	long pos = path.isExist( "/" );
	if( pos <= -1 )
		path = "/";
	else
		path.deleteChars( 0, pos );

	return path;
}

/**/

WSCstring ConvUrlToHost( WSCstring url )
{
	WSCstring path = url.getWord( 1, "//" );
	if( path.getChars() <= 0 )
		path = url;

	WSCstring tmp = path.getWord( 0, "/" );
	if( tmp.getChars() > 0 )
		path = tmp;

	return path;
}

/**/

