#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>

/**/

#include "Common.h"

/**/

#include <WSCmainWindow.h>
#include <WSCvkslabel.h>
#include <WSCvscrBar.h>
#include <WSCvbtn.h>
#include <WSCvtimer.h>
#include <WSCcomboBox.h>
#include <WSCmessageDialog.h>

extern WSCmainWindow *MainWin;
extern WSCvkslabel *Maivksl_HeadLine;
extern WSCvscrBar *Maivscr_ScrollBar;
extern WSCvbtn *Maivbtn_StopBtn;
extern WSCvtimer *Maivtim_MainTimer;
extern WSCvtimer *Maivtim_BeginTimer;
extern WSCcomboBox *Maicomb_NameList;
extern WSCvlabel *Maivlab_Art;
extern WSCvlabel *Maivlab_Thr;
extern WSCvlabel *Maivlab_Site;
extern WSCvbtn *Maivbtn_PrevUrlBtn;
extern WSCvbtn *Maivbtn_NextUrlBtn;
extern WSCvbtn *Maivbtn_BarBtn;

/**/

struct TListUrl {
	NMes mes;
	char *url;
	bool flagDown;
	long encoding;
};

TListUrl gListUrl[] = {
	{ NMesUrlName_news2_2ch_net_news5plus_,
		"http://news2.2ch.net/news5plus/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_sports2_2ch_net_iraq_,
		"http://sports2.2ch.net/iraq/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_news2_2ch_net_news5_,
		"http://news2.2ch.net/news5/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_society_2ch_net_kokusai_,
		"http://society.2ch.net/kokusai/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_tmp2_2ch_net_bakanews_,
		"http://tmp2.2ch.net/bakanews/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_tmp2_2ch_net_asia_,
		"http://tmp2.2ch.net/asia/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_news2_2ch_net_news2_,
		"http://news2.2ch.net/news2/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_pc_2ch_net_pcnews_,
		"http://pc.2ch.net/pcnews/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_comic_2ch_net_comicnews_,
		"http://comic.2ch.net/comicnews/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_music3_2ch_net_musicnews_,
		"http://music3.2ch.net/musicnews/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_news6_2ch_net_trafficinfo_,
		"http://news6.2ch.net/trafficinfo/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_news4_2ch_net_news_,
		"http://news4.2ch.net/news/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_news5_2ch_net_newsplus_,
		"http://news5.2ch.net/newsplus/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_bbq_2ch_net_bbynews_,
		"http://bbq.2ch.net/bbynews/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_news7_2ch_net_femnewsplus_,
		"http://news7.2ch.net/femnewsplus/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_news6_2ch_net_mnewsplus_,
		"http://news6.2ch.net/mnewsplus/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_book_2ch_net_bizplus_,
		"http://book.2ch.net/bizplus/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_news8_2ch_net_eqplus_,
		"http://news8.2ch.net/eqplus/",
		true,
		WS_EN_SJIS, },
	{ NMesUrlName_news8_2ch_net_eq_,
		"http://news8.2ch.net/eq/",
		true,
		WS_EN_SJIS, },
	{ NMesNull,
		NULL,
		false,
		WS_EN_DEFAULT, },
};

/**/

void CHeadLine::Init( void )
{
	ResetMessage( LANG_KIND_JAPANESE );
//ResetMessage( LANG_KIND_ENGLISH );//@@@
	Maivlab_Art->setProperty( WSNlabelString, MesLabelArt );
	Maivlab_Thr->setProperty( WSNlabelString, MesLabelThr );
	Maivlab_Site->setProperty( WSNlabelString, MesLabelSite );
	Maivbtn_PrevUrlBtn->setProperty( WSNlabelString, MesLabelSitePrev );
	Maivbtn_NextUrlBtn->setProperty( WSNlabelString, MesLabelSiteNext );
	Maivbtn_BarBtn->setProperty( WSNlabelString, MesLabelBar );

	mHeadLineCurN = 0;
	mHeadLineMaxN = 0;
	mFlagDown = false;

	mStrHeadLine.add( new WSCstring, -1 );
	mFlagDone.add( new bool, -1 );

	mStrItem = "";

	mWordIdx = 0;
	mWordMaxIdx = 1;

	mStrWordSep = "\n";

	gUrl.Init();
	if( !Load() )
		ResetUrlList();

	Reset();

	InitSrvr();

	if( !NewsThreadCreate( BGDownLoad ) )
		PopupError( MesThreadCreateError );
}

/**/

void CHeadLine::Reset( void )
{
	Stop();
	Update( 0, true );
}

/**/

WSCstring CHeadLine::GetStr( long n )
{
	long maxN = mStrHeadLine.getNum();

	if( n < 0 )
		return "";
	if( n > maxN - 1 )
		return "";
	if( mStrHeadLine[n] == NULL )
		return "";

	return( *(WSCstring *)(mStrHeadLine[n]) );
}

/**/

WSCstring CHeadLine::SetStr( long n, WSCstring str )
{
	long maxN = mStrHeadLine.getNum();

	if( n < 0 )
		return "";
	if( n > maxN - 1 )
		return "";
	if( mStrHeadLine[n] == NULL )
		return "";

	*((WSCstring *)(mStrHeadLine[n])) = str;
	return( *((WSCstring *)(mStrHeadLine[n])) );
}

/**/

bool CHeadLine::GetDone( long n )
{
	long maxN = mFlagDone.getNum();

	if( n < 0 )
		return false;
	if( n > maxN - 1 )
		return false;
	if( mFlagDone[n] == NULL )
		return false;

	return( *(bool *)(mFlagDone[n]) );
}

/**/

bool CHeadLine::SetDone( long n, bool done )
{
	long maxN = mFlagDone.getNum();

	if( n < 0 )
		return false;
	if( n > maxN - 1 )
		return false;
	if( mFlagDone[n] == NULL )
		return false;

	*((bool *)(mFlagDone[n])) = done;
	return( *((bool *)(mFlagDone[n])) );
}

/**/

void CHeadLine::Update( long nSkip, bool flgForce )
{
	long scrollLen = 2;

	unsigned long n = Maivscr_ScrollBar->getProperty( WSNvalue );
	unsigned long max_n = Maivscr_ScrollBar->getProperty( WSNmaximum );

	if( flgForce || ((n + scrollLen) >= max_n) ){
		mStrItem = GetText( nSkip );

		n = 0;
		max_n = mStrItem.getChars();
		if( max_n < 1 )
			max_n = 1;
		Maivscr_ScrollBar->setProperty( WSNvalue, n );
		Maivscr_ScrollBar->setProperty( WSNmaximum, max_n );
		Maivscr_ScrollBar->setProperty( WSNsliderSize, scrollLen );
		Maivscr_ScrollBar->setProperty( WSNincrement, scrollLen );
		Maivscr_ScrollBar->setProperty( WSNpageIncrement,
			scrollLen * 10 );

		WaitTimer();
	} else {
		n += scrollLen;
		Maivscr_ScrollBar->setProperty( WSNvalue, n );
	}

	Draw();
}

/**/

void CHeadLine::Draw( void )
{
	WSCstring strDraw = mStrItem;

	unsigned long n = Maivscr_ScrollBar->getProperty( WSNvalue );
	if( n > 0 )
		strDraw.deleteChars( 0, n );

	Maivksl_HeadLine->setProperty( WSNlabelString, strDraw );
	MainWin->setProperty( WSNtitleString, strDraw );
}

/**/

void CHeadLine::WaitTimer( void )
{
	WSCbool flagBegin = Maivtim_BeginTimer->getProperty( WSNrunning );
	WSCbool flagMain = Maivtim_MainTimer->getProperty( WSNrunning );

	if( flagBegin || flagMain ){
		Maivtim_BeginTimer->setProperty( WSNrunning, true );
		Maivtim_MainTimer->setProperty( WSNrunning, false );
	}

	SetStopBtn();
}

/**/

bool CHeadLine::PlayOrStop( void )
{
	WSCbool flagBegin = Maivtim_BeginTimer->getProperty( WSNrunning );
	WSCbool flagMain = Maivtim_MainTimer->getProperty( WSNrunning );

	if( flagBegin || flagMain ){
		return Stop();
	} else {
		return Play();
	}
}

/**/

bool CHeadLine::Play( void )
{
	Maivtim_BeginTimer->setProperty( WSNrunning, false );
	Maivtim_MainTimer->setProperty( WSNrunning, true );

	return SetStopBtn();
}

/**/

bool CHeadLine::Stop( void )
{
	Maivtim_BeginTimer->setProperty( WSNrunning, false );
	Maivtim_MainTimer->setProperty( WSNrunning, false );

	return SetStopBtn();
}

/**/

bool CHeadLine::SetStopBtn( void )
{
	WSCbool flagBegin = Maivtim_BeginTimer->getProperty( WSNrunning );
	WSCbool flagMain = Maivtim_MainTimer->getProperty( WSNrunning );

	if( flagBegin || flagMain ){
		/* It's playing. */
		Maivbtn_StopBtn->setProperty( WSNlabelString, "||" );
		return true;
	} else {
		/* It's stopping. */
		Maivbtn_StopBtn->setProperty( WSNlabelString, ">" );
		return false;
	}
}

/**/

long CHeadLine::PrevUrl( void )
{
	IncHeadLineCurN( -1 );
	Update( 0, true );

	return mHeadLineCurN;
}

/**/

long CHeadLine::NextUrl( void )
{
	IncHeadLineCurN( +1 );
	Update( 0, true );

	return mHeadLineCurN;
}

/**/

long CHeadLine::SelectUrl( void )
{
	WSCstring name = Maicomb_NameList->getProperty( WSNlabelString );
	long n = gUrl.GetN( name );

	if( n > -1 ){
		Update( 0, true );
	}
	if( mHeadLineCurN != n ){
		mHeadLineCurN = n;
		Update( 0, true );
	}

	return mHeadLineCurN;
}

/**/

void CHeadLine::ResetUrlList( void )
{
	DeleteUrlListAll();

	for( long i = 0; gListUrl[i].url != NULL; i++ ){
		if( gListUrl[i].mes == NMesNull )
			break;

		AddUrlList( Mes( gListUrl[i].mes ),
			gListUrl[i].url,
			gListUrl[i].flagDown,
			gListUrl[i].encoding );
	}
#if 0
 //@@@
 AddUrlList( "SourceForge.jp", "http://lnl.sourceforge.jp/", true );
#endif
#if 0
 //@@@
 AddUrlList( "YuMe", "http://life4.2ch.net/yume/", true );//@@@
#endif
}

/**/

void CHeadLine::AddUrlList(
	WSCstring name,
	WSCstring url, bool flagDown, long encoding )
{
	if( !gUrl.Add( name, url, flagDown, encoding ) )
		return;

	Maicomb_NameList->setProperty( WSNmenuItems, gUrl.GetList() );
	Maicomb_NameList->setProperty( WSNlabelString, name );

	mHeadLineCurN = 0;
	mHeadLineMaxN = gUrl.GetMaxN();

	if( mHeadLineMaxN <= 0 )
		return;

	long n = gUrl.GetN( name );

	WSCstring *newStr = new WSCstring;
	*newStr = MesHeadLineDefault;
	mStrHeadLine.add( newStr, n );

	bool *newFlag = new bool;
	*newFlag = false;
	mFlagDone.add( newFlag, n );
}

/**/

void CHeadLine::UpdateUrlList(
	WSCstring oldName, WSCstring name,
	WSCstring url, bool flagDown, long encoding )
{
	if( !gUrl.Update( oldName, name, url, flagDown, encoding ) )
		return;

	long n = gUrl.GetN( name );
	if( n <= -1 )
		return;

	SetStr( n, MesHeadLineDefault );
	SetDone( n, false );

	mHeadLineMaxN = gUrl.GetMaxN();
	Maicomb_NameList->setProperty( WSNmenuItems, gUrl.GetList() );
	IncHeadLineCurN( +-0 );
}

/**/

void CHeadLine::DeleteUrlList( WSCstring name )
{
	long n = gUrl.GetN( name );
	if( n <= -1 )
		return;

	if( !gUrl.Delete( name ) )
		return;

	mStrHeadLine.delPos( n );
	mFlagDone.delPos( n );

	mHeadLineMaxN = gUrl.GetMaxN();
	Maicomb_NameList->setProperty( WSNmenuItems, gUrl.GetList() );
	IncHeadLineCurN( +-0 );
}

/**/

void CHeadLine::DeleteUrlListAll( void )
{
	for( long i = gUrl.GetMaxN() - 1; i >= 0; i-- )
		DeleteUrlList( gUrl.GetName( i ) );
}

/**/

WSCstring CHeadLine::PickUp2ch( WSCstring html )
{
	WSCstring text;
	WSCstring strBgn = "<dd>";
	WSCstring strEnd = "<dt>";
	WSCstring strBgnSkip = "<dd><";
	long lenBgn = strBgn.getChars();

	while( 1 ){
		if( html.getChars() <= 0 )
			break;

		/* I search tokens. */

		WSCstring tmp = html;
		tmp.to_lower();

		long idxBgn = tmp.isExist( strBgn );
		long idxEnd = tmp.isExist( strEnd );
		long idxBgnSkip = tmp.isExist( strBgnSkip );

		tmp.deleteChars( 0, lenBgn );
		long idxEnd2 = tmp.isExist( strBgn );
		if( idxEnd2 > -1 )
			idxEnd2 += lenBgn;

		if( idxBgn <= -1 )
			break;
		if( idxEnd > -1 ){
			if( idxEnd2 > -1 ){
				if( idxEnd2 < idxEnd ){
					/* There are beginning token */
					/* after beginning token. */

					idxEnd = idxEnd2;
				}
			}
		} else {
			if( idxEnd2 > -1 ){
				idxEnd = idxEnd2;
			} else {
				/* I can't find beginning token */
				/* and ending token. */

				break;
			}
		}
		if( idxEnd < idxBgn ){
			/* There are ending token */
			/* before beginning token. */

			html.deleteChars( 0, idxBgn );
			continue;
		}
		if( idxBgn == idxBgnSkip ){
			/* There are skipping token */

			html.deleteChars( 0, idxBgn + lenBgn );
			continue;
		}

		/* I cut HTML text from beginning token */
		/* to ending token. */

		WSCstring str = html;

		idxBgn += lenBgn;
		str.cutString( idxEnd );
		str.deleteChars( 0, idxBgn );

		text << str << mStrWordSep;

		/* I set HTML text to next position. */

		html.deleteChars( 0, idxEnd );
	}

	return text;
}

/**/

WSCstring CHeadLine::GetText( long nSkip )
{
	mWordIdx += nSkip;

	if( mWordIdx >= mWordMaxIdx ){
		IncHeadLineCurN( +1 );
		mWordIdx = 0;
	}
	if( mWordIdx < 0 ){
		IncHeadLineCurN( -1 );
		mWordIdx = mWordMaxIdx - 1;
	}

	WSCstring str = GetStr( mHeadLineCurN )
		.getWord( mWordIdx, mStrWordSep );

	str = DelHtmlHref( str );

	str = DelHtmlTag( str, "<font", "</font>" );

	str = DelHtmlStr( str, " <br> " );
	str = DelHtmlStr( str, " <br>" );
	str = DelHtmlStr( str, "<br> " );
	str = DelHtmlStr( str, "<br>" );

	str = ConvHtmlMetaChar( str );

	str << "    ";

	return str;
}

/**/

WSCstring CHeadLine::SetText( long n, WSCstring str )
{
	if( (n < 0) || (n >= mHeadLineMaxN) )
		return "";

	SetStr( n, str );

	if( n == mHeadLineCurN )
		Update( 0, true );

	return str;
}

/**/

long CHeadLine::IncHeadLineCurN( long n )
{
	mWordIdx = 0;
	mWordMaxIdx = 1;

	if( mHeadLineMaxN <= 0 ){
		mHeadLineCurN = 0;

		return mHeadLineCurN;
	}

	mHeadLineCurN += n;
	mHeadLineCurN %= mHeadLineMaxN;
	mHeadLineCurN += mHeadLineMaxN;
	mHeadLineCurN %= mHeadLineMaxN;

	mWordMaxIdx = GetStr( mHeadLineCurN ).getWords( mStrWordSep );
	if( mWordMaxIdx <= 0 )
		mWordMaxIdx = 1;

	/* I Select URL list */

	WSCstring name = gUrl.GetName( mHeadLineCurN );
	Maicomb_NameList->setProperty( WSNlabelString, name );

	return mHeadLineCurN;
}

/**/

WSCstring CHeadLine::DelHtmlHref( WSCstring html )
{
	WSCstring strBgn1 = "<a href";
	WSCstring strEnd1 = "\"";
	WSCstring strBgn2 = "\"";
	WSCstring strEnd2 = "</a>";
	long lenBgn1 = strBgn1.getChars();
	long lenEnd1 = strEnd1.getChars();
	long lenBgn2 = strBgn2.getChars();
	long lenEnd2 = strEnd2.getChars();
	WSCstring strHead = "[";
	WSCstring strFoot = "]";

	while( 1 ){
		WSCstring tmp;

		/* Begin 1 */

		tmp = html;

		long idxBgn1 = tmp.isExist( strBgn1 );
		if( idxBgn1 <= -1 )
			break;

		/* End 1 */

		tmp = html;
		tmp.deleteChars( 0, idxBgn1 + lenBgn1 );

		long idxEnd1 = tmp.isExist( strEnd1 );
		if( idxEnd1 <= -1 )
			break;
		idxEnd1 += idxBgn1 + lenBgn1;

		/* Begin 2 */

		tmp = html;
		tmp.deleteChars( 0, idxEnd1 + lenEnd1 );

		long idxBgn2 = tmp.isExist( strBgn2 );
		if( idxBgn2 <= -1 )
			break;
		idxBgn2 += idxEnd1 + lenEnd1;

		/* End 2 */

		tmp = html;
		tmp.deleteChars( 0, idxBgn2 + lenBgn2 );

		long idxEnd2 = tmp.isExist( strEnd2 );
		if( idxEnd2 <= -1 )
			break;
		idxEnd2 += idxBgn2 + lenBgn2;

		/*  */

		if( idxBgn2 < idxBgn1 )
			continue;

		html.deleteChars( idxBgn2, (idxEnd2 - idxBgn2) + lenEnd2 );
		html.insertString( idxBgn2, strFoot );
		html.deleteChars( idxBgn1, (idxEnd1 - idxBgn1) + lenEnd1 );
		html.insertString( idxBgn1, strHead );
	}

	return html;
}

/**/

WSCstring CHeadLine::DelHtmlTag(
	WSCstring html,
	WSCstring strBgn, WSCstring strEnd )
{
	long lenEnd = strEnd.getChars();

	while( 1 ){
		long idxBgn = html.isExist( strBgn );
		if( idxBgn <= -1 )
			break;

		WSCstring tmp = html;
		tmp.deleteChars( 0, idxBgn );

		long idxEnd = tmp.isExist( strEnd );
		if( idxEnd <= -1 )
			break;
		idxEnd += idxBgn;

		if( idxEnd < idxBgn )
			break;

		idxEnd += lenEnd;
		html.deleteChars( idxBgn, idxEnd - idxBgn );
	}

	return html;
}

/**/

WSCstring CHeadLine::DelHtmlStr( WSCstring html, WSCstring str )
{
	html.delString( str, 0 );

	return html;
}

/**/

WSCstring CHeadLine::ConvHtmlMetaChar( WSCstring html )
{
	WSCstring listMeta[][2] = {
		{
			"&gt;",
			">",
		},
		{
			"&lt;",
			"<",
		},
		{
			"",
			"",
		},
	};

	for( long i = 0; i < 128; i++ ){
		if( listMeta[i][0].getChars() <= 0 ){
			break;
		}

		html.replaceString( listMeta[i][0], listMeta[i][1], 0 );
	}

	return html;
}

/**/

void CHeadLine::UpdateDownText( void )
{
	if( mFlagDown ){
		SetText( mDownN, mStrDown );

		mFlagDown = false;
	}
}

/**/

void CHeadLine::SetDownText( long n, WSCstring str )
{
	while( mFlagDown ){
		SleepSec( 1 );
	}

	mDownN = n;
	mStrDown = str;
	mFlagDown = true;
}

/**/

bool CHeadLine::Save( void )
{
	WSCstring str;
	for( long i = 0; i < gUrl.GetMaxN(); i++ ){
		long en = gUrl.GetEncoding( i );
		str << "\"\",\""
			<< gUrl.GetName( i ) << "\",\""
			<< gUrl.GetUrl( i ) << "\",\""
			<< gUrl.GetFlagDownload( i ) << "\",\""
			<< ConvEncodingToStr( en ) << "\",\""
			<< "\"\n";
	}

	long res = WSGFreplaceTextFile( CONFIG_FILE_NAME, str, false );
	if( res != WS_NO_ERR ){
		PopupError( MesUrlListSaveError );
		return false;
	}

	return true;
}

/**/

bool CHeadLine::Load( void )
{
	if( !WSGFcheckExistFile( CONFIG_FILE_NAME ) )
		return false;

	WSCstring *str = WSGFreadTextFile( CONFIG_FILE_NAME );
	long strMaxLine = str->getWords( "\n" ) - 1;

	DeleteUrlListAll();

	for( long i = strMaxLine - 1; i >= 0; i-- ){
		/* I split lines. */

		WSCstring line = str->getWord( i, "\n" );

		/* I split CSV data. */

		WSCstring name = line.getWord( 1, "\",\"" );
		WSCstring url = line.getWord( 2, "\",\"" );
		WSCstring tmpFlag = line.getWord( 3, "\",\"" );
		WSCstring tmpEn = line.getWord( 4, "\",\"" );

		/* Flag download */

		bool flagDown;
		if( CompareString( tmpFlag, "0" ) )
			flagDown = false;
		else
			flagDown = true;

		/* Encoding */

		long en = ConvStrToEncoding( tmpEn );

		/* I add URL list. */

		AddUrlList( name, url, flagDown, en );
	}

	delete str;

	return true;
}

/**/

void *BGDownLoad( void *arg )
{
	CHeadLine &hl = gHeadLine;

	while( 1 ){
		if( hl.mFlagDown ){
			SleepSec( 1 );
			continue;
		}

		WSCstring text;

		long curN = -1;
		long hlCurN = hl.mHeadLineCurN;
		long hlMaxN = hl.mHeadLineMaxN;
		long flagFirst = true;
		for( long i = hlMaxN - 1; i >= 0; i-- ){
			long j = (hlCurN + i) % hlMaxN;
			if( hlMaxN != hl.mHeadLineMaxN ){
				curN = -1;
				break;
			}
			if( hl.GetDone( j ) ){
				flagFirst = false;
			} else if( gUrl.GetFlagDownload( j ) ){
				curN = j;
			}
		}
		if( curN <= -1 ){
			SleepSec( 10 );
			continue;
		} else {
			hl.mDownN = curN;
		}

		WSCstring url = gUrl.GetUrl( curN );
		long encoding = gUrl.GetEncoding( curN );

		/* I am connecting a server. */

		text = MesDownLoadOpen;
		hl.SetDownText( curN, text );

		int sock = OpenSrvr( url, "http", 80 );
		if( sock <= -1 ){
			text = MesDownLoadOpenError;
			hl.SetDownText( curN, text );

			continue;
		}

		SleepSec( 2 );

		/* I am downloading from a server. */

		text = MesDownLoadRecv;
		hl.SetDownText( curN, text );

		WSCstring strHtml;
		if( !RecvSrvr( sock, url, &strHtml, encoding ) ){
			text = strHtml;
			hl.SetDownText( curN, text );

			continue;
		}

		SleepSec( 2 );

		/* I am disconnecting a server. */

		text = MesDownLoadClose;
		hl.SetDownText( curN, text );

		if( CloseSrvr( sock ) <= -1 ){
			text = MesDownLoadCloseError;
			hl.SetDownText( curN, text );

			continue;
		}

		SleepSec( 2 );

		/* I am converting data from HTML to text. */

		text = MesDownLoadPickUp;
		hl.SetDownText( curN, text );

		text = hl.PickUp2ch( strHtml );
		hl.SetDownText( curN, text );
		if( text.getChars() <= 0 ){
			text = MesDownLoadPickUpError;
			hl.SetDownText( curN, text );

			gUrl.SetFlagDownload( curN, false );

			continue;
		}

		SleepSec( 2 );

		/* Finish. */

		if( flagFirst ){
			if( curN == hl.mHeadLineCurN ){
				hl.IncHeadLineCurN( +-0 );
				hl.Update( 0, true );
			}
			hl.Play();
		}

		hl.SetDone( curN, true );
		hl.mFlagDown = true;

		SleepSec( 10 );
	}

	return NULL;
}

/**/

CHeadLine gHeadLine;
