#ifndef HEAD_LINE_H
#define HEAD_LINE_H

#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>

class CHeadLine {
private:
	long mHeadLineCurN;
	long mHeadLineMaxN;

	bool mFlagDown;
	long mDownN;
	WSCstring mStrDown;

	WSClistData mStrHeadLine;
	WSClistData mFlagDone;
	WSCstring mStrItem;

	long mWordIdx;
	long mWordMaxIdx;

	WSCstring mStrWordSep;
public:
	void CHeadLine::Init( void );
	void CHeadLine::Reset( void );

	WSCstring CHeadLine::GetStr( long n );
	WSCstring CHeadLine::SetStr( long n, WSCstring str );

	bool CHeadLine::GetDone( long n );
	bool CHeadLine::SetDone( long n, bool done );

	void CHeadLine::Update( long nSkip, bool flgForce );
	void CHeadLine::Draw( void );
	void CHeadLine::WaitTimer( void );

	bool CHeadLine::PlayOrStop( void );
	bool CHeadLine::Play( void );
	bool CHeadLine::Stop( void );
	bool CHeadLine::SetStopBtn( void );

	long CHeadLine::PrevUrl( void );
	long CHeadLine::NextUrl( void );
	long CHeadLine::SelectUrl( void );

	void CHeadLine::UpdateDownText( void );

	void CHeadLine::ResetUrlList( void );
	void CHeadLine::AddUrlList(
		WSCstring name,
		WSCstring url, bool flagDown, long encoding );
	void CHeadLine::UpdateUrlList(
		WSCstring oldName, WSCstring name,
		WSCstring url, bool flagDown, long encoding );
	void CHeadLine::DeleteUrlList( WSCstring name );
	void CHeadLine::DeleteUrlListAll( void );

	bool CHeadLine::Save( void );
	bool CHeadLine::Load( void );
private:
	WSCstring CHeadLine::PickUp2ch( WSCstring html );
	WSCstring CHeadLine::GetText( long nSkip );
	WSCstring CHeadLine::SetText( long n, WSCstring str );
	long CHeadLine::IncHeadLineCurN( long n );

	WSCstring CHeadLine::DelHtmlHref( WSCstring html );
	WSCstring CHeadLine::DelHtmlTag(
		WSCstring html,
		WSCstring strBgn, WSCstring strEnd );
	WSCstring CHeadLine::DelHtmlStr( WSCstring html, WSCstring str );
	WSCstring CHeadLine::ConvHtmlMetaChar( WSCstring html );

	void CHeadLine::SetDownText( long n, WSCstring str );

	friend void *BGDownLoad( void *arg );
};

extern CHeadLine gHeadLine;

#endif /* HEAD_LINE_H */
