#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>

/**/

#include "Common.h"

/**/

#include <WSCmessageDialog.h>

/**/

char	*gArrayMes[NMesMaxN];

typedef struct {
	NMes	n;
	char	*s;
} TMes;

static TMes	gAllLangMes[LANG_KIND_MAX_N][NMesMaxN] = {
	{
#include "MesEng.h"
	},
	{
#include "MesJpn.h"
	},
};

static bool gFlagMesDef[NMesMaxN];

/**/

void ResetMessage( ELangKind nLang )
{
	for( NMes m = 0; m < NMesMaxN; m++ )
		gFlagMesDef[m] = false;

	for( NMes i = 0; i < NMesMaxN; i++ ){
		if( gAllLangMes[nLang][i].s == NULL )
			break;

		NMes m = gAllLangMes[nLang][i].n;
		if( gFlagMesDef[m] ){
			/* åƤ */
			WSCstring str;
			str << "Redefined message data:"
				<< " LANG=" << nLang
				<< " No.=" << m
				<< " `" << gAllLangMes[nLang][i].s << "'"
				;

			PopupError( str );
			exit( 1 );
		}
		gArrayMes[m] = gAllLangMes[nLang][i].s;
		gFlagMesDef[m] = true;
	}

	for( NMes m = 0; m < NMesMaxN; m++ ){
		if( !gFlagMesDef[m] ){
			/* åƤʤ */
			WSCstring str;
			str << "Don't defined message data:"
				<< " LANG=" << nLang
				<< " No.=" << m
				;

			PopupError( str );
			exit( 1 );
		}
	}
}

/**/

void PopupError( WSCstring str )
{
	PopupMesCommon( "ERROR: ", str );
}

/**/

void PopupWarning( WSCstring str )
{
	PopupMesCommon( "WARNING: ", str );
}

/**/

void PopupMessage( WSCstring str )
{
	PopupMesCommon( "", str );
}

/**/

void PopupMesCommon( WSCstring strMesType, WSCstring str )
{
	WSCstring mes;
	mes << strMesType << str;

	WSCmessageDialog *dlg = WSGIappMessageDialog();
	dlg->setProperty( WSNlabelString, mes );
	dlg->popup();
}

/**/

