#ifdef _WIN32
# include <windows.h>
#else /* _WIN32 */
# include <pthread.h>
#endif /* _WIN32 */

/**/

#include "Common.h"
#include "NewsThread.h"

/**/

#ifdef _WIN32

static void *(*gNewsFunc)( void * ) = NULL;

DWORD WINAPI NewsThread( void *arg )
{
	if( gNewsFunc != NULL )
		gNewsFunc( NULL );

	return 0;
}

#endif /* _WIN32 */

/**/

bool NewsThreadCreate( void *(*func)( void * ) )
{
#ifdef _WIN32
# if 0
	unsigned dmy = 0;
	int id = _beginthreadex( NULL, 0, func, (void *)1, 0, &dmy );
	if( id == 0 )
		return false;
# else
	DWORD id = 0;
	gNewsFunc = func;
	HANDLE status = CreateThread( NULL, 0,
		NewsThread,
		NULL, 0, &id );
	if( status == FALSE )
		return false;
# endif
#else /* _WIN32 */
	pthread_t id;
	int status = pthread_create( &id, NULL, func, (void *)NULL );
	if( status != 0 )
		return false;

	pthread_detach( id );
#endif /* _WIN32 */

	return true;
}

/**/

