#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>

/**/

#include "Common.h"

/**/

void CUrl::Init( void )
{
}

/**/

bool CUrl::Add(
	WSCstring name,
	WSCstring url, bool flagDown, long encoding )
{
	/* If new name is exist already then it's error */
	if( GetN( name ) > -1 ){
		WSCstring strErr;
		strErr << MesUrlExistNameError
			<< "\n\"" << name << "\"";
		PopupError( strErr );

		return false;
	}

	WSCstring *newName = new WSCstring;
	WSCstring *newUrl = new WSCstring;
	bool *newFlagDown = new bool;
	long *newEncoding = new long;

	*newName = name;
	*newUrl = url;
	*newFlagDown = flagDown;
	*newEncoding = encoding;

	mStrName.add( newName, 0 );
	mStrUrl.add( newUrl, 0 );
	mFlagDownload.add( newFlagDown, 0 );
	mEncoding.add( newEncoding, 0 );

	return true;
}

/**/

bool CUrl::Update(
	WSCstring oldName, WSCstring name,
	WSCstring url, bool flagDown, long encoding )
{
	if( !CompareString( name, oldName ) ){
		/* If new name is exist already then it's error */
		if( GetN( name ) > -1 ){
			WSCstring strErr;
			strErr << MesUrlExistNameError
				<< "\n\"" << oldName
				<< "\" -> \"" << name << "\"";
			PopupError( strErr );

			return false;
		}
	}

	/* If old name isn't exist then it's error */
	long n = GetN( oldName );
	if( n <= -1 ){
		WSCstring strErr;
		strErr << MesUrlNotExistNameError
			<< "\n\"" << oldName << "\"";
		PopupError( strErr );

		return false;
	}

	SetName( n, name );
	SetUrl( n, url );
	SetFlagDownload( n, flagDown );
	SetEncoding( n, encoding );

	return true;
}

/**/

bool CUrl::Delete( WSCstring name )
{
	/* If name isn't exist then it's error */
	long n = GetN( name );
	if( n <= -1 ){
		WSCstring strErr;
		strErr << MesUrlNotExistNameError
			<< "\n\"" << name << "\"";
		PopupError( strErr );

		return false;
	}

	mStrName.delPos( n );
	mStrUrl.delPos( n );
	mFlagDownload.delPos( n );
	mEncoding.delPos( n );

	return true;
}

/**/

long CUrl::GetN( WSCstring name )
{
	for( long i = 0; i < GetMaxN(); i++ )
		if( CompareString( GetName( i ), name ) )
			return i;

	return -1;
}

/**/

WSCstring CUrl::GetList( void )
{
	WSCstring list;
	for( long i = 0; i < GetMaxN(); i++ ){
		list << GetName( i );

		if( (i + 1) < GetMaxN() ){
			list << ",";
		}
	}

	return list;
}

/**/

WSCstring CUrl::GetName( long n )
{
	if( n < 0 )
		return "";
	if( n >= GetMaxN() )
		return "";

	if( mStrName[n] == NULL )
		return "";
	else
		return( *((WSCstring *)(mStrName[n])) );
}

/**/

WSCstring CUrl::SetName( long n, WSCstring name )
{
	if( n < 0 )
		return "";
	if( n >= GetMaxN() )
		return "";

	if( mStrName[n] == NULL )
		return "";

	*((WSCstring *)(mStrName[n])) = name;

	return( *((WSCstring *)(mStrName[n])) );
}

/**/

WSCstring CUrl::GetUrl( WSCstring name )
{
	return GetUrl( GetN( name ) );
}

/**/

WSCstring CUrl::GetUrl( long n )
{
	if( n < 0 )
		return( "" );
	if( n >= GetMaxN() )
		return( "" );

	if( mStrUrl[n] == NULL ){
		return( "" );
	} else {
		return( *((WSCstring *)(mStrUrl[n])) );
	}
}

/**/

WSCstring CUrl::SetUrl( WSCstring name, WSCstring url )
{
	return( SetUrl( GetN( name ), url ) );
}

/**/

WSCstring CUrl::SetUrl( long n, WSCstring url )
{
	if( n < 0 )
		return false;
	if( n >= GetMaxN() )
		return false;

	if( mStrUrl[n] == NULL ){
		return false;
	} else {
		*((WSCstring *)(mStrUrl[n])) = url;
		return( *((WSCstring *)(mStrUrl[n])) );
	}
}

/**/

bool CUrl::GetFlagDownload( WSCstring name )
{
	return GetFlagDownload( GetN( name ) );
}

/**/

bool CUrl::GetFlagDownload( long n )
{
	if( n < 0 )
		return false;
	if( n >= GetMaxN() )
		return false;

	if( mFlagDownload[n] == NULL ){
		return( "" );
	} else {
		return( *((bool *)(mFlagDownload[n])) );
	}
}

/**/

bool CUrl::SetFlagDownload( WSCstring name, bool flag )
{
	return( SetFlagDownload( GetN( name ), flag ) );
}

/**/

bool CUrl::SetFlagDownload( long n, bool flag )
{
	if( n < 0 )
		return false;
	if( n >= GetMaxN() )
		return false;

	if( mFlagDownload[n] == NULL ){
		return false;
	} else {
		*((bool *)(mFlagDownload[n])) = flag;
		return( *((bool *)(mFlagDownload[n])) );
	}
}

/**/

long CUrl::GetEncoding( WSCstring name )
{
	return GetEncoding( GetN( name ) );
}

/**/

long CUrl::GetEncoding( long n )
{
	if( n < 0 )
		return WS_EN_DEFAULT;
	if( n >= GetMaxN() )
		return WS_EN_DEFAULT;

	if( mEncoding[n] == NULL ){
		return WS_EN_DEFAULT;
	} else {
		return( *((long *)(mEncoding[n])) );
	}
}

/**/

long CUrl::SetEncoding( WSCstring name, long en )
{
	return( SetEncoding( GetN( name ), en ) );
}

/**/

long CUrl::SetEncoding( long n, long en )
{
	if( n < 0 )
		return WS_EN_DEFAULT;
	if( n >= GetMaxN() )
		return WS_EN_DEFAULT;

	if( mEncoding[n] == NULL ){
		return WS_EN_DEFAULT;
	} else {
		*((long *)(mEncoding[n])) = en;
		return( *((long *)(mEncoding[n])) );
	}
}

/**/

CUrl gUrl;

/**/

