/*============================================================================*
 *  FILE: 
 *     machine.c
 *
 *  Description: 
 *     Palm device specific functions.
 *
 *===========================================================================*/
#define MACHINE_C

#ifdef USE_CLIE
// SONYpWOAVXg}XN
#define NUMBER_OF_MASKS   3
UInt16 NNshSonyJogMask[] = {
     sonyJogAstMaskType1, // tH[ɌʂɃ}XNݒ肷
     NUMBER_OF_MASKS,     // }XNtH[
     FRMID_MESSAGE,       sonyJogAstMaskAll,
     FRMID_MANAGEBBS,     sonyJogAstMaskAll,
     FRMID_THREAD,        sonyJogAstMaskAll,
     0, 0, 0, 0           // |]T...
};
#endif

extern Err setOfflineLogDir(Char *fileName);

/*-------------------------------------------------------------------------*/
/*   Function :   checkVFSdevice_NNsh                                      */
/*                               VFS̃T|[g󋵂p[^ɔf */
/*-------------------------------------------------------------------------*/
static void checkVFSdevice_NNsh(void)
{
    Err            err;
    Char           dirName[sizeof(DATAFILE_PREFIX)+ MARGIN];
    UInt32         vfsMgrVersion, volIterator;
    VolumeInfoType volInfo;  

    // VFS̃T|[gLmFB
    vfsMgrVersion = 0;
    err = FtrGet(sysFileCVFSMgr, vfsFtrIDVersion, &vfsMgrVersion);
    if (err == errNone)
    {
        //  VFSgp\mFB(t@X}jAƂɂ)
        volIterator = vfsIteratorStart;
        while (volIterator != vfsIteratorStop)
        {
            err = VFSVolumeEnumerate(&(NNshGlobal->vfsVol), &volIterator);
            if (err != errNone)
            {
                NNsh_DebugMessage(ALTID_WARN, "VFSVolumeEnumerate()", "", err);
                break;
            }
            err = VFSVolumeInfo(NNshGlobal->vfsVol, &volInfo);
            if (err != errNone)
            {
                NNsh_DebugMessage(ALTID_WARN, "VFSVolumeInfo()", "", err);
                break;
            }
            if (volInfo.fsType == vfsFilesystemType_VFAT)
            {
                // "VFSgp\ɎIVFS ON" ݒmF
                if (NNshParam->vfsOnAutomatic != 0)
                {
                    // VFS ONɂ
                    NNshParam->useVFS = ((NNSH_VFS_ENABLE)|
                                         (NNSH_VFS_WORKAROUND)|
                                         (NNSH_VFS_USEOFFLINE)|
                                         (NNSH_VFS_DBBACKUP));
                }
                if ((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0)
                {
                    // NNshpf[^i[pfBNg쐬(VFS ON)
                    StrCopy(dirName, DATAFILE_PREFIX);
                    dirName[StrLen(dirName) - 1] = '\0';
                    err = CreateDir_NNsh(dirName);
                    NNsh_DebugMessage(ALTID_INFO, "Created :", dirName, err);
                    err = errNone;
		}
                if ((NNshParam->useVFS & NNSH_VFS_USEOFFLINE) != 0)
                {
                    // NNshpOFFLINEf[^i[fBNg쐬(VFS ON)
                    StrCopy(dirName, LOGDATAFILE_PREFIX);
                    dirName[StrLen(dirName) - 1] = '\0';
                    err = CreateDir_NNsh(dirName);
                    NNsh_DebugMessage(ALTID_INFO,"Created :",dirName,err);

                    // logdir.txtǂOFFLINEOx[XfBNg擾
                    (void) setOfflineLogDir(LOGDIR_FILE);
                    err = errNone;
		}
                break;
            }
        }
    }
    if (err != errNone)
    {
        // foCXVFST|[gȂꍇ́ANNshݒVFSgpݒNA
        NNshParam->useVFS = NNSH_NOTSUPPORT_VFS;
    }
    return;
}

#ifdef USE_CLIE
/*-------------------------------------------------------------------------*/
/*   Function :   CLIEdisplayNotify                                        */
/*                                                CLIEfBXvCXV() */
/*-------------------------------------------------------------------------*/
Err CLIEdisplayNotify(SysNotifyParamType *notifyP)
{
    FormType *frm;

    // ---------------------------------------------------
    //    ӁFnotifyP ́ANULLŃR[
    // ---------------------------------------------------
    if (NNshGlobal->silkRef != 0)
    {
        frm = FrmGetActiveForm();
        HandEraResizeForm(frm);
        //   ʕ\̍XV́AW̃Cxg[vōsB̂߂ɁA
        // `wtOύXAnilEvent𔭍sB
        NNshGlobal->updateHR = NNSH_UPDATE_DISPLAY;
        EvtWakeup();
    }
    return (errNone);
}
#endif

#ifdef USE_CLIE
/*-------------------------------------------------------------------------*/
/*   Function :   setCLIESupport_NNsh                                      */
/*                                              CLIET|[g@\ݒ肷 */
/*-------------------------------------------------------------------------*/
static void setCLIESupport_NNsh(void)
{
    SonySysFtrSysInfoP     infoP;
    Boolean                isColor;
    UInt32                 vskVer, width, height, depth;
    Err                    ret;

    infoP                        = NULL;
    NNshGlobal->jogAssistSetBack = NULL;

    // SONYfoCXǂ̃`FbN
    if ((FtrGet(sysFtrCreator, sysFtrNumOEMCompanyID, &depth) != 0)||
        (depth != sonyHwrOEMCompanyID_Sony))
    {
        // SONYfoCXłȂ΁AI
        return;
    }

    // JOGAVXg@\̐ݒ
    if (!FtrGet(sonySysFtrCreator, sonySysFtrNumSysInfoP, (UInt32 *)&infoP))
    {
        // JOGAVXg@\Ă邩ǂ`FbN
        if (infoP && (infoP->extn & sonySysFtrSysInfoExtnJogAst))
        {
            // ݂̃WOAVXg擾
            if(!FtrGet(sonySysFtrCreator, sonySysFtrNumJogAstMaskP,
                       (UInt32 *) &(NNshGlobal->jogAssistSetBack)))
            {
                // ݂̃WOAVXgۊǁANNsip̐ݒ
                 NNshGlobal->jogInfoBack =
                                            *(NNshGlobal->jogAssistSetBack);
                *(NNshGlobal->jogAssistSetBack) =  NNshSonyJogMask;

                // WOAVXgI[in̐ݒ͏ȗ(񂾂)
            }
        }
    }

    // SILK}l[W̎QƔԍ擾
    ret = SysLibFind(sonySysLibNameSilk, &(NNshGlobal->silkRef));
    if (ret == sysErrLibNotFound)
    {
        // SILK}l[W[h̏ꍇA[hł邩TryĂ݂B
        ret = SysLibLoad('libr',sonySysFileCSilkLib,&(NNshGlobal->silkRef));
    }
    if (ret != errNone)
    {
        // 281Silk}l[WR[h}[W
        ret = SysLibLoad(sonySysFileTSilkLib,
                         sonySysFileCSilkLib,
                         &(NNshGlobal->silkRef));    // OS5
        if (ret != errNone)
        {
            ret = SysLibLoad('libr','SlSi',&(NNshGlobal->silkRef));
        }
        if (ret != errNone)
        {
            // SILK}l[W͎gpłȂAɂSONY HRLIB[h
            NNshGlobal->silkRef = 0;
            goto SONY_HRLIB_LOAD;
        }
    }

    // SILKgpȂꍇɂ͎ɐi
    if (NNshGlobal->notUseSilk != 0)
    {
        NNshGlobal->silkRef = 0;
        NNshGlobal->silkVer = 1;
        goto SONY_HRLIB_LOAD;
    }

    // SILK}l[W̃o[WmF
    ret = FtrGet(sonySysFtrCreator, sonySysFtrNumVskVersion, &vskVer);
    if (ret != errNone)
    {
        // SILK}l[WVERSION1ATCŶ݃T|[g(NRp)
        if (SilkLibOpen(NNshGlobal->silkRef) == errNone)
        {
            // SILK̃TCYT|[gĂ邱Ƃ(SILK}l[W)ʒm
            SilkLibEnableResize(NNshGlobal->silkRef);
            NNshGlobal->silkVer = 1;
        }
    }
    else
    {
        // SILK}l[WVERSION2A(NXȍ~)
        if (VskOpen(NNshGlobal->silkRef) == errNone)
        {
            // SILK̃TCYT|[gĂ邱Ƃ(SILK}l[W)ʒm
            VskSetState(NNshGlobal->silkRef, vskStateEnable, 1);
            NNshGlobal->silkVer = 2;
        }
    }

    // sysNotifyDisplayChangeEventsubscribe
    ret = SysNotifyRegister(0, SOFT_CREATOR_ID, sysNotifyDisplayChangeEvent,
                            CLIEdisplayNotify, sysNotifyNormalPriority,
                            NULL);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_WARN, "SysNotifyRegister()", "", ret);
    }

SONY_HRLIB_LOAD:
    // SONY HiResgpȂꍇɂ́AŏI
    if (NNshParam->disableSonyHR != 0)
    {
        // HRLIB͎gpȂ
        NNshGlobal->hrRef    = 0;
        NNshGlobal->notUseHR = NNshParam->disableSonyHR;
        return;
    }

    // HRLIB̎QƔԍ擾
    ret = SysLibFind(sonySysLibNameHR, &(NNshGlobal->hrRef));
    if (ret == sysErrLibNotFound)
    {
        // HRLIB[h̏ꍇA[hł邩TryĂ݂B
        ret = SysLibLoad('libr', sonySysFileCHRLib, &(NNshGlobal->hrRef));
    }
    if (ret != errNone)
    {
        // HRLIB͎gpłȂ
        NNshGlobal->hrRef = 0;
        return;
    }
    // HRLIB̎gp錾HRLIB̃o[Wԍ擾
    HROpen(NNshGlobal->hrRef);
    HRGetAPIVersion(NNshGlobal->hrRef, &(NNshGlobal->hrVer));
    if (NNshGlobal->hrVer < HR_VERSION_SUPPORT_FNTSIZE)
    {
        // o[W̃nC]...ʃ[hmF...
        ret = HRWinScreenMode(NNshGlobal->hrRef, winScreenModeGet, 
                              &width, &height, &depth, &isColor);
        if (ret != errNone)
        {
            // HRLIB͎gpȂ
            HRClose(NNshGlobal->hrRef);
            NNshGlobal->hrRef = 0;
            return;
        }

        NNshGlobal->prevHRWidth = width;
        if (width != hrWidth)
        {
            // ʃ[hnC]łȂ̂ŁAnC][hɐ؂ւ
            width  = hrWidth;
            height = hrHeight;
            ret    = HRWinScreenMode(NNshGlobal->hrRef, winScreenModeSet,
                                     &width, &height, &depth, &isColor);
            if (ret != errNone)
            {
                // HRLIB͎gpȂ
                HRClose(NNshGlobal->hrRef);
                NNshGlobal->hrRef = 0;
                return;
            }
        }
    }
    else
    {
        // ʃ[h͕ύXȂB
        NNshGlobal->prevHRWidth = hrWidth;
    }
    return;
}
#endif

#ifdef USE_CLIE
/*-------------------------------------------------------------------------*/
/*   Function :   resetCLIESupport_NNsh                                    */
/*                                                  CLIET|[g */
/*-------------------------------------------------------------------------*/
static void resetCLIESupport_NNsh(void)
{
    Boolean                isColor;
    UInt32                 width, height, depth;

    // JOGAVXg@\ɖ߂
    if (NNshGlobal->jogAssistSetBack != NULL)
    {
        *(NNshGlobal->jogAssistSetBack) = NNshGlobal->jogInfoBack;
    }

    if (NNshGlobal->silkRef == 0)
    {
        // SONYpVN̋@\gpȂꍇɂHRLIB̉
        goto SONY_HRLIB_UNLOAD;
    }

    // sysNotifyDisplayChangeEventunsubscribe
    (void) SysNotifyUnregister(0, SOFT_CREATOR_ID, sysNotifyDisplayChangeEvent,
                               sysNotifyNormalPriority);

    // SILK}l[W̉
    if (NNshGlobal->silkVer == 1)
    {
        // SILK}l[W(NRp)
        SilkLibDisableResize(NNshGlobal->silkRef);
        SilkLibClose(NNshGlobal->silkRef);
    }
    else
    {
        // VSILK}l[W(NXȍ~)
        VskSetState(NNshGlobal->silkRef, vskStateEnable, 0);
        VskClose(NNshGlobal->silkRef);
    }

SONY_HRLIB_UNLOAD:
    if (NNshGlobal->hrRef != 0)
    {
        // AvNɁAʃ[h猳ɖ߂
        if (NNshGlobal->prevHRWidth != hrWidth)
        {
            HRWinScreenMode(NNshGlobal->hrRef, winScreenModeGet,
                            &width, &height, &depth, &isColor);
            width      = stdWidth;
            height     = stdHeight;
            (void) HRWinScreenMode(NNshGlobal->hrRef, winScreenModeSet,
                                   &width, &height, &depth, &isColor);
        }
        // Sony HRLIB̎gpI
        HRClose(NNshGlobal->hrRef);
    }
    return;
}
#endif

#ifdef USE_HANDERA
/*-------------------------------------------------------------------------*/
/*   Function :   setHandEraSupport_NNsh                                   */
/*                                               HandErafoCX̃`FbN */
/*-------------------------------------------------------------------------*/
static void setHandEraSupport_NNsh(void)
{
    UInt32              handEraOsVersion;
    VgaScreenModeType   handEraScreenMode;     // XN[[h
    VgaRotateModeType   handEraRotateMode;     // ][h

    // HandEra QVGA T|[gLmFB
    handEraOsVersion = 0;
    if (_TRGVGAFeaturePresent(&handEraOsVersion))          
    {
        NNshGlobal->device = NNSH_DEVICE_HANDERA;
    }

    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        VgaGetScreenMode(&handEraScreenMode, &handEraRotateMode);
        VgaSetScreenMode(screenMode1To1, handEraRotateMode);
    }
}
#endif // #ifdef USE_HANDERA

/*-------------------------------------------------------------------------*/
/*   Function :   HandEraMoveObject                                        */
/*                                                     IuWFNg̈ړ  */
/*-------------------------------------------------------------------------*/
static void HandEraMoveObject(FormPtr frmP, UInt16 objIndex,
                              Coord x_diff, Coord y_diff)
{
    Coord   old_x, old_y;

    FrmHideObject(frmP, objIndex);
    FrmGetObjectPosition(frmP, objIndex, &old_x, &old_y);
    if (old_y < 110)
    {
        // ̕ɂIuWFNg͈ړȂ
        // ([x^...ƃJbR...)
        // x_diff = 0;
        y_diff = 0;
    }
    FrmSetObjectPosition(frmP, objIndex, old_x + x_diff, old_y + y_diff);

    // ꂾƁAinvisiblê...v
    FrmShowObject(frmP, objIndex);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   HandEraResizeObject                                      */
/*                                                 IuWFNg̃TCY  */
/*-------------------------------------------------------------------------*/
static void HandEraResizeObject(FormPtr frmP, UInt16 objIndex,
                                Coord x_diff, Coord y_diff)
{
    RectangleType r;
    Coord   old_x, old_y;

    FrmHideObject(frmP, objIndex);

    // IuWFNg̃TCY
    FrmGetObjectPosition(frmP, objIndex, &old_x, &old_y);
    if (old_y < 11)
    {
        // ̕ɂIuWFNg͑ɂȂ
        // (Ƃ肠...l...)
        return;
    }

    FrmGetObjectBounds(frmP, objIndex, &r);
    r.extent.x += x_diff;
    r.extent.y += y_diff;
    FrmSetObjectBounds(frmP, objIndex, &r);

    FrmShowObject(frmP, objIndex);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   HandEraResizeForm                                        */
/*                                                     tH[̃TCY  */
/*-------------------------------------------------------------------------*/
void HandEraResizeForm(FormPtr frmP)
{
    Coord           x, y, xDiff, yDiff;
    RectangleType   r;
    UInt16          objectIndex, numObjects, rowNum, nofRow, height;
    Int16           fldIndex, sclIndex;
    TableType      *tableP;
    ControlType    *ctlPtr;
    FormObjectKind  objType;

    fldIndex = -1;
    sclIndex = -1;

    /* VTCY */
    WinGetDisplayExtent(&x, &y);
    
    /* TCY */
    FrmGetFormBounds(frmP, &r);

    /* Ȃȉ̔Kvisj */
    r.topLeft.x++;
    r.topLeft.y++;
    r.extent.x -= 2;
    r.extent.y -= 2;

    xDiff = x - (r.topLeft.x + r.extent.x);
    yDiff = y - (r.topLeft.y + r.extent.y);

    if ((xDiff == 0)&&(yDiff == 0))
    {
        return;
    }

    /* TCY */
    r.extent.x += xDiff;
    r.extent.y += yDiff;
    WinSetWindowBounds(FrmGetWindowHandle(frmP), &r);
        
    /* IuWFNg̈ړATCY */
    numObjects = FrmGetNumberOfObjects(frmP);
    for (objectIndex = 0; objectIndex < numObjects; objectIndex++)
    {
        objType = FrmGetObjectType(frmP, objectIndex);
        switch (objType)
        {
          case frmFieldObj:
            // tB[ḧړiXԓFieldjATCYiX\Fieldj
            if (FldGetVisibleLines((FieldType *) 
                                     FrmGetObjectPtr(frmP, objectIndex)) == 1)
            {
                // tB[ḧړ
                HandEraMoveObject(frmP, objectIndex, 0, yDiff);
            }
            else
            {
                // tB[h̃TCY
                HandEraResizeObject(frmP, objectIndex, xDiff, yDiff);
                fldIndex = objectIndex;
            }
            break;
          case frmControlObj:
            // {^֘Äړ
            ctlPtr = (ControlType *)FrmGetObjectPtr(frmP, objectIndex);
#if 0
            if ((CtlGlueGetControlStyle(ctlPtr) == buttonCtl)||
                (CtlGlueGetControlStyle(ctlPtr) == checkboxCtl)||
                (CtlGlueGetControlStyle(ctlPtr) == repeatingButtonCtl))
#endif
            {
                HandEraMoveObject(frmP, objectIndex, 0, yDiff);
            }
            break;
          case frmTableObj:
            HandEraResizeObject(frmP, objectIndex, xDiff, yDiff);
            tableP = FrmGetObjectPtr(frmP, objectIndex);
            nofRow = TblGetNumberOfRows(tableP);
            TblGetBounds(tableP, &r);
            height = (r.extent.y - r.topLeft.y) / nofRow + 1;
            for (rowNum = 0; rowNum < nofRow; rowNum++)
            {
                TblSetRowHeight(tableP, rowNum, height);
            }
            break;
          case frmGadgetObj:
            // KWFbg̃TCY
            HandEraResizeObject(frmP, objectIndex, xDiff, yDiff);
            break;

          case frmLabelObj:
          case frmGraffitiStateObj:
            // GSÏړ
            HandEraMoveObject(frmP, objectIndex, 0, yDiff);
            break;

          case frmScrollBarObj:
            // XN[o[̃TCYAړ
            HandEraResizeObject(frmP, objectIndex, 0, yDiff);
            HandEraMoveObject(frmP, objectIndex, xDiff, 0);
            sclIndex = objectIndex;
            break;

          case frmListObj:
            // XgIuWFNg͉ȂB
          default:
            // ???(Ȃ)
            break;
        }
    }
    if ((fldIndex >= 0) && (sclIndex >= 0))
    {
        // XN[o[̃Abvf[g
        NNshWinViewUpdateScrollBar(
              FrmGetObjectId(frmP, fldIndex), FrmGetObjectId(frmP, sclIndex)); 
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   HandEraMoveDialog                                        */
/*                                                   _CÖړ      */
/*-------------------------------------------------------------------------*/
void HandEraMoveDialog(FormPtr frmP)
{
    Coord         x, y;
    RectangleType r;

#ifdef USE_HANDERA
    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        /* Ŝ̃TCY */
        WinGetDisplayExtent(&x, &y);
    
        /* dialog̃TCY */
        FrmGetFormBounds(frmP, &r);

        /* Ȃȉ̔Kvisj */
        r.topLeft.x += 2; 
        r.topLeft.y += 2; 
        r.extent.x -= 4;
        r.extent.y -= 4;
        goto MOVE_OBJECT;
    }
#endif
#ifdef USE_CLIE
    // SILK}l[WnodmĂ邩H
    if (NNshGlobal->silkRef != 0)
    {
        /* Ŝ̃TCY */
        WinGetDisplayExtent(&x, &y);
    
        /* dialog̃TCY */
        FrmGetFormBounds(frmP, &r);

        /* Ȃȉ̔Kvisj */
        // r.topLeft.x -=2;
        // r.topLeft.y -=2;
        r.extent.x  -= 4;
        r.extent.y  -= 4;
        goto MOVE_OBJECT;
    }
#endif
    return;

MOVE_OBJECT:
    /* dialog̈ړ */
    if (y - (r.topLeft.y + r.extent.y) < 0)
    {
        r.topLeft.y = y - r.extent.y;
    }
    WinSetWindowBounds(FrmGetWindowHandle(frmP), &r);

    NNsi_FrmDrawForm(frmP, true);

    return;
}

/*=========================================================================*/
/*   Function :   NNshRestoreNNsiSetting                                   */
/*                                                     NNsiݒ̓ǂݍ  */
/*=========================================================================*/
void NNshRestoreNNsiSetting(Int16 version, UInt16 size, NNshSavedPref *prm)
{
    Err           ret;
    UInt32        offset;
    UInt16        cnt, nofRec;
    DmOpenRef     dbRef;
    Char         *ptr;
    RGBColorType  color;

    // NNsiݒ̗̈
    nofRec = 0;

    if ((version == SOFT_PREFVERSION)&&(size == sizeof(NNshSavedPref)))
    {
        //  ݒ肳ꂽo[WƍNꂽo[Wэ\̃TCY
        // ꍇ̂݁ANNsiݒ𕜋B

        // ϐ 
        offset = 0;
        ptr    = (Char *) prm;

        // caANNsiݒǂݏo(R[h̓o^̌ˍŁAAA)
        OpenDatabase_NNsh(DBNAME_SETTING, DBVERSION_SETTING, &dbRef);
        GetDBCount_NNsh(dbRef, &nofRec);
        cnt = nofRec;
        while ((cnt != 0)&&(offset < sizeof(NNshSavedPref)))
        {
            ret = GetRecord_NNsh(dbRef,(cnt - 1),DBSIZE_SETTING, &ptr[offset]);
            if (ret != errNone)
            {
                // f[^ǂݏoɎs(̏ꍇANNsiݒ͏)
                NNsh_InformMessage(ALTID_WARN, MSG_NNSISET_READFAIL, "", ret);
                nofRec = 0;
                break;
            }
            cnt--;
            offset = offset + DBSIZE_SETTING;
        }
        CloseDatabase_NNsh(dbRef);
    }
    if (nofRec == 0)
    {
        // NNsiݒ
        prm->lastFrmID        = NNSH_FRMID_THREAD;
        prm->bufferSize       = NNSH_WORKBUF_DEFAULT;
        prm->partGetSize      = NNSH_WORKBUF_DEFAULT;
        prm->netTimeout       = NNSH_NET_TIMEOUT;
        prm->currentFont      = NNSH_DEFAULT_FONT;
        prm->sonyHRFont       = NNSH_DEFAULT_FONT;
        prm->useCookieWrite   = NNSH_ENABLE;
        prm->disableUnderline = NNSH_ENABLE;
        prm->writeBufferSize  = NNSH_WRITEBUF_DEFAULT;
        prm->writeAlwaysSage  = NNSH_ENABLE;
        prm->printNofMessage  = NNSH_ENABLE;
        prm->notListReadOnly  = NNSH_ENABLE;
        prm->autoOpenNotRead  = NNSH_ENABLE;
        prm->jogBackBtnAsGo   = NNSH_ENABLE;
        prm->addMenuBackRtnMsg= NNSH_ENABLE;
        prm->newArrivalNotRead= NNSH_SELBBS_NOTREAD;
        prm->displayFavorLevel= NNSH_MSGATTR_FAVOR_L1;
#ifdef USE_COLOR
        // gp"F"̏l

        // ԐF(G[)
        MemSet(&color, sizeof(color), 0x00);
        color.r = 255;
        prm->colorError       = WinRGBToIndex(&color);

        // (Sēǂ񂾁A1000)
        MemSet(&color, sizeof(color), 0x00);
        prm->colorAlready     = WinRGBToIndex(&color);
        prm->colorOver        = prm->colorAlready;

        // (ǂ)
        // MemSet(&color, sizeof(color), 0x00);
        color.b = 100;
        prm->colorRemain      = WinRGBToIndex(&color);

        // (VK擾A擾)
        MemSet(&color, sizeof(color), 0x00);
        color.b = 255;
        prm->colorNew         = WinRGBToIndex(&color);
        prm->colorUpdate      = prm->colorNew;

        // DF(擾Ȃ)
        MemSet(&color, sizeof(color), 0x00);
        color.r = 128;
        color.g = 128;
        color.b = 128;
        prm->colorNotYet      = WinRGBToIndex(&color);
        prm->colorUnknown     = prm->colorNotYet;
        prm->colorOver        = prm->colorNotYet;
#endif
        // ړIXCb`P(ꗗ) : X擾[h
        prm->usageOfTitleMultiSwitch1 = NNSH_SWITCHUSAGE_GETPART;

        // ړIXCb`Q(ꗗ) : ProxyoRŃANZX
        prm->usageOfTitleMultiSwitch2 = NNSH_SWITCHUSAGE_USEPROXY;

        // WBBSꗗ擾(URL)𔽉f
        StrCopy(prm->bbs_URL, URL_BBSTABLE);
        NNsh_InformMessage(ALTID_INFO, MSG_NNSISET_REFRESH, "", 0);
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   NNshSaveNNsiSetting                                      */
/*                                                         NNsiݒ̋L  */
/*-------------------------------------------------------------------------*/
static void NNshSaveNNsiSetting(Int16 version, UInt16 size,
                                NNshSavedPref *param)
{
    Err       ret;
    UInt32    offset;
    UInt16    nofRec;
    DmOpenRef dbRef;
    Char      *ptr;

    OpenDatabase_NNsh(DBNAME_SETTING, DBVERSION_SETTING, &dbRef);
    GetDBCount_NNsh(dbRef, &nofRec);
    while (nofRec != 0)
    {
        //  łNNsiݒ肪L^ĂꍇASR[h폜
        (void) DeleteRecordIDX_NNsh(dbRef, (nofRec - 1));
        nofRec--;
    }

    // NNsiݒDBɓo^(R[ho^̌ˍɒӁI)
    offset = 0;
    ptr    = (Char *) param;
    while (offset < sizeof(NNshSavedPref))
    {
        ret = EntryRecord_NNsh(dbRef, DBSIZE_SETTING, &ptr[offset]);
        if (ret != errNone)
        {
            NNsh_DebugMessage(ALTID_WARN, "EntryRecord_NNsh()", "", ret);
            NNsh_DebugMessage(ALTID_WARN, "    ", "offset:", offset);
            NNsh_DebugMessage(ALTID_WARN, "    ", "size:", DBSIZE_SETTING);
            break;
        }
        offset = offset + DBSIZE_SETTING;
    }
    CloseDatabase_NNsh(dbRef);

    return;
}

/*=========================================================================*/
/*   Function :   NNshSilkMinimize                                         */
/*                                          OtBeBGAŏ */
/*=========================================================================*/
Err NNshSilkMinimize(FormType *frm)
{
#ifdef USE_HANDERA
    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        SilkMinimizeWindow();
        HandEraResizeForm(frm);
        return (errNone);
    }
#endif
#ifdef USE_CLIE
    // SILK}l[WnodmĂ邩H
    if (NNshGlobal->silkRef != 0)
    {
        // SILK̍ŏs
        if (NNshGlobal->silkVer == 1)
        {
            // Version1(NRp)
            SilkLibResizeDispWin(NNshGlobal->silkRef, silkResizeToStatus);
        }
        else
        {
            // Version2(NXȍ~)
            VskSetState(NNshGlobal->silkRef, vskStateResize, vskResizeMin);
        }
        HandEraResizeForm(frm);
        return (errNone);
    }
#endif
    return (~errNone);
}

/*=========================================================================*/
/*   Function :   NNshSilkMaximize                                         */
/*                                          OtBeBGAő剻 */
/*=========================================================================*/
Err NNshSilkMaximize(FormType *frm)
{
#ifdef USE_HANDERA
    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        SilkMaximizeWindow();
        HandEraResizeForm(frm);
        return (errNone);
    }
#endif
#ifdef USE_CLIE
    // SILK}l[WnodmĂ邩H
    if (NNshGlobal->silkRef != 0)
    {
        // SILK̍ő剻s
        if (NNshGlobal->silkVer == 1)
        {
            // Version1(NRp)
            SilkLibResizeDispWin(NNshGlobal->silkRef, silkResizeNormal);
        }
        else
        {
            // Version2(NXȍ~)
            VskSetState(NNshGlobal->silkRef, vskStateResize, vskResizeMax);
        }
        HandEraResizeForm(frm);
        return (errNone);
    }
#endif
    return (~errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   NNshClearGlobal                                          */
/*                                          NNsĩO[öJ */
/*-------------------------------------------------------------------------*/
static void NNshClearGlobal(NNshWorkingInfo *workBuf)
{
    NNshMessageIndex *idxP;

    MEMFREE_HANDLE(workBuf->searchTitleH);
    MEMFREE_HANDLE(workBuf->boardIdxH);
    MEMFREE_HANDLE(workBuf->logPrefixH);
    MEMFREE_HANDLE(workBuf->bbsTitleH);
    MEMFREE_PTR(workBuf->bbsTitles);

    if (workBuf->msgIndex != NULL)
    {
        idxP = workBuf->msgIndex;
        CloseFile_NNsh(&(idxP->fileRef));
        MEMFREE_PTR(workBuf->msgIndex);
    }

    MEMFREE_PTR(workBuf->tempInfo);

    return;
}

/*=========================================================================*/
/*   Function :   BackupDatabaseToVFS                                      */
/*                                         NNsiDBVFSɃobNAbv */
/*=========================================================================*/
void BackupDBtoVFS(UInt16 backupAllDB)
{
    Err   ret;
    Char *buf, flag;

    flag = 0;

    // BUSYEBhE̕\̈m
    buf = MemPtrNew(BUFSIZE);
    if (buf == NULL)
    {

        // G[\
        NNsh_DebugMessage(ALTID_ERROR,"Cannot Alloc BUFFER"," size:",BUFSIZE);
        return;
    }
    MemSet(buf, BUFSIZE, 0x00);

    // (BBS-NNsĩobNAbv)
    StrCopy(buf, MSG_NNSI_DBBACKUP_BUSY);
    StrCat (buf, DBNAME_BBSLIST);
    Show_BusyForm(buf);
    if (backupAllDB != 0)
    {
        ret = BackupDatabaseToVFS_NNsh(DBNAME_BBSLIST);
        if (ret != errNone)
        {
            // G[łȂ
            flag = flag + 1;
        }
    }

    // (Subject-NNsĩobNAbv)
    StrCopy(buf, MSG_NNSI_DBBACKUP_BUSY);
    StrCat (buf, DBNAME_SUBJECT);
    SetMsg_BusyForm(buf);

    if ((backupAllDB != 0)||
        (((NNshGlobal->updateDatabaseInfo) & (NNSH_DB_UPDATE_SUBJECT)) != 0))
    {
        ret = BackupDatabaseToVFS_NNsh(DBNAME_SUBJECT);
        if (ret != errNone)
        {
            // G[łȂ
            flag = flag + 2;
        }
    }

    // (Settings-NNsĩobNAbv)
    StrCopy(buf, MSG_NNSI_DBBACKUP_BUSY);
    StrCat (buf, DBNAME_SETTING);
    SetMsg_BusyForm(buf);

    if ((backupAllDB != 0)||
        (((NNshGlobal->updateDatabaseInfo) & (NNSH_DB_UPDATE_SETTING)) != 0))
    {
        ret = BackupDatabaseToVFS_NNsh(DBNAME_SETTING);
        if (ret != errNone)
        {
            // G[łȂ
            flag = flag + 4;
        }
    }

    // BUSY\
    Hide_BusyForm(false);

    MemPtrFree(buf);
    if (flag != 0)
    {
        // obNAbvG[Ƃʒm
        NNsh_InformMessage(ALTID_ERROR, MSG_NNSI_DBBACKUP_FAIL, "", flag);
    }
    NNshGlobal->updateDatabaseInfo = 0;

    return;
}

/*=========================================================================*/
/*   Function :   RestoreDBtoVFS                                           */
/*                                           NNsiDBVFS烊XgA */
/*=========================================================================*/
Err RestoreDBtoVFS(void)
{
    Err      ret, ret1;
    FileRef  fileRef;
    Char     fileName[MAXLENGTH_FILENAME];
    UInt32   dummy;
    UInt16   butId;

    // VFS̃T|[gLmFB
    dummy = 0;
    ret = FtrGet(sysFileCVFSMgr, vfsFtrIDVersion, &dummy);
    if (ret != errNone)
    {
        // VFST|[g̏ꍇɂ́AIB
        NNsh_DebugMessage(ALTID_INFO, "Not Support VFS :", "", ret);
        return (~errNone);
    }

    // VFSgpłƂABackupꂽDB邩(FILEOPEN)mF
    MemSet (fileName, MAXLENGTH_FILENAME, 0x00);
    StrCopy(fileName, DATAFILE_PREFIX);
    StrCat (fileName, DBNAME_SUBJECT);
    StrCat (fileName, ".pdb");
    if (VFSFileOpen(NNshGlobal->vfsVol, fileName, vfsModeRead, &fileRef) !=
        errNone)
    {
        // BACKUPꂽt@CȂ̂ŏI
        NNsh_DebugMessage(ALTID_INFO, "Backup DB files do not exist", "", 0);
        return (~errNone);
    }
    // File Open(== DB)AXgA邩mF
    VFSFileClose(fileRef);
    butId = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_CONFIRM_RESTORE, "", 0);
    if (butId != 0)
    {
        // CancelIꂽ߁AXgAȂB
        NNsh_DebugMessage(ALTID_INFO, "DB-Restore is canceled.", "", 0);
        return (~errNone);
    }

    // "XgA"\
    Show_BusyForm(MSG_DBRESTORE_BUSY);

    // DBXgAC
    (void) RestoreDatabaseFromVFS_NNsh(DBNAME_SETTING);
    (void) RestoreDatabaseFromVFS_NNsh(DBNAME_DIRINDEX);
    ret   = RestoreDatabaseFromVFS_NNsh(DBNAME_BBSLIST);
    ret1  = (ret)|(RestoreDatabaseFromVFS_NNsh(DBNAME_SUBJECT));

    // "XgA"\̍폜
    Hide_BusyForm(true);

    if (ret1 != errNone)
    {
        // XgAs(Xꗗ)
        NNsh_InformMessage(ALTID_INFO, MSG_DBRESTORE_NG, DBNAME_SUBJECT, 0);
        return (errNone);
    }

    if (ret != errNone)
    {
        // XgAs(BBSꗗ)
        NNsh_InformMessage(ALTID_INFO, MSG_DBRESTORE_NG, DBNAME_BBSLIST, 0);
        return (errNone);
    }

    // XgA
    NNsh_InformMessage(ALTID_INFO, MSG_DBRESTORE_OK, "", 0);
    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   checkInstalledWebBrowser                                 */
/*                                        WebBrowser̃CXg[`FbN */
/*-------------------------------------------------------------------------*/
static void checkInstalledWebBrowser(void)
{
    UInt16            cardNo;
    LocalID           dbID;
    DmSearchStateType searchState;
    Err               ret;

    // NetFrontCXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'NF3T', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // NetFrontCXg[Ă
        NNshGlobal->browserCreator    = 'NF3T';
        NNshGlobal->browserLaunchCode = sysAppLaunchCmdGoToURL;
        return;
    }

    // WebBrowser 2.0CXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'NF3P', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // WebBrowser 2.0CXg[Ă
        NNshGlobal->browserCreator    = 'NF3P';
        NNshGlobal->browserLaunchCode = sysAppLaunchCmdGoToURL;
        return;
    }

    // Xiino(PalmScape)CXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'PScp', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // XiinoCXg[Ă
        NNshGlobal->browserCreator    = 'PScp';
        NNshGlobal->browserLaunchCode = 0xfa21;
        return;
    }

    // Xiino(LEM)CXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'dXin', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // Xiino(LEM)CXg[Ă
        NNshGlobal->browserCreator    = 'dXin';
        NNshGlobal->browserLaunchCode = 0xfa21;
        return;
    }


    // BlazerCXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'BLZ1', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // BlazerCXg[Ă
        NNshGlobal->browserCreator    = 'BLZ1';
        NNshGlobal->browserLaunchCode = sysAppLaunchCmdGoToURL;
        return;
    }

    // Eudora WebCXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'QCwb', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // Eudora WebCXg[Ă
        NNshGlobal->browserCreator    = 'QCwb';
        NNshGlobal->browserLaunchCode = 0xfa0;
        // NNshGlobal->browserLaunchCode = sysAppLaunchCmdGoToURL;
        return;
    }

#if 0
    // PocketLinkCXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'PLNK', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // PocketLinkCXg[Ă(but does not work...)
        NNshGlobal->browserCreator    = 'PLNK';
        // NNshGlobal->browserLaunchCode = sysAppLaunchCmdGoToURL;
        NNshGlobal->browserLaunchCode = sysAppLaunchCmdOpenDB;
        return;
    }
#endif

    NNsh_DebugMessage(ALTID_INFO, MSG_CANNOTFIND_BROWSER, "", ret);
    return;
}

/*=========================================================================*/
/*   Function : KeyConvertFiveWayToJogChara                                */
/*                                  5Way̓̓R[hWÕR[hɕϊ */
/*=========================================================================*/
UInt16 KeyConvertFiveWayToJogChara(EventType *event)
{
    if (((event->data.keyDown.keyCode) & (navBitSelect | navChangeSelect))
         == navChangeSelect)
    {
        // WOƓɂ
        return (vchrJogRelease);
    }
    if ((event->data.keyDown.keyCode) & navBitLeft)
    {
        // WO񂵂Ɠɂ
        return (vchrJogPushedUp);
    }
    if ((event->data.keyDown.keyCode) & navBitRight)
    {
        // WO񂵂Ɠɂ
        return (vchrJogPushedDown);
    }

    // LȊO͂̂܂܉
    return (event->data.keyDown.chr);
}

#ifdef USE_HIGHDENSITY
/*-------------------------------------------------------------------------*/
/*   Function :   setDoubleDensitySupport_NNsh                             */
/*                                              𑜓xT|[g̃`FbN */
/*-------------------------------------------------------------------------*/
static void setDoubleDensitySupport_NNsh(void)
{
    UInt32  version;

    // 𑜓xT|[gݒ
    NNshGlobal->os5HighDensity = (UInt32) kDensityLow;

    // OSo[W̊mF
    if (FtrGet(sysFtrCreator, sysFtrNumROMVersion, &version) == errNone)
    {
        NNshGlobal->palmOSVersion = version;

        // OS 3.5̏ꍇ
        if (NNshGlobal->palmOSVersion < 0x03503000)
        {
            // J[T|[g̒[(J[T|[g̐ݒsɂ
            NNshParam->useColor = 0;
        }
    }
#ifdef USE_CLIE
    if (NNshGlobal->hrRef != 0)
    {
        // CLIEA𑜓x̃`FbNȂ(CLIEnC]g)
        return;
    }
#endif

    // 𑜓xtB[`[̎擾
    if (FtrGet(sysFtrCreator, sysFtrNumWinVersion, &version) != 0)
    {
        // 𑜓xtB[`[̃T|[gȂ
        return;
    }
    NNsh_DebugMessage(ALTID_INFO, "Window Version", ": ", version);
    if (version < 4)
    {
        //@𑜓x̃T|[gȂAI
        //  (Ő񂾂낤...}jAɂ͂Ă...)
        return;
    }

    // Window̉𑜓x擾
    WinScreenGetAttribute(winScreenDensity, &(NNshGlobal->os5HighDensity));

    // Ƃ肠AW𑜓xɂ
    WinSetCoordinateSystem(kCoordinatesStandard);

    return;
}
#endif   // #ifdef USE_HIGHDENSITY

/*-------------------------------------------------------------------------*/
/*   Function : convertFormID                                              */
/*                                                tH[hc̃Ro[g */
/*-------------------------------------------------------------------------*/
static UInt16 convertFormID(UInt16 lastFrmID)
{
    UInt16 frmId;

    // lastFrmID ۂ̃tH[IDփRo[g
    switch (lastFrmID)
    {
      case NNSH_FRMID_MESSAGE:
        // XQƉ
        frmId = FRMID_MESSAGE;
        break;
#if 0
      case NNSH_FRMID_BOARDINPUT:
      case NNSH_FRMID_MESSAGEINFO:
      case NNSH_FRMID_MANAGEBBS:
      case NNSH_FRMID_INPUTDIALOG:
      case NNSH_FRMID_BUSY:
      case NNSH_FRMID_WRITE_MESSAGE:
      case NNSH_FRMID_NNSI_SETTING7:
      case NNSH_FRMID_NNSI_SETTING6:
      case NNSH_FRMID_NNSI_SETTING5:
      case NNSH_FRMID_NNSI_SETTING4:
      case NNSH_FRMID_NNSI_SETTING3:
      case NNSH_FRMID_NNSI_SETTING2:
      case NNSH_FRMID_CONFIG_NNSH:
#endif
      case NNSH_FRMID_THREAD:
      default:
        // Xꗗ
        frmId = FRMID_THREAD;
        break;
    }
    return (frmId);
}
