/*============================================================================*
 *  FILE:  
 *     main.c
 *
 *  Description: 
 *     main source code for Palm application.
 *     (This file includes in "skeleton.c".)
 *
 *===========================================================================*/
#define MAIN_C

#include "machine.c"

// external functions
extern Err     OpenForm_NNshMessage (FormType  *frm);
extern void    OpenForm_ThreadMain  (FormType  *frm);
extern void    OpenForm_WriteMessage(FormType  *frm);
extern void    OpenForm_SelectBBS   (FormType  *frm);
extern Err     OpenForm_NNshSetting (FormType  *frm);
extern Err     OpenForm_NNsiSetting2(FormType  *frm);
extern Err     OpenForm_NNsiSetting3(FormType  *frm);
extern Err     OpenForm_NNsiSetting4(FormType  *frm);
extern Err     OpenForm_NNsiSetting5(FormType  *frm);
extern Err     OpenForm_NNsiSetting6(FormType  *frm);
extern Err     OpenForm_NNsiSetting7(FormType  *frm);

extern Boolean Handler_ThreadMain   (EventType *event);
extern Boolean Handler_NNshMessage  (EventType *event);
extern Boolean Handler_WriteMessage (EventType *event);
extern Boolean Handler_SelectBBS    (EventType *event);
extern Boolean Handler_NNshSetting  (EventType *event);

/*=========================================================================*/
/*   Function :   MyApplicationHandleEvent                                 */
/*                                                                         */
/*=========================================================================*/
static Boolean MyApplicationHandleEvent(EventType *event)
{
    FormType  *frm;
    TableType *tableP;
    UInt16     rowNum, fieldFont, objFont;

    // SONYVNsꍇ̉ʍXV
#ifdef USE_CLIE
    if ((NNshGlobal->silkRef != 0)&&
        (NNshGlobal->updateHR == NNSH_UPDATE_DISPLAY))
    {
         // SILK}l[W̕\ɂ킹ʂ̍XVs
        frm = FrmGetActiveForm();
        FrmEraseForm(frm);
        NNsi_FrmDrawForm(frm, true);
        NNshGlobal->updateHR = NNSH_NOT_EFFECTIVE;
    }
#endif

    // ŁA(tH[[h)CxgM̏LqB
    switch (event->eType)
    {
      // tH[Jevent
      case frmLoadEvent:
        // gptHgݒ肷
        fieldFont = NNshParam->currentFont;
        FntSetFont(fieldFont);
        objFont   = NNshParam->currentFont;

        // tH[ 
        frm = FrmInitForm(event->data.frmLoad.formID);
#ifdef USE_HANDERA
        if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
        {
            VgaFormModify(frm, vgaFormModify160To240);
        }
#endif
#ifdef USE_CLIE
        NNshGlobal->tempStatus = 0;
#endif
        // tH[JăCxgnhݒ肷
        FrmSetActiveForm(frm);
        switch (event->data.frmLoad.formID)
        {
          // Xꗗ
          case FRMID_THREAD:
            // OtBeBGAŏĉʂTCYAtHgύX
            (void) NNshSilkMinimize(frm);

            // tH[JāACxgnhݒ肷
            OpenForm_ThreadMain(frm);
            FrmSetEventHandler(frm, Handler_ThreadMain);

            // OpenForm_ThreadMain()ŉʂ`悷邽߁Aɔ
            return (true);
            break;

          // XQƉ
          case FRMID_MESSAGE:
            // OtBeBGAŏĉʂTCYAtHgύX
            (void) NNshSilkMinimize(frm);
            FldSetFont(FrmGetObjectPtr(frm, 
                            FrmGetObjectIndex(frm, FLDID_MESSAGE)), fieldFont);
#ifdef USE_GLUE
            CtlGlueSetFont(FrmGetObjectPtr(frm,
                       FrmGetObjectIndex(frm, SELTRID_THREAD_TITLE)), objFont);
#endif
            // tH[JāACxgnhݒ肷
            OpenForm_NNshMessage(frm);
            FrmSetEventHandler(frm, Handler_NNshMessage);

            // OpenForm_NNshMessage()ŉʂ`悷邽߁Aɔ
            return (true);
            break;
 
          // X݉
          case FRMID_WRITE_MESSAGE:
            // OtBeBGAő剻ĉʂTCYAtHgύX
            FldSetFont(FrmGetObjectPtr(frm,
                         FrmGetObjectIndex(frm, FLDID_WRITE_NAME)), fieldFont);
            FldSetFont(FrmGetObjectPtr(frm, 
                        FrmGetObjectIndex(frm, FLDID_WRITE_EMAIL)), fieldFont);
            FldSetFont(FrmGetObjectPtr(frm, 
                      FrmGetObjectIndex(frm, FLDID_WRITE_MESSAGE)), fieldFont);
            (void) NNshSilkMaximize(frm);

            // tH[JāACxgnhݒ肷
            OpenForm_WriteMessage(frm);
            FrmSetEventHandler(frm, Handler_WriteMessage);
            break;

          // BBSǗ
          case FRMID_MANAGEBBS:
            // OtBeBGAŏĉʂTCY
            if (NNshSilkMinimize(frm) == errNone)
            {
                // ̈TCY߂
                tableP = FrmGetObjectPtr(frm, 
                                 FrmGetObjectIndex(frm, TBLID_BBS_SELECTION));
                for (rowNum = 0; rowNum < TblGetNumberOfRows(tableP); rowNum++)
                {
                    TblSetRowHeight(tableP, rowNum, 15);
                }
            }
            // tH[JāACxgnhݒ肷
            OpenForm_SelectBBS(frm);
            FrmSetEventHandler(frm, Handler_SelectBBS);
            break;

          // NNsiݒ
          case FRMID_CONFIG_NNSH:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNshSetting(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;

          // NNsiݒ-2
          case FRMID_NNSI_SETTING2:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNsiSetting2(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;

          // NNsiݒ-3
          case FRMID_NNSI_SETTING3:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNsiSetting3(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;

          // NNsiݒ-4
          case FRMID_NNSI_SETTING4:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNsiSetting4(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;

          // NNsiݒ-5
          case FRMID_NNSI_SETTING5:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNsiSetting5(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;

          // NNsiݒ-6
          case FRMID_NNSI_SETTING6:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNsiSetting6(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;

          // NNsiݒ-7
          case FRMID_NNSI_SETTING7:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNsiSetting7(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;

          default:
            // "tH[JCxg"\Ă݂B(fobO)
            NNsh_DebugMessage(ALTID_INFO, "frmLoadEvent()", " formID:",
                              event->data.frmLoad.formID);
            break;
        }
        // ʂ`悷
        NNsi_FrmDrawForm(frm, true);
        break;
#if 0
      // tH[Jevent
      case frmOpenEvent:
        break;

      // tH[event
      case frmCloseEvent:
        break;
#endif
      default:
        // T|[gĂȂCxgMB
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   myStartApplication                                       */
/*                                 X^[g(vO)  */
/*=========================================================================*/
static UInt16 MyStartApplication(void)
{
    Int16                   ret;
    UInt16                  size;
    NNshSoftwareVersionInfo verInfo;
#ifdef USE_ARMLET
    UInt32                  processorType;
#endif

    // NNsiݒo[W̊mF
    //   (VersionmFpPreferencemFAύXȂΕ)
    size = sizeof(NNshSoftwareVersionInfo);
    MemSet(&verInfo, sizeof(NNshSoftwareVersionInfo), 0x00);
    ret  = PrefGetAppPreferences(SOFT_CREATOR_ID, SOFT_PREFID, 
                                 &verInfo, &size, false);

    // NNsiݒpi[̈̊m
    size = sizeof(NNshSavedPref) + DBSIZE_SETTING;
    NNshParam = (NNshSavedPref *) MemPtrNew(size);
    if (NNshParam == NULL)
    {
        // ̈mۂɎsI(NNsi͋NȂ)
        NNsh_ErrorMessage(ALTID_ERROR, MSG_NNSI_CANNOT_LAUNCH,
                          "(NNsiSet)\nsize:", size);
        return (0);
    }
    MemSet(NNshParam, size, 0x00);

    // NNsiO[öpi[̈̊m
    size       = sizeof(NNshWorkingInfo) + MARGIN;
    NNshGlobal = (NNshWorkingInfo *) MemPtrNew(size);
    if (NNshGlobal == NULL)
    {
        // ̈mۂɎsI(NNsi͋NȂ)
        NNsh_ErrorMessage(ALTID_ERROR, MSG_NNSI_CANNOT_LAUNCH,
                          "(NNsiGbl)\nsize:", size);
        return (0);
    }        
    MemSet (NNshGlobal, size, 0x00);
    StrCopy(NNshGlobal->dummyBuffer, " ");

    // NNsiݒ𕜋
    (void) NNshRestoreNNsiSetting(ret, verInfo.prefSize, NNshParam);

    // fobO[h̏𕜋
    NNshParam->debugMessageON = verInfo.debugMode;

    // VFS@\Ȃݒ肾ꍇɂ́AUVFSp[^NAB
    if (NNshParam->useVFS == NNSH_NOTSUPPORT_VFS)
    {
        NNshParam->useVFS = NNSH_VFS_DISABLE;
    }
    // VFST|[g̐ݒ
    checkVFSdevice_NNsh();

#ifdef USE_CLIE
    // Silk̐ݒ𔽉f
    NNshGlobal->notUseSilk = NNshParam->notUseSilk;

    // CLIET|[g̐ݒ
    setCLIESupport_NNsh();
#endif  // #ifdef USE_CLIE

#ifdef USE_HANDERA
    // HandEraT|[g̐ݒ
    setHandEraSupport_NNsh();
#endif // #ifdef USE_HANDERA

#ifdef USE_HIGHDENSITY
    // 𑜓xT|[g/J[T|[g̃`FbN
    setDoubleDensitySupport_NNsh();
#else
    // 𑜓xT|[gݒ
    NNshGlobal->os5HighDensity = (UInt32) kDensityLow;
#endif    // #ifdef USE_HIGHDENSITY

#ifdef USE_ARMLET
    // ARMletgpۂ̃`FbN
    FtrGet(sysFileCSystem, sysFtrNumProcessorID, &processorType);
    if (sysFtrNumProcessorIsARM(processorType))
    {
        // ARMletgp\foCXB
        // NNshParam->useARMlet = NNSH_ENABLE;  // ARMlet͎gpݒɕύX
    }
    else
#endif
    {
        // ARMlet͎gpȂݒɂ
        NNshParam->useARMlet = NNSH_DISABLE;
    }

    // WebBrowser̃CXg[`FbN
    checkInstalledWebBrowser();

    // VFSOFFꍇɂ́AmFbZ[W\B
    if (NNshParam->useVFS == NNSH_VFS_DISABLE)
    {
        NNsh_InformMessage(ALTID_INFO, MSG_USE_VFS_WARNING1,
                           MSG_USE_VFS_WARNING2, 0);
    }

    // ݒ肳ĂꍇAJꏊw
    if ((NNshParam->useBookmark != 0)&&(NNshParam->lastFrmID == NNSH_FRMID_MESSAGE))
    {
        NNshParam->openMsgIndex = NNshParam->bookMsgIndex;
    }

    // ^CgR[h̎w肪ُ̏ꍇAR[hԍ
    if ((NNshParam->startTitleRec == NNshParam->endTitleRec)&&
        (NNshParam->startTitleRec == 0))
    {
        NNshParam->startTitleRec = 0xffff;
    }

    // ŏɃI[vtH[IDB
    return (convertFormID(NNshParam->lastFrmID));
}

/*=========================================================================*/
/*   Function :   myStopApplication                                        */
/*                                 Xgbv(vO)  */
/*=========================================================================*/
static void MyStopApplication(void)
{
    UInt16                  savedParam, frmId;
    NNshSoftwareVersionInfo verInfo;

    frmId = FrmGetActiveFormID();
    switch (frmId)
    {
      case FRMID_WRITE_MESSAGE:
        //  ݉ʂŃAv悤Ƃꍇ
        // (ݓeۑ邩mF)
        SaveWritingMessage();
        break;

      default:
        break;
    }

    // X^Cg\폜
    ClearMsgTitleInfo();

    // e|t@C̍폜(DEBUG[hɂ͎cĂ)
    if (NNshParam->debugMessageON == 0)
    {
        (void) DeleteFile_NNsh(FILE_SENDMSG, NNSH_VFS_DISABLE);
        (void) DeleteFile_NNsh(FILE_RECVMSG, NNSH_VFS_DISABLE);
    }

    // NNsiIɉؒf
    if (NNshParam->disconnectNNsiEnd != 0)
    {
        // vOIɂ́Auؒfv̊mFbZ[W͏oȂB
        savedParam = NNshParam->confirmationDisable;
        NNshParam->confirmationDisable = 1;
        NNshNet_LineHangup();
        NNshParam->confirmationDisable = savedParam;
    }

#ifdef USE_CLIE
    // CLIET|[gJ
    resetCLIESupport_NNsh();
#endif

    // NNsiݒVersionmFpPreference̕ۑ(Debug[h͂ŋL)
    verInfo.NNsiVersion = SOFT_PREFVERSION;
    verInfo.prefSize    = sizeof(NNshSavedPref);
    verInfo.prefType    = NNSH_PREFERTYPE;
    verInfo.debugMode   = (NNshParam != NULL) ? NNshParam->debugMessageON : 0;
    PrefSetAppPreferences(SOFT_CREATOR_ID, SOFT_PREFID, SOFT_PREFVERSION,
                          &verInfo, sizeof(NNshSoftwareVersionInfo), false);

    // NNsiݒ̕ۑ(NNsi̋Nɐ̂)
    if (NNshParam != NULL)
    {
        // Silk̐ݒ𔽉f
#ifdef USE_CLIE
        NNshParam->notUseSilk = NNshGlobal->notUseSilk;
#else
        NNshParam->notUseSilk = 0;
#endif
        NNshSaveNNsiSetting(NNSH_PREFERTYPE, sizeof(NNshSavedPref), NNshParam);

        // NNsiIɃf[^x[XVFSɃobNAbv
        if ((NNshParam->useVFS & (NNSH_VFS_DBBACKUP)) != 0)
        {
            BackupDBtoVFS(NNSH_DISABLE);
        }
    }

    // NNsĩO[öJ
    if (NNshGlobal != NULL)
    {
        NNshClearGlobal(NNshGlobal);
        MEMFREE_PTR(NNshGlobal);
        NNshGlobal = NULL;
    }

    // gp̈̊J
    MEMFREE_PTR(NNshParam);
    NNshParam = NULL;

    return;
}
