/*============================================================================*
 *  FILE: 
 *     msglist.c
 *
 *  Description: 
 *     Message(Thread) list drawings for NNsh. 
 *
 *===========================================================================*/
#define MSGLIST_C
#include "local.h"

/*-------------------------------------------------------------------------*/
/*   Function : CheckDispList                                              */
/*                                         ʂɕ\/Ȃ𔻒肷 */
/*-------------------------------------------------------------------------*/
Boolean CheckDispList(UInt16 bbsIndex, NNshSubjectDatabase *subjP,
                                                        NNshBoardDatabase *bdP)
{
    // \/Ȃ̏(ɂďꍇ)
    switch (bbsIndex)
    { 
      case NNSH_SELBBS_GETALL:
        // 擾ςݑSĂ\
        if ((subjP->state == NNSH_SUBJSTATUS_NOT_YET)||
            (((NNshGlobal->NNsiParam)->notListReadOnly != 0)&&
             ((subjP->boardNick[0]  == '!')&&(subjP->boardNick[1]  == 'G'))))
        {
            //  u擾v͎QƃOuQƃO͕\Ȃv
            // ꍇɂ͕\Ȃ
            return (false);
        }
        break;

      case NNSH_SELBBS_FAVORITE:
        // Cɓw\
        if ((subjP->msgAttribute & NNSH_MSGATTR_FAVOR) < (NNshGlobal->NNsiParam)->displayFavorLevel)
        {
            // uCɓvł͂Ȃ̂ŕ\Ȃ
            return (false);
        }
        break;

      case NNSH_SELBBS_NOTREAD:
        // ǂ\
        if ((subjP->state != NNSH_SUBJSTATUS_NEW)&&
            (subjP->state != NNSH_SUBJSTATUS_UPDATE)&&
            (subjP->state != NNSH_SUBJSTATUS_REMAIN))
        {
            // ǂXł͂Ȃ̂ŕ\Ȃ
            return (false);
        }
        break;

      case NNSH_SELBBS_CUSTOM1:
        // [UݒP̏mF
        return (CheckIfCustomTabIsValid(bdP->boardNick, subjP, &((NNshGlobal->NNsiParam)->custom1))); 
        break;

      case NNSH_SELBBS_CUSTOM2:
        // [UݒQ̏mF
        return (CheckIfCustomTabIsValid(bdP->boardNick, subjP, &((NNshGlobal->NNsiParam)->custom2))); 
        break;

      case NNSH_SELBBS_CUSTOM3:
        // [UݒȐmF
        return (CheckIfCustomTabIsValid(bdP->boardNick, subjP, &((NNshGlobal->NNsiParam)->custom3))); 
        break;

      case NNSH_SELBBS_CUSTOM4:
        // [UݒS̏mF
        return (CheckIfCustomTabIsValid(bdP->boardNick, subjP, &((NNshGlobal->NNsiParam)->custom4))); 
        break;

      case NNSH_SELBBS_CUSTOM5:
        // [UݒT̏mF
        return (CheckIfCustomTabIsValid(bdP->boardNick, subjP, &((NNshGlobal->NNsiParam)->custom5))); 
        break;

      case NNSH_SELBBS_OFFLINE:
        // QƐpO
#ifdef USE_STRSTR
        if (StrCompare(subjP->boardNick, OFFLINE_THREAD_NICK) != 0)
#else
        if ((subjP->boardNick[0]  != '!')||
            (subjP->boardNick[1]  != 'G'))
#endif
        {
            // X̏Ⴄ̂ŕ\Ȃ
            return (false);
        }
        if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_DIROFFLINE) != 0)
        {
            if (subjP->dirIndex != (NNshGlobal->NNsiParam)->readOnlySelection)
            {
                // ۊǂĂfBNĝŕ\Ȃ
                return (false);
            }
        }
        break;

      default:
        // uCɓvłu擾ςݑSāvłuǂvłȂꍇ
        if (StrCompare(subjP->boardNick, bdP->boardNick) != 0)
        {
            // X̏Ⴄ̂ŕ\Ȃ
            return (false);
        }
        break;
    }

    // \XƔ
    return (true);
}                               

/*-------------------------------------------------------------------------*/
/*   Function : copyThreadTitleString                                      */
/*                                X^CgRs[(f[^ϊt) */
/*-------------------------------------------------------------------------*/
static void copyThreadTitleString(Char  *dest, Char *src, UInt16 length,
                                  UInt16 state, UInt16 msgNumber)
{
    UInt16 msgState, size;
    Char   *dst;

    // G[ԂƂAbZ[W̐擪 '#'\
    dst = dest;
    if (((state >> 8)&(NNSH_MSGATTR_ERROR)) == NNSH_MSGATTR_ERROR)
    {
        *dst = '#';
        dst++;
    }

    // bZ[W̏ԂLŔf
    msgState = (state & 0xff);
    switch (msgState)
    {
      case NNSH_SUBJSTATUS_NEW:
        /** VK擾(Ď擾) **/
        *dst = '*';
        break;

      case NNSH_SUBJSTATUS_UPDATE:
        /** bZ[WXV **/
        *dst = '+';
        break;

      case NNSH_SUBJSTATUS_REMAIN:
        /** ǂ **/
        *dst = '-';
        break;

      case NNSH_SUBJSTATUS_ALREADY:
        /** bZ[WSǂ **/
        *dst = ':';
        break;

      case NNSH_SUBJSTATUS_NOT_YET:
      default:                
        /** bZ[W擾 **/
        *dst = ' ';
        break;
    }
    dst++;

    // bZ[W̃Rs[
    if ((NNshGlobal->NNsiParam)->printNofMessage != 0)
    {
        switch (msgState)
        {
          case NNSH_SUBJSTATUS_UNKNOWN:
            // X͂ȂƂ\
            StrCat(dst, "[???]");
            break;
          case NNSH_SUBJSTATUS_NEW:
            // VɎ擾Ƃ\
            StrCat(dst, "[NEW]");
            break;
          case NNSH_SUBJSTATUS_UPDATE:
            // XVƂ\
            StrCat(dst, "[New]");
            break;
          default:
            // 擾bZ[W\
            StrCat(dst, "[");
            (void) NUMCATI(dst, msgNumber);
            StrCat(dst, "]");
            break;
        }
    }
    size = StrLen(dest);
    dst  = dest + size;

    // X^Cg̃Rs[
    StrNCopyHanZen(dst, src, (length - size - 1));
    return;
}

/*=========================================================================*/
/*   Function : ClearMsgTitleInfo                                          */
/*                                           X^Cꗗ̊֘ÄJ  */
/*=========================================================================*/
void ClearMsgTitleInfo(void)
{
    MEMFREE_PTR(NNshGlobal->msgListIndex);
    MEMFREE_PTR(NNshGlobal->msgListStrings);
    MEMFREE_PTR(NNshGlobal->msgTitleIndex);
    MEMFREE_PTR(NNshGlobal->msgTitleStatus);
    MEMFREE_PTR(NNshGlobal->msgNumbers);

    NNshGlobal->nofTitleItems = 0;

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : AllocMsgTitleInfo                                          */
/*                                           X^Cꗗ̊֘Äm  */
/*-------------------------------------------------------------------------*/
static Err AllocMsgTitleInfo(UInt16 nofItems)
{
    UInt16 allocSize;

    // XꗗXR[hԍϊe[ü̏
    allocSize = sizeof(UInt16) * (nofItems + 2);
    NNshGlobal->msgListIndex = MEMALLOC_PTR(allocSize);
    if (NNshGlobal->msgListIndex == NULL)
    {
        return (~errNone + 10);
    }
    MemSet(NNshGlobal->msgListIndex, allocSize, 0x00);

    // X^Cg̐擪ʒui[̈̏
    allocSize = sizeof(Char *) * (nofItems + 2);
    NNshGlobal->msgTitleIndex = MEMALLOC_PTR(allocSize);
    if (NNshGlobal->msgTitleIndex == NULL)
    {
        MEMFREE_PTR(NNshGlobal->msgListIndex);
        return (~errNone + 11);    
    }
    MemSet(NNshGlobal->msgTitleIndex, allocSize, 0x00);

    // X^Cgi[̈̏
    allocSize = (LIMIT_TITLENAME_DEFAULT + 10 + MARGIN) * (nofItems + 1);
    NNshGlobal->msgListStrings = MEMALLOC_PTR(allocSize);
    if (NNshGlobal->msgListStrings == NULL)
    {
        MEMFREE_PTR(NNshGlobal->msgListIndex);
        MEMFREE_PTR(NNshGlobal->msgTitleIndex);
        return (~errNone + 12);
    }
    MemSet(NNshGlobal->msgListStrings, allocSize, 0x00);

    // X^CgԊi[̈̏
    allocSize = sizeof(UInt16) * (nofItems + 2);
    NNshGlobal->msgTitleStatus = MEMALLOC_PTR(allocSize);
    if (NNshGlobal->msgTitleStatus == NULL)
    {
        MEMFREE_PTR(NNshGlobal->msgListIndex);
        MEMFREE_PTR(NNshGlobal->msgTitleIndex);
        MEMFREE_PTR(NNshGlobal->msgListStrings);
        return (~errNone + 13);
    }
    MemSet(NNshGlobal->msgTitleStatus, allocSize, 0x00);

    // XbZ[Wi[̈̏
    allocSize = sizeof(UInt16) * (nofItems + 2);
    NNshGlobal->msgNumbers = MEMALLOC_PTR(allocSize);
    if (NNshGlobal->msgNumbers == NULL)
    {
        MEMFREE_PTR(NNshGlobal->msgListIndex);
        MEMFREE_PTR(NNshGlobal->msgTitleIndex);
        MEMFREE_PTR(NNshGlobal->msgListStrings);
        MEMFREE_PTR(NNshGlobal->msgTitleStatus);
        return (~errNone + 14);
    }
    MemSet(NNshGlobal->msgNumbers, allocSize, 0x00);

    NNshGlobal->nofTitleItems = 0;

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   function :   create_TitleList                                         */
/*                                            bZ[W^Cgꗗ쐬 */
/*-------------------------------------------------------------------------*/
static Err create_TitleList(UInt16 bbsIndex, UInt16 areaCount,
                             Char  *buffer,   Int16  command)
{
    Err                  ret = ~errNone;
    Char                *ptr;
    Int16                stepCnt;
    UInt16               dataIndexMax, loop, startRec, endRec, tempIndex;
    DmOpenRef            dbRef;
    NNshSubjectDatabase *subjDb;
    NNshBoardDatabase    bbsData;
    MemHandle            msgH;

#ifdef DEBUG
    Char debugMsg[129];
#endif

    // v^Cg̏
    NNshGlobal->nofTitleItems  = 0;
    endRec                     = 0;
    ptr                        = buffer;

    switch (bbsIndex)
    {
      case NNSH_SELBBS_NOTREAD:     // ǂ
      case NNSH_SELBBS_GETALL:      // 擾ςݑS
      case NNSH_SELBBS_FAVORITE:    // CɓX
        // BBS͎擾Ȃ(擾)
        break;

      case NNSH_SELBBS_CUSTOM1:     // CUSTOM1
        if (Get_BBS_Info((NNshGlobal->NNsiParam)->custom1.boardNick, &bbsData) != errNone)
        {
            // uꗗȂvݒ蕔փWv
            goto RECORD_NOTHING;
        }
        break;

      case NNSH_SELBBS_CUSTOM2:     // CUSTOM2
        if (Get_BBS_Info((NNshGlobal->NNsiParam)->custom2.boardNick, &bbsData) != errNone)
        {
            // uꗗȂvݒ蕔փWv
            goto RECORD_NOTHING;
        }
        break;

      case NNSH_SELBBS_CUSTOM3:     // CUSTOM3
        if (Get_BBS_Info((NNshGlobal->NNsiParam)->custom3.boardNick, &bbsData) != errNone)
        {
            // uꗗȂvݒ蕔փWv
            goto RECORD_NOTHING;
        }
        break;

      case NNSH_SELBBS_CUSTOM4:     // CUSTOM4
        if (Get_BBS_Info((NNshGlobal->NNsiParam)->custom4.boardNick, &bbsData) != errNone)
        {
            // uꗗȂvݒ蕔փWv
            goto RECORD_NOTHING;
        }
        break;

      case NNSH_SELBBS_CUSTOM5:     // CUSTOM5
        if (Get_BBS_Info((NNshGlobal->NNsiParam)->custom5.boardNick, &bbsData) != errNone)
        {
            // uꗗȂvݒ蕔փWv
            goto RECORD_NOTHING;
        }
        break;

      case NNSH_SELBBS_OFFLINE:
        // QƐpO
        if (Get_BBS_Info(bbsIndex, &bbsData) != errNone)
        {
            // uꗗȂvݒ蕔փWv
            goto RECORD_NOTHING;
        }
        break;

      default:
        // BBSȊÔƂ
        if (Get_BBS_Info(bbsIndex, &bbsData) != errNone)
        {
            // uꗗȂvݒ蕔փWv
            goto RECORD_NOTHING;
        }
        break;
    }
    ret = errNone;

    // XǗDBI[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    GetDBCount_NNsh(dbRef, &dataIndexMax);

    // Pf[^o^ĂȂꍇ
    if (dataIndexMax == 0)
    {
        // uꗗȂvݒ蕔փWv
        goto RECORD_NOTHING;
    }

    //////////////////// ݂̕\ԂmF ///////////////////////
    if (command == NNSH_STEP_UPDATE)
    {
        // XꗗXVwꍇɂ́AԂ""ɕύX
        (NNshGlobal->NNsiParam)->titleDispState = NNSH_DISP_UPPERLIMIT;
    }

    switch ((NNshGlobal->NNsiParam)->titleDispState)
    {
      case NNSH_DISP_UPPERLIMIT:
      case NNSH_DISP_ALL:
        // 擪猟
        (NNshGlobal->NNsiParam)->startTitleRec = (dataIndexMax - 1);
        break;

      case NNSH_DISP_LOWERLIMIT:
        // 猟
        (NNshGlobal->NNsiParam)->endTitleRec = 0;
        break;

      default:
        // Ȃ
        break;
    }

    //////////////////// \vmF ///////////////////////
    switch (command)
    {
      case NNSH_STEP_PAGEUP:
        // 1y[W""ֈړ        (R[hԍ̑偨j
        stepCnt  = -1;
        startRec = (NNshGlobal->NNsiParam)->endTitleRec;
        (NNshGlobal->NNsiParam)->titleDispState = NNSH_DISP_HALFWAY;
        break;

      case NNSH_STEP_PAGEDOWN:
        // 1y[W""ֈړ       iR[hԍ̏匟j
        stepCnt  = 1;
        startRec = (NNshGlobal->NNsiParam)->startTitleRec;
        (NNshGlobal->NNsiParam)->titleDispState = NNSH_DISP_HALFWAY;
        break;

      case NNSH_STEP_TO_BOTTOM:
        // ꗗ̖ֈړ        iR[hԍ̂O猟j
        stepCnt  = 1;
        startRec = 0;
        (NNshGlobal->NNsiParam)->titleDispState = NNSH_DISP_LOWERLIMIT;
        break;

      case NNSH_STEP_REDRAW:
        // ݕ\̃y[Wĕ`悷iO̕\R[hԍ̐擪j
        stepCnt  = -1;
        startRec = (NNshGlobal->NNsiParam)->startTitleRec;
        break;

      // case NNSH_STEP_UPDATE:
      // case NNSH_STEP_TO_TOP:
      default:
        // ̐擪ĕ\  iR[hԍ̍ő傩猟j
        stepCnt  = -1;
        startRec = (dataIndexMax - 1);
        (NNshGlobal->NNsiParam)->titleDispState = NNSH_DISP_UPPERLIMIT;
        break;
    }

    //////////////// \X̃R[hԍ /////////////////////////
    for (loop = startRec + 1;
         ((loop > 0)&&(loop <= dataIndexMax));
         loop = loop + stepCnt)
    {
        // \R[h擾
        GetRecordReadOnly_NNsh(dbRef, (loop - 1), &msgH, (void **) &subjDb);

        // \/Ȃ̏
        if (CheckDispList(bbsIndex, subjDb, &bbsData) == false)
        {
            // \ȂXƔ
            ReleaseRecordReadOnly_NNsh(dbRef, msgH);
            continue;
        }
        ReleaseRecordReadOnly_NNsh(dbRef, msgH);

        if (NNshGlobal->nofTitleItems >= areaCount)
        {
            // Xg\̕\\萔 + 1ÎŁAŔ
            endRec = NNshGlobal->msgListIndex[(NNshGlobal->nofTitleItems - 1)];
            break;                                          // [v𔲂
        }

        // \郌R[hԍLĂ
        NNshGlobal->msgListIndex[NNshGlobal->nofTitleItems] = (loop - 1);

        // R[hԍL^
        (NNshGlobal->nofTitleItems)++;

    }
    
    //////////  [v̏ImF
    if (loop == 0)                   // F 擪܂Ō
    {
        // R[h̖擪܂Ōǂ`FbN
        if (((NNshGlobal->NNsiParam)->titleDispState == NNSH_DISP_UPPERLIMIT)||
             ((NNshGlobal->NNsiParam)->titleDispState == NNSH_DISP_ALL))
        {
            // Sĕ\
            (NNshGlobal->NNsiParam)->titleDispState = NNSH_DISP_ALL;
        }
        else
        {
            // 
            (NNshGlobal->NNsiParam)->titleDispState = NNSH_DISP_LOWERLIMIT;
        }
        endRec = loop;
    }
    else if (loop > dataIndexMax)    // ܂Ō
    {
        // R[h̐擪疖܂Ōǂ`FbN
        if (((NNshGlobal->NNsiParam)->titleDispState == NNSH_DISP_LOWERLIMIT)||
            ((NNshGlobal->NNsiParam)->titleDispState == NNSH_DISP_ALL))
        {
            // Sĕ\
            (NNshGlobal->NNsiParam)->titleDispState = NNSH_DISP_ALL;
        }
        else
        {
            // 
            (NNshGlobal->NNsiParam)->titleDispState = NNSH_DISP_UPPERLIMIT;
        }
        endRec = (dataIndexMax - 1);
    }
    else   //   0 < loop <= dataIndexMax ̎...
    {
        if (startRec == 0)
        {
            // 
            (NNshGlobal->NNsiParam)->titleDispState = NNSH_DISP_LOWERLIMIT;
        }
        else if (startRec == (dataIndexMax - 1))
        {
            // 
            (NNshGlobal->NNsiParam)->titleDispState = NNSH_DISP_UPPERLIMIT;
        }
        else
        {
            // r܂ŕ\
            (NNshGlobal->NNsiParam)->titleDispState = NNSH_DISP_HALFWAY;
        }
    }

    //////// Y^ ///////////////////////////////////////////////////////////
    //   AǂꍇANNshGlobal->nofTitleItems0łɓB    //
    // 邱ƂB(ǂ̍ŏIy[WQƂIƂAX폜 //
    // Ẵy[Wɕ\XȂȂꍇ)                         //
    //  uȂvƕ\邪AۂɃ^uIčXVƃX݂͑ //
    // ̂ŁAΏKvB(̊֐ĂяoőΏ)                    //
    ///////////////////////////////////////////////////////////////////////////

    ///////////////////// Xꗗf[^̕בւ ////////////////////////////
    if (stepCnt > 0)
    {
        // R[hԍ̓ւ(~ɐ񂳂)
        for (loop = 0; loop < (NNshGlobal->nofTitleItems / 2) ; loop++)
        {
            tempIndex = NNshGlobal->msgListIndex[loop];

            NNshGlobal->msgListIndex[loop] =
               NNshGlobal->msgListIndex[NNshGlobal->nofTitleItems - (loop + 1)];

            NNshGlobal->msgListIndex[NNshGlobal->nofTitleItems - (loop + 1)] =
                                                                      tempIndex;
        }
    }

    //////////////////// Jn/IR[hԍ̊i[ //////////////////////
    if (startRec < endRec)
    {
        // Jn/ĨR[hԍL^
        (NNshGlobal->NNsiParam)->startTitleRec = endRec;
        (NNshGlobal->NNsiParam)->endTitleRec   = startRec;
    }
    else
    {
        // Jn/ĨR[hԍL^
        (NNshGlobal->NNsiParam)->startTitleRec = startRec;
        (NNshGlobal->NNsiParam)->endTitleRec   = endRec;     
    }

#ifdef DEBUG
    ///////////////////////////////////////// DEBUG MESSAGE { /////////////////
    MemSet (debugMsg, sizeof(debugMsg), 0x00);
    StrCopy(debugMsg, "startRec:");
    NUMCATI(debugMsg, (NNshGlobal->NNsiParam)->startTitleRec);
    StrCat (debugMsg, " endRec:");
    NUMCATI(debugMsg, (NNshGlobal->NNsiParam)->endTitleRec);
    NNsh_DebugMessage(ALTID_INFO, debugMsg, " (NNshGlobal->NNsiParam)->titleDispState:", 
                      (NNshGlobal->NNsiParam)->titleDispState);
    ///////////////////////////////////////// } DEBUG MESSAGE /////////////////
#endif  // #ifdef DEBUG


    ////////////////////////  Xꗗf[^i[  //////////////////////
    for (loop = 0; loop < NNshGlobal->nofTitleItems; loop++)
    {
        // \R[h擾
        GetRecordReadOnly_NNsh(dbRef, NNshGlobal->msgListIndex[loop],
                                                    &msgH, (void **) &subjDb);

        // bZ[WKI[oĂA̐FɂĂ܂
        if ((subjDb->maxLoc > NNSH_MESSAGE_LIMIT)&&
            (subjDb->state == NNSH_SUBJSTATUS_ALREADY))
        {
            NNshGlobal->msgTitleStatus[loop] = 
                        ((NNSH_SUBJSTATUS_OVER)|((subjDb->msgAttribute << 8)));
        }
        else
        {
            NNshGlobal->msgTitleStatus[loop] = 
                               ((subjDb->state)|((subjDb->msgAttribute << 8)));
        }

        // Xi[L^
        NNshGlobal->msgNumbers[loop] = subjDb->maxLoc;

        // X^Cgۑ
        copyThreadTitleString(ptr, subjDb->threadTitle,
                              LIMIT_TITLENAME_DEFAULT,
                              NNshGlobal->msgTitleStatus[loop],
                              NNshGlobal->msgNumbers[loop]);

        // X^Cg̐擪|C^ۑÅi[̈ֈړ
        NNshGlobal->msgTitleIndex [loop] = ptr;
        ptr = ptr + StrLen(ptr) + 1;

        // R[ḧJ
        ReleaseRecordReadOnly_NNsh(dbRef, msgH);
    }

RECORD_NOTHING:
    // f[^x[XN[Y
    CloseDatabase_NNsh(dbRef);


    //////////////////// YXPȂꍇ /////////////////////
    if (NNshGlobal->nofTitleItems == 0)
    {
        // uꗗȂvݒ肷
        StrCopy(buffer, MSG_SUBJECT_DEFAULT);
        (NNshGlobal->NNsiParam)->titleDispState     = NNSH_DISP_NOTHING;
        NNshGlobal->msgListIndex  [0] = 0;
        NNshGlobal->msgTitleIndex [0] = buffer;
        NNshGlobal->msgNumbers    [0] = 0;
        NNshGlobal->msgTitleStatus[0] = 0;
        ret = (NNSH_ERRORCODE_THREADNOTHING);
    }
    return (ret);
}

/*=========================================================================*/
/*   Function :   Update_Thread_List                                       */
/*                                                      Xꗗ\̍XV */
/*=========================================================================*/
Boolean Update_Thread_List(UInt16 bbsIdx, UInt16 selItem, UInt16 step)
{
    Err               ret;
    Char             *ptr;
    FormType         *frm;
    RectangleType     dimF;
    UInt16            fontID, nlines, fontHeight, threadStatus;

    // ANeBuȃtH[̃|C^擾
    frm = FrmGetActiveForm();
    FrmGetObjectBounds(frm, FrmGetObjectIndex(frm, GADID_MESSAGE_LIST), &dimF);

    // `̈ƃtHg̏A\\sXV
    fontID = ((NNshGlobal->NNsiParam)->useSonyTinyFontTitle == 0) ?
                           (NNshGlobal->NNsiParam)->currentFont : (NNshGlobal->NNsiParam)->sonyHRFontTitle;

    // ʂ̑傫擾(ݒ)
    NNsi_UpdateRectangle(&dimF, (NNshGlobal->NNsiParam)->useSonyTinyFontTitle,
                         &fontID, &fontHeight, &nlines);


    // "Xꗗ쐬" ̕\
    Show_BusyForm(MSG_READ_THREAD_WAIT);

    // X^C֘ÄJ
    ClearMsgTitleInfo();

    // X^C֘Ämۂ
    if (AllocMsgTitleInfo(nlines) != errNone)
    {
        // X^Cg֘Ä̊mۂɎs
        return (false);
    }

    ///////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////
    /////       X^Cg̕쐬
    ///////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////
    ptr = NNshGlobal->msgListStrings;
    threadStatus = (NNshGlobal->NNsiParam)->titleDispState;
    ret = create_TitleList(bbsIdx, nlines, ptr, step);
    if (ret == NNSH_ERRORCODE_THREADNOTHING)
    {
        // Xɕ\̂ȂAƂAAA
        if ((step == NNSH_STEP_REDRAW)&&(threadStatus != NNSH_DISP_ALL)&&
            (threadStatus != NNSH_DISP_UPPERLIMIT))
        {
            //  ĕ`wŁAXԂuS\vƁuvłȂꍇ
            // X^Cg쐬֐xĂяo
            MemSet(ptr, StrLen(ptr), 0x00);
            selItem = NNSH_ITEM_LASTITEM;
            step    = NNSH_STEP_TO_BOTTOM;
            ret     = create_TitleList(bbsIdx, nlines, ptr, step);
        }
    }

    // IXw肵ACeԍɐݒ肷
    // (\\s𒴂ĂAԉ̃ACeԍɕύX)
    (NNshGlobal->NNsiParam)->selectedTitleItem = (selItem >= NNshGlobal->nofTitleItems) ?
                                     (NNshGlobal->nofTitleItems - 1): selItem;

    // "Xꗗ쐬"̕\폜
    Hide_BusyForm(false);

#ifdef USE_PIN_DIA
    if (NNshGlobal->updateHR == NNSH_UPDATE_DISPLAY)
    {
        // CLIEŃVÑTCYύXꂽƂɂ͈UtH[
        FrmEraseForm(frm);
    }
#endif
    FrmDrawForm(frm);

    // Xꗗ̕\(`)
    NNsi_WinDrawList((NNshGlobal->NNsiParam)->selectedTitleItem, NNshGlobal->msgTitleIndex,
                     nlines, &dimF, fontHeight);

    return (true);
}

#ifdef USE_COLOR
/*=========================================================================*/
/*   Function :   NNsi_SetTitleColor                                       */
/*                                                    X^Cg̐Fݒ */
/*=========================================================================*/
void NNsi_SetTitleColor(UInt16 status)
{
    IndexedColorType color;

    if (((status >> 8)&(NNSH_MSGATTR_ERROR)) == NNSH_MSGATTR_ERROR)
    {
        // G[X    
        color = (IndexedColorType) (NNshGlobal->NNsiParam)->colorError;
        goto SET_COLOR;
    }
    // bZ[W̏ԂŐFݒ
    switch (status & 0xff)
    {
      case NNSH_SUBJSTATUS_NEW:
        /** VK擾(Ď擾) **/
        color = (IndexedColorType) (NNshGlobal->NNsiParam)->colorNew;
        break;

      case NNSH_SUBJSTATUS_UPDATE:
        /** bZ[WXV **/
        color = (IndexedColorType) (NNshGlobal->NNsiParam)->colorUpdate;
        break;

      case NNSH_SUBJSTATUS_REMAIN:
        /** ǂ **/
        color = (IndexedColorType) (NNshGlobal->NNsiParam)->colorRemain;
        break;

      case NNSH_SUBJSTATUS_ALREADY:
        /** bZ[WSǂ **/
        color = (IndexedColorType) (NNshGlobal->NNsiParam)->colorAlready;
        break;

      case NNSH_SUBJSTATUS_NOT_YET:
        /** bZ[W擾 **/
        color = (IndexedColorType) (NNshGlobal->NNsiParam)->colorNotYet;
        break;

      case NNSH_SUBJSTATUS_OVER:
        /** 1000 **/
        color = (IndexedColorType) (NNshGlobal->NNsiParam)->colorOver;
        break;

      default:                
        /** ̑(肦ȂH) **/
        color = (IndexedColorType) (NNshGlobal->NNsiParam)->colorUnknown;
        break;
    }

SET_COLOR:
    // Fݒ肷
    WinSetForeColor(color);
    WinSetTextColor(color);
    return;
}
#endif

/*=========================================================================*/
/*   Function :   NNsi_WinDrawList                                         */
/*                                                    Xꗗ̕\C */
/*=========================================================================*/
void NNsi_WinDrawList(UInt16 pointIndex, Char *titleIndex[], UInt16 listItems,
                      RectangleType *dimF, UInt16 height)
{
    UInt16        lp, len;
#ifdef USE_COLOR
    IndexedColorType savedIndex;
    RGBColorType     savedColor, drawColor;
#endif

    // Xꗗɕ\镶񂪂Ȃꍇɂ́A
    if (NNshGlobal->msgTitleIndex == NULL)
    {
        return;
    }

#ifdef USE_COLOR
    if ((NNshGlobal->NNsiParam)->useColor != 0)
    {
        ///////////////////////////////////////////////////////////////
        //  ̐ݒɂAꗗXg̗̈悾wiFς...
        // (Ȃ񂩂ƊiDȂBBB)
        ///////////////////////////////////////////////////////////////

        // wiFݒ肷
        WinSetBackColor((IndexedColorType) (NNshGlobal->NNsiParam)->colorBackGround);
    }
#endif

    // \̈NA
    NNsi_EraseRectangle(dimF);

#ifdef USE_HIGHDENSITY
    // 𑜓x̐ݒ
    switch (NNshGlobal->os5HighDensity)
    {
      case kDensityDouble:
      case kDensityQuadruple:
      case kDensityTriple:
      case kDensityOneAndAHalf:
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),kDensityLow);
        WinSetCoordinateSystem(kCoordinatesNative);
        // FntSetFont((NNshGlobal->NNsiParam)->sonyHRFontTitle);
        break;

      case kDensityLow:
      default:
        break;
    }
#endif   // #ifdef USE_HIGHDENSITY

    // X^Cg̕`
    for (lp = 0; lp < listItems; lp++)
    {
        if (NNshGlobal->msgTitleIndex[lp] == '\0')
        {
            // ^CgCfbNXȂAI
            break;
        }

#ifdef USE_COLOR
        // tHgJ[̐ݒ
        if ((NNshGlobal->NNsiParam)->useColor != 0)
        {
            // ƎsA͔...Ă...(^^;
            NNsi_SetTitleColor(NNshGlobal->msgTitleStatus[lp]);
        }
#endif

#ifdef USE_CLIE
        if (NNshGlobal->hrRef != 0)
        {
            // CLIEnC]`
            HRWinDrawChars(NNshGlobal->hrRef, 
                           titleIndex[lp], StrLen(titleIndex[lp]),
                           dimF->topLeft.x, dimF->topLeft.y);
            if (pointIndex == lp)
            {
                // J[\ʒu𔽓]
                HRWinDrawInvertedChars(NNshGlobal->hrRef, 
                                       titleIndex[lp], StrLen(titleIndex[lp]),
                                       dimF->topLeft.x, dimF->topLeft.y);
            }
        }
        else
#endif
        {
            // ʏ탂[h`
            len = FntWordWrap(titleIndex[lp], dimF->extent.x);
            WinDrawChars(titleIndex[lp],len,dimF->topLeft.x,dimF->topLeft.y);
            if (pointIndex == lp)
            {
                // J[\ʒu𔽓]
                WinDrawInvertedChars(titleIndex[lp], len,
                                     dimF->topLeft.x, dimF->topLeft.y);
            }
        }

        // ̍sɕ`ʒuړ
        dimF->topLeft.y = dimF->topLeft.y + height;
    }

#ifdef USE_HIGHDENSITY
    // 𑜓x̐ݒ
    switch (NNshGlobal->os5HighDensity)
    {
      case kDensityDouble:
      case kDensityQuadruple:
      case kDensityTriple:
      case kDensityOneAndAHalf:
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),
                      NNshGlobal->os5HighDensity);
        WinSetCoordinateSystem(kCoordinatesStandard);
        // FntSetFont((NNshGlobal->NNsiParam)->sonyHRFont);
        break;

      case kDensityLow:
      default:
        break;
    }
#endif   // #ifdef USE_HIGHDENSITY

#ifdef USE_COLOR
    if ((NNshGlobal->NNsiParam)->useColor != 0)
    {
        // ݂̐Fۑ
        savedIndex = UIColorGetTableEntryIndex(UIObjectForeground);
        WinIndexToRGB(savedIndex, &savedColor);

        // {^̐Fϊ
        WinIndexToRGB((NNshGlobal->NNsiParam)->colorButton,    &drawColor);
        UIColorSetTableEntry(UIObjectForeground, &drawColor);
    }
#endif

    // /̃{^\
    // (㉺{^\/\ɂ)
    NNsh_UpDownButtonControl(FrmGetActiveForm(), (NNshGlobal->NNsiParam)->titleDispState, BTNID_LISTPREV, BTNID_LISTNEXT);

#ifdef USE_COLOR
    if ((NNshGlobal->NNsiParam)->useColor != 0)
    {
        // {^̐Fɖ߂
        UIColorSetTableEntry(UIObjectForeground, &savedColor);

        // ftHg̔wiFݒ肷
        WinSetBackColor(UIColorGetTableEntryIndex(UIFieldBackground));
    }   
#endif

    return;
}


/*=========================================================================*/
/*   Function :   NNsi_WinUpdateList                                       */
/*                                            Xgf[^̔]XV */
/*=========================================================================*/
void NNsi_WinUpdateList(UInt16 pointIndex, UInt16 prevIndex,
                        Char *titleIndex[], UInt16 listItems,
                        RectangleType *dimF, UInt16 height)
{
    UInt16         lp, len;
#ifdef USE_COLOR
    IndexedColorType savedIndex;
    RGBColorType     savedColor, drawColor;
#endif

#ifdef USE_COLOR
    if ((NNshGlobal->NNsiParam)->useColor != 0)
    {
        ///////////////////////////////////////////////////////////////
        //  ̐ݒɂAꗗXg̗̈悾wiFς...
        // (Ȃ񂩂ƊiDȂBBB)
        ///////////////////////////////////////////////////////////////

        // wiFݒ肷
        WinSetBackColor((IndexedColorType) (NNshGlobal->NNsiParam)->colorBackGround);
    }
#endif

#ifdef USE_HIGHDENSITY
    // 𑜓x̐ݒ
    switch (NNshGlobal->os5HighDensity)
    {
      case kDensityDouble:
      case kDensityQuadruple:
      case kDensityTriple:
      case kDensityOneAndAHalf:
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),kDensityLow);
        WinSetCoordinateSystem(kCoordinatesNative);
        // FntSetFont((NNshGlobal->NNsiParam)->sonyHRFont);
        break;

      case kDensityLow:
      default:
        break;
    }
#endif

    // X^Cg̕`
    for (lp = 0; lp < listItems; lp++)
    {
        if (NNshGlobal->msgTitleIndex[lp] == '\0')
        {
            // ^CgCfbNXȂAI
            break;
        }

        if (lp == prevIndex)
        {
#ifdef USE_COLOR
            // tHgJ[̐ݒ
            if ((NNshGlobal->NNsiParam)->useColor != 0)
            {
                // ƎsA͔...Ă...(^^;
                NNsi_SetTitleColor(NNshGlobal->msgTitleStatus[lp]);
            }
#endif
#ifdef USE_CLIE
            if (NNshGlobal->hrRef != 0)
            {
                // J[\ʒuɖ߂(CLIEnC]`)
                HRWinDrawChars(NNshGlobal->hrRef, 
                               titleIndex[lp], StrLen(titleIndex[lp]),
                               dimF->topLeft.x, dimF->topLeft.y);
            }
            else
#endif
            {
                // J[\ʒuɖ߂(ʏ탂[h`)
                len = FntWordWrap(titleIndex[lp], dimF->extent.x);
                WinDrawChars(titleIndex[lp], len,
                             dimF->topLeft.x, dimF->topLeft.y);
            }
        }

        if (lp == pointIndex)
        {
            // tHgJ[̐ݒ
#ifdef USE_COLOR
            if ((NNshGlobal->NNsiParam)->useColor != 0)
            {
                // ƎsA͔...Ă...(^^;
                NNsi_SetTitleColor(NNshGlobal->msgTitleStatus[lp]);
            }
#endif
#ifdef USE_CLIE
            if (NNshGlobal->hrRef != 0)
            {
                // J[\ʒu𔽓](CLIEnC]`)
                HRWinDrawInvertedChars(NNshGlobal->hrRef, 
                                       titleIndex[lp], StrLen(titleIndex[lp]),
                                       dimF->topLeft.x, dimF->topLeft.y);
            }
            else
#endif
            {
                // J[\ʒu𔽓](ʏ탂[h`)
                len = FntWordWrap(titleIndex[lp], dimF->extent.x);
                WinDrawInvertedChars(titleIndex[lp], len,
                                     dimF->topLeft.x, dimF->topLeft.y);
            }
        }
 
        // ̍sɕ`ʒuړ
        dimF->topLeft.y = dimF->topLeft.y + height;
    }

#ifdef USE_HIGHDENSITY
    // 𑜓x̐ݒ
    switch (NNshGlobal->os5HighDensity)
    {
      case kDensityDouble:
      case kDensityQuadruple:
      case kDensityTriple:
      case kDensityOneAndAHalf:
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),
                      NNshGlobal->os5HighDensity);
        WinSetCoordinateSystem(kCoordinatesStandard);
        // FntSetFont((NNshGlobal->NNsiParam)->sonyHRFont);
        break;

      case kDensityLow:
      default:
        break;
    }
#endif // #ifdef USE_HIGHDENSITY

#ifdef USE_COLOR
    if ((NNshGlobal->NNsiParam)->useColor != 0)
    {
        // ݂̐Fۑ
        savedIndex = UIColorGetTableEntryIndex(UIObjectForeground);
        WinIndexToRGB(savedIndex, &savedColor);

        // {^̐Fϊ
        WinIndexToRGB((NNshGlobal->NNsiParam)->colorButton,    &drawColor);
        UIColorSetTableEntry(UIObjectForeground, &drawColor);
    }
#endif

    // /̃{^\
    // (㉺{^\/\ɂ)
    NNsh_UpDownButtonControl(FrmGetActiveForm(), (NNshGlobal->NNsiParam)->titleDispState, BTNID_LISTPREV, BTNID_LISTNEXT);

#ifdef USE_COLOR
    if ((NNshGlobal->NNsiParam)->useColor != 0)
    {
        // {^̐Fɖ߂
        UIColorSetTableEntry(UIObjectForeground, &savedColor);

        // ftHg̔wiFݒ肷
        WinSetBackColor(UIColorGetTableEntryIndex(UIFieldBackground));
    }   
#endif
    return;
}
