

/////////////////////////
///// カルテからの継承値 ///

function noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.opener.name == "tools"){
        return window.opener.top.noa;
    } else if (window.top.noa){
        return window.top.noa;
    } else {
        alert("ERROR *** chartFinder.js: window.opener としての NOA が見つかりません");
        return null;
    }
}

function owner(){
    return noa().owner();
}

function labelTagValue(){
    var items = new Array();
    var entryDate = noa().currentDate();
    if (!entryDate){
        var elm = document.getElementById("alert");
        elm.innerHTML = "";
        var dv = newDIV(elm, "");
        dv.innerHTML = "検索対象を表示できません。";
        var dv = newDIV(elm, "");
        dv.innerHTML = "カルテを開き やり直してください。";
        return null;
    }

    var array = noa().layoutArray(_progress);
    array = array.concat(noa().layoutArray(_basic));
    array = array.concat(noa().layoutArray(_insurance));
    for (num in array){
        var rec = array[num];
        items[rec.label] = rec.tag;
    }

    return items;
}

///// カルテからの継承値 ///
/////////////////////////


var _fieldName;
function setTagetField(fieldName){
	// calendar ツールを呼ぶ前に対象フィールドを記憶しておく
	_fieldName = fieldName;
}
function fieldname(){
	return _fieldName;
}

var _tagName;
function setTagName(tag){
	// 検索対象の tag を記憶しておく
	_tagName = tag;
}
function tagName(){
	return _tagName;
}

var _labelTable;
function setLabelTable(array){
	_labelTable = array;
}
function labelTable(){
	// array[label] = tag 形式の配列を返す
	return _labelTable;
}
function tagForLabel(label){
	// label に対する tag を返す
	return _labelTable[label];
}




////////////////////////////////
/// neuron.js による処理 /////////

var _targetY;
function showInfo(answer){
	// 検索結果詳細を表示
	var obj = JSON.parse(answer);
	// objct: "{'table.field':'value','table.field':'value'},{,,}"
	// alert(encodeObject(obj)); //##
	
	showInfoPanel(_targetY, obj);
}
function getInfo(elm, pid, date, tag){
	// pid, date の情報をサーバへリクエスト
	var tagArray = "ProgressSection.patientId,NameSection.patientKanjiName,ProgressSection.entryDate," + tag;
	
	var pos = getPosition(elm);
	var h =  elm.offsetHeight;
    //	_targetY = pos.y; // クリックされた行の位置を記憶
	_targetY = pos.y + h; // クリックされた行の位置を記憶
	
	NRGetPage(owner(), pid, date, "", tagArray, showInfo);
}

function found(answer){
	// 検索結果を表示
	var obj = JSON.parse(answer);
    //alert("found->"+encodeObject(obj)); //##
    
	showResults(obj);
}
function find(){
	// 検索を実行
	var tag = tagForLabel(document.getElementById("labelName").value);
	//var pid = encodeSTRING(document.getElementById("patientId").value);
	var key = document.getElementById("key").value;
	var from = document.getElementById("from").value;
	var to = document.getElementById("to").value;
	var unique = (document.getElementById("uniqueId").checked) 
    ? "on" : "";
    
    //alert(tag+"/"+pid+"/"+key+"/"+from+".."+to+"/"+unique); //##
    
	setTagName(tag); // 検索対象 tag を記憶
	NRFind(tag, "", key, from, to, unique, found);
}

/// neuron.js による処理 /////////
////////////////////////////////

function showInfoPanel(cursorY, obj){
	// 検査結果詳細情報を表示
	// header
	var pid = obj['ProgressSection.patientId'];
	var name = pureValue(obj['NameSection.patientKanjiName']);
	var date = obj['ProgressSection.entryDate'];
	var label = window.document.getElementById("labelName").value;
	var tag = window.tagForLabel(label);
	var buff = pureValue(obj[tag]);
	
	// 保険情報の確認パネルを生成
	var elm = document.getElementById("_confirm");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "");
	tbl.style.fontSize = "10pt";
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "カルテ");
	var td = newTD(tr, "", pid + " " + name);
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "受診日");
	var td = newTD(tr, "", date);
	
	// ドキュメント表示エリア
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.setAttribute("colspan","2");
	td.style.padding = "2px 5px";
	var hr = newHR(td);
	var array = buff.split("\n");
	for(var i=0,ct=array.length; i < ct; i++){
		var dv = newDIV(td, "");
		var tx = newTEXT(dv, array[i]);
	}
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.style.textAlign = "right";
	td.setAttribute("colspan","2");
	var hr = newHR(td);
	var bt = newBUTTON(td, "", "このカルテを開く");
	var action = "noa().openChart('"+pid+"','"+name+"')";
	bt.setAttribute("onclick", action);
	var buff = elm.innerHTML;
	
	openFloatPanel(tbl, 5, cursorY, "データ確認パネル", "fixed");
}

function patientIdClicked(patientId, patientName){
	// カルテを開く
    noa().openChart(patientId, patientName);
}

function showResults(obj){
	// JSON obj を元に結果を表示
	// $rec[entryDate] = { 'patientId' = $pid, 'value' = $value } 形式で返す
	var isMultiPatient = true;
	
	var elm = window.document.getElementById("resultArea");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "resultTable");
	tbl.style.fontSize = "9pt"; // Firefox では CSS に書いても反映されない
	
	// header
	var tr = newTR(tbl, "resultHeader", "");
	var td = newTD(tr, "dateHeader", "受診日");
	if (isMultiPatient){
		var td = newTD(tr, "", "カルテID");
		var td = newTD(tr, "", "氏名");
	}
	var td = newTD(tr, "", "検索結果");
	
	// results
	var key = document.getElementById("key").value;
	var num=0;
	for (datetimeAndNum in obj){
		// datetimeAndNum には、同じ entryDate の患者を区別するための枝番号がついている
		// datetimeAndNum:"2009-03-10 10:44:00 8"
		var rec = obj[datetimeAndNum];
		var entryDate = datetimeAndNum.substr(0, 19);
		
		// 時刻を削除し日付のみ取り出す
		var array = datetimeAndNum.split(" ");
		var date = array[0];
		var pid = rec['pid'];
		var name = (rec['name']) ? rec['name'] : "";
		
		// 検索キーに一致した部分以後一定の長さを取り出す
		var val = rec['value'];
		var pos = val.indexOf(key);
		val = val.substr(pos, 30);
		val = transferToCR(val);
		
		var tr = newTR(tbl, "", "");
		// 受診日
		var td = newTD(tr, "date", date);
		
		if (isMultiPatient){
			// カルテID
			var td = newTD(tr, "patientId", pid);
			var action = "patientIdClicked('" + pid + "','" + name + "')";
			td.setAttribute("onclick", action);
			td.setAttribute("onmouseover", "setColor(this, '#ff0', '#00f')");
			td.setAttribute("onmouseout", "resetColor(this, '#000', '#fff')");
			
			// 氏名
			var td = newTD(tr, "name", name);
		}
        
		// 検索結果
		var td = newTD(tr, "data", val);
		var action = "getInfo(this,'"+pid+"','"+entryDate+"','"+tagName()+"')";
		td.setAttribute("onclick", action);
		td.setAttribute("onmouseover", "setColor(this, '#ff0', 'blue')");
		td.setAttribute("onmouseout", "resetColor(this, '#000', '#fff')");
		num++;
	}
	
	// 印刷ボタン
	var tbl = newTABLE(elm, "subTable");
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "buttonArea", "");
	td.style.fontSize = "10pt"; // Firefox では CSS に書いても反映されない
	td.setAttribute("colspan", "4");
	var tx = newTEXT(td, num + " 件 みつかりました　");
    
	// window.print() は javascript のメソッド
	// Safari でないと稼働しないようだ
	var bt = newBUTTON(td, "", "印刷");
	bt.setAttribute("onclick", "print()");
}

function tagMenuItems(){
	// array[ラベル名]=タグ名 の配列を返す
	var menuItems = new Array();
	var labelTable = new Array();
	var obj = labelTagValue();
    
	for (label in obj){
		if (label.length > 0){
			var tag = obj[label];
			menuItems.push(label);
			labelTable[label] = tag;
		}
	}
	setLabelTable(labelTable);
	return menuItems;
}

function showUniqueIdBox(status){
	// "IDの重複を避ける" check box を表示
	var elm = document.getElementById("uniqueIdBoxArea");
	elm.innerHTML = "";
	var cb = newCHECKBOX(elm, "uniqueId", "IDの重複を避ける", status);
}

function showAnotherPanel(){
    // 別ウインドーに表示する
	window.open("./chartFinder.php","chartFinder"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initChartFinder(){
	var elm = document.getElementById("base");
    
    // === HEADER ==================
	var div = newDIV(elm, "tool-header");
    // --- LEFT SIDE ---------------
    dv = newDIV(div, "/left-side");
    dv.innerHTML = "検索";
    dv.style.width = "20%";
    // --- RIGHT SIDE --------------
    if (window.name == "tools"){
        // 別ウインドーで開くアイコン
        dv = newDIV(div, "/right-side");
        dv.style.width = "60%";
        var img = newIMAGE(dv, "outArrowIcon", "outArrow.png", "out");
        img.setAttribute("onclick", "showAnotherPanel()");
        img.style.height = "15px";
        img.style.position = "relative";
        img.style.top = "2px";
        setInfoTip("outArrowIcon", "別ウインドーで開く"); // HELP
    }
    
    // === CONTENTS ================
	var div = newDIV(elm, "");
    div.style.padding = "10px 10px";
    
    var date = noa().currentDate();
    if (date){
        var tbl = newTABLE(div, "base-table");
        tbl.style.fontSize = "9pt"; // Firefox では CSS に書いても反映されない
        // tag
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "", "検索対象");
        td.style.width = "50px";
        var td = newTD(tr, "", "");
        var tagItems = tagMenuItems();
        var pu = makePopupMenu(td, "labelName", tagItems, "主訴");
        
        // 検索範囲
        var date = today(); // lib.js
        var array = date.split("-");
        var yy = array[0] * 1;
        var mm = array[1] * 1;
        var dd = array[2] * 1;
        var tr = newTR(tbl, "", "検索");
        var td = newTD(tr, "fromPop", "");
        var label = nengou(yy-1); // 西暦に相当する年号
        newDatePopUp(td, "from", label, yy, 1, 1, false);
        var tx = newTEXT(td, "から");
        
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "", "範囲");
        var td = newTD(tr, "toPop", "");
        var label = nengou(yy); // 西暦に相当する年号
        newDatePopUp(td, "to", label, yy, mm, dd, false);
        var tx = newTEXT(td, "まで");
        
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "", "カルテID");
        var td = newTD(tr, "", "");
        
        var sp  = newSPAN(td, "uniqueIdBoxArea");
        showUniqueIdBox(1); // "IDの重複を避ける" check box を表示
        
        // 検索キー
        var tr = newTR(tbl, "", "検索キー");
        var td = newTD(tr, "keyArea", "");
        var fd = newFIELD(td, "key", "", 20, "");
        fd.setAttribute("onchange", "find()");
        fd.setAttribute("type", "search");
        fd.focus();
        var bt = newBUTTON(td, "", "検索");
        bt.setAttribute("onclick", "find()");
        
    } else {
        div.style.fontSize = "10pt";
        div.style.color = "#f06";
        div.innerHTML = "カルテが開いてないので検索できません";
    }
    
    // === FOOTER ==================
	var div = newDIV(elm, "tool-footer");
    div.style.paddingLeft = "10px";
    div.innerHTML = version();
    
	// アラート・エリア
	var div = newDIV(elm, "alert");
    
	// 結果表示エリア
	var div = newDIV(elm, "resultArea");
}

function version(){
	return "Ver.130417";
}

