
var _editObject = null; // Global 変数
var _labelWidth = 9;
var _rangeWidth = 12;
var _item = ""; // Global 変数

function editObject(){
	return _editObject;
}
function setEditObject(obj){
	_editObject = obj;
}

function menuItem(){
	return _item;
}
function setMenuItem(item){
	_item = item;
}



////////////////////////////////
/// neuron.js による処理 /////////

function removeItem(tag){
	// 表示されているテンプレートをサーバから削除
	var item = document.getElementById("_item").value; // 伝票名
	
	if (confirm(item + " を削除していいですか")){
		closeEditor();
		NRRemoveMenu(owner(), cellLabel(), item, showItemPopUp);
	}
}

function puttedMenuItem(answer){
    // バックアップファイルも保存
    showItemPopUp(answer);

    // 伝票のテンプレートをバックアップのためアーカイブ
    var templateName = document.getElementById("_item").value; // 伝票名
	var val = templateName +"(" + form2buff(editObject(), false, false) +")";
    
    // アーカイブ内容は array として格納しなければならないので array に入れる
    var array = new Array();
    array.push(templateName);
    array.push(val);

    var dir = "FORM/" + templateName;
    NRPutArchiveFile(owner(), dir, array, alert);
}
function putMenuItem(item, value){
	// item をサーバに登録し item の頻度インクリメント
	if (item == "...その他") return;
	
	NRPutMenu(owner(), cellLabel(), item, "", value, puttedMenuItem);
}

function removeArchiveFile(){
    // 選択されたファイルを削除
    var templateName = document.getElementById("_item").value; // 伝票名
    var filename = document.getElementById("fileNamePop").value; // 日付ファイル名
    var dir = templateName + "/" + filename;
    
    NRRemoveArchiveFile(owner(), "FORM", dir, alert);
}

function gotBackup(answer){
    // バックアップ・ファイルの読み書きするペーンを表示
    // FORM のアーカイブ・ファイル名をポップアップに表示
    var obj = JSON.parse(answer);
    var filenames = obj.files; // obj.path -- archive path
    var menuItems = new Array();
    for (num in filenames){
        // ファイル名が _ で始まる削除済みファイルを抜いたものをポップアップ表示
        var name = filenames[num];
        if (name.charAt(0) == "_") continue;
        
        menuItems.push(name);
    }
    
    var elm = document.getElementById("message");
    elm.innerHTML = "";
    
    var div = newDIV(elm, "");
    div.style.padding = "10px 10px";
    div.style.background = "#ffd";
    div.style.border = "thin solid #833";
    div.style.color = "#833"; // brown
    
    // バックアップから復元
    var dv = newDIV(div, "");
    var sp = newSPAN(dv, "");
    sp.innerHTML = document.getElementById("_item").value; // 伝票名
    sp.style.paddingRight = "10px";
    sp.style.color = "#000";
    sp.style.fontSize = "10pt";
    sp.style.fontWeight = "bold";
    var sp = newSPAN(dv, "");
    sp.innerHTML = "の伝票レイアウトを";
    
    // バックアップ・ファイルのポップアップ
    var dv = newDIV(div, "");
    var pm = makePopupMenu(dv, "fileNamePop", menuItems, "");
    setInfoTip("fileNamePop", "過去のバックアップ・ファイル"); // HELP
    
    // 復元ボタン
    var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "から復元";
    bt.setAttribute("onclick", "getLayoutFile()");
    
    // バックアップ・ファイル削除アイコン
    var sp = newSPAN(dv, "removeArchiveIcon");
    sp.style.position = "relative";
    sp.style.top = "2px";
    setInfoTip("removeArchiveIcon", "選択したバックアップを削除"); // HELP
    var img = newIMAGE(sp, "", "./remove-field.png", "X");
    img.style.height = "11px";
    img.setAttribute("onclick", "removeArchiveFile()");
}
function getBackup(){
    // FORM のアーカイブファイル・リストをサーバへリクエスト
    var elm = document.getElementById("message");
    if (elm.innerHTML.length){ // toggle 式に開閉
        elm.innerHTML = "";
        return;
    }
    
    var templateName = document.getElementById("_item").value; // 伝票名
    var dir = "FORM/" + templateName;
    NRGetArchiveFiles(owner(), dir, gotBackup);
}

function gotLayoutFile(answer){
    //alert("gotLayoutFile->"+answer); //##
    var array = JSON.parse(answer);
    
    // array = ["title", {"title":"value"}] 型式
    // array からテンプレートを復元
    var title = array[0];
    var obj = decodeObject(array[1]);
    //alert("gotLayoutFile->"+encodeObject(obj)); return; //##

    var rec = obj[title];
    var template = encodeObject(rec);
    
    // item をサーバに登録し item の頻度インクリメント
    putMenuItem(title, template);
	closeEditor();
}
function getLayoutFile(){
    //　サーバから伝票レイアウトのバックアップ・ファイルを取り出して復元
    var templateName = document.getElementById("_item").value; // 伝票名
    var filename = document.getElementById("fileNamePop").value; // 日付ファイル名
    var dir = templateName + "/" + filename;

    NRGetArchiveFile(owner(), "FORM", dir, gotLayoutFile);
}

/// neuron.js による処理 /////////
////////////////////////////////



function saveItem(){
	// 表示されているポップアップメニューのアイテム（テンプレート名）をサーバへ登録
	var item = document.getElementById("_item").value; // 伝票名
	if (item.length == 0){
		alert("タイトルが入力されていません");
		return;
	}
	
	setMenuItem(item); // 選択されたメニューアイテムを記憶
	
	// 選択アイテムが存在しなければ登録、存在すれば頻度をインクリメント
	var obj = editObject();
	var value = form2buff(obj, false, formatMode());
	putMenuItem(item, value);
	closeEditor();
}

function closeEditor(){
	// editorBase を隠し formBase を表示
	// editorBase と formBase を見かけ上、入れ替え
    document.getElementById("formBase").style.display = "block";
    document.getElementById("editorBase").style.display = "none";
    document.getElementById("message").innerHTML = "";
}

function form2buff(parentObj, skipNull, formatter){
	// FORM に表示された内容を label(..) の文字列へ展開して返す
	var buff = "";
	var fmt = (formatter) ? formSeparator() : "";
	var fm = (formatter) ? "<br>" : "";
	var i, count = parentObj.children.length;
	for (i=1; i < count; i++){
		var obj = parentObj.children[i];
		var label = obj.label;
		if (obj.hasChild && (obj.hasChild > 0)){
			// 佐々木先生のリクエストにより伝票ごと末尾に改行を入れる
			buff+=label+"("+form2buff(obj,skipNull,formatter)+")\n"+fm;
		} else {
			if (skipNull){
				// FORM 表示の場合 value は obj に記憶していない
				var value =
                document.getElementById(obj.id+".value").value;
				if (value.length > 0){ // value が空のものはスキップ
					// value に unit を埋め込む
					var unit =
					document.getElementById(obj.id+".unit").innerHTML;
					if (unit.length)
						buff += fmt + label + "(" + value + " " + unit + ")";
					else
						buff += fmt + label + "(" + value + ")" ;
				}
			} else {　// FORM 編集の場合 value(実際は range) は obj に記憶
				buff += fmt + label + "(" + obj.value + ")" ;
			}
		}
	}
	return buff;
}

function prevIdOf(cellId){
	// cellId の前の id を返す
	var array = cellId.split(".");
	var lastNum = array[array.length - 1] * 1;
	array[array.length - 1] = (lastNum - 1) + "";
	return array.join(".");
}
function nextIdOf(cellId){
	// cellId の次の id を返す
	var array = cellId.split(".");
	var lastNum = array[array.length - 1] * 1;
	array[array.length - 1] = (lastNum + 1) + "";
	return array.join(".");
}
function addCell(cid){
	// 新しい行を追加
	var tr = document.getElementById("_structure");
	tr.innerHTML = "";
	
	// クリックされた行へ挿入するため、対象 cellId をひとつ前へずらす
	cellId = prevIdOf(cid);
	
	// cellId のセルを削除して再表示
	var _targetId = "";
	var parentObj = addCellForId(editObject(), cellId);
	setEditObject(parentObj); // 構造を記憶
	showStructure(tr, parentObj); // 構造化したものを表示
	
	// 最後に追加された行の label フィールドにフォーカス
	document.getElementById(_targetId+"_name").focus();
	
	function addCellForId(parentCell, cellId){
		// parentCell へ cellId のセルを挿入して返す
		var newCell = new Object();
		newCell.id = parentCell.id;
		newCell.label = parentCell.label;
		newCell.children = new Array();
		newCell.hasChild = (parentCell.hasChild) ? parentCell.hasChild : 0;
		var i, num, count = parentCell.children.length;
		if (count == 0){
			var firstId = parentCell.id+".0";
			if (isSame(firstId, cid)){
				// 新しい行を挿入
				var aCell = new Object();
				aCell.id = parentCell.id+".1";
				_targetId = aCell.id; // 追加された行を記憶
				aCell.label = "";
				aCell.value = "";
				aCell.hasChild = 0;
				aCell.children = new Array();
				newCell.children[0] = aCell;
			}
		}
		
		for (i=num=0; i < count; i++){
			var cell = parentCell.children[i];
			cell.id = parentCell.id + "." + num; // id を付け直す
			if ((cell.hasChild != null) && (cell.hasChild > 0))
				newCell.children[num++] = addCellForId(cell, cellId);
			else
				newCell.children[num++] = cell;
			if (isSame(cell.id, cellId)){
				// 新しい行を挿入
				var aCell = new Object();
				aCell.id = nextIdOf(cellId);
				_targetId = aCell.id; // 追加された行を記憶
				aCell.label = "";
				aCell.value = "";
				aCell.hasChild = 0;
				aCell.children = new Array();
				newCell.children[num++] = aCell;
			}
		}
		return newCell;
	}
}


function removeCell(cellId){
	// cellId の行を削除
	var label = document.getElementById(cellId+"_name").value;
	if (window.confirm(label+" ("+cellId+") を削除しますか　")){
		var tr = document.getElementById("_structure");
		tr.innerHTML = "";
		
		// cellId のセルを削除して再表示
		var parentObj = removeCellForId(editObject(), cellId);
		setEditObject(parentObj); // 構造を記憶
		showStructure(tr, parentObj); // 構造化したものを表示
	}
	
	function removeCellForId(parentCell, cellId){
		// parentCell から cellId のセルを削除して返す
		var newCell = new Object();
		newCell.id = parentCell.id;
		newCell.label = parentCell.label;
		newCell.hasChild = parentCell.hasChild;
		newCell.children = new Array();
		newCell.hasChild = (parentCell.hasChild) ? parentCell.hasChild : 0;
		var i, num, count = parentCell.children.length;
		for (i=num=0; i < count; i++){
			var cell = parentCell.children[i];
			if (isSame(cell.id, cellId)) continue; // item removed
			cell.id = parentCell.id + "." + num; // 削除したため id を付け直す
			if ((cell.hasChild != null) && (cell.hasChild > 0))
				newCell.children[num++] = removeCellForId(cell, cellId);
			else
				newCell.children[num++] = cell;
		}
		return newCell;
	}
}

function setCellValue(cellId){
	// EDITOR: cellId の value を structure 中の object に設定
	var label = document.getElementById(cellId+"_name").value;
	var value = document.getElementById(cellId+"_value").value;
	setValueForId(editObject(), cellId, label, value);
}

function setUnitValue(cellId){
	// EDITOR: cellId の value を structure 中の object に設定
	var label = document.getElementById(cellId+"_name").value;
	var unit = document.getElementById(cellId+"_unit").value;
	var value = document.getElementById(cellId+"_value").value;
	var array = value.split("|");
	array[1] = unit;
	value = array.join("|");
	setValueForId(editObject(), cellId, label, value);
}

function makeEditRecord(tr, objId, label, value){
	// エディターの１行分を作成
	var td = newTD(tr, "valLabel", ""); // objId を表示も可
    td.style.paddingLeft = "5px";
	
	// optionEditor との値受け渡しのためメモリー上に保持
	var hd = newHIDDEN(td, objId+"_value", value); // value:"val|range|menu"
	
	var im = newIMAGE(td, "icon", "./blueGem.png", "X");
	var action = "addCell('" + objId + "')";
	im.setAttribute("onclick", action);
	
	var fd = newFIELD(td, objId+"_name", "", _labelWidth, label);
	var action = "setCellValue('"+objId+"')";
	fd.setAttribute("onchange", action);
	
	var td = newTD(tr, "valRange", "");
    td.style.paddingRight = "5px";
	var fd = newFIELD(td, objId+"_unit", "", _rangeWidth, unitOfRecord(value));
	var action = "setUnitValue('"+objId+"')";
	fd.setAttribute("onchange", action);
	
	//newTEXT(td,value);//===
	
	var im = newIMAGE(td, "icon", "./hammer.png", "X");
	var action = "editOption('"+objId+"')";
	im.setAttribute("onclick", action);
	
	var im = newIMAGE(td, "icon", "./redGem.png", "X");
	var action = "removeCell('"+objId+"')";
	im.setAttribute("onclick", action);
}

function optionOK(cellId){
	// オプション編集ペーンを閉じる
	var label = document.getElementById("_label").value;
	var unit = document.getElementById("_unit").value;
	var val = document.getElementById("_default").value;
	var range = document.getElementById("_range").value;
	var st = document.getElementById("_menuItems").value;
	var array = st.split("\n");
	var menu = array.join(",");
	var value = (val.length + unit.length + range.length + menu.length == 0)
	? "" : val + "|" + unit + "|" + range + "|" +menu;
	
	// object の value を更新
	setValueForId(editObject(), cellId, label, value);
	
	var tr = document.getElementById("_editor"+cellId);
	tr.innerHTML = "";
	makeEditRecord(tr, cellId, label, value);
	setCellValue(cellId);
}

function optionClose(cellId){
	// オプション編集ペーンを閉じる
	var label = document.getElementById("_label").value;
	var value = document.getElementById("_value").value;
	
	var tr = document.getElementById("_editor"+cellId);
	tr.innerHTML = "";
	makeEditRecord(tr, cellId, label, value);
	setCellValue(cellId);
}

function updateMenuForRecord(menu, rec){
	// レコード "50|mg|10..20|menu" に、メニュー "red,#ff0,blue" を追加し
	// "50|mg|10..20|red,#ff0,blue" とする
	var array = rec.split("|");
	if (array.length >= 3)
		array[3] = menu;
	else
		array.push(menu);
	return array.join("|");
}

function removePopUpItem(cellId){
	// オプション・ポップアップの選択されたアイテムを削除
	var selectedItem = document.getElementById("_optionPopUp").value;
	if (selectedItem.length == 0){
		// 最終アイテムは削除できない
		alert("この項目は削除できません");
		return;
	}
	if (window.confirm("("+selectedItem + ") をメニューから削除していいですか")){
		var value = document.getElementById("_value").value; // hidden
		var menu = menuOfRecord(value);
		if (menu == null) return;
		var array = menu.split(",");
		var i, num, count = array.length;
		var narray = new Array();
		for (i=num=0; i < count; i++){
			var item = array[i];
			if (isSame(item, selectedItem)) continue;
			narray[num++] = item;
		}
		menu = narray.join(",");
		document.getElementById("_menu").value = menu;
		document.getElementById("_value").value = updateMenuForRecord(menu, value);
		showOptionPopUp(cellId, menu);
	}
}

function showOptionPopUp(cellId, menu){
	// オプション設定のポップアップメニュー編集ペーンを表示
	var array = (menu != null) ? menu.split(",") : new Array();
	
	var td = document.getElementById("_optionMenuItemArea");
	td.innerHTML = "メニュー";
	td.style.verticalAlign = "top"; // 機能していない
	var array = menu.split(",");
	var buff = array.join("\n");
	var ta = newTEXTAREA(td, "_menuItems", 20, 5, buff);
}

function editOption(cellId){
	// オプション編集ペーンを表示
	// label = "メモ"
	var label = document.getElementById(cellId+"_name").value;
	// value="default|単位|範囲|メニュー項目"
	// ex. "||-|-,,+,+-" あるいは "|mmHg|0..140|"
	var value = document.getElementById(cellId+"_value").value;
	var unit = unitOfRecord(value);
	var menu = menuOfRecord(value);
	if (menu == null) menu = "";
	
	// tr.innerHTML = "" を実行する前に label, unit をメモリー上に確保
	var tr = document.getElementById("_editor"+cellId);
	tr.innerHTML = "";
	
	var td = newTD(tr, "", "");
	td.setAttribute("colspan", "2");
	var hd = newHIDDEN(td, "_label", label);
	var hd = newHIDDEN(td, "_value", value);
	var hd = newHIDDEN(td, "_unit", unit);
	var hd = newHIDDEN(td, "_menu", menu);
	
	var tbl = newTABLE(td, "optionTable");
	
	var tr = newTR(tbl, "optionHeader", label);
	
	var tr = newTR(tbl, "", "");
	var text = "基準値は以下のような形式で入れてください";
	var td = newTD(tr, "optionMessage", text);
	var tr = newTR(tbl, "", "");
	var text = "　範囲指定の場合：最低..最高（数値のみ）";
	var td = newTD(tr, "optionMessage", text);
	var tr = newTR(tbl, "", "");
	var text = "　単一指定の場合：基準値";
	var td = newTD(tr, "optionMessage", text);
	var tr = newTR(tbl, "", "");
	var text = "　複数指定の場合：基準値,基準値,基準値";
	var td = newTD(tr, "optionMessage", text);
	
	var tr = newTR(tbl, "optionFooter", "");
	var td = newTD(tr, "", "default値");
	var val = document.getElementById(cellId+".value").value;
	var fd = newFIELD(td, "_default", "", 25, val);
	
	var tr = newTR(tbl, "optionFooter", "");
	var td = newTD(tr, "", "基準値");
	var fd = newFIELD(td, "_range", "", 25, rangeOfRecord(value));
	
	var tr = newTR(tbl, "", "");
	var text = "ポップアップ・メニューのメニュー項目を１行ずつ入れてください";
	var td = newTD(tr, "optionMessage", text);
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "_optionMenuItemArea", "");
	showOptionPopUp(cellId, menu);
	
	var tr = newTR(tbl, "optionFooter", "");
	var td = newTD(tr, "", "");
	var bt = newDIV(td, "/whiteButton");
    bt.innerHTML = "とりやめ";
	bt.setAttribute("onclick", "optionClose('"+cellId+"')");
	var bt = newDIV(td, "/whiteButton");
    bt.innerHTML = "確定";
	bt.setAttribute("onclick", "optionOK('"+cellId+"')");
}

function showSameEditor(){
	return 1;
}

function showStructure(elm, parentObj){
	// EDITOR: parentObj の構造に従い編集用 FORM を表示
	if (parentObj == null) return;
	
	// 子供グループを表示するテーブル生成
	var tbl = newTABLE(elm, "valueTable");
	
	// cell header を生成
	var tr = newTR(tbl, "valHeader", "");
	// cell header のタイトル名入力部分
	var td = newTD(tr, "", "");
	td.style.padding = "3px 5px";
	if (isSame(parentObj.id, "0")){
		// root object のヘッダー
		var tx = newTEXT(td, parentObj.label);
	} else {
		// root object 以外は変更可能
		var im = newIMAGE(td, "icon", "./blueGem.png", "X");
		var action = "addCell('" + parentObj.id + "')";
		im.setAttribute("onclick", action);
		var fd = newFIELD(td, parentObj.id+"_name", "", 10, parentObj.label);
		var action = "setCellValue('"+parentObj.id+"')";
		fd.setAttribute("onchange", action);
	}
	// cell header の後半部分
	var td = newTD(tr, "valHeaderRight", "");　// parentObj.id を表示も可
    td.style.paddingRight = "5px";
	if (isSame(parentObj.id, "0") == 0){
		// root object 以外は変更可能
		var im = newIMAGE(td, "icon", "./redGem.png", "X");
		var action = "removeCell('"+parentObj.id+"')";
		im.setAttribute("onclick", action);
	}
	
	// 子供 cell を生成
    for (i in parentObj.children){
		var obj = parentObj.children[i];
		var label = trim(obj.label);
		
		if (obj.hasChild == 0){
			// 子供が文字列(value)を持ち、孫(children)を持たない場合
			var tr = newTR(tbl, "_editor"+obj.id, "");
			var value = trim(obj.value);
			if (i == 0){
				// タイトル行を read-only で表示
				var td = newTD(tr, "valTitle", label); // 項目名
				td.style.padding = "0px 30px";
				td.style.textAlign = "left";
				var td = newTD(tr, "valTitle", value); // 単位
				td.style.padding = "0px 30px";
				td.style.textAlign = "right";
			} else {
				// １行分のエレメント作成
				makeEditRecord(tr, obj.id, label, value);
			}
		} else {
			// 子供が孫(children)を持ち、文字列(value)を持たない場合
			var tr = newTR(tbl, "_editor"+obj.id, "");
			showStructure(tr, obj);
		}
	}
	
	// control 行を生成
	var cellId = parentObj.id + "." + parentObj.children.length;
	var objId = cellId; //nextIdOf(cellId);
	
	var tr = newTR(tbl, "valControl", "");
	var td = newTD(tr, "valControLeft", "");
	td.style.height = "15pt";
	td.style.paddingLeft = "5px";
	var im = newIMAGE(td, "icon", "./blueGem.png", "X");
	var action = "addCell('" + objId + "')";
	im.setAttribute("onclick", action);
	
	var td = newTD(tr, "valControRight", ""); // cellId を表示も可
}

function formEditorHelp(){
	// ヘルプをパネル表示
	window.open("./formEditorHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function showEditor(isNew, label){
	// FORM のエディターを開く（isNew が 1 なら空のエディター）
	var item = "";
	var parentObj = buff2cell("0", "伝票構造", "()"); // メニューのバリューを構造化
	if (isNew == 0){ // テンプレートの編集
		document.getElementById("formBase").style.display = "none"; // 表示しない
		document.getElementById("editorBase").style.display = "block";

		var value = form2buff(structure(), false, false);
		//if (isDebugMode()) alert(value);//##
		var obj = buff2cell("0", "", value); // メニューのバリューを構造化
        parentObj = objForLabel(label); // label に相当するオブジェクトを選択
        if (parentObj == null){
            alert(label + " に相当するオブジェクトが見つかりません");
            return;
        }
		item = parentObj.label;
		parentObj.label = "伝票構造";
		parentObj.id = "0";
	}
	setEditObject(parentObj); // 構造を記憶
	
    var elm = document.getElementById("editorBase");
	elm.innerHTML = "";

    // === HEADER =======================
    var div = newDIV(elm, "yellow-bar");
    // --- LEFT SIDE ---
    var dv = newDIV(div, "/left-side");
    dv.style.marginLeft = "5px";
    dv.innerHTML = "伝票編集";
    // --- RIGHT SIDE ---
    var dv = newDIV(div, "/right-side");
    // HELP ICON -- 
	var img = newIMAGE(dv, "", "./Help.png", "?");
	img.style.height = "18px";
	img.setAttribute("onclick", "formEditorHelp()");

	// 編集テーブルを生成
    var div = newDIV(elm, "");
	// テンプレート名
	var fd = newFIELD(div, "_item", "", 18, item);
	var bt = newDIV(div, "/whiteButton");
    bt.innerHTML = "の伝票を削除";
	bt.setAttribute("onclick", "removeItem()");
    bt.style.position = "relative";
    bt.style.top = "1px";
    
    var div = newDIV(elm, "_structure"); // 削除・再生できるよう div 上に以下を構築
	showStructure(div, parentObj); // 構造化したものを表示
	
    // === FOOTER =======================
    var div = newDIV(elm, "yellow-bar");
    // --- RIGHT SIDE ---
    var dv = newDIV(div, "/right-side");
    var sp = newSPAN(dv, "");
    sp.style.paddingRight = "15px";
    sp.style.fontSize = "9pt";
    var a = newA(sp, "バックアップ", "#", "");
    a.innerHTML = "バックアップ";
	a.setAttribute("onclick", "getBackup()");
	var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "とりやめ";
	bt.setAttribute("onclick", "closeEditor()");
    dv.style.width = "300px";
	var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "登録";
	bt.setAttribute("onclick", "saveItem()");
    
    function objForLabel(label){
        // label に相当する obj を返す
        for (num in obj.children){
            var parentObj = obj.children[num];
            if (parentObj.label == label)
                return parentObj;
        }
        return null;
    }
}
