
//////////////////////////////////////////////////////
///// HTTP で受け渡されたパラメータ //////////////////////

var _docInfo;
function getDocInfo(){
    // URL のパラメータがあればそれを解読しオブジェクトに変換して記憶
    var elm = document.getElementById("_value");
    _docInfo = (elm.value) ? decodeSTRING(elm.value) : "";
    
    _debug("== getDocInfo->"+_docInfo); //##
    
    // _docInfo 取得後 elm 削除
    var elm = document.getElementById("_docInfoArea");
    elm.innerHTML = "";
}
function docInfo(){
    // URL に添付されたデータを返す
    return _docInfo;
}

///// HTTP で受け渡されたパラメータ //////////////////////
//////////////////////////////////////////////////////

var _tags;
function tagArray(){
    // DocMaker で使用する DB タグの配列を返す
    if (!_tags){
        _tags = new Array();
        _tags.push("NameSection.patientKanjiName");
        _tags.push("PatientTable.sex");
        _tags.push("PatientTable.birthDate");
        _tags.push("AddressSection.address");
        _tags.push("AddressSection.phone");
        _tags.push("HospitalTable.住所");
        _tags.push("HospitalTable.電話番号");
        _tags.push("HospitalTable.FAX");
        _tags.push("HospitalTable.施設名");
        _tags.push("ProgressSection.object");
    }
    return _tags;
}

var _leftbrackets = "^[^"; // encode 中で使う '('
var _rightbrackets = "^]^"; // encode 中で使う ')'
function decodeObjectNoNest(layer, buff){
	// "key(value)" 形式の文字列を OBJECT に decode して返す
	// ### DocMaker 専用：文書(...) 内で第２層目までネストした decode を行う
	// ### 第２層目のコンテンツ すなわち第３層目には '(...)' が含まれている可能性あり
	// ### またそれ以上分解する必要もないので第３層目は decode せず 文字列そのまま表示
	var obj = new Object();
	var len = buff.length, begin, end;
	var key, value;
	for (var p=begin=nest=0; p < len; p++){
		var ch = buff.charAt(p);
		if (ch == '('){
			if (nest == 0){
				key = trim(buff.substring(begin, p)); // key 終端
				begin = p + 1; // value 開始位置
			}
			nest++;
		} else if (ch == ')'){
			if (--nest == 0){
				if (nest == 0){
					value = buff.substring(begin, p); // value 終端:trim しない
					begin = p + 1; // key 開始位置
				}
				
				if (value.indexOf(")") > 0){ // まだ入れ子になっているなら
					if (layer == 0){
						// 第１層目の "文書(...)" 内はネストする
						obj[key] = decodeObjectNoNest(layer+ 1, value);
					} else {
						// 第２層目では "contents(...)" 内などをネストしない
						obj[key] = value;
					}
				} else {
					// 特定文字を "(", ")" へ戻す
					value = convertSTRING(value, _leftbrackets, "(");
					value = convertSTRING(value, _rightbrackets, ")");
					
					obj[key] = value;
				}
			}
		}
	}
	return obj;
}

var _args;
function setArguments(val){
	if (val){
        _debug("setArguments->"+val); //##
        
		// val = "文書(...)value(some shing)" のような形式
		// ### 通常の decodeObject() を使うと contents などの中にある '(...)' も
		// ### object としてデコードしてしまうので、ネストしないデコードを行う
		var obj = decodeObjectNoNest(0, val);
        _debug("obj->"+encodeObject(obj)); //##
        
		if (obj['文書']){
			// カルテへ添付されたアーカイブは「文書(...)」のように
			// 文書（）でくくられているので、中身の「...」だけを取り出す
			_args = obj['文書'];
		} else
			_args = obj;
	} else
		_args = new Object();
    
    _debug("docObj()->"+_args+"->"+encodeObject(_args)); //##
}
function docObj(){
	// アーカイブとしてカルテへ転写する内容
	return _args;
}

var _docNames;
function setDocNames(array){
	_docNames = array;
}
function docNames(){
	// 文書名の配列
	return _docNames;
}

var _adressees;
function setAddressees(array){
	_adressees = array;
}
function addressee(){
	// 宛名の配列
	return _adressees;
}

var _timeStampStatus;
function setTimeStampStatus(status){
	_timeStampStatus = status;
}
function timeStampStatus(){
	// 年月日を default で本日にするかどうか
	// 文書毎ではなく DocMaker の初期値として記憶される
	return (_timeStampStatus * 1 > 0) ? true : false;
}

/////////////////////////
///// カルテからの継承値 ///
///// NOA へ問い合わせて得る値 /////

function owner(){
    // neuron.js で owner() 定義済みなのでカブらないようにする
	return parent().owner();
}

function patientId(){
    // neuron.js で patientId() 定義済みなのでカブらないようにする
	return parent().patientId();
}

function currentDate(){
    // neuron.js で currentDate() 定義済みなのでカブらないようにする
	return parent().currentDate();
}

function hospitalId(){
    // neuron.js で hospitalId() 定義済みなのでカブらないようにする
	return parent().hospitalId();
}

function patientKanjiName(){
    return _dogTagObj["NameSection.patientKanjiName"];
}
function sex(){
    return _dogTagObj["PatientTable.sex"];
}
function birthDate(){
    return _dogTagObj["PatientTable.birthDate"];
}
function patientAddress(){
    return _dogTagObj["AddressSection.address"];
}
function patientPhone(){
    return _dogTagObj["AddressSection.phone"];
}

function hospitalAddress(){
    return _dogTagObj["HospitalTable.住所"];
}
function hospitalPhone(){
    return _dogTagObj["HospitalTable.電話番号"];
}
function hospitalFAX(){
    return _dogTagObj["HospitalTable.FAX"];
}
function hospitalName(){
    return _dogTagObj["HospitalTable.施設名"];
}

///// カルテからの継承値 ///
/////////////////////////


///////////////////////////
/// Ajax による処理 /////////

var _dataObj;
var _dogTagObj;
function gotDogTag(answer){
    //_debug("=== gotDogTag->"+answer); //##
    
    var obj = JSON.parse(answer);
    _debug("=== gotDogTag"); //##
    //_debug("obj->"+encodeObject(obj)+"<br>"); //##
    
    for (tag in obj){
        var rec = obj[tag];
        _debug(tag+" -> "+rec.value); //##
        _dogTagObj[tag] = rec.value;
    }

    var st = _dogTagObj['ProgressSection.object'];
    if (st && (st.indexOf('<img src=') >= 0)){
        // ### ICON から起動された場合 ###
        var array = st.split('?value=');
        if (array.length > 1){
            var val = array[1];
            var obj = decodeObject(val);
            _dogTagObj.documentName = obj.documentName;
            _dogTagObj.addressee = obj.addressee;
            _dogTagObj.greetings = obj.greetings;
            _dogTagObj.contents = obj.contents;
        }
    } 
    _debug("_dogTagObj-> "+encodeObject(_dogTagObj)); //##

    // サーバからメニュー類のソースをもらった後、ポップアップメニューなどを生成
    getAddressAndDocumentMenu();
}
function getDogTag(){
    // 文書作成で使用するパラメータを _dogTag に記憶
    //_initDebug(true); //##
    _debug("== getDogTag: docInfo->"+docInfo()); //##
    
    _dogTagObj = new Object();
    if (docInfo() && (docInfo().length > 0)){
        // ## ICON から起動された場合の処理 ##
        var obj = decodeObject(docInfo());
        for (key in obj){
            // owner, patientId, currentDate, hospitalId, documentName, addressee, greeting, contents のパラメータを受け取る
            _dogTagObj[key] = decodeParentheses(obj[key]);
        }
        _debug("<p>getDogTag contents->"+_dogTagObj.contents+"</p>"); //##
    }
    
    var own = owner();
    var pid = patientId();
    var date = currentDate();
    var hid = hospitalId();
    _debug("owner->"+owner()); //##
    _debug("patientId->"+patientId()); //##
    _debug("currentDate->"+currentDate()); //##
    _debug("hospitalId->"+hospitalId()); //##
    
    var args = new Object();
    args.owner = own;
    args.patientId = pid;
    args.currentDate = date;
    args.hospitalId = hid;
    args.tags = tagArray().join(","); // "table.field,table.field,,," 型式
    NRCall("GET_VALUE_API", args, gotDogTag);
}

function _sendToNOA(archivedSt){
	// 宛先をメニューに登録
	var bt = document.getElementById("submitButton");
	bt.style.display = "block"; // 表示する
	
	// その後、文書を印刷
	saveAsTemplate();
    
    // ウインドーのサイズと位置を自動記憶
    putWindowSize();
    
    // NOA へドキュメントのアーカイブを返送
    var st = "";
    if (!isSameDate(currentDate(), today()))
        st = "NOA は ** 過去のページ ** ですが、";
    
    // CELL 内容を取り出す
    var tag = "ProgressSection.object";
    var cellVal = _dogTagObj[tag];
    
    cellVal = convertSTRING(cellVal, "\n", "<br>");
    
    //　CELL 内容に archivedStrings() を追加
    if (trim(cellVal).length == 0)
        var result = archivedSt;
    else
        var result = cellVal + "<br>" + archivedSt;
    
    // CELL エディターを開き result を表示
    parent().putValueForTag(result, tag);
}
function savedAsTemplate(answer){
    /* === いちいち表示はうるさいので省略 ===
     var docname = document.getElementById("documentName").value;
     var msg = "文書名：" + docname + " がメニューにない場合、新しい";
     msg += "「文書名と付随するテンプレート」として「文書名」メニューに登録されます";
     alert(st);
     */
}
function saveAsTemplate(){
	// 表示された書式をテンプレートとして登録（既存書式名なら頻度のみインクリメント）
	// 宛先をメニューに登録（宛先が既存なら頻度のみインクリメント）
    var args = new Object();
    args["owner"] = owner();
    args["address"] = document.getElementById("addressee").value;
    args["documentName"] = document.getElementById("documentName").value;
    // 改行はサーバで <br/> へ置換され格納される
    args["contents"] = encodeSTRING(contents());
    
    // alert("saveAsTemplate: PUT_DOCUMENT"); //##
    
    _callServer("PUT_DOCUMENT", "server.php", args, savedAsTemplate);
}
function sendToNOA(){
	// 宛先をメニューに登録
    _sendToNOA(archivedStrings());
}

function sendIconToNOA(){
    // カルテへアイコンとして添付
    // NOA フォーマットにした文書情報
    var obj = new Object();
    
    obj['owner'] = owner(); // 最初に DocMaker を開いた時 dogTag から取得
    obj['patientId'] = patientId(); // 最初に DocMaker を開いた時 dogTag から取得
    obj['currentDate'] = currentDate(); // 最初に DocMaker を開いた時 dogTag から取得
    obj['hospitalId'] = hospitalId(); // 最初に DocMaker を開いた時 dogTag から取得
    obj['documentName'] = document.getElementById("documentName").value;
    obj['addressee'] = document.getElementById("addressee").value;
    
    // データに改行が入っていると DB に収納できないので <br> に変換
    var greetings = document.getElementById("greetings").value;
    // greetings 中の '(',')' を decodeObject で展開されないよう encode
    greetings = encodeParentheses(greetings); // decodeObject で解けないよう encode
    greetings = transferCR(greetings); // 改行 "\n" を "<br>" に変換
    obj['greetings'] = greetings;
    
    var contents = document.getElementById("contents").value;
    // contents 中の '(',')' を decodeObject で展開されないよう encode
    contents = encodeParentheses(contents);
    contents = transferCR(contents); // 改行 "\n" を "<br>" に変換
    obj['contents'] = contents;
    
    var docInfo = encodeObject(obj);
    
    console.log("dragstart->"+docInfo); //##
    
    // NOA フォーマットにした文書を書類アイコンの中に埋込み
    // アイコンをクリックすると DocMaker が立ち上がって書類を復元するようにする
    var imageData = "<img src=\"docSmall.png\" onclick=\"window.open('/DocMaker?value=" + docInfo + "', '_blank')\">";
    
    _sendToNOA(imageData);
}

function printPDF(){
    // 印刷
    
    // ウインドーのサイズと位置を自動記憶
    putWindowSize();
    
    // printDoc.php へ送るオブジェクトを生成
    var obj = new Object();
    obj.documentName = documentTitle();
    obj.addressee = document.getElementById("addressee").value;
    obj.hasPatientInfo = (document.getElementById("hasPatientInfo").checked)
    ? "on" : "";
    obj.isSmallFont = (document.getElementById("isSmallFont").checked)
    ? "on" : "";;
    obj.patientName = document.getElementById("patientName").value;
    obj.sex = document.getElementById("sex").value;
    obj.age = document.getElementById("age").value;
    obj.birthDate = seireki(document.getElementById("birthDate").value);
    obj.patientAddress = document.getElementById("patientAddress").value;
    obj.patientPhone = document.getElementById("patientPhone").value;
    obj.greetings = document.getElementById("greetings").value;
    obj.contents = document.getElementById("contents").value;
    obj.timestamp = document.getElementById("timestamp").value;
    obj.hospitalName = hospitalName();
    obj.hospitalAddress = hospitalAddress();
    obj.hospitalPhone = hospitalPhone();
    obj.hospitalFAX = hospitalFAX();
    obj.hospitalLogo = logoPath(); // ロゴ画像の URL は相対パスの必要あり
    
    //alert("printPDF->"+encodeObject(obj)); //##
    
    // printDoc.php へ送る
    var json = JSON.stringify(obj);
    
    //alert(encodeSTRING(json)); //##
    
    // # などのキャラクターが化けるので encodeSTRING() する
	var url = "./printDoc.php?value=" + encodeSTRING(json);
	
	window.open(url, "PDF", "dependent=yes");
    
    function documentTitle(){
        // documentName の（）でくくられた部分を印刷しない
        var name = document.getElementById("documentName").value;
        var array = name.split('(');
        var title = array[0];
        var array = title.split('（');
        var title = array[0];
        
        return title;
    }
}

function showOverWrite(answer){
    //alert("showOverWrite ===\n"+answer); //##
    window.location.reload();
}
function overWriteTemplate(){
	// 表示されている書式をテンプレートとして登録
	var documentName = document.getElementById("documentName").value;
	if (documentName.length == 0){
		alert("文書名を入力してください");
		return;
	}
	if (!confirm("この内容でテンプレートを上書きしていいですか")) return;
	
	// 既存の書式があれば上書き
    var args = new Object();
    args["owner"] = owner();
    args["address"] = document.getElementById("addressee").value;
    args["documentName"] = documentName;
    args["contents"] = encodeSTRING(contents());
    
    //alert("OVERWRITE_DOCUMENT"); //##
    
    _callServer("OVERWRITE_DOCUMENT", "server.php", args, showOverWrite);
}

function setTemplate(answer){
    //alert("setTemplate->"+answer); //##
    
    document.getElementById("addressee").value = "";
    document.getElementById("greetings").value = "";
    var td = document.getElementById("patientInfoArea");
    setHasPatientInfo(true);
    document.getElementById("contents").value = "";
    var buff = trim(answer);
    if (buff.length){
        buff = transferCR(buff); // 念のため
        //alert("buff->"+buff); //##
        
        var obj = eval('(' + buff + ')');
        var greetings = obj['greetings'];
        greetings = transferToCR(greetings);
        document.getElementById("greetings").value = greetings;
        var td = document.getElementById("patientInfoArea");
        var status = (obj['haPatInfo'] && obj['haPatInfo'].length)
        ? true : false;
        setHasPatientInfo(status);
        var contents = obj['contents'];
        contents = transferToCR(contents);
        document.getElementById("contents").value = contents;
    }
}
function getTemplate(documentName){
	// 選択された文書名に相当するテンプレートをサーバへリクエスト
    var args = new Object();
    args["owner"] = owner();
    args["documentName"] = document.getElementById("documentName").value;
        
	_callServer("GET_TEMPLATE", "server.php", args, setTemplate)
}

function gotMenu(answer){
    var obj = JSON.parse(answer); // 宛先メニュー内容
    //alert("gotMenu: obj ->"+encodeObject(obj)); //##
    
    setAddressees(getKeys(obj.documentAddress));
    setDocNames(getKeys(obj.documentName));
    setTimeStampStatus(obj.timeStampStatus);
    
    makeDocumentSelector();
    makeAdresseeSelector();
    makePatientInfo();
    
    makeHospitalInfoArea();
    
    //alert("<p>_dogTagObj ->"+encodeObject(_dogTagObj)+"</p>"); //##
    
    // docValue でのデータ渡しなら以下の情報を表示
    var name = (_dogTagObj.documentName) ? _dogTagObj.documentName : "";
    document.getElementById("documentName").value = name;
    
    var addressee = (_dogTagObj.addressee) ? _dogTagObj.addressee : "";
    document.getElementById("addressee").value = addressee;
    
    var greetings = (_dogTagObj.greetings) ? _dogTagObj.greetings : "";
    greetings = transferToCR(greetings); // <br> を改行に変換
    document.getElementById("greetings").value = greetings;
    
    var contents = (_dogTagObj.contents) ? _dogTagObj.contents : "";
    contents = transferToCR(contents); // <br> を改行に変換
    document.getElementById("contents").value = contents;
    
	function getKeys(obj){
		// obj から key の配列を返す
		var array = [""];
		for (key in obj) array.push(key);
		return array;
	}
}
function getAddressAndDocumentMenu(){
	// 宛先メニューと文書メニューをサーバへリクエスト
    _debug("getAddressAndDocumentMenu->"+owner()); //##
    var args = new Object();
    args["owner"] = owner();
        
	_callServer("GET_MENU", "server.php", args, gotMenu);
}

function removedAddressItem(answer){
    //alert("removedAddressItem ---\n"+answer); //##
    window.location.reload();
}
function removeAddressItem(){
	// 宛先の削除をサーバへリクエスト
	var item = document.getElementById("addressee").value;
	if (item.length == 0) return;
	
	if (confirm("「" + item + "」を宛名リストから削除して良いですか")){
		// item の削除をサーバへ登録依頼
        var args = new Object();
        args["tag"] = "UniversalSection.documentAddress";
        args["address"] = item;
        
        _callServer("REMOVE_MENU_ITEM", "server.php", args, removedAddressItem);
	}
}

function removedDocumentItem(answer){
    //alert("removedAddressItem ---\n"+answer); //##
    window.location.reload();
}
function removeDocumentItem(){
	// 文書の削除をサーバへリクエスト
	var item = document.getElementById("documentName").value;
	if (item.length == 0) return;
	
	if (confirm("「" + item + "」を文書リストから削除して良いですか")){
		// item の削除をサーバへ登録依頼
        var args = new Object();
        args["tag"] = "UniversalSection.documentName";
        args["address"] = item;
        
        _callServer("REMOVE_MENU_ITEM", "server.php", args, removedDocumentItem);
	}
}

function puttedTimeStampSetting(answer){
    //alert("puttedTimeStampSetting ---\n"+answer); //##
}
function putTimeStampStatus(status){
	// タイムスタンプをカルテ日付にするか当日日付にするかの設定をサーバへ記憶
    var args = new Object();
    args["menu"] = "DocMaker.timeStampStatus";
    args["owner"] = owner();
    args["val"] = status;
    
    _callServer("PUT_MENU", "server.php", args, puttedTimeStampSetting);
}

/// LOGO /////////

var _logoPath;
function getLogoPath(imageElement){
    // imageElement：<"img src="path"> から path を取り出して記憶
    _logoPath = "";
    var array = imageElement.split("src='");
    if (array.length > 1){
        var st = array[1];
        var ary = st.split("'");
        _logoPath = ary[0];
    }
    //alert("getLogoPath->"+imageElement+" ("+_logoPath+")"); //##
}
function logoPath(){
    return _logoPath;
}

function gotImage(answer){
    //alert("gotImages ->"+answer);//##
    
    var value = answer;
    getLogoPath(value);
    
    var elm = document.getElementById("logoArea");
    if (value.length > 0){
        // ロゴを表示
        elm.innerHTML = value;
    } else {
        // 登録ボタンを表示
        elm.innerHTML = "";
        var dummyLogo = newDIV(elm, "/dummyLogo");
        dummyLogo.innerHTML = "ロゴ登録";
    }
    
    closeFloatPanel();
}
function getImage(){
    // 画像ファイルをサーバへリクエスト
    var args = new Object();
    args["owner"] = owner();
    
    _postServer("GET_IMAGE", "pictServer.php", args, gotImage);
}

function removedImage(answer){
    //alert("removedImage ===\n"+answer);//##
    
    getImage();
    closeFloatPanel();
}
function removeImage(){
    // ロゴ画像をサーバから削除
    if (!confirm("ロゴを削除していいですか")) return;
    
    var args = new Object();
    args["owner"] = owner();
    
    _postServer("REMOVE_IMAGE", "pictServer.php", args, removedImage);
}

/// Ajax による処理 /////////
///////////////////////////



////////////////////////////////////////////
/// localStorage ///////////////////////////

function getWindowSize(){
	// Booking のウインドー位置とサイズをサーバへリクエスト
    var size = window.localStorage["docMakerWindowSize"];
    
	// サーバから得られたサイズにウインドーを調整する
	if (size){
		var args = size.split(",");
		var x = args[0] * 1;
		var y = args[1];
		var w = args[2];
		var h = args[3];
		// resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
		// としてもウインドー境界の制限で移動できない場合がある
		window.resizeTo(w, h);
		window.moveTo(x, y);
	}
}
function putWindowSize(){
    // docMake のウインドー位置とサイズをサーバへ記憶
    put_windowSize(0, -22, "docMakerWindowSize");

    showFadeoutInfo("_message", "ウィンドー・サイズを記憶しました", 800);
}

function setDocMakerDebug(elm){
    var status = (elm.checked) ? "1" : "";
    window.localStorage["docMakerDebug"] = status;
}
function docMakerDebug(){
    // デバッグ・ステータスを返す
    return (window.localStorage["docMakerDebug"]) ? 1 : 0;
}

function setFromAddress(){
    // メールの From アドレスを記憶
    window.localStorage["fromAddress"] = document.getElementById("from").value;
}
function fromAddress(){
    return (window.localStorage["fromAddress"]) ? window.localStorage["fromAddress"] : "";
}

/// localStorage ///////////////////////////
////////////////////////////////////////////


function contents(){
	// サーバへ送るデータ・パッケージを作成して返す
	// contents 中の改行は server.php で "<br/>" に置換されて DB に格納される
	var status = (document.getElementById("hasPatientInfo").checked)
    ? "on" : "";
	return "{"
	+ '"greetings":"' + document.getElementById("greetings").value + '",'
	+ '"haPatInfo":"' + status + '",'
	+ '"contents":"' + document.getElementById("contents").value + '"}';
}

function archivedData(){
	// サーバへ送るデータ・パッケージを作成して返す
	// contents 中の改行は server.php で "<br/>" に置換されて DB に格納される
	var json = "{"
	+ '"greetings":"' + document.getElementById("greetings").value + '",'
	+ '"haPatInfo":"' + document.getElementById("hasPatientInfo").value + '",'
	+ '"contents":"' + document.getElementById("contents").value + '"}';
	
	return document.getElementById("address").value + "_|_"
	+ document.getElementById("documentName").value + "_|_"
	+ json + "_|_";
}

function makePopupItems(){
	// addressPopup のコンテンツを作成
	var records = tableArray();
	var st = "<INPUT type=checkbox onclick=clickedBox(this) id=active checked>"
	+ "<select id=popup onclick=popupClicked(this)>";
	var i, count = records.length;
	for (i=0; i < count; i++){
		var recObj = records[i];
		var name = recObj.name;
		st += "<option value=\""+name+"\">"+name;
	}
	st += "</select>";
	st += " <font size=-2 color=blue onclick=man()><U>能書</U></font>";
	_isActive = 1;
	
	document.getElementById("addressPopup").innerHTML = st;
}

function addressClicked(){
	// 宛先ポップアップがクリックされた
	var selectedItem = document.getElementById("addresMenu").value;
	document.getElementById("addressee").value = selectedItem;
}

function docClicked(elm){
	// 文書ポップアップがクリックされた
	var selectedItem = elm.value;
	document.getElementById("documentName").value = selectedItem;
	// 選択された文書名に相当するテンプレートをサーバへリクエストし表示
	getTemplate(selectedItem);
}

function setHasPatientInfo(status){
	// 患者情報表示チェックボックスのステータスを設定
	var checkbox = document.getElementById("hasPatientInfo");
	checkbox.checked = status;
	togglePatientInfo(checkbox);
}
function togglePatientInfo(elm){
	// 患者情報表示チェックボックスのチェックにより toggle
	var td = document.getElementById("patientInfoArea");
	toggleView(td, elm.checked);
}

function checkToday(elm){
	// 本日の日付に設定がチェックされた
	var date = (elm.checked) ? today() : currentDate();
	var array = date.split(" ");
	date = yyyymmdd(date); // "2010-12-31 17:48:29" を "2010-12-31" にする
	document.getElementById("timestamp").value = wareki(date);
    
	// 設定をサーバへ記憶
	var status = (elm.checked) ? "1" : "0";
	putTimeStampStatus(status);
}

function removeArchive(){
	// アーカイブを読込む
	document.getElementById("output").value = "";
	document.getElementById("output").focus();
}

function archivedDocument(){
	// 文書をアーカイブして返す
    _debug("== archivedDocument"); //##
	var obj = new Object();
	obj['documentName'] = document.getElementById("documentName").value;
	// ## 旧バージョンとの互換性のため adressee でなく address を使う ##
	obj['address'] = document.getElementById("addressee").value;
	var wareki = document.getElementById("timestamp").value;
	obj['entryDate'] = seireki(wareki);
	var status = document.getElementById("hasPatientInfo").checked;
	obj['hasPatientInfo'] = (status) ? "on" : "";
	if (status){
		obj['patientName'] = document.getElementById("patientName").value;
		obj['birthDate'] = seireki(document.getElementById("birthDate").value);
		obj['sex'] = document.getElementById("sex").value;
		obj['patientAddress'] = document.getElementById("patientAddress").value;
		obj['patientPhone'] = document.getElementById("patientPhone").value;
	}
    // 挨拶文
	var st = document.getElementById("greetings").value;
    st = encodeParentheses(st); // '(',')' を decodeObject で展開されないよう encode
    st = transferCR(st); // 改行 "\n" を "<br>" に変換
	obj['greetings'] = st;
    // 本文
	var st = document.getElementById("contents").value;
    st = encodeParentheses(st); // '(',')' を decodeObject で展開されないよう encode
    st = transferCR(st); // 改行 "\n" を "<br>" に変換
	obj['contents'] = st;
    
    _debug("obj->"+encodeObject(obj)+"<br>"); //##
	
	return encodeObject(obj);
}
function archivedStrings(){
	// 文書をアーカイブして返す
	return "文書(" + archivedDocument() + ")";
}

function decodeDocArchive(obj){
    // obj を文書に復元
	if (! obj) obj = new Object();
    
    _debug("decodeDocArchive->"+encodeObject(obj)); //##
    
	// 文書選択
	var documentName = (obj.documentName) ? obj.documentName : "";
	document.getElementById("documentName").value = documentName;
    
	// 宛先情報
	var addressee = (obj.address) ? obj.address : "";
	document.getElementById("addressee").value = addressee;
	
	// 患者情報
	setHasPatientInfo(true);
	var val = (obj.patientName) ? obj.patientName : "";
	document.getElementById("patientName").value = val;
	var val = (obj.sex) ? obj.sex : "";
	document.getElementById("sex").value = val;
	var val = (obj.birthDate) ? obj.birthDate : "";
	document.getElementById("birthDate").value = wareki(val);
	//alert(val+"->"+age(val)); //##
	document.getElementById("age").value = age(val);
	var val = (obj.patientAddress) ? obj.patientAddress : "";
	document.getElementById("patientAddress").value = val;
	var val = (obj.patientPhone) ? obj.patientPhone : "";
	document.getElementById("patientPhone").value = val;
	
	// 挨拶文
	var greetings = (obj.greetings) ? obj.greetings : "";
    greetings = transferToCR(greetings); //  "<br>" を改行 "\n" に変換
    greetings = decodeParentheses(greetings); //  "(" ")" を decode
	document.getElementById("greetings").value = greetings;
    
    _debug("decodeDocArchive->"+encodeObject(obj)); //##
    _debug("contents->"+obj.contents); //##
	
	// 本文
	var contents = (obj.contents) ? obj.contents : "";
    contents = transferToCR(contents); // <br> を改行に変換
    contents = decodeParentheses(contents); //  "(" ")" を decode
	document.getElementById("contents").value = contents;
	
	// 日付欄
	var val = (obj.entryDate) ? obj.entryDate : currentDate();
	document.getElementById("timestamp").value = wareki(val);
	
	// 印刷ボタン:SubmitButton を消す
	//var bt = document.getElementById("submitButton");
	//bt.style.display = "none"; // 表示しない
    
	// アーカイブパネルを削除
	closeFloatPanel();
}
function loadArchive(){
	// アーカイブを読込む
    
	// 各フィールドへ docObj() の値を埋め込む
	setArguments(document.getElementById("output").value);
    
    // obj を文書に復元
    decodeDocArchive(docObj());
}

function sendMailDone(answer){
    alert("=== 以下の文書がメールで発出されました ===\n"+answer);//##
    /*
	// サーバから返された処理を実行
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		alert("=== 以下の文書がメールで発出されました ===\n"+value);//##
	}*/
}
function sendMail(value){
    // buff をメールで送る
    var from = document.getElementById("from").value;
    var to = document.getElementById("to").value;
    var subject = document.getElementById("subject").value;
    var contents = document.getElementById("mailContents").value;
    if (from.length == 0){ alert("From を記入してください"); return; }
    if (to.length == 0){ alert("To を記入してください"); return; }
    if (subject.length == 0){ alert("Subject を記入してください"); return; }
    if (contents.length == 0){ alert("メール本文を記入してください"); return; }

    var args = new Object();
    args["from"] = encodeSTRING(from);
    args["to"] = encodeSTRING(to);
    args["subject"] = encodeSTRING(subject);
    args["message"] = encodeSTRING(contents);
    
    _postServer("POST_MAIL", "postServer.php", args, sendMailDone);
}

function postMail(){
    // 文書をメールで送付
	var elm = document.getElementById("_floatPanel");
	if (elm.innerHTML.length){
		// パネルが既に表示されていればトグル式に閉じる
		closeFloatPanel();
		return;
	}
	
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "outputTable");
	tbl.style.backgroundColor = "#ff0";
    
    // FROM
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.style.paddingLeft = "10px";
    var from = "";
    var fd = newFIELD(td, "from", "From ", 50, fromAddress());
    fd.setAttribute("onchange", "setFromAddress()");
    fd.setAttribute("placeholder", "発信元メール・アドレスを入れてください"); // 入力ヒントを表示
    fd.style.padding = "0 5px";
    
    // TO
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.style.paddingLeft = "10px";
    var fd = newFIELD(td, "to", "To ", 50, "");
    fd.setAttribute("placeholder", "送信先メール・アドレスを入れてください"); // 入力ヒントを表示
    fd.style.padding = "0 5px";
    
    // SUBJECT
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.style.paddingLeft = "10px";
    var fd = newFIELD(td, "subject", "Subject ", 70, "");
    fd.setAttribute("placeholder", "メールの表題を入れてください"); // 入力ヒントを表示
    fd.style.padding = "0 5px";
    
    // CONTENTS
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.style.paddingLeft = "10px";
	td.style.paddingBottom= "10px";
	var ta = newTEXTAREA(td, "mailContents", 70, 30, mailStrings());
    ta.style.padding = "5px";
	
    // 送信ボタン
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.style.textAlign = "right";
	td.style.paddingRight = "10px";
    var bt = newBUTTON(td, "", "メールで送信");
    bt.setAttribute("onclick", "sendMail()");
    
	// 最上部に開いた infoTip が見えないことがあるので最上部へスクロールしておく
	window.scroll(0, 0);
	openFloatPanel(tbl, 15, 65, "メール送信パネル");
    
    function mailStrings(){
        // 文書をメール型式にする
        var array = new Array();
        // セパレータ
        array.push(separator());
        // 文書名
        var docName = document.getElementById("documentName").value;
        var date = document.getElementById("timestamp").value;
        array.push( docName + "　" + date );
        array.push("");
        // 宛先
        var status = document.getElementById("hasPatientInfo").checked;
        if (status){
            array.push( "　氏名： " + document.getElementById("patientName").value );
            var st = "　生年月日： " + document.getElementById("birthDate").value;
            st += "　( 性別： " + document.getElementById("sex").value + " )";
            st += "　年齡 " + document.getElementById("age").value + " 歳";
            array.push( st );
            array.push( "　住所： " + document.getElementById("patientAddress").value );
            array.push("");
            array.push("");
        }
        var buff = array.join("\n");
        // 挨拶文
        buff += document.getElementById("greetings").value;
        buff += "\n\n";
        // 本文
        buff += document.getElementById("contents").value;
        buff += "\n\n";
        // 施設名
        buff += hospitalName() + "　" + hospitalAddress();
        buff += "\n";
        buff += "電話： " + hospitalPhone() + "　FAX: " + hospitalFAX();
        buff += "\n";
        // 医師名
        buff += "医師: " + parent().userName();
        buff += "\n";
        // セパレータ
        buff += separator() + "\n";
        
        return buff;
        
        
        function separator(){
            var st = "";
            for (var i=0; i < 40; i++)
                st += "-";
            return st;
        }
    }
}

function showArchive(){
	// 文書のアーカイブを表示：トグル式
	var elm = document.getElementById("_floatPanel");
	if (elm.innerHTML.length){
		// パネルが既に表示されていればトグル式に閉じる
		closeFloatPanel();
		return;
	}
	
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "outputTable");
	tbl.style.backgroundColor = "#ff0";
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.style.paddingTop = "5px";
	td.style.paddingLeft = "10px";
	var tx = newTEXT(td, " 文書アーカイブ表示欄　");
	var bt = newBUTTON(td, "", "空欄");
	bt.setAttribute("onclick", "removeArchive()");
	var bt = newBUTTON(td, "", "文書へ復元");
	bt.setAttribute("onclick", "loadArchive()");
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.style.paddingLeft = "10px";
	td.style.paddingBottom= "10px";
	var ta = newTEXTAREA(td, "output", 70, 30, archivedStrings());
	
	// 最上部に開いた infoTip が見えないことがあるので最上部へスクロールしておく
	window.scroll(0, 0);
	openFloatPanel(tbl, 15, 65, "アーカイブ表示パネル");
}

function selectedAddress(elm){
    // 入力された文字列でメニュー内容を絞り込む
    var key = elm.value;
    var array = addressee();
    if (key){
        // key があればメニューを key を含むものに絞り込み
        var items = [""];
        for (num in array){
            // key を含むものに絞り込み
            var item = array[num];
            var ary = item.split(key);
            if ((item == key) || (ary.length > 1))
                items.push(item);
        }
    } else
        items = array;
    
    var sp = document.getElementById("addressPopupArea");
    sp.innerHTML = "";
    var address = (docObj().address) ? docObj().address : "";
    var pu = newPopupMenu(sp, "addresMenu", items, address);
    pu.setAttribute("onchange", "addressClicked()");
}

function makeDocumentSelector(){
    // 文書選択エリアを生成
    var docName = (docObj().documentName) ? docObj().documentName : "";
    var elm = document.getElementById("docMenuArea");
    
    // 文書選択ポップアップを生成
    var pu = newPopupMenu(elm, "docMenu", docNames(), docName);
    pu.setAttribute("onchange", "docClicked(this)");
    
    // 文書名を表示
    document.getElementById("documentName").value = docName;
}

function makeAdresseeSelector(){
    // 宛先選択エリアを生成
    var items = addressee();
        
    var td = document.getElementById("addressArea");
    td.innerHTML = "";
    var tbl = newTABLE(td, "docTable");
    var tr = newTR(tbl,"","");
    
    var td = newTD(tr, "", "宛　先 ");
    var sp = newSPAN(td, "addressPopupArea");
    var address = (docObj().address) ? docObj().address : "";
    var pu = newPopupMenu(sp, "addresMenu", items, address);
    pu.setAttribute("onchange", "addressClicked()");
    
    var fd = newFIELD(td, "addressee", "", 30, address);
    fd.setAttribute("NAME", "addressee"); // form で送られるパラメータ
    fd.setAttribute("onchange", "selectedAddress(this)");
    
    // メニューから削除
    var spn = newSPAN(td, "removeAddressIcon");
    spn.style.color = "#aaa";
    spn.style.paddingLeft = "5px";
    spn.setAttribute("onclick", "removeAddressItem()");
    setInfoTip("removeAddressIcon", "選択項目をメニューから削除"); // HELP
    var img = newIMAGE(spn, "", "remove-field.png", "remove");
    img.style.width = "10px";
}

function makePatientInfo(){
    // 患者情報エリアの生成
    var elm = document.getElementById("patientArea");
    elm.innerHTML = "";
    var table = newTABLE(elm, "");
    table.style.width = "100%";
    
    var tr = newTR(table, "", "");
    var td = newTD(tr, "", "");
    td.style.fontSize = "9pt";
    var cb = newCHECKBOX(td, "hasPatientInfo", "患者情報表示", 1);
    cb.setAttribute("NAME", "hasPatientInfo"); // form で送られるパラメータ
    cb.setAttribute("onclick", "togglePatientInfo(this)");
    
    // 患者情報エリア
    var tr = newTR(table, "", "");
    var td = newTD(tr, "patientInfoArea", "");
    var tbl = newTABLE(td, "patientInfoTable");
    
    // 氏名
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "", "");
    var name = (patientKanjiName()) ? patientKanjiName() : "";
    var fd = newFIELD(td, "patientName", "氏名", 30, name);
    fd.setAttribute("NAME", "patientName"); // form で送られるパラメータ
    // 性別
    var sx = (sex()) ? sex() : "女";
    var fd = newFIELD(td, "sex", "性別", 4, sx);
    fd.setAttribute("NAME", "sex"); // form で送られるパラメータ
    // 生年月日は西暦で "2008-4-29" 形式のこと
    var bdate = wareki(birthDate());
    var fd = newFIELD(td, "birthDate", "生年月日", 15, bdate);
    fd.setAttribute("NAME", "birthDate"); // form で送られるパラメータ
    // 年令
    var array = birthDate().split("-");
    var anAge = age(array[0],array[1],array[2]);
    var fd = newFIELD(td, "age", "年齢", 3, anAge);
    fd.setAttribute("NAME", "age"); // form で送られるパラメータ
    // 患者住所
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "", "");
    var address = (patientAddress()) ? patientAddress() : "";
    var fd = newFIELD(td, "patientAddress", "住所", 75, address);
    fd.setAttribute("NAME", "patientAddress"); // form で送られるパラメータ
    // 患者電話
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "", "");
    var phone = (patientPhone()) ? patientPhone() : "";
    var fd = newFIELD(td, "patientPhone", "電話", 75, phone);
    fd.setAttribute("NAME", "patientPhone"); // form で送られるパラメータ
}

/////////////////////////////////////
///// LOGO //////////////////////////

function upload(){
    // form を submit
    var submitButton = document.getElementById("uploadForm");
    submitButton.submit();
    
    setTimeout(getImage, 3000);
}

function openLogoPanel(button){
    // ロゴ登録パネルを開く
    var pos = getPosition(button);
    var w = 300;
	var x = 15; // 表示するx座標
	var y = pos.y - 100; // 表示するy座標
    var elm = openSeeThroughPanel("_floatPanel", x, y, w);
    var div = newDIV(elm, "logoPanelArea");
    div.style.padding = "5px 5px 0 5px";
    div.style.fontSize = "9pt";
    
    var dv = newDIV(div, "");
    
    // === FORM を生成 =============================
    var fm = newFORM(dv, "pictServer.php"); // submit で起動される URL
    fm.setAttribute("id", "uploadForm");
    // ### iframe を使うにはここがキモ ###
    fm.setAttribute("target", "iframeElement"); // iframe を指定
    
    // === ファイル選択ボタン ========================
    var dv = newDIV(fm, "file");
    var bt = newUploadBUTTON(dv, "imageFile", "files[]");
    bt.setAttribute("onclick", "putWindowSize()");
    
    // === 転送データのコンテナー =====================
    // key
    var fd = newFIELD(fm, "key", "", "", "SAVE_IMAGE");
    fd.setAttribute("NAME", "command"); // form で送られるパラメータ
    fd.setAttribute("type", "hidden");
    // imageId
    var fd = newFIELD(fm, "owner", "", "", owner());
    fd.setAttribute("NAME", "owner"); // form で送られるパラメータ
    fd.setAttribute("type", "hidden");
    
    // === アップロード・ボタン =======================
    // ### iframe を使うにはここがキモ ###
    // form を見せない形で処理するため submit-button 機能を別に作成
    var dv = newDIV(div, "");
    dv.style.marginLeft = "3px";
    dv.style.marginBottom = "10px";
    var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "画像読込み";
    bt.setAttribute("onclick", "upload()");
    
    // === ロゴ削除ボタン ===========================
    var dv = newDIV(div, "");
    dv.style.marginLeft = "3px";
    dv.style.marginBottom = "10px";
    dv.setAttribute("onclick", "removeImage()");
    var spn = newSPAN(dv, "/removeLogoButton");
    var img = newIMAGE(spn, "", "remove-field.png", "remove");
    img.style.width = "12px";
    var sp = newSPAN(spn, "");
    sp.innerHTML = " ロゴを削除";
    
    // === データ戻り先として iframe を作成 ===========
    // ### iframe を使うにはここがキモ ###
    var dv = newDIV(div, "");
    dv.style.display = "none"; // 表示しない
    var fr = newIFRAME(dv, "iframeElement");
}

///// LOGO //////////////////////////
/////////////////////////////////////


function makeHospitalInfoArea(){
    // 施設情報エリアの生成
    _debug("=== makeHospitalInfoArea =============="); //##
    
    var elm = document.getElementById("hospitalInfoArea");
    elm.innerHTML = "";
    var table = newTABLE(elm, "");
    table.style.width = "100%";
    var tr = newTR(table, "", "");
    
    // 左エリア ===================
    var dateStatus = timeStampStatus();
    var date = (dateStatus) ? todayAndTime() : currentDate();
    _debug("date->"+date); //##
    
    date = yyyymmdd(date);
    var td = newTD(tr, "", "");
    td.style.verticalAlign = "top";
    var htbl = newTABLE(td, "hospTable");
    htbl.style.fontSize = "11px";
    _debug("makeHospitalInfoArea->"+date); //##
    
    // 日付欄
    var tr2 = newTR(htbl, "", "");
    var td = newTD(tr2, "", "");
    td.style.verticalAlign = "top";
    var fd = newFIELD(td, "timestamp", "", 16, wareki(date));
    fd.setAttribute("NAME", "timestamp"); // form で送られるパラメータ
    var cb = newCHECKBOX(td, "dateCheckBox", "本日の日付に設定", dateStatus);
    cb.setAttribute("onchange","checkToday(this)");
    // フォント指定欄
    var tr2 = newTR(htbl, "", "");
    var td = newTD(tr2, "", "");
    td.style.verticalAlign = "top";
    var cb = newCHECKBOX(td, "isSmallFont", "小さいフォントサイズで印刷", 0);
    cb.setAttribute("NAME", "isSmallFont"); // form で送られるパラメータ
    // ロゴの設定
    var tr2 = newTR(htbl, "", "");
    var td = newTD(tr2, "", "");
    td.style.verticalAlign = "top";
    var dv = newDIV(td, "logoArea");
    dv.setAttribute("onclick", "openLogoPanel(this)"); // ロゴ登録パネルを開く
    var dummyLogo = newDIV(dv, "/dummyLogo");
    
    // 右エリア =======================
    var td = newTD(tr, "", "");
    var htbl = newTABLE(td, "hospTable");
    // 施設情報
    var tr = newTR(htbl, "", "");
    var td = newTD(tr, "", "");
    var fd = newFIELD(td, "", "", 40, hospitalName());
    fd.setAttribute("NAME", "hospitalName"); // form で送られるパラメータ
    fd.setAttribute("Readonly","true"); // form で送られるパラメータ
    fd.style.backgroundColor = "#a7e6d7";
    fd.style.border = "thin solid #a7e6d7";
    var tr = newTR(htbl, "", "");
    var td = newTD(tr, "", "");
    var fd = newFIELD(td, "", "", 40, hospitalAddress());
    fd.setAttribute("NAME", "hospitalAddress"); // form で送られるパラメータ
    fd.setAttribute("Readonly","true"); // form で送られるパラメータ
    fd.style.backgroundColor = "#a7e6d7";
    fd.style.border = "thin solid #a7e6d7";
    var tr = newTR(htbl, "", "");
    var td = newTD(tr, "", "");
    var fd = newFIELD(td, "", "", 40, "TEL: "+hospitalPhone());
    fd.setAttribute("NAME", "hospitalPhone"); // form で送られるパラメータ
    fd.setAttribute("Readonly","true"); // form で送られるパラメータ
    fd.style.backgroundColor = "#a7e6d7";
    fd.style.border = "thin solid #a7e6d7";
    var tr = newTR(htbl, "", "");
    var td = newTD(tr, "", "");
    var fd = newFIELD(td, "", "", 40, "FAX: "+hospitalFAX());
    fd.setAttribute("NAME", "hospitalFAX"); // form で送られるパラメータ
    fd.setAttribute("Readonly","true"); // form で送られるパラメータ
    fd.style.backgroundColor = "#a7e6d7";
    fd.style.border = "thin solid #a7e6d7";
    
    // ロゴ・イメージをサーバへリクエスト
    getImage();
}

function dragstart(event){
    // 書類アイコンのドラッグ開始処理
    // ドラッグするデータをDataTransferオブジェクトにセット
    // NOA フォーマットにした文書情報
    var obj = new Object();
    
    obj['owner'] = owner(); // 最初に DocMaker を開いた時 dogTag から取得
    obj['patientId'] = patientId(); // 最初に DocMaker を開いた時 dogTag から取得
    obj['currentDate'] = currentDate(); // 最初に DocMaker を開いた時 dogTag から取得
    obj['hospitalId'] = hospitalId(); // 最初に DocMaker を開いた時 dogTag から取得
    obj['documentName'] = document.getElementById("documentName").value;
    obj['addressee'] = document.getElementById("addressee").value;
    
    // データに改行が入っていると DB に収納できないので <br> に変換
    var greetings = document.getElementById("greetings").value;
    // greetings 中の '(',')' を decodeObject で展開されないよう encode
    greetings = encodeParentheses(greetings); // decodeObject で解けないよう encode
    greetings = transferCR(greetings); // 改行 "\n" を "<br>" に変換
    obj['greetings'] = greetings;
    
    var contents = document.getElementById("contents").value;
    // contents 中の '(',')' を decodeObject で展開されないよう encode
    contents = encodeParentheses(contents);
    contents = transferCR(contents); // 改行 "\n" を "<br>" に変換
    obj['contents'] = contents;
    
    var docInfo = encodeObject(obj);
    
    //alert("dragstart->"+docInfo); //##
    
    // NOA フォーマットにした文書を書類アイコンの中に埋込み
    // アイコンをクリックすると DocMaker が立ち上がって書類を復元するようにする
    var imageData = "<img src=\"docSmall.png\" onclick=\"window.open('/DocMaker?value=" + docInfo + "', '_blank')\">";
    
    //alert("imageData->"+encodeSTRING(imageData)); //##
    
    event.dataTransfer.setData("text", encodeSTRING(imageData));
    
    // 文書名・宛先・テンプレートを保存
	saveAsTemplate();
}

function help(html){
	window.open(html,"Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initDocMaker(){
    // 画面を生成
    //_initDebug(true); //##
    
    // docInfo を取得後 TEXTAREA を削除
    getDocInfo(); //### ICON から起動された場合に必要
    
	setArguments("");
    
    var base = document.getElementById("base");
    
    // HEADER: 文書選択エリア ================================
    var div = newDIV(base, "/tool-header");
    div.style.backgroundColor = "#a7e6d7";
    div.style.paddingTop = "10px";
    // -- LEFT ------------
    var dv = newDIV(div, "/left-side");
    dv.style.width = "80%";
    // ラベル
    var sp = newSPAN(dv, "");
    sp.innerHTML = "文書名";
    sp.style.padding = "0 5px";
    sp.style.fontSize = "9pt";
    // 文書選択ポップアップ
    var sp = newSPAN(dv, "docMenuArea");
    // 文書名
    var fd = newFIELD(dv, "documentName", "", 30, "");
    fd.setAttribute("NAME", "documentName"); // form で送られるパラメータ
    // メニューから削除
    var spn = newSPAN(dv, "removeDocIcon");
    spn.style.paddingLeft = "5px";
    spn.style.color = "#aaa";
    spn.setAttribute("onclick", "removeDocumentItem()");
    setInfoTip("removeDocIcon", "選択項目をメニューから削除"); // HELP
    var img = newIMAGE(spn, "", "remove-field.png", "remove");
    img.style.width = "10px";
    // -- RIGHT ----------
    var dv = newDIV(div, "/right-side");
    // HELP
    var img = newIMAGE(dv, "", "Help.png", "Help");
    img.style.width = "19px";
    img.setAttribute("onclick","help('docMakerHelp.html')");
    
    // docMaker BODY =====================================
    var body = newDIV(base, "docBody");
    
    // 宛先選択エリア
    var div = newDIV(body, "addressArea");
    div.style.paddingLeft = "5px";
    
    // 患者情報
    var div = newDIV(body, "patientArea");
    
    // 文頭挨拶文
    var div = newDIV(body, "");
    div.innerHTML = "挨拶文";
    div.style.paddingLeft = "5px";
    var div = newDIV(body, "");
    var greetings = (docObj().greetings) ? docObj().greetings : "";
    var lines = greetings.split("<br/>");
    greetings = lines.join("\n");
    var ta = newTEXTAREA(div, "greetings", 77, 3, greetings);
    ta.setAttribute("NAME", "greetings"); // form で送られるパラメータ
    ta.style.fontFamily = "times, arial, Helvetica";
    ta.style.fontSize = "10pt";
    ta.style.padding = "5px";
    
    // 本文
    var div = newDIV(body, "");
    div.innerHTML = "本文";
    div.style.paddingLeft = "5px";
    var div = newDIV(body, "");
    
    _debug("docObj().contents->"+docObj().contents); //##

    var ta = newTEXTAREA(div, "contents", 77, 25, "");
    ta.setAttribute("NAME", "contents"); // form で送られるパラメータ
    ta.style.fontFamily = "times, arial, Helvetica";
    ta.style.fontSize = "10pt";
    ta.style.padding = "5px";
    ta.focus();
    
    // 日付・施設情報エリア
    var div = newDIV(body, "");
    var addressTbl = newTABLE(div, "hospitalInfoTable");
    var tr = newTR(addressTbl, "", "");
    var td = newTD(tr, "hospitalInfoArea", "");
    
    // FOOTER ==========================================
    var div = newDIV(base, "/tool-footer");
    div.style.backgroundColor = "#a7e6d7";
    // --- LEFT SIDE ---------------
    var dv = newDIV(div, "/left-side");
    dv.style.width = "80%";
    dv.style.position = "relative";
    dv.style.bottom = "2px";
    /* // 書類アイコン
    var img = newIMAGE(dv, "", "docSmall.png", "doc");
    img.style.width = "15px";
    img.setAttribute("draggable", "true"); // HTML5: ドラッグ可能にする
    img.setAttribute("ondragstart", "dragstart(event)");
    // テンプレートへ登録
    img.style.marginRight = "5px";
    img.style.position = "relative";
    img.style.top = "3px"; */
    var bt = newBUTTON(dv, "overWriteButton", "テンプレートへ登録");
    bt.setAttribute("onclick", "overWriteTemplate()");
    var bt = newBUTTON(dv, "", "アーカイブ");
    bt.setAttribute("onclick", "showArchive()");
    var bt = newBUTTON(dv, "", "メールで送付");
    bt.setAttribute("onclick", "postMail()");
//    var bt = newBUTTON(dv, "", "カルテへ添付");
//    bt.setAttribute("onclick", "sendIconToNOA()");
    var bt = newBUTTON(dv, "", "カルテへ転記");
    bt.setAttribute("onclick", "sendToNOA()");
    // --- RIGHT SIDE ---------------
    var dv = newDIV(div, "/right-side");
    dv.style.position = "relative";
    dv.style.bottom = "2px";
    var bt = newSubmitBUTTON(dv, "submitButton", " 印 刷 ");
    //bt.style.display = "none"; // 初期状態では非表示にしておく
    bt.setAttribute("onclick", "printPDF()");
    
    // 欄外エリア
    var div = newDIV(base, "/clearfix");
    // --- LEFT SIDE ---------------
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = version();
    dv.style.color = "#aaa";
    dv.style.fontSize = "10pt";
    // --- RIGHT SIDE ---------------
    var dv = newDIV(div, "/right-side");
    //var cb = newCHECKBOX(dv, "", "debug", docMakerDebug());
    //cb.setAttribute("onchange", "setDocMakerDebug(this)");
    
    // ウインドー・サイズを localStorage から読み込みサイズ調整
    getWindowSize();

    // 親ウインドーの認識票を読込み、それを元に必要なデータを親から取り寄せる
    getDogTag();
}

function version(){
	return "Ver.140827";
}

