
var _currentRow;
function setCurrentRow(row){
    _currentRow = row;
}
function currentRow(){
    // 現在選択されている行を返す
    return _currentRow;
}

function remakePrefixMenus(){
    // 接頭語リストを再表示
    var elm = elmFor("prefixPopArea");
    elm.innerHTML = "";
    
    var pu = newPopupMenu(elm, "prefixPop", prefixMenus(), "");
    pu.setAttribute("onchange", "prefixPopupChanged(this)");
}
function addedPrefixMenu(answer){
   var obj = JSON.parse(answer);
    setPrefixMenus(obj);
    
    // 接頭語リストを再表示
    remakePrefixMenus();
}
function addPrefixMenu(){
    // 接頭語メニューに item を新規追加
    var item = prompt("新規に追加するメニュー項目");
    if (item.length > 0){
        // item をサーバへ登録するために incrementFrequency() を使う
        put_menu(owner(), _prefix, item, "", "", addedPrefixMenu);
    }
}

function removedPrefixMenu(answer){
    var obj = JSON.parse(answer);
    setPrefixMenus(obj);
    
    // 接頭語リストを再表示
    remakePrefixMenus();
}
function removePrefixMenu(){
    // 選択された接頭語をメニューから削除
    var item = elmFor("prefixPop").value;
    
    if (item == "") return;
    if (item == "...その他") return;
    if (confirm(item + " をメニューから削除していいですか"))
        remove_menu(owner(), _prefix, item, "", removedPrefixMenu);
}

function remakeSuffixMenus(){
    // 接尾語リストを再表示
    var elm = elmFor("suffixPopArea");
    elm.innerHTML = "";
    
    var pu = newPopupMenu(elm, "suffixPop", suffixMenus(), "");
    pu.setAttribute("onchange", "suffixPopupChanged(this)");
}
function addedSuffixMenu(answer){
    var obj = JSON.parse(answer);
    setSuffixMenus(obj);
    
    // 接尾語リストを再表示
    remakeSuffixMenus();
}
function addSuffixMenu(){
    // 接尾語メニューに item を新規追加
    var item = prompt("新規に追加するメニュー項目");
    if (item.length > 0){
        // item をサーバへ登録するために incrementFrequency() を使う
        put_menu(owner(), _suffix, item, "", "", addedSuffixMenu);
    }
}

function removedSuffixMenu(answer){
    var obj = JSON.parse(answer);
    setSuffixMenus(obj);
    
    // 接尾語リストを再表示
    remakeSuffixMenus();
}
function removeSuffixMenu(){
    // 選択された接尾語をメニューから削除
    var item = elmFor("suffixPop").value;
    
    if (item == "") return;
    if (item == "...その他") return;
    if (confirm(item + " をメニューから削除していいですか"))
        remove_menu(owner(), _suffix, item, "", removedSuffixMenu);
}

function showDiseaseMenu(answer){
    // 変更された病名リストを再表示
    var obj = JSON.parse(answer);
    setDiseaseMenus(obj);
    
    // 病名リストを再表示
    var elm = elmFor("menuPopArea");
    elm.innerHTML = "";
    var pu = newPopupMenu(elm, "namePop", diseaseMenus(), "");
    pu.setAttribute("onchange", "diseasePopupChanged(this)");
}
function addDiseaseMenu(){
    // 病名メニューに item を新規追加
    var item = prompt("新規に追加するメニュー項目");
    if (item.length > 0){
        // item をサーバへ登録するために incrementFrequency() を使う
        var alias = prompt("検索用アルファベット名");
        put_menu(owner(), "ProgressSection.disease", item, "", alias, showDiseaseMenu);
    }
}
function removeMenu(){
    // 選択された病名をメニューから削除
    var item = elmFor("namePop").value;
    
    if (item == "") return;
    if (item == "...その他") return;
    if (confirm(item + " をメニューから削除していいですか"))
        remove_menu(owner(), "ProgressSection.disease", item, "", showDiseaseMenu);
}


function setDiseaseAt(row){
    // 編集パネルの結果を _disease へ反映させる
    var rec = _diseases[row];
    rec.start = shortDate(elmFor("start").value);
    rec.name = elmFor("name").value;
    rec.end = shortDate(elmFor("end").value);
    if (trim(rec.end).length > 0){
        rec.conclusion = elmFor("conclusion").value;
    } else {
        rec.conclusion = "";
    }
    
    // エディターを閉じリスト内容を更新
    closeFloatPanel();
    
    // 病名の順序が主病名により変更されることがあるので、全部の行を表示しなおす
    var array = diseases(true); // true なら主病名先頭の配列
    for (row in array){
        // 一行分のエレメントを生成
        makeRow(row);
    }
    
    // CELL の入力欄（隠しフィールド）に転記
    var elm = elmFor(currentTag() + ".value");
    elm.innerHTML = diseasesToString(true); // 主病名先頭で表示
}
function checkKeyDown(row){
    // CTRL-j が入力されたら setDiseaseAt() を実行
    if (window.event.ctrlKey){
        if (window.event.keyCode == 74){ // CTRL-J
            setDiseaseAt(row);
        }
    }
}

function diseaseFocusPressed(){
    // 絞り込みフィールドでキーが押される度、キーに一致したメニューを再表示
    var elm = elmFor("menuPopArea");
    elm.innerHTML = "";
    
    var key = elmFor("focusF").value;
    var pu = newPopupMenu(elm, "namePop", menuItems(diseaseMenus(), key), "");
    pu.setAttribute("onchange", "diseasePopupChanged(this)");
    diseasePopupChanged(pu);
    
    function menuItems(menuArray, key){
        // メニュー・データを表示用にカスタマイズして返す
        var array = new Array();
        for (num in menuArray){
            var item = menuArray[num];
            if (!item || (item.length == 0)) continue;
            
            if (item.indexOf(key) < 0){
                // key に対応する item がなかった：key がアルファベットかも知れない
                // メニューに対応するローマ字は value フィールドに存在
                var romaji = aliasForMenu(item);
                if (romaji && (romaji.length > 0)){
                    // ローマ字が絞り込みキーにマッチしないものはスキップ
                    if (romaji.indexOf(key) < 0) continue;
                }
            }
            array.push(item);
        }
        return array;
    }
}

function mainMarkChanged(elm){
    // 主病名チェックボックスが変更された
    var fd = elmFor("name");
    var array = [];
    
    if (elmFor("mainMarkBox").checked)
        array.push("* ");
    
    var prefix = elmFor("prefixPop").value;
    if (prefix.length > 0) array.push(prefix);
    
    var disease = elmFor("namePop").value;
    if (disease.length > 0) array.push(disease);
    
    var suffix = elmFor("suffixPop").value;
    if (suffix.length > 0) array.push(suffix);
    
    fd.value = array.join(" ");
}
function diseasePopupChanged(elm){
    // name ポップアップが変更された
    if (elm.value == "...その他"){
        addDiseaseMenu();
    } else {
        var fd = elmFor("name");
        var array = [];
        
        if (elmFor("mainMarkBox").checked)
            array.push("* ");
        
        var prefix = elmFor("prefixPop").value;
        if (prefix.length > 0) array.push(prefix);
        
        var disease = elmFor("namePop").value;
        if (disease.length > 0) array.push(disease);
        
        //elmFor("focusF").value = elm.value;
        
        var suffix = elmFor("suffixPop").value;
        if (suffix.length > 0) array.push(suffix);
        
        fd.value = array.join(" ");
    }
}
function prefixPopupChanged(elm){
    // 接頭語ポップアップが変更された
    if (elm.value == "...その他"){
        addPrefixMenu();
    } else {
        var fd = elmFor("name");
        var array = [];
        
        if (elmFor("mainMarkBox").checked)
            array.push("* ");
        
        var prefix = elmFor("prefixPop").value;
        if (prefix.length > 0) array.push(prefix);
        
        var disease = elmFor("namePop").value;
        if (disease.length > 0) array.push(disease);
        
        var suffix = elmFor("suffixPop").value;
        if (suffix.length > 0) array.push(suffix);
        
        fd.value = array.join(" ");
    }
}
function suffixPopupChanged(elm){
    // 接尾語ポップアップが変更された
    if (elm.value == "...その他"){
        addSuffixMenu();
    } else {
        var fd = elmFor("name");
        var array = [];
        
        if (elmFor("mainMarkBox").checked)
            array.push("* ");
        
        var prefix = elmFor("prefixPop").value;
        if (prefix.length > 0) array.push(prefix);
        
        var disease = elmFor("namePop").value;
        if (disease.length > 0) array.push(disease);
        
        var suffix = elmFor("suffixPop").value;
        if (suffix.length > 0) array.push(suffix);
        
        fd.value = array.join(" ");
    }
}

function setNow(tag){
    // tag の年月日ポップアップに本日の年月日を設定
    var dv = elmFor(tag+".area");
    dv.innerHTML = "";
    
    // 日付ポップアップを表示
    var dateArray = arrayWithDateTime(todayAndTime());
    var yy = dateArray[0];
    var mm = dateArray[1];
    var dd = dateArray[2];
    newDatePopUp(dv, tag, "平成", yy, mm, dd, false);
}

function openDiseaseEditor(row, isEndDate){
    // 病名編集ペーンを開く
    //_initDebug(true); //##
    _debug("== openEditor"); //##
    var elm = valueElementForTag(currentDate(), currentTag()); // CELL 位置
    var pos = getPosition(elm);

    var w = 400;
	var x = pos.x; // 表示するx座標
	var y = pos.y - 200; // 表示するy座標
    var title = "病名編集";
    var action = "openHelp('diseaseEditorHelp.html')";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title, action);
    if (!elm){
        alert("_floatPanel がないのでパネルを表示できません"); return;
    }
    elm.style.padding = "8px";
    elm.style.color = "#f55";
    var tbl = newTABLE(elm, "/base-table");
    var tr = newTR(tbl, "", "");
    
    var rec = diseaseAt(row);
    var start = (rec) ? rec.start : shortDate(today());
    var names = (rec) ? rec.name : "";
    var end = (rec) ? rec.end : "";
    var conclusion = (rec) ? rec.conclusion : "";
    
    // 主病名マークを取り出す
    var mainMark = "";
    if (names.substr(0, 2) == "* "){
        mainMark = "* ";
        names = names.substr(2);
    }

    // 接頭語・病名・接尾語を切り分ける
    var prefix = "";
    var name = "";
    var suffix = "";
    if (names.length){
        var ary = names.split(" ");
        if (indexOfArray(prefixMenus(), ary[0]) >= 0){
            // ary[0] が接頭語に含まれるなら ary[1] は病名
            prefix = ary[0];
            name = (ary.length > 1) ? ary[1] : "";
        } else {
            name = ary[0];
        }
        if (indexOfArray(suffixMenus(), ary[ary.length - 1]) >= 0){
            // ary[ary.length - 1] が接尾語に含まれるなら
            suffix = ary[ary.length - 1];
        }
    }
    
    // 開始日
    if (trim(start) == ""){
        var array = dateTimeArray(todayAndTime());
        var yyyy = array[0];
        var mm = array[1];
        var dd = array[2];
    } else {
        var yyyy = "20" + start.substr(0, 2);
        var mm = start.substr(2, 2);
        var dd = start.substr(4, 2);
    }
    
    var td = newTD(tr, "", "");
    td.setAttribute("colspan", "5");
    var elm = newDIV(td, "/editorPane");
    
    // 開始日 ---------------
    var div = newDIV(elm, "/clearfix");
    var sp = newSPAN(div, "");
    sp.innerHTML = "開始日 ";
    // 日付設定アイコン
    var sp = newSPAN(div, "");
    sp.style.paddingRight = "5px";
    var img = newIMAGE(sp, "", "./timer-set.png", "time");
    img.style.height = "14px";
    img.setAttribute("onclick", "setNow('start')");
    img.style.position = "relative";
    img.style.top = "2px";
    img.setAttribute("class", "expandIcon");
    // 日付ポップアップ
    var sp = newSPAN(div, "start.area");
    newDatePopUp(sp, "start", "平成", yyyy, mm, dd, false, null);

    // 病名接頭語 -------------
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "接頭語 ";
    var sp = newSPAN(div, "prefixPopArea");
    var pu = newPopupMenu(sp, "prefixPop", prefixMenus(), prefix);
    pu.setAttribute("onchange", "prefixPopupChanged(this)");
    // 削除アイコン
    var img = newIMAGE(div, "", "./remove-field.png", "remove");
    img.setAttribute("onclick", "removePrefixMenu()");
    img.style.height = "12px";
    img.style.marginLeft = "3px";
    img.style.position = "relative";
    img.style.top = "3px";
    // 主病名チェックボックス
    var sp = newSPAN(div, "");
    sp.style.marginLeft = "20px";
    sp.style.position = "relative";
    sp.style.top = "2px";
    var status = (mainMark.length > 0) ? true : false;
    var cb = newCHECKBOX(sp, "mainMarkBox", "主病名", status);
    cb.setAttribute("onchange", "mainMarkChanged(this)");
    // 病名 ---------------
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "病　名 ";
    // 病名ポップアップ・メニュー
    var sp = newSPAN(div, "menuPopArea");
    var pu = newPopupMenu(sp, "namePop", diseaseMenus(), name);
    pu.setAttribute("onchange", "diseasePopupChanged(this)");
    // 削除アイコン
    var img = newIMAGE(div, "", "./remove-field.png", "remove");
    img.setAttribute("onclick", "removeMenu()");
    img.style.height = "12px";
    img.style.marginLeft = "2px";
    img.style.marginRight = "8px";
    img.style.position = "relative";
    img.style.top = "3px";
    // 絞りこみ欄
    var focusF = newFIELD(div, "focusF", "", 10, "");
    focusF.setAttribute("placeholder", "絞込み"); // 入力ヒントを表示
    focusF.setAttribute("onkeyup", "diseaseFocusPressed()");
    focusF.setAttribute("onkeydown", "checkKeyDown('" + row + "')");
    // 病名接尾語 -------------
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "接尾語 ";
    var sp = newSPAN(div, "suffixPopArea");
    var pu = newPopupMenu(sp, "suffixPop", suffixMenus(), suffix);
    pu.setAttribute("onchange", "suffixPopupChanged(this)");
    // 削除アイコン
    var img = newIMAGE(div, "", "./remove-field.png", "remove");
    img.setAttribute("onclick", "removeSuffixMenu()");
    img.style.height = "12px";
    img.style.marginLeft = "3px";
    img.style.position = "relative";
    img.style.top = "3px";
    // 病名欄 ---------------
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "　　　 ";
    var fd = newFIELD(div, "name", "", 40, mainMark + names);
    fd.style.backgroundColor = "#eee";
    fd.style.color = "#888";
    fd.style.border = "thin solid #eee";
    
    // 終了日
    if (trim(end).length == 0){
        // yyyy は start と同じ年を表示
        // mm は start と同じ月を表示
        var dd = 0;
    } else {
        var yyyy = "20" + end.substr(0, 2);
        var mm = end.substr(2, 2);
        var dd = end.substr(4, 2);
    }
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "終了日 ";
    // 日付設定アイコン
    var sp = newSPAN(div, "");
    sp.style.paddingRight = "5px";
    var img = newIMAGE(sp, "", "./timer-set.png", "time");
    img.style.height = "14px";
    img.setAttribute("onclick", "setNow('end')");
    img.style.position = "relative";
    img.style.top = "2px";
    img.setAttribute("class", "expandIcon");
    // 日付ポップアップ
    var sp = newSPAN(div, "end.area");
    newDatePopUp(sp, "end", "平成", yyyy, mm, dd, false, null);
    // 転帰
    var array = ["","治癒","中止"];
    var pu = newPopupMenu(div, "conclusion", array, rec.conclusion);
    
    // 確定ボタン
    var div = newDIV(elm, "/clearfix");
    div.style.marginTop = "5px";
    // VERSION
    var dv = newDIV(div, "/left-side");
    dv.style.paddingLeft = "0";
    dv.style.width = "50%";
    var sp = newSPAN(dv, "");
    sp.innerHTML = di_version();
    sp.style.fontSize = "9pt";
    sp.style.color = "#888";
    // とりやめ・確定ボタン
    var dv = newDIV(div, "/right-side");
    var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "とりやめ";
    bt.setAttribute("onclick", "closeFloatPanel()");
    var bt = newDIV(dv, "/fixButton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "setDiseaseAt('" + row + "')");
 
    focusF.focus();
}
