
///////////////////////////////////
/// localStorage による処理 /////////

function getFinderWindowSize(){
	// DocMaker のウインドー位置とサイズを localStorage から取り出す
    if (window.name == "tools") return;

    var windowStatus = window.localStorage["finderWindowSize"];
    if (windowStatus){
        var array = windowStatus.split(",");
        var x = array[0];
        var y = array[1];
        var w = array[2];
        var h = array[3];
		// resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
		// としてもウインドー境界の制限で移動できない場合がある
		window.resizeTo(w, h);
		window.moveTo(x, y);
    }
}

/// localStorage による処理 /////////
///////////////////////////////////


function _showPatientList(){
    // 検索キーに一致したカルテを検索
    
    // ウインドー位置とサイズをサーバへ記憶
    put_windowSize(0, -22, "finderWindowSize");

    var searchKey = document.getElementById("keyF").value;
    
    setStoragedKey(searchKey); // localStorage に記憶
    parent().getPatients(searchKey);
}
function makePatientFinder(){
    // カルテ検索の画面を生成
    var div = elmFor("patientFinderArea");
    div.innerHTML = "";
    div.style.marginBottom = "10px";
    var fd = newFIELD(div, "keyF", "", 40, storagedKey());
    fd.setAttribute("class", "searchField");
    fd.setAttribute("onchange", "_showPatientList()");
    fd.setAttribute("placeholder", "カルテ番号 or ローマ字 or かな or 漢字氏名"); // 入力ヒントを表示
    fd.focus();
    fd.select(); // 入力欄を全選択
    // 検索ボタン
    var bt = newSPAN(div, "/searchButton");
    bt.innerHTML = "検索";
    bt.setAttribute("onclick", "_showPatientList()");
}

function _showAnotherPanel(){
    // 別ウインドーに表示する
	window.open("./search.php","chartFinder"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function searchHelp(){
	window.open("./searchHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initSearch(){
    //_initDebug(true); //##
    
	var elm = document.getElementById("base");
    
    // === HEADER ==================
	var div = newDIV(elm, "/tool-header");
    // --- LEFT SIDE ---------------
    dv = newDIV(div, "/left-side");
    dv.innerHTML = "カルテ検索";
    dv.style.width = "40%";
    // --- RIGHT SIDE --------------
    dv = newDIV(div, "/right-side");
    var img = newIMAGE(dv, "outArrowIcon", "Help.png", "?");
    img.setAttribute("onclick", "searchHelp()");
    img.style.height = "17px";
    img.setAttribute("class", "expandIcon");
   
    // === CONTENTS ================
	var div = newDIV(elm, "");

    // カルテ検索
	var dv = newDIV(div, "patientFinderArea");
    dv.style.marginLeft = "10px";
    dv.style.marginTop = "8px";
    makePatientFinder();
    
    // 条件検索
	var dv = newDIV(div, "/tool-header");
    dv.innerHTML = "条件検索";
    dv.style.paddingLeft = "10px";
    dv.style.marginBottom = "8px";
	var dv = newDIV(div, "chartFinderArea");
    dv.style.marginLeft = "10px";
    makeChartFinder();

    // 受診日検索
	var dv = newDIV(div, "/tool-header");
    dv.innerHTML = "受診日検索";
    dv.style.paddingLeft = "10px";
    dv.style.marginBottom = "8px";
	var dv = newDIV(div, "lvdSearchArea");
    dv.style.marginBottom = "10px";
    dv.style.marginLeft = "10px";
    makeLvdSearcher();

    // カルテ検索のフィールドにフォーカスし直す
    var fd = elmFor("keyF");
    fd.focus();
    
    // === FOOTER ==================
	var div = newDIV(elm, "/tool-footer");
    div.style.paddingLeft = "10px";
    div.style.borderRadius = "0";
    div.innerHTML = version();
    
    // iFrame なら toggleButton にツール名を表示
    var bt = tools().elmFor("toggleButton");
    if (bt) bt.innerHTML = "検索ツール";

    // window size を読み込む
    getFinderWindowSize();
}

function version(){
	return "Ver.140713";
}

