<?php
	
    function decodeSTRING($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("%x0;", $val);
        $val = implode("#", $array);
        $array = explode("%x1;", $val);
        $val = implode("&", $array);
        $array = explode("%x2;", $val);
        $val = implode("+", $array);
        $array = explode("%x3;", $val);
        $val = implode("<", $array);
        $array = explode("%x4;", $val);
        $val = implode(">", $array);
        $array = explode("%x5;", $val);
        $val = implode(" ", $array);
        $array = explode("%x6;", $val);
        $val = implode("\n", $array);
        $array = explode("%x7;", $val);
        $val = implode("\"", $array);
        $array = explode("%x8;", $val);
        $val = implode("$", $array);
        $array = explode("%x9;", $val);
        $val = implode("\'", $array);
        $array = explode("%xa;", $val); // DocMaker の Image 用
        $val = implode("\\'", $array);
        /*
         $array = explode("%xb;", $val);
         $val = implode(")", $array);
         */
        return $val;
    }
    
    function leftBrackets(){
        // $leftBrackets = "\^\[\^" では誤作動
        return "^[^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function rightBrackets(){
        return "^]^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function decodeObject($buff){
        // "key(value)" 形式の文字列を OBJECT に decode して返す
        $obj = array();
        //	echo "decodeObject ===\n$buff\n"; //##
        for ($p=$begin=$nest=0, $len=strlen($buff); $p < $len; $p++){
            $ch = substr($buff, $p, 1);
            if (strcmp($ch, "(") == 0){
                if ($nest == 0){
                    $key = trim(substr($buff, $begin, $p - $begin)); // key 終端
                    $begin = $p + 1; // value 開始位置
                }
                $nest++;
            } else if (strcmp($ch, ")") == 0){
                if (--$nest == 0){
                    if ($nest == 0){
                        // value 終端 ( trim しない )
                        $value = substr($buff,$begin,$p-$begin);
                        $begin = $p + 1; // key 開始位置
                    }
                    if (preg_match("/\)/", $value)){ // まだ入れ子になっているなら
                        $obj[$key] = decodeObject($value);
                    } else {
                        // 特定文字を "(", ")" へ戻す
                        $array = explode(leftBrackets(), $value);
                        $value = join("(", $array);
                        $array = explode(rightBrackets(), $value);
                        $value = join(")", $array);
                        
                        $obj[$key] = $value;
                    }
                    //echo "$key{".$obj[$key]."}\n"; //##
                }
            }
        }
        return $obj;
    }
    
    function timeStamp(){
        // 本日の日時を返す
        date_default_timezone_set("Asia/Tokyo");
        return date("Y-m-d H:i:s",time());
    }
    
    function putMenuItem($link, $tag, $owner, $menuItem){
        // MenuTable をアップデート
        if (strlen($menuItem)){
            $sql = "SELECT * FROM `MenuTable` WHERE `tag`='$tag' AND `menu`='$menuItem'";
            $result=mysqli_query($link, $sql);
            $update = timeStamp();
            if (mysqli_num_rows ($result) > 0){	// 同じ menuItem が存在した
                $row=mysqli_fetch_array($result);
                $rowid = $row['rowid'];
                // menuItem は同じなので freq のみ更新
                $freq = $row['freq'] + 1; // 頻度をインクリメント
                $sql = "UPDATE `MenuTable` SET `freq`='$freq',`updateTime`='$update' WHERE `rowid`=$rowid";
            } else {							// 同じ menuItem が存在しなかった
                $sql = "INSERT INTO `MenuTable` ( `tag`, `freq`, `menu`, `value`, `updateTime`, `owner` ) VALUES ( '$tag','0','$menuItem','$value','$update','$owner')";
            }
            mysqli_query($link, $sql);
            
            // 変更結果を返す
            echo "\n===== $menuItem について以下の更新をしました =====\n";
            echo $sql;
        }
    }
    
    function putDocumentItem($link, $tag, $owner, $docName, $json, $doUpdate){
        // 文書テンプレートをアップデート
        if (strlen($docName)){
            $sql = "SELECT * FROM `MenuTable`
            WHERE `tag`='$tag' AND `menu`='$docName' AND `owner`='$owner'";
            $result=mysqli_query($link, $sql);
            $update = timeStamp();
            if (mysqli_num_rows ($result) > 0){	// 同じ docName が存在した
                $row=mysqli_fetch_array($result);
                $rowid = $row['rowid'];
                $freq = $row['freq'] + 1; // 頻度をインクリメント
                if ($doUpdate){
                    // 内容も更新
                    $sql = "UPDATE `MenuTable`
                    SET `value`='$json',`freq`='$freq'
                    ,`updateTime`='$update'
                    WHERE `rowid`=$rowid";
                } else {
                    // 頻度のみ更新
                    $sql = "UPDATE `MenuTable`
                    SET `freq`='$freq',`updateTime`='$update'
                    WHERE `rowid`=$rowid";
                }
            } else {							// 同じ menuItem が存在しなかった
                $sql = "INSERT INTO `MenuTable`
                ( `tag`,`freq`,`menu`,`value`,`updateTime`,`owner` )
                VALUES
                ( '$tag','0','$docName','$json','$update','$owner')";
            }
            mysqli_query($link, $sql);
            echo "\n====== $docName について以下の更新をしました =====\n";
            echo "$sql =====\n";
        }
    }
    
    function getTimeStampStatus($link, $owner){
        // owner の MenuTable から timeStampStatus を返す
        $sql = "SELECT * FROM `MenuTable` WHERE `menu`='DocMaker.timeStampStatus' AND `owner`='$owner'";
        $result=mysqli_query($link, $sql);
        echo "$sql ======\n\n"; //##
        
        $row = mysqli_fetch_array($result);
        return ($row) ? $row['value'] : "0";
    }
	
	
	
    $command = $_GET['command']; $command=htmlspecialchars($command);
    $patientId = $_GET['patientId']; $patientId=htmlspecialchars($patientId);
    $tag = $_GET['tag']; $tag=htmlspecialchars($tag);
    $target = $_GET['target']; $target=htmlspecialchars($target);
    $owner = $_GET['owner']; $owner=htmlspecialchars($owner);
    $value = $_GET['value']; $value=htmlspecialchars($value);
    $value = decodeSTRING($value);
    
    // DB を開いて該当レコードを読み込む
    // ### セキュリティーを保つには、以下のファイルを外からアクセスできない
    // ### directory に置き、以下の cfg.php の相対パスをそこへ変更
    require_once('../NOA/cfg.php');
    
    $link = mysqli_connect($db['host'], $db['user'], $db['pwd'], $db['dbname']);
    // 接続状況をチェック
    if (mysqli_connect_errno()) {
        echo("Connect failed: ".mysqli_connect_error()." <br>");
        exit();
    }
    $db_select = mysqli_select_db($link, $db['dbname']);
    mysqli_query($link, "set names utf8");
    
    if (strcmp($command,"PUT_DOCUMENT") == 0){
        // owner, value
        // 宛先メニュー・アイテム、文書テンプレートを登録
        echo "<SEPARATOR>";
        $array = decodeObject($value);
        $owner = $array["owner"];
        $address = $array["address"];
        $docName = $array["documentName"];
        // 以下は JSON 形式 {"greetings":"foo,,","haPatInfo":"on","contents":"bar,,"}
        $contents = $array["contents"];
        
        if ($address){
            // 宛先メニューをアップデート
            putMenuItem($link, "UniversalSection.documentAddress", $owner, $address);
        }
        if ($docName){
            // 文書テンプレートをアップデート
            // '"' が URL 転送により '&quot;' になっているので、元へ戻す
            $contents = str_replace("\\&quot;", "\"", $contents);
            // 改行が含まれた JSON は javascript の eval() で正常に展開されない
            $contents = str_replace("\n", "<br/>", $contents);
            putDocumentItem($link, "UniversalSection.documentName",
                            $owner, $docName, $contents, FALSE);
        }
        echo "<SEPARATOR>";
        echo "文書を保存しました";
    } else if (strcmp($command,"OVERWRITE_DOCUMENT") == 0){
        // owner, value
        // 文書テンプレートを登録あるいは上書き
        echo "<SEPARATOR>";
        $array = decodeObject($value);
        $owner = $array["owner"];
        $address = $array["address"];
        $docName = $array["documentName"];
        // 以下は JSON 形式 {"greetings":"foo,,","haPatInfo":"on","contents":"bar,,"}
        $contents = $array["contents"];
        
        if ($address){
            // 宛先メニューをアップデート
            putMenuItem($link, "UniversalSection.documentAddress", $owner, $address);
        }

        echo "docName($docName) \n";
        if ($docName){
            // 文書テンプレートをアップデート
            // '"' が URL 転送により '&quot;' になっているので、元へ戻す
            $contents = str_replace("\\&quot;", "\"", $contents);
            // 改行が含まれた JSON は javascript の eval() で正常に展開されない
            $contents = str_replace("\n", "<br/>", $contents);
            putDocumentItem($link, "UniversalSection.documentName",
                            $owner, $docName, $contents, TRUE);
        }
    } else if (strcmp($command,"GET_TEMPLATE") == 0){
        // 文書名に該当するテンプレートを返す
        $array = decodeObject($value);
        $owner = $array["owner"];
        $docName = $array["documentName"];
        
        $sql = "SELECT * FROM `MenuTable`
        WHERE `tag`='UniversalSection.documentName'
        AND `menu`='$docName' AND `owner`='$owner'
        ORDER BY `freq` DESC";
        $result=mysqli_query($link, $sql);
        echo "$sql ======\n\n"; //##
        
        if (mysqli_num_rows ($result) == 0){
            // ### private なデータがない場合は public を使う
            $sql = "SELECT * FROM `MenuTable`
            WHERE `tag`='UniversalSection.documentName'
            AND `menu`='$docName' AND `owner`='public'
            ORDER BY `freq` DESC";
            $result=mysqli_query($link, $sql);
            echo "$sql ======\n\n"; //##
        }
        
        $row = mysqli_fetch_array($result);
        echo "<SEPARATOR>";
        echo $row['value'];
    } else if (strcmp($command,"PUT_MENU") == 0){
        // tag, onwer に該当するメニュー・リストを DB へ保存
        $args = decodeObject($value);
        // client 側との約束ごと
        $menu = $args['menu'];
        $owner = $args['owner'];
        $val = $args['val'];
        
        echo "menu($menu) val($val)\n"; //####
        
        $sql = "SELECT * FROM `MenuTable` WHERE `menu`='$menu' AND `owner`='$owner'";
        echo "$sql ========\n"; //###
        $result=mysqli_query($link, $sql);
        if (mysqli_num_rows ($result) > 0){	// 同じ menuItem が存在した
            $sql = "UPDATE `MenuTable`
            SET `value`='$val'
            WHERE `menu`='$menu' AND `owner`='$owner'";
        } else { // 同じ menuItem が存在しなかった
            $sql = "INSERT INTO `MenuTable`
            ( `tag`,`freq`,`menu`,`value`,`public`,`updateTime`,`owner` )
            VALUES ( '','','$menu','$val','','','$owner')";
        }
        echo "$sql ========\n"; //###
        mysqli_query($link, $sql);
        
        // timeStampStatus を返す
        $records = array();
        $records['timeStampStatus'] = getTimeStampStatus($link, $owner);
        echo "<SEPARATOR>タイムスタンプを更新しました";
    } else if (strcmp($command,"GET_MENU") == 0){
        // 宛先メニュー、文書メニュー、timeStampStatus を返す
        $array = decodeObject($value);
        $owner = $array["owner"];

        $records = array();
        
        ///// 宛名メニュー内容を抽出 /////
        $array = array();
        // まず public から読込む
        $sql = "SELECT * FROM `MenuTable` WHERE `tag`='UniversalSection.documentAddress' AND `owner`='public' ORDER BY `freq` DESC";
        $result=mysqli_query($link, $sql);
        echo "$sql ======\n"; //##
        
        while( $row = mysqli_fetch_array($result)){
            $val = $row['menu'];
            $array[$val] = $row['owner'];
        }
        
        // 次に owner のメニューを読込み 同じものがあれば public を上書き
        $sql = "SELECT * FROM `MenuTable` WHERE `tag`='UniversalSection.documentAddress' AND `owner`='$owner' ORDER BY `freq` DESC";
        $result=mysqli_query($link, $sql);
        echo "$sql ======\n\n"; //##
        
        while( $row = mysqli_fetch_array($result)){
            $val = $row['menu'];
            $array[$val] = $row['owner'];
        }
        $records['documentAddress'] = $array;
        
        ///// 文書メニュー内容を抽出 /////
        $array = array();
        // まず public から読込む
        $sql = "SELECT * FROM `MenuTable` WHERE `tag`='UniversalSection.documentName' AND `owner`='public' ORDER BY `freq` DESC";
        $result=mysqli_query($link, $sql);
        echo "$sql ======\n"; //##
        
        while( $row = mysqli_fetch_array($result)){
            $val = $row['menu'];
            $array[$val] = $row['owner'];
        }
        
        // 次に owner のメニューを読込み 同じものがあれば public を上書き
        $sql = "SELECT * FROM `MenuTable` WHERE `tag`='UniversalSection.documentName' AND `owner`='$owner' ORDER BY `freq` DESC";
        $result=mysqli_query($link, $sql);
        echo "$sql ======\n\n"; //##
        
        while( $row = mysqli_fetch_array($result)){
            $val = $row['menu'];
            $array[$val] = $row['owner'];
        }
        $records['documentName'] = $array;
        
        // timeStampStatus を返す
        $records['timeStampStatus'] = getTimeStampStatus($link, $owner);
        
        echo "<SEPARATOR>";
        echo json_encode($records);
    } else if (strcmp($command,"REMOVE_MENU_ITEM") == 0){
        // tag, value
        $array = decodeObject($value);
        $tag = $array["tag"];
        $address = $array["address"];
        
        $sql = "DELETE FROM `MenuTable` WHERE `tag`='$tag' AND `menu`='$address'";
        $result=mysqli_query($link, $sql);
        
        // 変更結果を返す
        echo "$sql \n"; // ###
        echo "<SEPARATOR>$address";
    } else if (strcmp($command,"PUT_WINDOW_SIZE") == 0){
        // FieldTable の 'editor'フィールドにサイズ属性を格納
        $array = decodeObject($value);
        $val = $array["editor"];
        $tag = $array["tag"];
        $owner = $array["owner"];
        
        $sql = "SELECT * FROM `FieldTable` 
        WHERE `tag`='$tag' AND `owner`='$owner'";
        echo "$sql ========\n"; //###
        $result=mysqli_query($link, $sql);
        if (mysqli_num_rows ($result) > 0){	// 同じ tag が存在した
            $sql = "UPDATE `FieldTable` 
            SET `editor`='$val'
            WHERE `tag`='$tag' AND `owner`='$owner'";
        } else { // 同じ menuItem が存在しなかった
            $sql = "INSERT INTO `FieldTable` 
            ( `tag`,`editor`,`owner` )
            VALUES ( '$tag','$val','$owner')";
        }
        echo "$sql ========\n"; //###
        mysqli_query($link, $sql);
        echo "<SEPARATOR>";
        echo "ウインドー・サイズ $val を保存しました";
    } else if (strcmp($command,"GET_WINDOW_SIZE") == 0){
        // FieldTable の 'editor'フィールドにサイズ属性を格納
        $array = decodeObject($value);
        $val = $array["editor"];
        $tag = $array["tag"];
        $owner = $array["owner"];
        
        $sql = "SELECT * FROM `FieldTable` 
        WHERE `tag`='$tag' AND `owner`='$owner'";
        echo "$sql ========\n"; //###
        $result=mysqli_query($link, $sql);
        echo "<SEPARATOR>";
        $val = "20,10,700,900"; // default window size
        if (mysqli_num_rows ($result) > 0){	// 同じ tag が存在した
            $row = mysqli_fetch_array($result);
            $val = $row['editor']; // 'editor'フィールドにサイズ属性を格納
            echo "$val"; //###
        }
    }
	
?>