#ifndef CCHANNEL_H_
#define CCHANNEL_H_
// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include <cstdlib>   // size_t

namespace nbox {

    class Channel {
    protected:
        Channel()
        {}
    private:
        // privateかつ未定義にして、コピーと代入を禁止する
        Channel(const Channel &obj);
        Channel &operator=(const Channel &rhs);
    public:
        virtual ~Channel()
        {}
        virtual void read(void *buf, size_t len) = 0;
        virtual void write(const void *buf, size_t len) = 0;
        virtual void flush() = 0;
    };

} // namespace nbox

#endif
