// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include <iostream>          // cerr
#include "cClientSidePipe.h" // ClientSidePipe

namespace nbox {
    static bool debug = false;

    ClientSidePipe::ClientSidePipe(const char *pipe_name, size_t bufsize)
        : NamedPipe()
    {
		/** 
		  * コンストラクタ。
		　* 名前を指定して、パイプに接続する。 
		  */

		hPipe = CreateFile(pipe_name,           // パイプ名
			GENERIC_WRITE | GENERIC_READ,       // 読み書きアクセス
			FILE_SHARE_READ | FILE_SHARE_WRITE, // 読み書きアクセス共有
			NULL,                               // セキュリティ属性なし
			OPEN_EXISTING,                      // 既存の名前付きパイプに接続
			FILE_ATTRIBUTE_NORMAL,              // ファイル属性なし
			NULL);                              // テンプレート・ファイルなし
		std::cerr << "HANDLE " << hPipe << std::endl;
		if (hPipe == INVALID_HANDLE_VALUE) {
			int eno = GetLastError();
			if(eno == ERROR_FILE_NOT_FOUND){
				std::cerr << "Specified Pipe Not Found" << std::endl;
				ExitProcess(eno);	
			} else {
				err_exit("CreateFile");
			}
		}
		if(debug) std::cerr << "Successfully connected to the named-pipe" << std::endl;
	}		

    ClientSidePipe::~ClientSidePipe()
    {
        CloseHandle(hPipe);
    }

} // namespace nbox
