// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include <iostream>     // cout
#include "cNamedPipe.h" // NamedPipe

namespace nbox {

    static bool debug = 0;

    NamedPipe::NamedPipe() : Channel(), hPipe(0)
    {}

    NamedPipe::~NamedPipe()
    {}

    void NamedPipe::read(void *ptr, size_t len)
    {
		/** バッファbuf(長さbuflen)に、lenで指定されたバイト数読み込む。*/
        static const size_t buflen = 256;
        char *buf = static_cast<char *>(ptr);

		size_t already_read = 0;
		if(len >= buflen)
			err_close_exit("Too small buffer");

		while(already_read < len){
			DWORD actual_len;
			int ret = ReadFile(hPipe, buf + already_read, len - already_read, &actual_len, NULL);
			if(debug)
				std::cout << "Read "<< actual_len << " bytes" << std::endl;
			already_read += actual_len;
			if(!ret) err_close_exit("ReadFile");
		}
		if(debug) std::cout << "Server read: " << buf << std::endl;
	}

    void NamedPipe::write(const void *ptr, size_t len)
    {
        const char *buf = static_cast<const char *>(ptr);
		if(debug)
			std::cerr << "% Writing to HANDLE " << hPipe << std::endl;
		/** バッファbufから、lenで指定されたバイト数書き込む。*/
		size_t already_written = 0;
		while(already_written < len){
			DWORD actual_len;
			int ret = WriteFile(hPipe, buf + already_written, len - already_written, &actual_len, NULL);
			if(debug)
				std::cout << "% Wrote "<< actual_len << " bytes" << " (tried to write " << len << ")" << std::endl;
			already_written += actual_len;
			if(!ret) err_close_exit("WriteFile");
		}
	}

    void NamedPipe::flush()
    {
    }

    /** エラーを表示して終了する */
    void NamedPipe::err_exit(const char *str)
    {
        DWORD eno = GetLastError();
        std::cerr << "Error: " << str << " errcode=" << eno << std::endl;
        ExitProcess(eno);	
    }

    /** エラーを表示して、パイプを閉じて終了する */
    void NamedPipe::err_close_exit(const char *str)
    {
        int eno = GetLastError();
        std::cerr << "Error: " << str << " errcode=" << eno << std::endl;
        CloseHandle(hPipe);	
        ExitProcess(eno);	
    }

} // namespace nbox
