#ifndef CNAMEDPIPE_H_
#define CNAMEDPIPE_H_
// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include <windows.h>  // HANDLE
#include "cChannel.h" // Channel

namespace nbox {

    class NamedPipe : public Channel {
    protected:
        HANDLE hPipe;
        NamedPipe();
    private:
        // privateかつ未定義にして、コピーと代入を禁止する
        NamedPipe(const NamedPipe &obj);
        NamedPipe &operator=(const NamedPipe &rhs);
    public:
        virtual ~NamedPipe();
        virtual void read(void *buf, size_t len);
        virtual void write(const void *buf, size_t len);
        virtual void flush();
        virtual void err_exit(const char *str);
        virtual void err_close_exit(const char *str);
    };

} // namespace nbox

#endif
