// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include <cstdlib> // abort()

#include "MPU_dpi.h" // vlogコマンドを使って、MPU.vから自動生成
//#include "svdpi.h" svdpi.hはMPU_dpi.hでincludeされるので、ここでは不要
#include "cMpu.h"        // Mpu
#include "cMpuFactory.h" // MpuFactory

// どちら側で実装されているのかわかりやすいように、
// 'v_'で始まる関数 は Verilog-HDL による実装、
// 'c_'で始まる関数 は C++         による実装にしてある。

// exportしているtask v_waitClock(), v_write()は、
// vlogが自動生成するヘッダにプロトタイプ宣言が吐き出されるので、
// Cからの呼び出しができるようになる
// また、importしているfunctionやtaskはCで実装できる


// initial beginで呼び出される関数
// マルチプロセッサ構成に対応するため、mpu_idを引数にとる
// 1stと2ndに分けた(すぐにmpu->startup()しない)理由は、
// Verilog HDL側の信号や変数の値を変化させるにはC側の関数がリターン
// しなければならないから
void *c_startup1st(int mpu_id, const char *mpu_name)
{
    nbox::MpuFactory *factory = nbox::MpuFactory::getInstance();
    nbox::Mpu *mpu = factory->create(mpu_id, mpu_name);

    // Verilog HDL側にポインタを返す
    return mpu;
}

// initial beginで呼び出される関数
// returnする前にdeleteしないとメモリリークする
int c_startup2nd(void *mpu_handle)
{
    nbox::Mpu *mpu = static_cast<nbox::Mpu *>(mpu_handle);

    // ユーザプログラムの開始
    mpu->startup();

    delete mpu;
    return 0;
}

// シミュレータとC++実装との情報交換を行う関数
int c_reflect(
    void                *mpu_handle,
    svLogicVecVal       *a,
    svLogicVecVal       *dout,
    const svLogicVecVal *ctrli,
    svLogicVecVal       *ctrlo,
    int                  clk,
    int                 *need_next_rising)
{
    // 呼び出されたことを画面に出す、デバッグ情報
    //v_write(0x00ca11ed);

    nbox::Mpu *mpu = static_cast<nbox::Mpu *>(mpu_handle);
    *need_next_rising = mpu->reflect(a, dout, ctrli, ctrlo, clk);
    return 0;
}

int c_reflect_din(
    void                *mpu_handle,
    const svLogicVecVal *din)
{
    nbox::Mpu *mpu = static_cast<nbox::Mpu *>(mpu_handle);
    mpu->reflect_din(din);
    return 0;
}
